<?php

namespace App\Providers;

use App\Http\Helpers\UserPermissionHelper;
use App\Models\Language;
use App\Models\Menu;
use App\Models\Social;
use App\Models\User\BasicExtended;
use App\Models\User\BasicSetting as UserBasciSettings;
use App\Models\User\FooterText;
use App\Models\User\Language as TenantLanguage;
use App\Models\User\Language as UserLanguage;
use App\Models\User\Menu as UserMenu;
use App\Models\User\Section;
use App\Models\User\Social as UserSocialMedia;
use App\Models\User\UserPermission;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

use Illuminate\Support\Facades\Session;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    public function changePreferences($userId)
    {
        $currentPackage = UserPermissionHelper::currentPackage($userId);

        $preference = UserPermission::where([
            ['user_id', $userId],
        ])->first();

        // if current package does not match with 'package_id' of 'user_permissions' table, then change 'package_id' in 'user_permissions'
        if (!empty($currentPackage) && ($currentPackage->id != $preference->package_id)) {
            $preference->package_id = $currentPackage->id;

            $features = !empty($currentPackage->features) ? json_decode($currentPackage->features, true) : [];
            $features[] = "Contact";
            $preference->permissions = json_encode($features);
            $preference->package_id = $currentPackage->id;
            $preference->save();
        }
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();

        if (!app()->runningInConsole()) {
            $socials = Social::orderBy('serial_number', 'ASC')->get();
            $langs = Language::all();
            // $data = DB::table('user_basic_settings')->orderBy('id', 'desc')->first();
            $data = DB::table('user_basic_settings')->find(75);

            View::composer('*', function ($view) {
                Paginator::useBootstrapCustom();
                if (session()->has('lang')) {
                    $currentLang = Language::where('code', session()->get('lang'))->first();
                } else {
                    $currentLang = Language::where('is_default', 1)->first();
                }

                $bs = $currentLang->basic_setting;
                $be = $currentLang->basic_extended;

                if (Menu::where('language_id', $currentLang->id)->count() > 0) {
                    $menus = Menu::where('language_id', $currentLang->id)->first()->menus;
                } else {
                    $menus = json_encode([]);
                }

                if ($currentLang->rtl == 1) {
                    $rtl = 1;
                } else {
                    $rtl = 0;
                }

                $view->with('bs', $bs);
                $view->with('be', $be);
                $view->with('currentLang', $currentLang);
                $view->with('menus', $menus);
                $view->with('rtl', $rtl);
            });

            View::composer(['admin.*'], function ($view) {
                Paginator::useBootstrapCustom();
                if (session()->has('admin_lang')) {
                    $lang_code = str_replace('admin_', '', session()->get('admin_lang'));
                    $language = Language::where('code', $lang_code)->first();
                    if (empty($language)) {
                        $language = Language::where('is_default', 1)->first();
                    }
                } else {
                    $language = Language::where('is_default', 1)->first();
                }
                View::share('default', $language);
                View::share('dashboard_language', $language);
            });

            View::composer(['user.*'], function ($view) {
                Paginator::useBootstrapCustom();
                if (Auth::check()) {
                    $userId = Auth::guard('web')->user()->id;
                    // change package_id in 'user_permissions'
                    $this->changePreferences($userId);
                    $userBs = UserBasciSettings::query()
                        ->where('user_id', Auth::user()->id)
                        ->first();
                    $view->with('userBs', $userBs);

                    $language = TenantLanguage::where('is_default', 1)->where('user_id', Auth::guard('web')->user()->id)->first();
                    $footerText = FooterText::where('user_id', Auth::guard('web')->user()->id)->where('language_id', $language->id)->first();

                    //for translate tenant dashboard start
                    $userDashboardLang = null;
                    if (Session::has('user_lang')) {
                        $userDashboardLang = TenantLanguage::where('user_id', Auth::guard('web')->user()->id)->where('code', Session::get('user_lang'))->first();
                    }
                    if(is_null($userDashboardLang)){
                        $userDashboardLang = TenantLanguage::where('user_id', Auth::guard('web')->user()->id)->where('dashboard_default', 1)->first();
                    }
                    //not extis dashboard language
                    
                    Session::put('user_lang', $userDashboardLang->code);
                    app()->setLocale('user_' . $userDashboardLang->code);
                 
                    //for translate tenant dashboard end


                    $view->with('defaultLang', $language);
                    $view->with('footerTextInfo', $footerText);
                    $view->with('currentLanguageInfo', $language);
                    $view->with('dashboard_language', $userDashboardLang);
                }
            });
            
            View::composer(['user-front.*'], function ($view) {
                Paginator::useBootstrapFour();
                $user = getUser();
                // change package_id in 'user_permissions'
                $this->changePreferences($user->id);

                if (session()->has('user_front_lang')) {
                    $userCurrentLang = UserLanguage::query()->where('code', session()->get('user_front_lang'))->where('user_id', $user->id)->first();
                    session()->put('user_front_lang', $userCurrentLang->code);
                } else {
                    $userCurrentLang = UserLanguage::query()->where('is_default', 1)->where('user_id', $user->id)->first();
                }
                $allLanguages = UserLanguage::query()->where('user_id', $user->id)->get();
                $socialMedias = UserSocialMedia::query()->where('user_id', $user->id)->get();

                $packagePermissions = UserPermissionHelper::packagePermission($user->id);
                $packagePermissions = json_decode($packagePermissions, true);

                $keywords = json_decode($userCurrentLang->keywords, true);
                

                if (UserMenu::query()->where('language_id', $userCurrentLang->id)->where('user_id', $user->id)->count() > 0) {
                    $userMenus = UserMenu::query()->where('language_id', $userCurrentLang->id)->where('user_id', $user->id)->first()->menus;
                } else {
                    $userMenus = json_encode([]);
                }

                $userBs = UserBasciSettings::query()
                    ->where('user_id', $user->id)
                    ->orderBy('id', 'desc')->first();

                // get the announcement popups
                $popups = $userCurrentLang->announcementPopup()->where('status', 1)->orderBy('serial_number', 'asc')->get();

                // get the user basic extendes info
                $userBe = BasicExtended::query()->where('user_id', $user->id)->where('language_id', $userCurrentLang->id)->first();

                // get footer section status (enable/disable) information
                $userSections = Section::query()->where('user_id', $user->id)->first();
                $userBs = UserBasciSettings::query()->where('user_id', $user->id)->first();

                $view->with('user', $user);
                $view->with('userBs', $userBs);
                $view->with('userBe', $userBe);
                $view->with('userMenus', $userMenus);
                $view->with('allLanguageInfos', $allLanguages);
                $view->with('socialMediaInfos', $socialMedias);
                $view->with('currentLanguageInfo', $userCurrentLang);
                $view->with('popupInfos', $popups);
                $view->with('keywords', $keywords);
                $view->with('packagePermissions', $packagePermissions);
                $view->with('sections', $userSections);
                $view->with('popups', $popups);
            });

            View::share('langs', $langs);
            View::share('defaultLang', $langs);
            View::share('socials', $socials);
            View::share(['userBs' => $data]);
           
        }
    }
}
