<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

$domain = env('WEBSITE_HOST');

if (! app()->runningInConsole()) {
    if (substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {
        $domain = 'www.' . env('WEBSITE_HOST');
    }
}

Route::fallback(function () {
    return view('errors.404');
});
Route::get('/config-clear', function () {
    Artisan::call('config:clear');
});

Route::get('/forget/coupon', function () {
    request()->session()->forget('discountedCourse');
    request()->session()->forget('discount');
    request()->session()->forget('discountedPrice');
});

// cron job for sending expiry mail

Route::domain($domain)->group(function () {
    Route::get('/subcheck', 'CronJobController@expired')->name('cron.expired');

    Route::group(['prefix' => 'user', 'middleware' => ['auth:web', 'userstatus', 'setUserLang','Demo']], function () {

        Route::get('/dashboard', 'User\UserController@index')->name('user-dashboard');
        Route::get('/pdf-test-2', 'User\RoomController@pdfTest');
        Route::get('/pdf-test-package', 'User\RoomController@pdfPackageTest');
        Route::get('/reset', 'User\UserController@resetform')->name('user-reset');
        Route::post('/reset', 'User\UserController@reset')->name('user-reset-submit');

        Route::get('/logout', 'User\Auth\LoginController@logout')->name('user-logout');
        Route::post('/change-status', 'User\UserController@status')->name('user-status');
        // user theme change
        Route::get('/change-theme', 'User\UserController@changeTheme')->name('user.theme.change');
        // RTL check
        Route::get('/rtlcheck/{langid}', 'User\LanguageController@rtlcheck')->name('user.rtlcheck');
        Route::get('user/rtlcheck/{langid}', 'User\LanguageController@rtlcheck')->name('user.rtlcheck_2');
        // Summernote image upload
        Route::post('/summernote/upload', 'Admin\SummernoteController@upload')->name('user.summernote.upload');

        // room management route start
        Route::prefix('/room-management')->group(function () {
            Route::group(['prefix' => 'settings'], function () {

                //preferences routes
                Route::group(['prefix' => 'preferences'], function () {
                    Route::get('/', 'User\RoomController@settings')->name('tenant.rooms_management.settings');
                    Route::post('/update', 'User\RoomController@updateSettings')->name('tenant.rooms_management.update_settings');
                });
                // amenities route
                //tax , fee routes
                Route::group(['prefix' => 'tax-fee'], function () {
                    Route::get('/', 'User\RoomController@taxFee')->name('tenant.rooms_management.tax_fee');
                    Route::post('/update', 'User\RoomController@updateTaxFee')->name('tenant.rooms_management.update_tax_fee');
                });

                Route::group(['prefix' => 'amenities'], function () {
                    Route::get('/', 'User\RoomController@amenities')->name('tenant.rooms_management.amenities');
                    Route::post('/store', 'User\RoomController@storeAmenity')->name('tenant.rooms_management.store_amenity');
                    Route::get('/edit/{id}', 'User\RoomController@editAmenity')->name('tenant.rooms_management.edit_amenity');
                    Route::post('/update', 'User\RoomController@updateAmenity')->name('tenant.rooms_management.update_amenity');
                    Route::post('/delete', 'User\RoomController@deleteAmenity')->name('tenant.rooms_management.delete_amenity');
                    Route::post('/bulk_delete', 'User\RoomController@bulkDeleteAmenity')->name('tenant.rooms_management.bulk_delete_amenity');
                });

                // categories route
                Route::group(['prefix' => 'categories'], function () {
                    Route::get('/', 'User\RoomController@categories')->name('tenant.rooms_management.categories');
                    Route::post('/bulk_delete', 'User\RoomController@bulkDeleteCategory')->name('tenant.rooms_management.bulk_delete_category');
                    Route::post('/store', 'User\RoomController@storeCategory')->name('tenant.rooms_management.store_category')->middleware('limitCheck:room_categories,store');
                    Route::get('/edit/{id}', 'User\RoomController@editCategory')->name('tenant.rooms_management.edit_category');
                    Route::post('/update', 'User\RoomController@updateCategory')->name('tenant.rooms_management.update_category')->middleware('limitCheck:room_categories,update');
                    Route::post('/delete', 'User\RoomController@deleteCategory')->name('tenant.rooms_management.delete_category');
                });

                // coupon routes
                Route::group(['prefix' => 'coupons'], function () {
                    Route::get('/', 'User\RoomController@coupons')->name('tenant.rooms_management.coupons');
                    Route::post('/store-coupon', 'User\RoomController@storeCoupon')->name('tenant.rooms_management.store_coupon')->middleware('limitCheck:room_booking_coupons,store');
                    Route::post('/update-coupon', 'User\RoomController@updateCoupon')->name('tenant.rooms_management.update_coupon')->middleware('limitCheck:room_booking_coupons,update');
                    Route::post('/delete-coupon/{id}', 'User\RoomController@destroyCoupon')->name('tenant.rooms_management.delete_coupon');
                });
            });
            // rooms route
            Route::group(['prefix' => 'rooms'], function () {
                Route::get('/', 'User\RoomController@rooms')->name('tenant.rooms_management.rooms');
                Route::get('/create', 'User\RoomController@createRoom')->name('tenant.rooms_management.create_room');
                Route::post('/store', 'User\RoomController@storeRoom')->name('tenant.rooms_management.store_room')->middleware('limitCheck:rooms,store');
                Route::get('/edit/{id}', 'User\RoomController@editRoom')->name('tenant.rooms_management.edit_room');
                Route::post('/slider_images', 'User\RoomController@sliderImgageUpload')->name('tenant.rooms_management.sliderImage');
                Route::post('/remove-slider-image', 'User\RoomController@removeImage')->name('tenant.rooms_management.remove_slider_image');
                Route::post('/detach-slider-image', 'User\RoomController@detachImage')->name('tenant.rooms_management.detach_slider_image');
                Route::post('/update/{id}', 'User\RoomController@updateRoom')->name('tenant.rooms_management.update_room')->middleware('limitCheck:rooms,update');
                Route::post('/delete', 'User\RoomController@deleteRoom')->name('tenant.rooms_management.delete_room');
                Route::post('/bulk_delete', 'User\RoomController@bulkDeleteRoom')->name('tenant.rooms_management.bulk_delete_room');
                Route::post('/update_featured', 'User\RoomController@updateFeaturedRoom')->name('tenant.rooms_management.update_featured_room');
            });
        });
        // room management route end

        // Room Bookings Routes
        Route::prefix('/room-booking')->group(function () {
            Route::get('/all_bookings', 'User\RoomController@bookings')->name('tenant.room_bookings.all_bookings');
            Route::get('/paid_bookings', 'User\RoomController@bookings')->name('tenant.room_bookings.paid_bookings');
            Route::get('/unpaid_bookings', 'User\RoomController@bookings')->name('tenant.room_bookings.unpaid_bookings');
            Route::post('/update_payment_status', 'User\RoomController@updatePaymentStatus')->name('tenant.room_bookings.update_payment_status');
            Route::get('/booking_edit/{id}', 'User\RoomController@roomBookingEdit')->name('tenant.room_bookings.booking_edit');
            Route::get('/booking_details/{id}', 'User\RoomController@roomBookingDetails')->name('tenant.room_bookings.booking_details');

            Route::post('/update_booking', 'User\RoomController@updateBooking')->name('tenant.room_bookings.update_booking')->middleware('limitCheck:room_bookings,update');

            Route::post('/send_mail', 'User\RoomController@sendMail')->name('tenant.room_bookings.send_mail');

            Route::post('/delete_booking/{id}', 'User\RoomController@deleteBooking')->name('tenant.room_bookings.delete_booking');

            Route::post('/bulk_delete_booking', 'User\RoomController@bulkDeleteBooking')->name('tenant.room_bookings.bulk_delete_booking');

            Route::get('/get_booked_dates', 'User\RoomController@bookedDates')->name('tenant.room_bookings.get_booked_dates');

            Route::get('/booking_form', 'User\RoomController@bookingForm')->name('tenant.room_bookings.booking_form');

            Route::post('/make_booking', 'User\RoomController@makeBooking')->name('tenant.room_bookings.make_booking')->middleware('limitCheck:room_bookings,store');

            // room booking report
            Route::get('/room/report', 'User\RoomController@report')->name('tenant.rooms_management.report');
            Route::get('/room/export-report', 'User\RoomController@exportReport')->name('tenant.rooms_management.export_report');
        });
        // Room Booking routes end

        // packages management route start
        Route::group(['prefix' => 'packages_management', 'middleware' => 'checkUserPermission:Tour Package'], function () {

            Route::group(['prefix' => 'settings'], function () {
                //preferences
                Route::group(['prefix' => 'preferences'], function () {
                    Route::get('/', 'User\PackageController@settings')->name('tenant.packages_management.settings');
                    Route::post('/updates', 'User\PackageController@updateSettings')->name('tenant.packages_management.update_settings');
                });

                //tax , fee routes
                Route::group(['prefix' => 'tax-fee'], function () {
                    Route::get('/', 'User\PackageController@taxFee')->name('tenant.packages_management.tax_fee');
                    Route::post('/update', 'User\PackageController@updateTaxFee')->name('tenant.packages_management.update_tax_fee');
                });
                //coupons
                Route::group(['prefix' => 'coupons'], function () {
                    Route::get('/', 'User\PackageController@coupons')->name('tenant.packages_management.coupons');
                    Route::post('/store', 'User\PackageController@storeCoupon')->name('tenant.packages_management.store_coupon')->middleware('limitCheck:package_booking_coupons,store');
                    Route::post('/update', 'User\PackageController@updateCoupon')->name('tenant.packages_management.update_coupon')->middleware('limitCheck:package_booking_coupons,update');
                    Route::post('/delete/{id}', 'User\PackageController@destroyCoupon')->name('tenant.packages_management.delete_coupon');
                });

                //categories
                Route::group(['prefix' => 'categories'], function () {
                    Route::get('/', 'User\PackageController@categories')->name('tenant.packages_management.categories');
                    Route::post('/store', 'User\PackageController@storeCategory')->name('tenant.packages_management.store_category')->middleware('limitCheck:package_categories,store');
                    Route::get('/edit/{id}', 'User\PackageController@editCategory')->name('tenant.packages_management.edit_category');
                    Route::post('/update', 'User\PackageController@updateCategory')->name('tenant.packages_management.update_category')->middleware('limitCheck:package_categories,update');
                    Route::post('/delete', 'User\PackageController@deleteCategory')->name('tenant.packages_management.delete_category');
                    Route::post('/bulk_delete', 'User\PackageController@bulkDeleteCategory')->name('tenant.packages_management.bulk_delete_category');
                });
            });
            //packages
            Route::group(['prefix' => 'packages'], function () {

                Route::get('/', 'User\PackageController@packages')->name('tenant.packages_management.packages');
                Route::get('/create_package', 'User\PackageController@createPackage')->name('tenant.packages_management.create_package');
                // dropzone slider package route
                Route::post('/slider_images', 'User\PackageController@sliderImgageUpload')->name('tenant.packages_management.sliderImage');
                Route::post('/remove-slider-image', 'User\PackageController@removeImage')->name('tenant.packages_management.remove_slider_image');
                Route::post('/detach-slider-image', 'User\PackageController@detachImage')->name('tenant.packages_management.detach_slider_image');

                Route::post('/store_package', 'User\PackageController@storePackage')->name('tenant.packages_management.store_package')->middleware('limitCheck:packages,store');
                Route::post('t/update_featured_package', 'User\PackageController@updateFeaturedPackage')->name('tenant.packages_management.update_featured_package');
                Route::get('/edit_package/{id}', 'User\PackageController@editPackage')->name('tenant.packages_management.edit_package');
                Route::get('/slider_images/{id}', 'User\PackageController@getSliderImages');
                Route::post('/update_package/{id}', 'User\PackageController@updatePackage')->name('tenant.packages_management.update_package')->middleware('limitCheck:packages,update');
                Route::post('/delete_package', 'User\PackageController@deletePackage')->name('tenant.packages_management.delete_package');
                Route::post('/bulk_delete_package', 'User\PackageController@bulkDeletePackage')->name('tenant.packages_management.bulk_delete_package');
                Route::post('/store_location', 'User\PackageController@storeLocation')->name('tenant.packages_management.store_location');
                Route::get('/view_locations/{package_id}', 'User\PackageController@viewLocations')->name('tenant.packages_management.view_locations');
                Route::post('/update_location', 'User\PackageController@updateLocation')->name('tenant.packages_management.update_location');
                Route::post('/delete_location', 'User\PackageController@deleteLocation')->name('tenant.packages_management.delete_location');
                Route::post('/bulk_delete_location', 'User\PackageController@bulkDeleteLocation')->name('tenant.packages_management.bulk_delete_location');
                Route::post('/store_daywise_plan', 'User\PackageController@storeDaywisePlan')->name('tenant.packages_management.store_daywise_plan');
                Route::post('/store_timewise_plan', 'User\PackageController@storeTimewisePlan')->name('tenant.packages_management.store_timewise_plan');
                Route::get('/view_plans/{package_id}', 'User\PackageController@viewPlans')->name('tenant.packages_management.view_plans');
                Route::post('/update_daywise_plan', 'User\PackageController@updateDaywisePlan')->name('tenant.packages_management.update_daywise_plan');
                Route::post('/update_timewise_plan', 'User\PackageController@updateTimewisePlan')->name('tenant.packages_management.update_timewise_plan');
                Route::post('/delete_plan', 'User\PackageController@deletePlan')->name('tenant.packages_management.delete_plan');
                Route::post('/bulk_delete_plan', 'User\PackageController@bulkDeletePlan')->name('tenant.packages_management.bulk_delete_plan');
            });
        });
        // packages management route end

        // Package Bookings Routes start
        Route::group(['prefix' => 'package-bookings', 'middleware' => 'checkUserPermission:Tour Package'], function () {
            Route::get('/all_bookings', 'User\PackageController@bookings')->name('tenant.package_bookings.all_bookings');
            Route::get('/paid_bookings', 'User\PackageController@bookings')->name('tenant.package_bookings.paid_bookings');
            Route::get('/unpaid_bookings', 'User\PackageController@bookings')->name('tenant.package_bookings.unpaid_bookings');
            Route::post('/update_payment_status', 'User\PackageController@updatePaymentStatus')->name('tenant.package_bookings.update_payment_status');
            Route::get('/booking_details/{id}', 'User\PackageController@bookingDetails')->name('tenant.package_bookings.booking_details');
            Route::post('/send_mail', 'User\PackageController@sendMail')->name('tenant.package_bookings.send_mail');
            Route::post('/delete_booking/{id}', 'User\PackageController@deleteBooking')->name('tenant.package_bookings.delete_booking');
            Route::post('/bulk_delete_booking', 'User\PackageController@bulkDeleteBooking')->name('tenant.package_bookings.bulk_delete_booking');

            // package booking report
            Route::get('/report', 'User\PackageController@report')->name('tenant.package_management.report');
            Route::get('/export-report', 'User\PackageController@exportReport')->name('tenant.package_management.export_report');
        });
        // Package Bookings Routes End


         Route::prefix('/pages')->group(function () {
            // home page  route start
            Route::group(['prefix' => 'home-page'], function () {
                Route::group(['prefix' => 'image-texts'], function ($e) {
                    Route::get('/', 'User\BasicController@images_texts')->name('tenant.pages.home_page.images_texts');
                    Route::post('/update', 'User\BasicController@updateImages_texts')->name('tenant.pages.home_page.images_texts_update');
                });
                Route::group(['prefix' => 'sliders'], function () {
                    Route::get('/', 'User\HomePage\HeroSliderController@sliderVersion')->name('tenant.home_page.hero.slider_version');
                    Route::get('/create', 'User\HomePage\HeroSliderController@createSlider')->name('tenant.home_page.hero.create_slider');
                    Route::post('/slider_version/store_slider_info/{language}', 'User\HomePage\HeroSliderController@storeSliderInfo')->name('tenant.home_page.hero.store_slider_info');
                    Route::get('/edit/{id}', 'User\HomePage\HeroSliderController@editSlider')->name('tenant.home_page.hero.edit_slider');
                    Route::post('/update/{id}', 'User\HomePage\HeroSliderController@updateSliderInfo')->name('tenant.home_page.hero.update_slider_info');
                    Route::post('/delete-slider', 'User\HomePage\HeroSliderController@deleteSlider')->name('tenant.home_page.hero.delete_slider');
                });
                Route::group(['prefix' => 'statistics'], function () {
                    Route::get('/', 'User\HomePage\IntroSectionController@introSection')->name('tenant.home_page.intro_section');
                    Route::get('/create', 'User\HomePage\IntroSectionController@createCountInfo')->name('tenant.home_page.intro_section.create_count_info');
                    Route::post('/store/{language}', 'User\HomePage\IntroSectionController@storeCountInfo')->name('tenant.home_page.intro_section.store_count_info');
                    Route::get('/edit/{id}', 'User\HomePage\IntroSectionController@editCountInfo')->name('tenant.home_page.intro_section.edit_count_info');
                    Route::post('/update/{id}', 'User\HomePage\IntroSectionController@updateCountInfo')->name('tenant.home_page.intro_section.update_count_info');
                    Route::post('/delete', 'User\HomePage\IntroSectionController@deleteCountInfo')->name('tenant.home_page.intro_section.delete_count_info');
                });
                Route::group(['prefix' => 'facilities'], function () {
                    Route::get('/', 'User\HomePage\FacilityController@facilitySection')->name('tenant.home_page.facility_section');
                    Route::get('/create', 'User\HomePage\FacilityController@createFacility')->name('tenant.home_page.facility_section.create_facility');
                    Route::post('/store/{language}', 'User\HomePage\FacilityController@storeFacility')->name('tenant.home_page.facility_section.store_facility');
                    Route::get('/edit/{id}', 'User\HomePage\FacilityController@editFacility')->name('tenant.home_page.facility_section.edit_facility');
                    Route::post('/update/{id}', 'User\HomePage\FacilityController@updateFacility')->name('tenant.home_page.facility_section.update_facility');
                    Route::post('/delete', 'User\HomePage\FacilityController@deleteFacility')->name('tenant.home_page.facility_section.delete_facility');
                });
                Route::group(['prefix' => 'brand-partners'], function () {
                    Route::get('/', 'User\HomePage\BrandSectionController@brandSection')->name('tenant.home_page.brand_section');
                    Route::post('/store/{language}', 'User\HomePage\BrandSectionController@storeBrand')->name('tenant.home_page.brand_section.store_brand');
                    Route::post('/update', 'User\HomePage\BrandSectionController@updateBrand')->name('tenant.home_page.brand_section.update_brand');
                    Route::post('/delete', 'User\HomePage\BrandSectionController@deleteBrand')->name('tenant.home_page.brand_section.delete_brand');
                });
                Route::group(['prefix' => 'testimonials'], function () {
                    Route::get('/', 'User\HomePage\TestimonialController@testimonialSection')->name('tenant.home_page.testimonial_section');
                    Route::get('/create', 'User\HomePage\TestimonialController@createTestimonial')->name('tenant.home_page.testimonial_section.create_testimonial');
                    Route::post('/store/{language}', 'User\HomePage\TestimonialController@storeTestimonial')->name('tenant.home_page.testimonial_section.store_testimonial');
                    Route::get('/edit/{id}', 'User\HomePage\TestimonialController@editTestimonial')->name('tenant.home_page.testimonial_section.edit_testimonial');
                    Route::post('/update/{id}', 'User\HomePage\TestimonialController@updateTestimonial')->name('tenant.home_page.testimonial_section.update_testimonial');
                    Route::post('/delete', 'User\HomePage\TestimonialController@deleteTestimonial')->name('tenant.home_page.testimonial_section.delete_testimonial');
                });
                Route::group(['prefix' => 'sections'], function () {
                    Route::get('/', 'User\HomePage\SectionsController@sections')->name('tenant.sections.index');
                    Route::post('/update', 'User\HomePage\SectionsController@updatesections')->name('tenant.sections.update');
                });
                Route::prefix('additional-sections')->group(function () {
                    Route::get('sections', 'User\AdditionalSectionController@index')->name('user.additional_sections');
                    Route::get('add-section', 'User\AdditionalSectionController@create')->name('user.additional_section.create');
                    Route::post('store-section', 'User\AdditionalSectionController@store')->name('user.additional_section.store');
                    Route::get('edit-section/{id}', 'User\AdditionalSectionController@edit')->name('user.additional_section.edit');
                    Route::post('update/{id}', 'User\AdditionalSectionController@update')->name('user.additional_section.update');
                    Route::post('delete/{id}', 'User\AdditionalSectionController@delete')->name('user.additional_section.delete');
                    Route::post('bulkdelete', 'User\AdditionalSectionController@bulkdelete')->name('user.additional_section.bulkdelete');
                });
            });

            Route::prefix('about-us')->group(function () {

                //additional section
                Route::prefix('additional-sections')->group(function () {
                    Route::get('sections', 'User\AboutAdditionalSectionController@index')->name('user.about.additional_sections');
                    Route::get('add-section', 'User\AboutAdditionalSectionController@create')->name('user.about.additional_section.create');
                    Route::post('store-section', 'User\AboutAdditionalSectionController@store')->name('user.about.additional_section.store');
                    Route::get('edit-section/{id}', 'User\AboutAdditionalSectionController@edit')->name('user.about.additional_section.edit');
                    Route::post('update/{id}', 'User\AboutAdditionalSectionController@update')->name('user.about.additional_section.update');
                    Route::post('delete/{id}', 'User\AboutAdditionalSectionController@delete')->name('user.about.additional_section.delete');
                    Route::post('bulkdelete', 'User\AboutAdditionalSectionController@bulkdelete')->name('user.about.additional_section.bulkdelete');
                });
                //images & texts
                Route::prefix('images-texts')->group(function(){
                    Route::get('/', 'User\AboutPageController@index')->name('user.about.images_texts');
                    Route::post('/update', 'User\AboutPageController@update')->name('user.about.images_texts.update');
                });

                // sections show hide
                Route::get('/sections', 'User\AboutUsController@sections')->name('user.about.sections.index');
                Route::post('/sections/update', 'User\AboutUsController@updatesections')->name('user.about.sections.update');
            });

            Route::group(['prefix' => 'breadcrumbs'], function () {
                Route::group(['prefix' => 'breadcrumb'], function () {
                    Route::get('/', 'User\BasicController@breadcrumb')->name('user.breadcrumb');
                    Route::post('/update', 'User\BasicController@updateBreadcrumb')->name('user.update_breadcrumb');
                });
                Route::group(['prefix' => 'headings'], function () {
                    Route::get('/', 'User\PageHeadingController@pageHeadings')->name('user.page_headings');
                    Route::post('/update', 'User\PageHeadingController@updatePageHeadings')->name('user.update_page_headings');
                });
            });

            Route::group(['prefix' => 'contact-page'], function () {
                Route::get('/', 'User\BasicController@information')->name('user.basic_settings.information');
                Route::post('/update-contact-page', 'User\BasicController@updateInfo')->name('user.basic_settings.update_info');
            });
            //login page
            Route::group(['prefix' => 'login-page'], function () {
                Route::get('/', 'User\BasicController@loginPage')->name('user.basic_settings.login_page');
                Route::post('/update-contact-page', 'User\BasicController@updateloginPage')->name('user.basic_settings.update_login_page');
            });

            Route::group(['prefix' => 'singup-page'], function () {
                Route::get('/', 'User\BasicController@signupPage')->name('user.basic_settings.signup_page');
                Route::post('/update-contact-page', 'User\BasicController@updatesignupPage')->name('user.basic_settings.update_signup_page');
            });

            //error 404 page
            Route::group(['prefix' => 'error-404'], function () {
                Route::get('/', 'User\BasicController@error_404')->name('user.basic_settings.error_404');
                Route::post('/update-error-404', 'User\BasicController@updateError_404')->name('user.basic_settings.error_404_update');
            });

            // blog
            Route::prefix('/blog')->middleware('checkUserPermission:Blog')->group(function () {
                Route::get('/categories', 'User\Journal\CategoryController@index')->name('user.blog_management.categories');
                Route::post('/store-category/{language}', 'User\Journal\CategoryController@store')->name('user.blog_management.store_category');
                Route::get('/category/edit/{id}', 'User\Journal\CategoryController@edit')->name('user.blog_management.category.edit');
                Route::post('/update-category', 'User\Journal\CategoryController@update')->name('user.blog_management.update_category');
                Route::post('/delete-category/{id}', 'User\Journal\CategoryController@destroy')->name('user.blog_management.delete_category');
                Route::post('/bulk-delete-category', 'User\Journal\CategoryController@bulkDestroy')->name('user.blog_management.bulk_delete_category');

                Route::get('/blogs', 'User\Journal\BlogController@index')->name('user.blog_management.blogs');
                Route::get('/create-blog', 'User\Journal\BlogController@create')->name('user.blog_management.create_blog');
                Route::post('/store-blog/{language}', 'User\Journal\BlogController@store')->name('user.blog_management.store_blog')->middleware('limitCheck:blogs,store');
                Route::get('/edit-blog/{id}', 'User\Journal\BlogController@edit')->name('user.blog_management.edit_blog');
                Route::post('/update-blog/{id}', 'User\Journal\BlogController@update')->name('user.blog_management.update_blog')->middleware('limitCheck:blogs,update');;
                Route::post('/delete-blog/{id}', 'User\Journal\BlogController@destroy')->name('user.blog_management.delete_blog');
                Route::post('/bulk-delete-blog', 'User\Journal\BlogController@bulkDestroy')->name('user.blog_management.bulk_delete_blog');
            });
            // blog route end
            // faqs
            Route::prefix('/faqs')->group(function () {
                Route::get('', 'User\FaqController@index')->name('user.faq_management');
                Route::post('/store/{language}', 'User\FaqController@store')->name('user.faq_management.store_faq');
                Route::post('/update', 'User\FaqController@update')->name('user.faq_management.update_faq');
                Route::post('/delete/{id}', 'User\FaqController@destroy')->name('user.faq_management.delete_faq');
                Route::post('/bulk-delete', 'User\FaqController@bulkDestroy')->name('user.faq_management.bulk_delete_faq');
            });
            // faqs
            Route::prefix('/seo')->group(function () {
                Route::get('/', 'User\BasicController@seo')->name('user.basic_settings.seo');
                Route::post('/update', 'User\BasicController@updateSEO')->name('user.basic_settings.update_seo_informations');
            });
            //services
            Route::prefix('/service')->group(function () {
                Route::get('/', 'User\ServiceController@services')->name('tenant.services_management');
                Route::get('/create', 'User\ServiceController@createService')->name('tenant.services_management.create_service');
                Route::post('/store', 'User\ServiceController@storeService')->name('tenant.services_management.store_service');
                Route::post('/update_featured_service', 'User\ServiceController@updateFeaturedService')->name('tenant.services_management.update_featured_service');
                Route::get('/edit/{id}', 'User\ServiceController@editService')->name('tenant.services_management.edit_service');
                Route::post('/update/{id}', 'User\ServiceController@updateService')->name('tenant.services_management.update_service');
                Route::post('/delete', 'User\ServiceController@deleteService')->name('tenant.services_management.delete_service');
                Route::post('/bulk_delete', 'User\ServiceController@bulkDeleteService')->name('tenant.services_management.bulk_delete_service');
            });

            // gallery
            Route::prefix('/gallery')->group(function () {
                Route::get('/categories', 'User\GalleryController@categories')->name('tenant.gallery_management.categories');
                Route::post('/store_category/{language}', 'User\GalleryController@storeCategory')->name('tenant.gallery_management.store_category');
                Route::post('/update_category', 'User\GalleryController@updateCategory')->name('tenant.gallery_management.update_category');
                Route::post('/delete_category', 'User\GalleryController@deleteCategory')->name('tenant.gallery_management.delete_category');
                Route::post('/bulk_delete_category', 'User\GalleryController@bulkDeleteCategory')->name('tenant.gallery_management.bulk_delete_category');
                Route::get('/images', 'User\GalleryController@index')->name('tenant.gallery_management.images');
                Route::post('/store_gallery_info/{language}', 'User\GalleryController@storeInfo')->name('tenant.gallery_management.store_gallery_info');
                Route::post('/update_gallery_info', 'User\GalleryController@updateInfo')->name('tenant.gallery_management.update_gallery_info');
                Route::post('/delete_gallery_info', 'User\GalleryController@deleteInfo')->name('tenant.gallery_management.delete_gallery_info');
                Route::post('/bulk_delete_gallery_info', 'User\GalleryController@bulkDeleteInfo')->name('tenant.gallery_management.bulk_delete_gallery_info');
            });

            // menu builder
            Route::prefix('/menu-builder')->group(function () {
                Route::get('/', 'User\MenuBuilderController@index')->name('user.menu_builder.index');
                Route::post('/update', 'User\MenuBuilderController@update')->name('user.menu_builder.update');
            });

            //footer
            Route::prefix('/footer')->group(function () {
                Route::get('/content', 'User\FooterController@footerContent')->name('user.footer.content');
                Route::post('/update-content/{language}', 'User\FooterController@updateFooterContent')->name('user.footer.update_content');
                Route::get('/quick_links', 'User\FooterController@quickLinks')->name('user.footer.quick_links');
                Route::post('/store_quick_link', 'User\FooterController@storeQuickLink')->name('user.footer.store_quick_link');
                Route::post('/update_quick_link', 'User\FooterController@updateQuickLink')->name('user.footer.update_quick_link');
                Route::post('/delete_quick_link', 'User\FooterController@deleteQuickLink')->name('user.footer.delete_quick_link');
            });

            //Custom Page
            Route::prefix('/custom-pages')->middleware('checkUserPermission:Custom Page')->group(function () {
                Route::get('', 'User\CustomPageController@index')->name('user.custom_pages');
                Route::get('/create-page', 'User\CustomPageController@create')->name('user.custom_pages.create_page');
                Route::post('/store-page', 'User\CustomPageController@store')->name('user.custom_pages.store_page')->middleware('limitCheck:custom_pages,store');
                Route::get('/edit-page/{id}', 'User\CustomPageController@edit')->name('user.custom_pages.edit_page');
                Route::post('/update-page/{id}', 'User\CustomPageController@update')->name('user.custom_pages.update_page')->middleware('limitCheck:custom_pages,update');
                Route::post('/delete-page/{id}', 'User\CustomPageController@destroy')->name('user.custom_pages.delete_page');
                Route::post('/bulk-delete-page', 'User\CustomPageController@bulkDestroy')->name('user.custom_pages.bulk_delete_page');
            });
        });

        // announcement-popup route start
        Route::prefix('/announcement-popups')->group(function () {
            Route::get('', 'User\PopupController@index')->name('user.announcement_popups');
            Route::get('/select-popup-type', 'User\PopupController@popupType')->name('user.announcement_popups.select_popup_type');
            Route::get('/create-popup/{type}', 'User\PopupController@create')->name('user.announcement_popups.create_popup');
            Route::post('/store-popup', 'User\PopupController@store')->name('user.announcement_popups.store_popup');
            Route::post('/popup/{id}/update-status', 'User\PopupController@updateStatus')->name('user.announcement_popups.update_popup_status');
            Route::get('/edit-popup/{id}', 'User\PopupController@edit')->name('user.announcement_popups.edit_popup');
            Route::post('/update-popup/{id}', 'User\PopupController@update')->name('user.announcement_popups.update_popup');
            Route::post('/delete-popup/{id}', 'User\PopupController@destroy')->name('user.announcement_popups.delete_popup');
            Route::post('/bulk-delete-popup', 'User\PopupController@bulkDestroy')->name('user.announcement_popups.bulk_delete_popup');
        });
        
        Route::group(['prefix' => 'user-management', 'middleware' => 'checkPackage'], function () {
            Route::get('/registered-users', 'User\RegisteredUserController@index')->name('user.registered_users');
            Route::post('/user/{id}/update-account-status', 'User\RegisteredUserController@updateAccountStatus')->name('user.user.update_account_status');
            Route::post('register/users/email', 'User\RegisteredUserController@emailStatus')->name('user.email');
            Route::get('/user/{id}/details', 'User\RegisteredUserController@show')->name('user.user_details');
            Route::get('/user/{id}/change-password', 'User\RegisteredUserController@changePassword')->name('user.user.change_password');
            Route::post('/user/{id}/update-password', 'User\RegisteredUserController@updatePassword')->name('user.user.update_password');
            Route::post('/user/{id}/delete', 'User\RegisteredUserController@destroy')->name('user.user.delete');
            Route::post('/bulk-delete-user', 'User\RegisteredUserController@bulkDestroy')->name('user.bulk_delete_user');
            Route::get('register/user/secret-login/{id}', 'User\RegisteredUserController@secret_login')->name('user.register.user.secret_login');
            //user subscriber routes
            Route::group(['prefix' => 'subscribers'], function () {
                Route::get('/', 'User\SubscriberController@index')->name('user.subscriber.index');
                Route::get('/mailsubscriber', 'User\SubscriberController@mailsubscriber')->name('user.mailsubscriber');
                Route::post('/sendmail', 'User\SubscriberController@subscsendmail')->name('user.subscribers.sendmail');
                Route::post('/delete', 'User\SubscriberController@delete')->name('user.subscriber.delete');
                Route::post('/bulk-delete', 'User\SubscriberController@bulkDelete')->name('user.subscriber.bulk.delete');
            });
        });
        // basic settings
        Route::group(['prefix' => 'settings'], function ($e) {
            //general-settings Routes
            Route::group(['prefix' => 'general-settings'], function () {
                Route::get('/', 'User\BasicController@generalSettings')->name('user.site_settings.general_settings');
                Route::post('/update', 'User\BasicController@updateGeneralSettings')->name('user.site_settings.update_general_settings');
            });
            //lanuages Routes
            Route::group(['prefix' => 'language'], function () {
                Route::get('/all', 'User\LanguageController@index')->name('user.language.index');
                Route::get('/{id}/edit', 'User\LanguageController@edit')->name('user.language.edit');
                Route::get('/{id}/edit/keyword', 'User\LanguageController@editKeyword')->name('user.language.editKeyword');
                Route::post('/{id}/update/keyword', 'User\LanguageController@updateKeyword')->name('user.language.updateKeyword')->middleware('limitCheck:languages,update');
                Route::post('/store', 'User\LanguageController@store')->name('user.language.store')->middleware('limitCheck:languages,store');
                Route::post('/upload', 'User\LanguageController@upload')->name('user.language.upload');
                Route::post('/{id}/uploadUpdate', 'User\LanguageController@uploadUpdate')->name('user.language.uploadUpdate');
                Route::post('/{id}/default', 'User\LanguageController@makeDefault')->name('user.language.default')->withoutMiddleware('Demo');
                Route::post('/{id}/dashboard-default', 'User\LanguageController@makeDashboardDefault')->name('user.language.dashboard_default')->withoutMiddleware('Demo');
                Route::post('/{id}/delete', 'User\LanguageController@destroy')->name('user.language.delete');
                Route::post('/update', 'User\LanguageController@update')->name('user.language.update')->middleware('limitCheck:languages,update');
            });

            //Gateways Routes
            Route::group(['prefix' => 'gateways'], function () {
                Route::get('/', 'User\GatewayController@index')->name('user.gateway.index');
                Route::post('/stripe/update', 'User\GatewayController@stripeUpdate')->name('user.stripe.update');
                Route::post('/anet/update', 'User\GatewayController@anetUpdate')->name('user.anet.update');
                Route::post('/paypal/update', 'User\GatewayController@paypalUpdate')->name('user.paypal.update');
                Route::post('/paystack/update', 'User\GatewayController@paystackUpdate')->name('user.paystack.update');
                Route::post('/paytm/update', 'User\GatewayController@paytmUpdate')->name('user.paytm.update');
                Route::post('/flutterwave/update', 'User\GatewayController@flutterwaveUpdate')->name('user.flutterwave.update');
                Route::post('/instamojo/update', 'User\GatewayController@instamojoUpdate')->name('user.instamojo.update');
                Route::post('/mollie/update', 'User\GatewayController@mollieUpdate')->name('user.mollie.update');
                Route::post('/razorpay/update', 'User\GatewayController@razorpayUpdate')->name('user.razorpay.update');
                Route::post('/mercadopago/update', 'User\GatewayController@mercadopagoUpdate')->name('user.mercadopago.update');
                // User Offline Gateway Routes
                Route::get('/offline', 'User\GatewayController@offline')->name('user.gateway.offline');
                Route::post('/offline/store', 'User\GatewayController@store')->name('user.gateway.offline.store');
                Route::post('/offline/update', 'User\GatewayController@update')->name('user.gateway.offline.update');
                Route::post('/offline/status', 'User\GatewayController@status')->name('user.offline.status');
                Route::post('/offline/delete', 'User\GatewayController@delete')->name('user.offline.gateway.delete');
            });

            // User Domains & URLs
            Route::group(['middleware' => 'checkUserPermission:Custom Domain'], function () {
                Route::get('/domains', 'User\DomainController@domains')->name('user-domains');
                Route::post('/request/domain', 'User\DomainController@domainrequest')->name('user-domain-request');
            });
            // User Subdomains & URLs
            Route::get('/subdomain', 'User\SubdomainController@subdomain')->name('user-subdomain');

            // User Change Password Routes
            Route::group(['prefix' => 'password'], function () {
                Route::get('/change', 'User\UserController@changePass')->name('user.changePass');
                Route::post('/update', 'User\UserController@updatePassword')->name('user.updatePassword');
            });

            //profile Routes
            Route::group(['prefix' => 'profile'], function () {
                Route::get('/edit', 'User\UserController@profile')->name('user.profile_edit');
                Route::post('/update', 'User\UserController@profileupdate')->name('user-profile-update');
            });

            //maintenance-mode Routes 
            Route::group(['prefix' => 'maintenance-mode'], function () {
                Route::get('/', 'User\BasicController@maintenance')->name('user.maintenance_mode');
                Route::post('/update', 'User\BasicController@updateMaintenance')->name('user.update_maintenance_mode');
            });

            // user Social routes
            Route::group(['prefix' => 'social'], function () {
                Route::get('/', 'User\SocialController@index')->name('user.social.index');
                Route::post('/store', 'User\SocialController@store')->name('user.social.store');
                Route::get('/{id}/edit', 'User\SocialController@edit')->name('user.social.edit');
                Route::post('/update', 'User\SocialController@update')->name('user.social.update');
                Route::post('/delete', 'User\SocialController@delete')->name('user.social.delete');
            });

            // mail  routes
            Route::group(['prefix' => 'mail'], function ($e) {
                Route::get('/information', 'User\BasicController@getMailInformation')->name('user.mail.info');
                Route::post('/information', 'User\BasicController@storeMailInformation')->name('user.mail.info.update');
                Route::get('/templates', 'User\MailTemplateController@index')->name('user.mail_templates');
                Route::get('/edit-mail-template/{id}', 'User\MailTemplateController@edit')->name('user.edit_mail_template');
                Route::post('/update-mail-template/{id}', 'User\MailTemplateController@update')->name('user.update_mail_template');
            });

            // cookie-alert  routes
            Route::group(['prefix' => 'cookie-alert'], function ($e) {
                Route::get('/', 'User\CookieAlertController@cookieAlert')->name('user.cookie_alert');
                Route::post('/update', 'User\CookieAlertController@updateCookieAlert')->name('user.update_cookie_alert');
            });
            // plugins Route
            Route::group(['prefix' => 'plugins'], function ($e) {
                Route::get('/', 'User\BasicController@plugins')->name('user.plugins');
                Route::post('/basic_settings/update_script', 'User\BasicController@updateScript')->name('tenant.basic_settings.update_script');
            });
        });
        // Tenant tickets route start
        Route::group(['middleware' => 'checkUserPermission:Support Ticket'], function () {
            Route::get('/tickets', 'User\TicketController@index')->name('tenant.tickets');
            Route::get('/ticket/create', 'User\TicketController@create')->name('tenant.ticket.create');
            Route::get('/ticket/messages/{id}', 'User\TicketController@messages')->name('tenant.ticket.messages');
            Route::post('/ticket/store/', 'User\TicketController@ticketstore')->name('tenant.ticket.store');
            Route::post('/ticket/reply/{id}', 'User\TicketController@ticketreply')->name('tenant.ticket.reply');
            Route::post('/zip-file/upload', 'User\TicketController@zip_upload')->name('zip.upload');
        });

        Route::group(['prefix'=> 'advertisements','middleware' => 'checkUserPermission:Advertisement'],function(){
            Route::get('/settings', 'User\AdvertisementController@advertiseSettings')->name('user.advertise.settings');
            Route::post('/update-settings', 'User\AdvertisementController@updateAdvertiseSettings')->name('user.advertise.update_settings');
            Route::get('', 'User\AdvertisementController@index')->name('user.advertisements');
            Route::post('/store-advertisement', 'User\AdvertisementController@store')->name('user.advertise.store_advertisement');
            Route::post('/update-advertisement', 'User\AdvertisementController@update')->name('user.advertise.update_advertisement');
            Route::post('/delete-advertisement/{id}', 'User\AdvertisementController@destroy')->name('user.advertise.delete_advertisement');
            Route::post('/bulk-delete-advertisement', 'User\AdvertisementController@bulkDestroy')->name('user.advertise.bulk_delete_advertisement');
        });
        //user package extend route
        Route::group(['prefix' => 'membership'], function ($e) {
            Route::get('/package-list', 'User\BuyPlanController@index')->name('user.plan.extend.index');
            Route::get('/package/checkout/{package_id}', 'User\BuyPlanController@checkout')->name('user.plan.extend.checkout');
            Route::post('/package/checkout', 'User\UserCheckoutController@checkout')->name('user.plan.checkout');
            // Payment Log
            Route::get('/payment-log', 'User\PaymentLogController@index')->name('user.payment-log.index');
        });
        // user QR Builder
        Route::group(['middleware' => 'checkUserPermission:QR Builder'], function () {
            Route::get('/saved/qrs', 'User\QrController@index')->name('user.qrcode.index');
            Route::post('/saved/qr/delete', 'User\QrController@delete')->name('user.qrcode.delete')->withoutMiddleware('Demo');;
            Route::post('/saved/qr/bulk-delete', 'User\QrController@bulkDelete')->name('user.qrcode.bulk.delete')->withoutMiddleware('Demo');
            Route::get('/qr-code', 'User\QrController@qrCode')->name('user.qrcode');
            Route::post('/qr-code/generate', 'User\QrController@generate')->name('user.qrcode.generate')->withoutMiddleware('Demo');
            Route::get('/qr-code/clear', 'User\QrController@clear')->name('user.qrcode.clear');
            Route::post('/qr-code/save', 'User\QrController@save')->name('user.qrcode.save')->withoutMiddleware('Demo');;
            Route::get('qr-code/download/{name?}', 'User\QrController@download')->name('user.qrcode.download');
        });
    });
});
