<?php

use App\Http\Middleware\UserMaintenance;
use Illuminate\Support\Facades\Route;

$domain = env('WEBSITE_HOST');

if (!app()->runningInConsole()) {
    if (substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {
        $domain = 'www.' . env('WEBSITE_HOST');
    }
}



$parsedUrl = parse_url(url()->current());

$host = str_replace("www.", "", $parsedUrl['host']);
if (array_key_exists('host', $parsedUrl)) {
    // if it is a path based URL
    if ($host == env('WEBSITE_HOST')) {
        $domain = $domain;
        $prefix = '/{username}';
    }
    // if it is a subdomain / custom domain
    else {
        if (!app()->runningInConsole()) {
            if (substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {
                $domain = 'www.{domain}';
            } else {
                $domain = '{domain}';
            }
        }
        $prefix = '';
    }
}

Route::group(['domain' => $domain, 'prefix' => $prefix, 'middleware' => 'userMaintenance'], function () {

    Route::get('/', 'FrontEnd\UserViewController@userDetailView')->name('front.user.detail.view');
    Route::get('/about', 'FrontEnd\UserViewController@userAbout')->name('front.user.about');
    Route::get('/faq', 'FrontEnd\FAQController@faqs')->name('faqs');
    //======= Rooms========
    Route::group(['prefix' => 'rooms'], function () {
        Route::get('/', 'FrontEnd\Room\RoomController@rooms')->name('rooms');
        Route::get('/details/{slug}', 'FrontEnd\Room\RoomController@roomDetails')->name('room_details');
        Route::post('/store_review/{id}', 'FrontEnd\Room\RoomController@storeReview')->name('room.store_review')->middleware('Demo');

        Route::group(['prefix' => 'user'], function () {
            Route::post('/room_booking/apply_coupon', 'FrontEnd\Room\RoomBookingController@applyCoupon');
            Route::get('/room_booking/remove_coupon', 'FrontEnd\Room\RoomBookingController@removeCoupon');
            Route::post('/room_booking', 'FrontEnd\Room\RoomBookingController@makeRoomBooking')->name('room_booking')->middleware('Demo');
            Route::get('/room_booking/paypal/notify', 'FrontEnd\Room\PayPalController@notify')->name('room_booking.paypal.notify');
            Route::post('/room_booking/paytm/notify', 'FrontEnd\Room\PaytmController@notify')->name('room_booking.paytm.notify');
            Route::get('/room_booking/instamojo/notify', 'FrontEnd\Room\InstamojoController@notify')->name('room_booking.instamojo.notify');
            Route::get('/room_booking/paystack/notify', 'FrontEnd\Room\PaystackController@notify')->name('room_booking.paystack.notify');

            Route::post('/room_booking/flutterwave/notify', 'FrontEnd\Room\FlutterwaveController@notify')->name('room_booking.flutterwave.notify');

            Route::get('/room_booking/mollie/notify', 'FrontEnd\Room\MollieController@notify')->name('room_booking.mollie.notify');

            Route::post('/room_booking/razorpay/notify', 'FrontEnd\Room\RazorpayController@notify')->name('room_booking.razorpay.notify');

            Route::get('/room_booking/mercadopago/notify', 'FrontEnd\Room\MercadoPagoController@notify')->name('room_booking.mercadopago.notify');
            Route::get('/room_booking/complete', 'FrontEnd\Room\RoomBookingController@complete')->name('room_booking.complete');
            Route::get('/room_booking/cancel', 'FrontEnd\Room\RoomBookingController@cancel')->name('room_booking.cancel');
        });
    });

    //=== services ===
    Route::group(['prefix' => 'services'], function () {
        Route::get('/', 'FrontEnd\ServiceController@services')->name('services');
        Route::get('/service-details/{slug}', 'FrontEnd\ServiceController@serviceDetails')->name('service_details');
    });

    //=== Blogs ===
    Route::group(['middleware' => 'routeAccess:Blog'], function () {
        Route::get('/blog', 'FrontEnd\BlogController@blogs')->name('blogs');
        Route::get('/blog-details/{slug}', 'FrontEnd\BlogController@blogDetails')->name('blog_details');
    });
    //=====gallery=====
    Route::get('/gallery', 'FrontEnd\GalleryController@gallery')->name('gallery');

    //======= Packeges========
    Route::group(['prefix' => 'packages', 'middleware' => 'routeAccess:Tour Package'], function () {
        Route::get('/', 'FrontEnd\Package\PackageController@packages')->name('packages');
        Route::get('/details/{slug}', 'FrontEnd\Package\PackageController@packageDetails')->name('package_details');
        Route::post('/store_review/{id}', 'FrontEnd\Package\PackageController@storeReview')->name('package.store_review')->middleware('Demo');
        Route::group(['prefix' => 'user'], function () {
            Route::post('/package_booking/apply_coupon', 'FrontEnd\Package\PackageBookingController@applyCoupon');
            Route::get('/package_booking/remove_coupon', 'FrontEnd\Package\PackageBookingController@removeCoupon');
            Route::post('/package_booking', 'FrontEnd\Package\PackageBookingController@makePackageBooking')->name('package_booking')->middleware('Demo');

            Route::get('/package-booking/paypal/notify', 'FrontEnd\Package\PayPalController@notify')->name('package_booking.paypal.notify');

            Route::get('/package-booking/stripe/notify', 'FrontEnd\Package\StripeController@notify')->name('package_booking.stripe.notify');

            Route::get('/package_booking/instamojo/notify', 'FrontEnd\Package\InstamojoController@notify')->name('package_booking.instamojo.notify');

            Route::get('/package_booking/paystack/notify', 'FrontEnd\Package\PaystackController@notify')->name('package_booking.paystack.notify');

            Route::post('/package_booking/razorpay/notify', 'FrontEnd\Package\RazorpayController@notify')->name('package_booking.razorpay.notify');

            Route::get('/package_booking/mollie/notify', 'FrontEnd\Package\MollieController@notify')->name('package_booking.mollie.notify');

            Route::post('/package_booking/paytm/notify', 'FrontEnd\Package\PaytmController@notify')->name('package_booking.paytm.notify');

            Route::get('/package_booking/mercadopago/notify', 'FrontEnd\Package\MercadoPagoController@notify')->name('package_booking.mercadopago.notify');

            Route::post('/package_booking/flutterwave/notify', 'FrontEnd\Package\FlutterwaveController@notify')->name('package_booking.flutterwave.notify');

            Route::get('/package-booking/complete', 'FrontEnd\Package\PackageBookingController@complete')->name('package_booking.complete');

            Route::get('/package-booking/cancel', 'FrontEnd\Package\PackageBookingController@cancel')->name('package_booking.cancel');
        });
    });

    //========= Customer login
    Route::prefix('/user')->middleware(['guest:customer'])->group(function () {

        Route::get('/login/google', 'FrontEnd\CustomerController@redirectToGoogle')->name('customer.google_login');
        Route::get('/login/google/callback', 'FrontEnd\CustomerController@handleGoogleCallback')->name('user.client.google.callback');

        // user redirect to login page route
        Route::get('/login', 'FrontEnd\CustomerController@login')->name('customer.login');

        // user login submit route
        Route::post('/login-submit',  'FrontEnd\CustomerController@loginSubmit')->name('customer.login_submit');

        // user forget password route
        Route::get('/forget-password', 'FrontEnd\CustomerController@forgetPassword')->name('customer.forget_password');


        // send mail to user for forget password route
        Route::post('/mail-for-forget-password', 'FrontEnd\CustomerController@sendMail')->name('customer.mail_for_forget_password')->middleware('Demo');

        // reset password route
        Route::get('/reset-password/form', 'FrontEnd\CustomerController@resetPassword')->name('password.reset.form');

        // user reset password submit route
        Route::post('/reset-password-submit', 'FrontEnd\CustomerController@resetPasswordSubmit')->name('customer.reset_password_submit')->middleware('Demo');

        // user redirect to signup page route
        Route::get('/signup', 'FrontEnd\CustomerController@signup')->name('customer.signup');

        // user signup submit route
        Route::post('/signup-submit', 'FrontEnd\CustomerController@signupSubmit')->name('customer.signup_submit')->middleware('Demo');

        // signup verify route
        Route::get('/signup-verify/{token}', 'FrontEnd\CustomerController@signupVerify')->name('customer.signup.verify');
    });


    //======= dashboard
    Route::prefix('/user')->middleware(['auth:customer', 'accountStatus', 'checkWebsiteOwner'])->group(function () {
        // user redirect to dashboard route
        Route::get('/dashboard', 'FrontEnd\CustomerController@redirectToDashboard')->name('customer.dashboard');
        // edit profile route
        Route::get('/edit-profile', 'FrontEnd\CustomerController@editProfile')->name('customer.edit_profile');
        // update profile route
        Route::post('/update-profile', 'FrontEnd\CustomerController@updateProfile')->name('customer.update_profile');
        // change password route
        Route::get('/change-password',  'FrontEnd\CustomerController@changePassword')->name('customer.change_password');
        // update password route
        Route::post('/update-password',  'FrontEnd\CustomerController@updatePassword')->name('customer.update_password');
        // user logout attempt route
        Route::get('/logout',  'FrontEnd\CustomerController@logoutSubmit')->name('customer.logout');
        Route::get('/my-room/booking', 'FrontEnd\CustomerController@myRoomBoking')->name('customer.room_booking');
        Route::get('/room-booking-details/{id}', 'FrontEnd\CustomerController@roomBookingDetails')->name('customer.room_booking_details');

        Route::group(['prefix' => 'package-bookings', 'middleware' => 'routeAccess:Tour Package'], function () {
            Route::get('/', 'FrontEnd\CustomerController@packageBookings')->name('customer.package_bookings');
            Route::get('/details/{id}', 'FrontEnd\CustomerController@packageBookingDetails')->name('user.package_booking_details');
        });
    });

    //======== Custom Pages
    Route::group(['middleware' => ['routeAccess:Custom Page']], function () {
        Route::get('/{slug}', 'FrontEnd\UserViewController@userCPage')->name('front.user.cpage');
    });

    //==== contact pages ==

    Route::get('/contact/support', 'FrontEnd\ContactController@contact')->name('contact');
    Route::post('/contact/send_mail', 'FrontEnd\ContactController@sendMail')->name('contact.send_mail');
    Route::post('/contact/message', 'FrontEnd\UserViewController@contactMessage')->name('front.contact.message');
    //change lanauge
    Route::get('user/change-language', 'FrontEnd\UserViewController@changeUserLanguage')->name('front.user.change_language');
    
    //support ticket
    Route::post('/subscribe', 'User\SubscriberController@store')->name('front.user.subscriber');
    Route::get('apply/{token}', 'FrontEnd\UserViewController@removeMaintenance')->name('front.user.remove')->withoutMiddleware(UserMaintenance::class);
});
