<?php

use Illuminate\Support\Facades\Route;

$domain = env('WEBSITE_HOST');

if (!app()->runningInConsole()) {
  if (substr($_SERVER['HTTP_HOST'], 0, 4) === 'www.') {
    $domain = 'www.' . env('WEBSITE_HOST');
  }
}

Route::fallback(function () {
  return view('errors.404');
});

Route::get('/forget/coupon', function () {
  request()->session()->forget('discountedCourse');
  request()->session()->forget('discount');
  request()->session()->forget('discountedPrice');
});



Route::domain($domain)->group(function () {

  // cron job for sending expiry mail
  Route::get('/subcheck', 'CronJobController@expired')->name('cron.expired');
  
  Route::get('/changelanguage/{lang}', 'Front\FrontendController@changeLanguage')->name('changeLanguage');

  Route::group(['middleware' => 'setlang'], function () {
    Route::get('/', 'Front\FrontendController@index')->name('front.index');
    Route::post('/subscribe', 'Front\FrontendController@subscribe')->name('front.subscribe');
    Route::get('/listings', 'Front\FrontendController@users')->name('front.user.view');
    Route::get('/contact', 'Front\FrontendController@contactView')->name('front.contact');
    Route::get('/faqs', 'Front\FrontendController@faqs')->name('front.faq.view');
    Route::get('/blog', 'Front\FrontendController@blogs')->name('front.blogs');
    Route::get('/pricing', 'Front\FrontendController@pricing')->name('front.pricing');
    Route::get('/blog-details/{id}/{slug}', 'Front\FrontendController@blogdetails')->name('front.blogdetails');
    Route::get('/registration/step-1/{status}/{id}', 'Front\FrontendController@step1')->name('front.register.view');
    Route::get('/registration', 'Front\FrontendController@commisionRegister')->name('front.composion.register.view');
    Route::get('/check/{username}/username', 'Front\FrontendController@checkUsername')->name('front.username.check');
    Route::get('/p/{slug}', 'Front\FrontendController@dynamicPage')->name('front.dynamicPage');
    Route::get('/about', 'Front\FrontendController@about')->name('front.about');
    Route::view('/success', 'front.success')->name('success.page');
  });

  Route::group(['middleware' => ['web', 'guest', 'setlang']], function () {
    Route::get('/registration/final-step', 'Front\FrontendController@step2')->name('front.registration.step2');
    Route::post('/checkout', 'Front\FrontendController@checkout')->name('front.checkout.view');
  });

  Route::group(['middleware' => ['web', 'setlang']], function () {
    Route::post('/coupon', 'Front\CheckoutController@coupon')->name('front.membership.coupon');
    Route::post('/membership/checkout', 'Front\CheckoutController@checkout')->name('front.membership.checkout')->middleware('Demo');
    Route::post('/payment/instructions', 'Front\FrontendController@paymentInstruction')->name('front.payment.instructions');
    Route::post('/contact/message', 'Front\FrontendController@contactMessage')->name('front.contact.message');
    Route::post('/admin/contact-msg', 'Front\FrontendController@adminContactMessage')->name('front.admin.contact.message')->middleware('Demo');

    //checkout payment gateway routes
    Route::prefix('membership')->middleware('setlang')->group(function () {
      Route::get('paypal/success', "Payment\PaypalController@successPayment")->name('membership.paypal.success');
      Route::get('paypal/cancel', "Payment\PaypalController@cancelPayment")->name('membership.paypal.cancel');
      Route::get('stripe/cancel', "Payment\StripeController@cancelPayment")->name('membership.stripe.cancel');
      Route::post('paytm/payment-status', "Payment\PaytmController@paymentStatus")->name('membership.paytm.status');
      Route::get('paystack/success', 'Payment\PaystackController@successPayment')->name('membership.paystack.success');
      Route::post('mercadopago/cancel', 'Payment\paymenMercadopagoController@cancelPayment')->name('membership.mercadopago.cancel');
      Route::post('mercadopago/success', 'Payment\MercadopagoController@successPayment')->name('membership.mercadopago.success');
      Route::post('razorpay/success', 'Payment\RazorpayController@successPayment')->name('membership.razorpay.success');
      Route::post('razorpay/cancel', 'Payment\RazorpayController@cancelPayment')->name('membership.razorpay.cancel');
      Route::get('instamojo/success', 'Payment\InstamojoController@successPayment')->name('membership.instamojo.success');
      Route::get('instamojo/cancel', 'Payment\InstamojoController@cancelPayment')->name('membership.instamojo.cancel');
      Route::post('flutterwave/success', 'Payment\FlutterWaveController@successPayment')->name('membership.flutterwave.success');
      Route::post('flutterwave/cancel', 'Payment\FlutterWaveController@cancelPayment')->name('membership.flutterwave.cancel');
      Route::get('/mollie/success', 'Payment\MollieController@successPayment')->name('membership.mollie.success');
      Route::post('mollie/cancel', 'Payment\MollieController@cancelPayment')->name('membership.mollie.cancel');
      Route::get('anet/cancel', 'Payment\AuthorizenetController@cancelPayment')->name('membership.anet.cancel');
      Route::get('/offline/success', 'Front\CheckoutController@offlineSuccess')->name('membership.offline.success');
      Route::get('/trial/success', 'Front\CheckoutController@trialSuccess')->name('membership.trial.success');
    });
  });
  Route::group(['middleware' => ['web', 'guest']], function () {
    Route::get('/login', 'User\Auth\LoginController@showLoginForm')->name('user.login');
    Route::post('/login', 'User\Auth\LoginController@login')->name('user.login.submit');
    Route::get('/register', 'User\Auth\RegisterController@registerPage')->name('user-register');
    Route::post('/register/submit', 'User\Auth\RegisterController@register')->name('user-register-submit')->middleware('Demo');
    Route::get('/register/mode/{mode}/verify/{token}', 'User\Auth\RegisterController@token')->name('user-register-token');

    Route::get('/password/forget', 'User\Auth\ForgotPasswordController@showLinkRequestForm')->name('user.forgot.password.form')->middleware('setlang');
    Route::post('/password/email', 'User\Auth\ForgotPasswordController@sendResetLinkEmail')->name('user.forgot.password.submit')->middleware('setlang')->middleware('Demo');
    Route::get('/password/reset/form', 'User\Auth\ResetPasswordController@showResetForm')->name('user.reset.password.form');
    Route::post('/password/reset/submit', 'User\Auth\ForgotPasswordController@createNewPassword')->name('user.reset.password.submit')->middleware('Demo');
  });
});
