@extends('user.layout')

@section('content')

  <div class="page-header">
    <h4 class="page-title">{{ __('My Tickets') }}</h4>
    <ul class="breadcrumbs">
      <li class="nav-home">
        <a href="{{ route('user-dashboard') }}">
          <i class="flaticon-home"></i>
        </a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">{{ __('Support Tickets') }}</a>
      </li>
      <li class="separator">
        <i class="flaticon-right-arrow"></i>
      </li>
      <li class="nav-item">
        <a href="#">{{ __('My Tickets') }}</a>
      </li>
    </ul>
  </div>
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <div class="row">
            <div class="col-lg-4">
              <div class="card-title d-inline-block">

              </div>
            </div>
            <div class="col-lg-3 offset-lg-5 mt-2 mt-lg-0">
              <form action="{{ url()->current() }}" method="GET">
                <input class="form-control" type="text" name="search"
                  value="{{ request()->input('search') ? request()->input('search') : '' }}"
                  placeholder="{{ __('Enter Ticket Number') }}">
              </form>
            </div>
          </div>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-lg-12">
              <a class="btn btn-info btn-sm float-right d-inline-block" href="{{ route('tenant.ticket.create') }}">
                {{ __('Create Ticket') }}
              </a>
              @if ($tickets->count() == 0)
                <h3 class="text-center">{{ __('NO TICKET FOUND') }}</h3>
              @else
                <div class="table-responsive">
                  <table class="table table-striped mt-3">
                    <thead>
                      <tr>
                        <th scope="col">{{ __('Ticket Number') }}</th>
                        <th scope="col">{{ __('Subject') }}</th>
                        <th scope="col">{{ __('Status') }}</th>
                        <th scope="col">{{ __('Message') }}</th>
                      </tr>
                    </thead>
                    <tbody>
                      @foreach ($tickets as $ticket)
                        <tr>
                          <td>
                            #{{ $ticket->ticket_number }}
                          </td>
                          <td>{{ $ticket->subject }}</td>
                          <td>
                            @if ($ticket->status == 'pending')
                              <span class="badge badge-warning">{{ __('Pending') }}</span>
                            @elseif($ticket->status == 'open')
                              <span class="badge badge-primary">{{ __('Open') }}</span>
                            @else
                              <span class="badge badge-danger">{{ __('Closed') }}</span>
                            @endif
                          </td>
                          <td>
                            <a href="{{ route('tenant.ticket.messages', $ticket->ticket_number) }}"
                              class="btn btn-primary   border-0 btn-sm">
                              <i class="fas fa-comments"></i>
                            </a>
                          </td>
                        </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              @endif
            </div>
          </div>
        </div>
        <div class="card-footer">
          <div class="row">
            <div class="d-inline-block mx-auto">
              {{ $tickets->appends(['search' => request()->input('search')])->links() }}
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


@endsection
@section('scripts')
<script src="{{ asset('assets/tenant/js/ticket.js') }}"></script>
@endsection
