@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Signup Page') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Signup Page') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 mb-3 mb-lg-0">
                            <div class="card-title">{{ __('Update Signup Page') }}</div>
                        </div>

                        <div class="col-lg-2">
                            @includeIf('user.partials.languages')
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto ">
                            <form id="ajaxForm"
                                action="{{ route('user.basic_settings.update_signup_page', ['language' => request()->input('language')]) }}"
                                method="post">
                                @csrf

                                <div class="form-group">
                                    <div class="col-12 mb-2 pl-0">
                                        <label for="image"><strong>{{ __('Image') }} <span
                                                    class="text-danger">**</span></strong></label>
                                    </div>
                                    <div class="col-md-12 showImage2 mb-3 pl-0 pr-0">
                                        <img src="{{ $data != null ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_IMAGE, $data->signup_page_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                            alt="..." class="img-thumbnail">
                                    </div>
                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image2">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="signup_page_image">
                                    </div>
                                    <p id="err_signup_page_image" class="mb-0 text-danger em"></p>
                                    <p class="text-warning">{{ __('Only JPG, JPEG, PNG images are allowed') }}</p>
                                    <p class="text-warning mt-0">{{ __('Recommended image size: Upload 624X591 pixel size image') }}
                                    </p>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="signup_page_title"
                                        value="{{ $data != null ? $data->signup_page_title : '' }}"
                                        placeholder="{{ __('Enter Title') }}">
                                    <p id="err_signup_page_title" required class="em text-danger mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Subtitle') }}</label>
                                    <input type="text" class="form-control" name="signup_page_subtitle"
                                        value="{{ $data != null ? $data->signup_page_subtitle : '' }}"
                                        placeholder="">
                                    <p id="err_signup_page_subtitle" required class="em text-danger mb-0"></p>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="submitBtn" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
