@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('SEO Informations') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('SEO Informations') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form action="{{ route('user.basic_settings.update_seo_informations') }}" method="post">
                    @csrf
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-9 mb-3 mb-lg-0">
                                <div class="card-title">{{ __('Update SEO Informations') }}</div>
                            </div>
                            <div class="col-lg-3">
                                @includeIf('user.partials.languages')
                            </div>
                        </div>
                    </div>

                    <div class="card-body pt-5 pb-5">
                        <div class="row">

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Home Page') }}</label>
                                    <input class="form-control" name="home_meta_keywords"
                                        value="{{ $data->home_meta_keywords }}"
                                        placeholder="{{ __('Enter Meta Keywords') }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Home Page') }}</label>
                                    <textarea class="form-control" name="home_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->home_meta_description }}</textarea>
                                </div>
                            </div>

                            @php
                                $user = Auth::guard('web')->user();
                                if (!empty($user)) {
                                    $permissions = \App\Http\Helpers\UserPermissionHelper::packagePermission($user->id);
                                    $permissions = json_decode($permissions, true);
                                }
                            @endphp
                            @if (!empty($permissions) && in_array('Blog', $permissions))
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>{{ __('Meta Keywords For Blog Page') }}</label>
                                        <input class="form-control" name="blogs_meta_keywords"
                                            value="{{ $data->blogs_meta_keywords }}"
                                            placeholder="{{ __('Enter Meta Keywords') }}" data-role="tagsinput">
                                    </div>

                                    <div class="form-group">
                                        <label>{{ __('Meta Description For Blog Page') }}</label>
                                        <textarea class="form-control" name="blogs_meta_description" rows="5"
                                            placeholder="{{ __('Enter Meta Description') }}">{{ $data->blogs_meta_description }}</textarea>
                                    </div>
                                </div>
                            @endif

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For FAQ Page') }}</label>
                                    <input class="form-control" name="faqs_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->faqs_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For FAQ Page') }}</label>
                                    <textarea class="form-control" name="faqs_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->faqs_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Contact Page') }}</label>
                                    <input class="form-control" name="contact_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->contact_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Contact Page') }}</label>
                                    <textarea class="form-control" name="contact_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->contact_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Login Page') }}</label>
                                    <input class="form-control" name="login_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->login_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Login Page') }}</label>
                                    <textarea class="form-control" name="login_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->login_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Sign Up Page') }}</label>
                                    <input class="form-control" name="sign_up_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->sign_up_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Sign Up Page') }}</label>
                                    <textarea class="form-control" name="sign_up_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->sign_up_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Forget Password Page') }}</label>
                                    <input class="form-control" name="forget_password_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->forget_password_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Forget Password Page') }}</label>
                                    <textarea class="form-control" name="forget_password_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->forget_password_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Gallery Page') }}</label>
                                    <input class="form-control" name="gallery_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->gallery_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Gallery  Page') }}</label>
                                    <textarea class="form-control" name="gallery_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->gallery_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Services Page') }}</label>
                                    <input class="form-control" name="services_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->services_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Services  Page') }}</label>
                                    <textarea class="form-control" name="services_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->services_meta_description }}</textarea>
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For Rooms Page') }}</label>
                                    <input class="form-control" name="rooms_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->rooms_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For Rooms  Page') }}</label>
                                    <textarea class="form-control" name="rooms_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->rooms_meta_description }}</textarea>
                                </div>
                            </div>


                            @if (!empty($permissions) && in_array('Tour Package', $permissions))
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>{{ __('Meta Keywords For Packages Page') }}</label>
                                        <input class="form-control" name="packages_meta_keywords"
                                            placeholder="{{ __('Enter Meta Keywords') }}"
                                            value="{{ $data->packages_meta_keywords }}" data-role="tagsinput">
                                    </div>

                                    <div class="form-group">
                                        <label>{{ __('Meta Description For Packages Page') }}</label>
                                        <textarea class="form-control" name="packages_meta_description" rows="5"
                                            placeholder="{{ __('Enter Meta Description') }}">{{ $data->packages_meta_description }}</textarea>
                                    </div>
                                </div>
                            @endif

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Meta Keywords For About Us Page') }}</label>
                                    <input class="form-control" name="about_meta_keywords"
                                        placeholder="{{ __('Enter Meta Keywords') }}"
                                        value="{{ $data->about_meta_keywords }}" data-role="tagsinput">
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Meta Description For About Us Page') }}</label>
                                    <textarea class="form-control" name="about_meta_description" rows="5"
                                        placeholder="{{ __('Enter Meta Description') }}">{{ $data->about_meta_description }}</textarea>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="form">
                            <div class="row">
                                <div class="col-12 text-center">
                                    <button type="submit"
                                        class="btn btn-success {{ $data == null ? 'd-none' : '' }}">{{ __('Update') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
