@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Page Headings') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Breadcrumbs') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Page Headings') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form action="{{ route('user.update_page_headings', ['language' => request()->input('language')]) }}"
                    method="post">
                    @csrf
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-10 mb-3 mb-lg-0">
                                <div class="card-title">{{ __('Update Page Headings') }}</div>
                            </div>

                            <div class="col-lg-2">
                                @includeIf('user.partials.languages')
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            @php
                                $user = Auth::guard('web')->user();
                                if (!empty($user)) {
                                    $permissions = \App\Http\Helpers\UserPermissionHelper::packagePermission($user->id);
                                    $permissions = json_decode($permissions, true);
                                }
                            @endphp

                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>{{ __('Rooms Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="rooms_page_title"
                                        value="{{ $data != null ? $data->rooms_page_title : '' }}">
                                    @if ($errors->has('rooms_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('rooms_page_title') }}</p>
                                    @endif
                                </div>

                                @if (!empty($permissions) && in_array('Tour Package', $permissions))
                                    <div class="form-group">
                                        <label>{{ __('Packages Page Title') }} <span class="text-danger">**</span></label>
                                        <input type="text" class="form-control" name="packages_page_title"
                                            value="{{ $data != null ? $data->packages_page_title : '' }}">
                                        @if ($errors->has('packages_page_title'))
                                            <p class="mt-2 mb-0 text-danger">{{ $errors->first('packages_page_title') }}
                                            </p>
                                        @endif
                                    </div>
                                @endif

                                <div class="form-group">
                                    <label>{{ __('Services Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="services_page_title"
                                        value="{{ $data != null ? $data->services_page_title : '' }}">
                                    @if ($errors->has('services_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('services_page_title') }}</p>
                                    @endif
                                </div>


                                @if (!empty($permissions) && in_array('Blog', $permissions))
                                    <div class="form-group">
                                        <label>{{ __('Blogs Page Title') }} <span class="text-danger">**</span></label>
                                        <input type="text" class="form-control" name="blog_page_title"
                                            value="{{ $data != null ? $data->blog_page_title : '' }}">
                                        @if ($errors->has('blog_page_title'))
                                            <p class="mt-2 mb-0 text-danger">{{ $errors->first('blog_page_title') }}</p>
                                        @endif
                                    </div>
                                @endif


                                <div class="form-group">
                                    <label>{{ __('Contact Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="contact_page_title"
                                        value="{{ $data != null ? $data->contact_page_title : '' }}">
                                    @if ($errors->has('contact_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('contact_page_title') }}</p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Gallery Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="gallery_page_title"
                                        value="{{ $data != null ? $data->gallery_page_title : '' }}">
                                    @if ($errors->has('gallery_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('gallery_page_title') }}</p>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label>{{ __('FAQ Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="faq_page_title"
                                        value="{{ $data != null ? $data->faq_page_title : '' }}">
                                    @if ($errors->has('faq_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('faq_page_title') }}</p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Forget Password Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="forget_password_page_title"
                                        value="{{ $data != null ? $data->forget_password_page_title : '' }}">
                                    @if ($errors->has('forget_password_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('forget_password_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Login Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="login_page_title"
                                        value="{{ $data != null ? $data->login_page_title : '' }}">
                                    @if ($errors->has('login_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('login_page_title') }}</p>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-6">

                                <div class="form-group">
                                    <label>{{ __('Signup Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="signup_page_title"
                                        value="{{ $data != null ? $data->signup_page_title : '' }}">
                                    @if ($errors->has('signup_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('signup_page_title') }}</p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Reset Password Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="reset_password_page_title"
                                        value="{{ $data != null ? $data->reset_password_page_title : '' }}">
                                    @if ($errors->has('reset_password_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('reset_password_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Dashboard Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="dashboard_page_title"
                                        value="{{ $data != null ? $data->dashboard_page_title : '' }}">
                                    @if ($errors->has('dashboard_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('dashboard_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Room Bookings Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="room_bookings_page_title"
                                        value="{{ $data != null ? $data->room_bookings_page_title : '' }}">
                                    @if ($errors->has('room_bookings_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('room_bookings_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                @if (!empty($permissions) && in_array('Tour Package', $permissions))
                                <div class="form-group">
                                    <label>{{ __('Package Bookings Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="package_bookings_page_title"
                                        value="{{ $data != null ? $data->package_bookings_page_title : '' }}">
                                    @if ($errors->has('package_bookings_page_title'))
                                        <p class="mt-2 mb-0 text-danger">
                                            {{ $errors->first('package_bookings_page_title') }}
                                        </p>
                                    @endif
                                </div>
                                @endif

                                <div class="form-group">
                                    <label>{{ __('Edit Profile Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="edit_profile_page_title"
                                        value="{{ $data != null ? $data->edit_profile_page_title : '' }}">
                                    @if ($errors->has('edit_profile_page_title'))
                                        <p class="mt-2 mb-0 text-danger">
                                            {{ $errors->first('edit_profile_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Change Password Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="change_password_page_title"
                                        value="{{ $data != null ? $data->change_password_page_title : '' }}">
                                    @if ($errors->has('change_password_page_title'))
                                        <p class="mt-2 mb-0 text-danger">
                                            {{ $errors->first('change_password_page_title') }}
                                        </p>
                                    @endif
                                </div>
                                
                                <div class="form-group">
                                    <label>{{ __('About Us Page Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="about_page_title"
                                        value="{{ $data != null ? $data->about_page_title : '' }}">
                                    @if ($errors->has('about_page_title'))
                                        <p class="mt-2 mb-0 text-danger">
                                            {{ $errors->first('about_page_title') }}
                                        </p>
                                    @endif
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Error Page Title') }} <span class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="error_page_title"
                                        value="{{ $data != null ? $data->error_page_title : '' }}">
                                    @if ($errors->has('error_page_title'))
                                        <p class="mt-2 mb-0 text-danger">{{ $errors->first('error_page_title') }}</p>
                                    @endif
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-success">
                                    {{ __('Update') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
