@extends('user.layout')
@includeIf('user.partials.rtl-style')
@php
    use App\Http\Helpers\UserPermissionHelper;
    $user = Auth::guard('web')->user();
    $packageFeatures = UserPermissionHelper::currentPackageFeatures($user->id);
@endphp
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Images & Texts') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Images & Texts') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form id="ajaxForm" action="{{ route('tenant.pages.home_page.images_texts_update') }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="language_id" value="{{ $language->id }}">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-10 mb-3 mb-lg-0">
                                <div class="card-title">{{ __('Update Images & Texts') }}</div>
                            </div>
                            <div class="col-lg-2">
                                @includeIf('user.partials.languages')
                            </div>
                        </div>
                    </div>

                    <div class="card-body py-5">

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Hero Section') }}</h3>
                                    <hr class="divider">
                                    @if (in_array($userBs->home_version, ['static', 'particles', 'water', 'parallax']))
                                        <h3 class="text-warning">
                                            {{ __(ucfirst($userBs->home_version)) . ' ' . __('Version') }}
                                        </h3>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span></strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage7 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->hero_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_HERO_SECTION_IMAGE, $data->hero_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image7">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input" name="hero_section_image">
                                                    </div>
                                                    <p id="err_hero_section_image" class="mb-0 text-danger em"></p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 1920X849 pixel size image for best quality') }}
                                                    </p>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="">{{ __('Title') }}<span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control" name="hero_section_title"
                                                        value="{{ $data->hero_section_title }}">
                                                    <p id="err_hero_section_title" class="mb-0 text-danger em"></p>
                                                </div>
                                                <div class="form-group">
                                                    <label for="">{{ __('Subtitle') }}<span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control" name="hero_section_subtitle"
                                                        value="{{ $data->hero_section_subtitle }}">
                                                    <p id="err_hero_section_subtitle" class="mb-0 text-danger em"></p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="">{{ __('Button Name') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="hero_section_button_name"
                                                        value="{{ $data->hero_section_button_name }}">
                                                    <p id="err_hero_section_button_name" class="mb-0 text-danger em"></p>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="">{{ __('Button URL') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control ltr"
                                                        name="hero_section_button_url"
                                                        value="{{ $data->hero_section_button_url }}">
                                                    <p id="err_hero_section_button_url" class="mb-0 text-danger em"></p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    @if (in_array($userBs->home_version, ['video']))
                                        <h3 class="text-warning">{{ __('Video Version') }}</h3>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="">{{ __('Video Link') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="hero_section_video_link"
                                                        value="{{ $data->hero_section_video_link }}">
                                                    <p class="text-warning">
                                                        {{ __('Link will be formatted automatically after submitting the form.') }}
                                                    </p>
                                                    <p id="err_hero_section_video_link" class="mb-0 text-danger em"></p>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFive->value,
                                App\Enums\ThemeVersion::ThemeFour->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Intro Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="row">
                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeFive->value,
                                                        App\Enums\ThemeVersion::ThemeFour->value,
                                                        App\Enums\ThemeVersion::ThemeThree->value,
                                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                                        App\Enums\ThemeVersion::ThemeOne->value,
                                                    ]))
                                                    <div class="col-12 col-lg-6">
                                                        <div class="form-group">
                                                            <div class="col-12 mb-2 pl-0">
                                                                <label for="image"><strong>{{ __('Image') }} <span
                                                                            class="text-danger"></span></strong></label>
                                                            </div>
                                                            <div class="col-md-12 showImage3 mb-3 pl-0 pr-0">
                                                                <img src="{{ $data->intro_img ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $data->intro_img, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                                    alt="..." class="img-thumbnail">
                                                            </div>
                                                            <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                                id="image3">
                                                                {{ __('Choose Image') }}
                                                                <input type="file" class="img-input" name="intro_img">
                                                            </div>
                                                            <p id="err_intro_img" class="mb-0 text-danger em"></p>
                                                            <p class="text-warning mb-0">
                                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                            </p>
                                                            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFive->value]))
                                                                <p class="text-warning">
                                                                    {{ __('Recommended image size:Upload 368X367 pixel size image for best quality') }}
                                                                </p>
                                                            @endif
                                                        </div>

                                                    </div>
                                                @endif

                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeFive->value,
                                                        App\Enums\ThemeVersion::ThemeThree->value,
                                                    ]))
                                                    <div class="col-12 col-lg-6">
                                                        <div class="form-group">
                                                            <div class="col-12 mb-2 pl-0">
                                                                <label for="image"><strong>{{ __('Image') }} <span
                                                                            class="text-danger"></span></strong></label>
                                                            </div>
                                                            <div class="col-md-12 showImage13 mb-3 pl-0 pr-0">
                                                                <img src="{{ $data->intro_image_two ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $data->intro_image_two, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                                    alt="..." class="img-thumbnail">
                                                            </div>
                                                            <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                                id="image13">
                                                                {{ __('Choose Image') }}
                                                                <input type="file" class="img-input"
                                                                    name="intro_image_two">
                                                            </div>
                                                            <p id="err_intro_image_two" class="mb-0 text-danger em"></p>
                                                            <p class="text-warning mb-0">
                                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                            </p>
                                                            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFive->value]))
                                                                <p class="text-warning">
                                                                    {{ __('Recommended image size:Upload 589X529 pixel size image for best quality') }}
                                                                </p>
                                                            @endif
                                                        </div>

                                                    </div>
                                                @endif
                                                @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                                    <div class="col-12 col-lg-6">
                                                        <div class="form-group">
                                                            <div class="col-12 mb-2 pl-0">
                                                                <label for="image"><strong>{{ __('Image') }} <span
                                                                            class="text-danger"></span></strong></label>
                                                            </div>
                                                            <div class="col-md-12 showImage14 mb-3 pl-0 pr-0">
                                                                <img src="{{ $data->intro_image_three ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $data->intro_image_three, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                                    alt="..." class="img-thumbnail">
                                                            </div>
                                                            <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                                id="image14">
                                                                {{ __('Choose Image') }}
                                                                <input type="file" class="img-input"
                                                                    name="intro_image_three">
                                                            </div>
                                                            <p id="err_intro_image_three" class="mb-0 text-danger em"></p>
                                                            <p class="text-warning mb-0">
                                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                            </p>
                                                            <p class="text-warning">
                                                                {{ __('Recommended image size:Upload 1920X849 pixel size image for best quality') }}
                                                            </p>
                                                        </div>

                                                    </div>
                                                @endif

                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeFive->value,
                                                        App\Enums\ThemeVersion::ThemeFour->value,
                                                        App\Enums\ThemeVersion::ThemeThree->value,
                                                    ]))
                                                    <div class="col-12 col-lg-6">

                                                        <div class="form-group">
                                                            <label>{{ __('Member Image Show') }} <span
                                                                    class="text-danger">**</span></label>
                                                            <div class="selectgroup w-100">
                                                                <label class="selectgroup-item">
                                                                    <input type="radio" name="intro_member_image_show"
                                                                        value="1" class="selectgroup-input"
                                                                        {{ $data->intro_member_image_show == 1 ? 'checked' : '' }}>
                                                                    <span
                                                                        class="selectgroup-button">{{ __('Active') }}</span>
                                                                </label>

                                                                <label class="selectgroup-item">
                                                                    <input type="radio" name="intro_member_image_show"
                                                                        value="0" class="selectgroup-input"
                                                                        {{ $data->intro_member_image_show == 0 ? 'checked' : '' }}
                                                                        }}>
                                                                    <span
                                                                        class="selectgroup-button">{{ __('Deactive') }}</span>
                                                                </label>
                                                            </div>
                                                            <p id="err_intro_member_image_show"
                                                                class="mb-0 text-danger em"></p>
                                                        </div>

                                                        <div class="form-group">
                                                            <div class="col-12 mb-2 pl-0">
                                                                <label for="image"><strong>{{ __('Member Image') }}
                                                                        <span class="text-danger"></span></strong></label>
                                                            </div>
                                                            <div class="col-md-12 showImage15 mb-3 pl-0 pr-0">
                                                                <img src="{{ $data->intro_member_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $data->intro_member_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                                    alt="..." class="img-thumbnail">
                                                            </div>
                                                            <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                                id="image15">
                                                                {{ __('Choose Image') }}
                                                                <input type="file" class="img-input"
                                                                    name="intro_member_image">
                                                            </div>
                                                            <p id="err_intro_member_image" class="mb-0 text-danger em">
                                                            </p>
                                                            <p class="text-warning mb-0">
                                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                            </p>
                                                            @if (in_array($userBs->theme_version, [
                                                                    App\Enums\ThemeVersion::ThemeFive->value,
                                                                    App\Enums\ThemeVersion::ThemeFour->value,
                                                                    App\Enums\ThemeVersion::ThemeThree->value,
                                                                ]))
                                                                <p class="text-warning">
                                                                    {{ __('Recommended image size:Upload 174X42 pixel size image for best quality') }}
                                                                </p>
                                                            @endif
                                                        </div>


                                                    </div>
                                                @endif
                                            </div>


                                            <div class="form-group">
                                                <label for="">{{ __('Intro Primary Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="intro_primary_title"
                                                    value="{{ $data->intro_primary_title }}">
                                                <p id="err_intro_primary_title" class="mb-0 text-danger em"></p>
                                            </div>

                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeThree->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Intro Secondary Title') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="intro_secondary_title"
                                                        value="{{ $data->intro_secondary_title }}">
                                                    <p id="err_intro_secondary_title" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif

                                            <div class="form-group">
                                                <label for="">{{ __('Intro Text') }} <span
                                                        class="text-danger"></span></label>
                                                <textarea id="" cols="30" rows="4" class="form-control" name="intro_text"> {{ $data->intro_text }}</textarea>
                                                <p id="err_intro_text" class="mb-0 text-danger em"></p>
                                            </div>

                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeFive->value,
                                                    App\Enums\ThemeVersion::ThemeFour->value,
                                                    App\Enums\ThemeVersion::ThemeThree->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Intro Button Text') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control" name="intro_button_text"
                                                        value="{{ $data->intro_button_text }}">
                                                    <p id="err_intro_button_text" class="mb-0 text-danger em"></p>
                                                </div>
                                                <div class="form-group">
                                                    <label for="">{{ __('Intro Button Url') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control ltr"
                                                        name="intro_button_url" value="{{ $data->intro_button_url }}">
                                                    <p id="err_intro_button_url" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Room Category Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Room Category Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="room_category_section_title"
                                                    value="{{ $data->room_category_section_title }}">
                                                <p id="err_room_category_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>

                                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span></strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage22 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->room_category_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_ROOM_IMAGE, $data->room_category_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image22">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input"
                                                            name="room_category_section_image">
                                                    </div>
                                                    <p id="err_room_category_section_image" class="mb-0 text-danger em">
                                                    </p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                                        <p class="text-warning">
                                                            {{ __('Recommended image size:Upload 1920X1115 pixel size image for best quality') }}
                                                        </p>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFour->value]))
                        <div class="row">
                            <div class="col-lg-10 mx-auto">
                                <h3 class="text-warning">{{ __('Package Category Section') }}</h3>
                                <hr class="divider">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Package Category Section Title') }} <span
                                                    class="text-danger"></span></label>
                                            <input type="text" class="form-control"
                                                name="package_category_section_title"
                                                value="{{ $data->package_category_section_title }}">
                                            <p id="err_package_category_section_title" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFive->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Featured Room Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Room Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="room_section_title"
                                                    value="{{ $data->room_section_title }}">
                                                <p id="err_room_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Room Section Subtitle') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="room_section_subtitle"
                                                        value="{{ $data->room_section_subtitle }}">
                                                    <p id="err_room_section_subtitle" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeOne->value]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Room Section Text') }} <span
                                                            class="text-danger"></span></label>
                                                    <textarea id="" cols="30" rows="4" class="form-control" name="room_section_text">{{ $data->room_section_text }}</textarea>
                                                    <p id="err_room_section_text" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>

                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeOne->value,
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Featured Service Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Service Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="service_section_title"
                                                    value="{{ $data->service_section_title }}">
                                                <p id="err_service_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            <div class="form-group">
                                                <label for="">{{ __('Service Section Subtitle') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="service_section_subtitle"
                                                    value="{{ $data->service_section_subtitle }}">
                                                <p id="err_service_section_subtitle" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFive->value,
                                App\Enums\ThemeVersion::ThemeFour->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Video Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-12 mb-2 pl-0">
                                                    <label for="image"><strong>{{ __('Image') }} <span
                                                                class="text-danger"></span>
                                                        </strong></label>
                                                </div>
                                                <div class="col-md-12 showImage10 mb-3 pl-0 pr-0">
                                                    <img src="{{ $data->video_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $data->video_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                        alt="..." class="img-thumbnail">
                                                </div>
                                                <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                    id="image10">
                                                    {{ __('Choose Image') }}
                                                    <input type="file" class="img-input" name="video_section_image">
                                                </div>
                                                <p id="err_video_section_image" class="mb-0 text-danger em"></p>
                                                <p class="text-warning mb-0">
                                                    {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                </p>
                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeOne->value,
                                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                                        App\Enums\ThemeVersion::ThemeFour->value,
                                                        App\Enums\ThemeVersion::ThemeFive->value,
                                                    ]))
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 1920X600 pixel size image for best quality') }}
                                                    </p>
                                                @endif

                                                @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 325X465 pixel size image for best quality') }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>

                                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span>
                                                            </strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage23 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->video_section_image_two ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $data->video_section_image_two, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image23">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input"
                                                            name="video_section_image_two">
                                                    </div>
                                                    <p id="err_video_section_image_two" class="mb-0 text-danger em"></p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 552X511 pixel size image for best quality') }}
                                                    </p>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-md-12">
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Video Section Title') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control" name="video_section_title"
                                                        value="{{ $data->video_section_title }}">
                                                    <p id="err_video_section_title" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Video Section Subtitle') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="video_section_subtitle"
                                                        value="{{ $data->video_section_subtitle }}">
                                                    <p id="err_video_section_subtitle" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Button Name') }}</label>
                                                    <input type="text" class="form-control"
                                                        name="video_section_button"
                                                        value="{{ $data->video_section_button }}">
                                                    <p id="err_video_section_button" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Button URL') }} </label>
                                                    <input type="text" class="form-control ltr"
                                                        name="video_section_button_url"
                                                        value="{{ $data->video_section_button_url }}">
                                                    <p id="err_video_section_button_url" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="">{{ __('Video URL') }} </label>
                                                <input type="text" class="form-control ltr"
                                                    name="video_section_video_url"
                                                    value="{{ $data->video_section_video_url }}">
                                                <p id="err_video_section_video_url" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFour->value,
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]) && in_array('Tour Package', $packageFeatures))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Featured Package Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Package Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="package_section_title"
                                                    value="{{ $data->package_section_title }}">
                                                <p id="err_package_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Package Section Subtitle') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="package_section_subtitle"
                                                        value="{{ $data->package_section_subtitle }}">
                                                    <p id="err_package_section_subtitle" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Latest Room Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Room Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="latest_room_section_title"
                                                    value="{{ $data->latest_room_section_title }}">
                                                <p id="err_latest_room_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFour->value,
                                App\Enums\ThemeVersion::ThemeFive->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Latest Package Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Package Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="latest_package_section_title"
                                                    value="{{ $data->latest_package_section_title }}">
                                                <p id="err_latest_package_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFive->value,
                                App\Enums\ThemeVersion::ThemeFour->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Facility Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <div class="col-12 mb-2 pl-0">
                                                    <label for="image"><strong>{{ __('Image') }} <span
                                                                class="text-danger"></span></strong></label>
                                                </div>
                                                <div class="col-md-12 showImage4 mb-3 pl-0 pr-0">
                                                    <img src="{{ $data->facility_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $data->facility_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                        alt="..." class="img-thumbnail">
                                                </div>
                                                <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                    id="image4">
                                                    {{ __('Choose Image') }}
                                                    <input type="file" class="img-input"
                                                        name="facility_section_image">
                                                </div>
                                                <p id="err_facility_section_image" class="mb-0 text-danger em"></p>
                                                <p class="text-warning mb-0">
                                                    {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                </p>
                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeThree->value,
                                                        App\Enums\ThemeVersion::ThemeFour->value,
                                                        App\Enums\ThemeVersion::ThemeFive->value,
                                                    ]))
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 579X585 pixel size image for best quality') }}
                                                    </p>
                                                @endif
                                                @if (in_array($userBs->theme_version, [
                                                        App\Enums\ThemeVersion::ThemeOne->value,
                                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                                    ]))
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 570X697 pixel size image for best quality') }}
                                                    </p>
                                                @endif

                                            </div>
                                        </div>
                                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFive->value]))
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span></strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage21 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->facility_section_image_two ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $data->facility_section_image_two, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image21">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input"
                                                            name="facility_section_image_two">
                                                    </div>
                                                    <p id="err_facility_section_image_two" class="mb-0 text-danger em">
                                                    </p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    @if (in_array($userBs->theme_version, [
                                                            App\Enums\ThemeVersion::ThemeOne->value,
                                                            App\Enums\ThemeVersion::ThemeTwo->value,
                                                            App\Enums\ThemeVersion::ThemeThree->value,
                                                            App\Enums\ThemeVersion::ThemeFour->value,
                                                            App\Enums\ThemeVersion::ThemeFive->value,
                                                        ]))
                                                        <p class="text-warning">
                                                            {{ __('Recommended image size:Upload 600X600 pixel size image for best quality') }}
                                                        </p>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif

                                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFive->value]))
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span></strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage20 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->facility_section_image_three ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $data->facility_section_image_three, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image20">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input"
                                                            name="facility_section_image_three">
                                                    </div>
                                                    <p id="err_facility_section_image_three" class="mb-0 text-danger em">
                                                    </p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    @if (in_array($userBs->theme_version, [
                                                            App\Enums\ThemeVersion::ThemeOne->value,
                                                            App\Enums\ThemeVersion::ThemeTwo->value,
                                                            App\Enums\ThemeVersion::ThemeThree->value,
                                                            App\Enums\ThemeVersion::ThemeFour->value,
                                                            App\Enums\ThemeVersion::ThemeFive->value,
                                                        ]))
                                                        <p class="text-warning">
                                                            {{ __('Recommended image size:Upload 600X610 pixel size image for best quality') }}
                                                        </p>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Facility Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="facility_section_title"
                                                    value="{{ $data->facility_section_title }}">
                                                <p id="err_facility_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            <div class="form-group">
                                                <label for="">{{ __('Facility Section Subtitle') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="facility_section_subtitle"
                                                    value="{{ $data->facility_section_subtitle }}">
                                                <p id="err_facility_section_subtitle" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeOne->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Testimonial Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeTwo->value]))
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="col-12 mb-2 pl-0">
                                                        <label for="image"><strong>{{ __('Image') }} <span
                                                                    class="text-danger"></span></strong></label>
                                                    </div>
                                                    <div class="col-md-12 showImage5 mb-3 pl-0 pr-0">
                                                        <img src="{{ $data->testimonial_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TESTIMONIAL_SECTION_IMAGE, $data->testimonial_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                            alt="..." class="img-thumbnail">
                                                    </div>
                                                    <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                        id="image5">
                                                        {{ __('Choose Image') }}
                                                        <input type="file" class="img-input"
                                                            name="testimonial_section_image">
                                                    </div>
                                                    <p id="err_testimonial_section_image" class="mb-0 text-danger em"></p>
                                                    <p class="text-warning mb-0">
                                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                    </p>
                                                    <p class="text-warning">
                                                        {{ __('Recommended image size:Upload 567X675 pixel size image for best quality') }}
                                                    </p>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Testimonial Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control"
                                                    name="testimonial_section_title"
                                                    value="{{ $data->testimonial_section_title }}">
                                                <p id="err_testimonial_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            @if (in_array($userBs->theme_version, [
                                                    App\Enums\ThemeVersion::ThemeOne->value,
                                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                                ]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Testimonial Section Subtitle') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="testimonial_section_subtitle"
                                                        value="{{ $data->testimonial_section_subtitle }}">
                                                    <p id="err_testimonial_section_subtitle" class="mb-0 text-danger em">
                                                    </p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeTwo->value]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('FAQ Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-12 mb-2 pl-0">
                                                    <label for="image"><strong>{{ __('Image') }} <span
                                                                class="text-danger"></span></strong></label>
                                                </div>
                                                <div class="col-md-12 showImage6 mb-3 pl-0 pr-0">
                                                    <img src="{{ $data->faq_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FAQ_SECTION_IMAGE, $data->faq_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                        alt="..." class="img-thumbnail">
                                                </div>
                                                <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                    id="image6">
                                                    {{ __('Choose Image') }}
                                                    <input type="file" class="img-input" name="faq_section_image">
                                                </div>
                                                <p id="err_faq_section_image" class="mb-0 text-danger em"></p>
                                                <p class="text-warning mb-0">
                                                    {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                </p>
                                                <p class="text-warning">
                                                    {{ __('Recommended image size:Upload 1920X849 pixel size image for best quality') }}
                                                </p>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('FAQ Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="faq_section_title"
                                                    value="{{ $data->faq_section_title }}">
                                                <p id="err_faq_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            <div class="form-group">
                                                <label for="">{{ __('FAQ Section Subtitle') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="faq_section_subtitle"
                                                    value="{{ $data->faq_section_subtitle }}">
                                                <p id="err_faq_section_subtitle" class="mb-0 text-danger em"></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeTwo->value,
                                App\Enums\ThemeVersion::ThemeFour->value,
                            ]) && in_array('Tour Package', $packageFeatures))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Blog Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="">{{ __('Blog Section Title') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="blog_section_title"
                                                    value="{{ $data->blog_section_title }}">
                                                <p id="err_blog_section_title" class="mb-0 text-danger em"></p>
                                            </div>
                                            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeTwo->value]))
                                                <div class="form-group">
                                                    <label for="">{{ __('Blog Section Subtitle') }} <span
                                                            class="text-danger"></span></label>
                                                    <input type="text" class="form-control"
                                                        name="blog_section_subtitle"
                                                        value="{{ $data->blog_section_subtitle }}">
                                                    <p id="err_blog_section_subtitle" class="mb-0 text-danger em"></p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if (in_array($userBs->theme_version, [
                                App\Enums\ThemeVersion::ThemeFive->value,
                                App\Enums\ThemeVersion::ThemeThree->value,
                            ]))
                            <div class="row">
                                <div class="col-lg-10 mx-auto">
                                    <h3 class="text-warning">{{ __('Statitics Section') }}</h3>
                                    <hr class="divider">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-12 mb-2 pl-0">
                                                    <label for="image"><strong>{{ __('Image') }} <span
                                                                class="text-danger"></span></strong></label>
                                                </div>
                                                <div class="col-md-12 showImage12 mb-3 pl-0 pr-0">
                                                    <img src="{{ $data->statistics_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_STATISTICS_SECTION_IMAGE, $data->statistics_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                        alt="..." class="img-thumbnail">
                                                </div>
                                                <div role="button" class="btn btn-primary btn-sm upload-btn"
                                                    id="image12">
                                                    {{ __('Choose Image') }}
                                                    <input type="file" class="img-input"
                                                        name="statistics_section_image">
                                                </div>
                                                <p id="err_statistics_section_image" class="mb-0 text-danger em"></p>
                                                <p class="text-warning mb-0">
                                                    {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                                </p>
                                                <p class="text-warning">
                                                    {{ __('Recommended image size:Upload 1920X341 pixel size image for best quality') }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                    </div>

                    <div class="card-footer">
                        <div class="row">
                            <div class="col-12 text-center">
                                <button type="submit" id="submitBtn" class="btn btn-success">
                                    {{ __('Update') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection
