@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Footer Logo') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Basic Settings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Footer Logo') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">{{ __('Update Footer Logo') }}</div>
                </div>
                <div class="card-body pt-5 pb-4">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="ajaxForm" action="{{ route('user.footer.logo.update') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="image">{{ __('Logo') }}
                                        <span class="text-danger">**</span></label>
                                    <div class="showImage mb-3">
                                        <img src="{{ $basic_setting->footer_logo ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $basic_setting->footer_logo, $userBs) : asset('assets/tenant/img/default.jpg') }}"
                                            alt="..." class="img-thumbnail">
                                    </div>

                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="footer_logo">
                                    </div>

                                    <p id="err_footer_logo" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">{{ __('Only JPG, JPEG, PNG images are allowed') }}</p>
                                    <p class="text-warning mb-0">{{ __('Upload 170 X 50 image for best quality') }}</p>
                                </div>

                                <div class="card-footer">
                                    <div class="form">
                                        <div class="form-group from-show-notify row">
                                            <div class="col-12 text-center">
                                                <button type="button" id="submitBtn"
                                                    class="btn btn-success">{{ __('Update') }}</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
