@extends('user.layout')



@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Breadcrumb') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Breadcrumbs') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Breadcrumb') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="card-title">{{ __('Update Breadcrumb') }}</div>
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5 pb-4">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="ajaxForm" action="{{ route('user.update_breadcrumb') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="">{{ __('Breadcrumb') }} <span class="text-danger">**</span></label>
                                    <div class="showImage mb-3">
                                        <img src="{{ $basic_setting->breadcrumb ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_BREADCRUMB, $basic_setting->breadcrumb, $userBs) : asset('assets/tenant/img/default.jpg') }}"
                                            alt="..." class="img-thumbnail">
                                    </div>

                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="breadcrumb">
                                    </div>

                                    <p id="err_breadcrumb" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">{{ __('Only JPG, JPEG, PNG images are allowed') }}</p>
                                    <p class="text-warning mb-0">{{ __('Upload 1920 X 820 image for best quality') }}</p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="button" id="submitBtn" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
