@extends('user.layout')
@includeIf('user.partials.rtl-style')
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Images & Texts') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('About Us') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Images & Texts') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form id="ajaxForm" action="{{ route('user.about.images_texts.update') }}" method="post"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="language_id" value="{{ $language->id }}">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-10">
                                <div class="card-title">{{ __('Update Images & Texts') }}</div>
                            </div>
                            <div class="col-lg-2">
                                @includeIf('user.partials.languages')
                            </div>
                        </div>
                    </div>
                    <div class="card-body py-5">
                        <div class="row">
                            <div class="col-lg-8 mx-auto">
                                <h3 class="text-warning">{{ __('About Section') }}</h3>
                                <hr class="divider">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="col-12 mb-2 pl-0">
                                                <label for="image"><strong>{{ __('Image') }} <span
                                                            class="text-danger">**</span></strong></label>
                                            </div>
                                            <div class="col-md-12 showImage3 mb-3 pl-0 pr-0">
                                                <img src="{{ $data->about_page_about_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_ABOUT_US_SECTION_IMAGE, $data->about_page_about_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                    alt="..." class="img-thumbnail">
                                            </div>
                                            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image3">
                                                {{ __('Choose Image') }}
                                                <input type="file" class="img-input" name="about_section_image">
                                            </div>
                                            <p id="err_about_section_image" class="mb-0 text-danger em"></p>
                                            <p class="text-warning mb-0">
                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                            </p>
                                            <p class="text-warning">
                                                {{ __('Recommended image size:Upload 746X525 pixel size image for best quality') }}
                                            </p>
                                        </div>
                                        <div class="form-group">
                                            <label for="">{{ __('About Section Title') }} <span
                                                    class="text-danger"></span></label>
                                            <input type="text" class="form-control" name="about_section_title"
                                                value="{{ $data->about_page_about_section_title }}">
                                            <p id="err_about_section_title" class="mb-0 text-danger em"></p>
                                        </div>

                                        <div class="form-group">
                                            <label for="">{{ __('About Section Text') }} <span
                                                    class="text-danger"></span></label>
                                            <textarea id="" cols="30" rows="4" class="form-control" name="about_section_text"> {{ $data->about_page_about_section_text }}</textarea>
                                            <p id="err_about_section_text" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-8 mx-auto">
                                <h3 class="text-warning">{{ __('Facility Section') }}</h3>
                                <hr class="divider">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <div class="col-12 mb-2 pl-0">
                                                <label for="image"><strong>{{ __('Image') }} <span
                                                            class="text-danger">**</span></strong></label>
                                            </div>
                                            <div class="col-md-12 showImage4 mb-3 pl-0 pr-0">
                                                <img src="{{ $data->about_page_facility_section_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $data->about_page_facility_section_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                    alt="..." class="img-thumbnail">
                                            </div>
                                            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image4">
                                                {{ __('Choose Image') }}
                                                <input type="file" class="img-input" name="facility_section_image">
                                            </div>
                                            <p id="err_facility_section_image" class="mb-0 text-danger em"></p>
                                            <p class="text-warning mb-0">
                                                {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                            </p>
                                            <p class="text-warning">
                                                {{ __('Recommended image size:Upload 724X549 pixel size image for best quality') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Facility Section Title') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="facility_section_title"
                                                value="{{ $data->about_page_facility_section_title }}">
                                            <p id="err_facility_section_title" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-8 mx-auto">
                                <h3 class="text-warning">{{ __('Testimonial Section') }}</h3>
                                <hr class="divider">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Testimonial Section Title') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="testimonial_section_title"
                                                value="{{ $data->about_page_testimonial_section_title }}">
                                            <p id="err_testimonial_section_title" class="mb-0 text-danger em"></p>
                                        </div>
                                        <div class="form-group">
                                            <label for="">{{ __('Testimonial Section Text') }} <span
                                                    class="text-danger"></span></label>
                                            <textarea id="" cols="30" rows="4" class="form-control" name="testimonial_section_text"> {{ $data->about_page_testimonial_section_text }}</textarea>
                                            <p id="err_testimonial_section_text" class="mb-0 text-danger em"></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="row">
                            <div class="col-12 text-center">
                                <button type="submit" id="submitBtn" class="btn btn-success">
                                    {{ __('Update') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection
