@extends('user.layout')
@section('styles')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/cropper.css') }}">
@endsection

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Add Room') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Rooms Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Add Room') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Add New Room') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.rooms_management.rooms', ['language' => 'en']) }}">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>

                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">

                            <div class="alert alert-danger pb-1" id="roomErrors" style="display: none;">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>

                            <div style="margin-left: 10px;">
                                <label for=""><strong>{{ __('Slider Images') }} <span
                                            class="text-danger">**</span></strong></label>
                                <form id="slider-dropzone" enctype="multipart/form-data" class="dropzone mt-2 mb-0">
                                    @csrf
                                    <div class="fallback"></div>
                                </form>
                                <h3 class="em text-danger mt-3 mb-0 font-weight-blod" id="err_slider_image"></h3>
                                <p class="em text-warning mt-3 mb-0">
                                    {{ __('Recommended image size : Upload 770X600 pixel size image for best quality.') }}
                                </p>
                            </div>

                            <form id="roomForm" action="{{ route('tenant.rooms_management.store_room') }}"
                                enctype="multipart/form-data" method="POST">
                                @csrf
                                <div id="slider-image-id"></div>
                                {{-- featured image start --}}
                                <div class="form-group">
                                    <div class="">
                                        <label for="image"><strong> {{ __('Thumbnail Image') }}
                                                <span class="text-danger">**</span></strong></label>
                                    </div>
                                    <div class="showImage mb-3">
                                        <img src="{{ asset('assets/admin/img/noimage.jpg') }}" alt="..."
                                            class="cropped-thumbnail-image img-thumbnail">
                                    </div>

                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#thumbnail-image-modal">{{ __('Choose Image') }}</button>

                                    <p id="errthumbnail" class="mb-0 text-danger em"></p>
                                    <p class="text-warning"> {{ __('Only image size will be 370X250 pixel.') }}</p>
                                </div>
                                {{-- featured image end --}}

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Room Status') }} <span class="text-danger">**</span></label>
                                            <select name="status" class="form-control">
                                                <option selected disabled>{{ __('Select a Status') }}</option>
                                                <option value="1">{{ __('Show') }}</option>
                                                <option value="0">{{ __('Hide') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Rent / Night') }} ({{ __('in') }}
                                                {{ $userBs->base_currency_text }}) <span
                                                    class="text-danger">**</span></label>
                                            <input type="number" step="0.01" class="form-control" name="rent"
                                                placeholder="{{ __('Enter Room Rent') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Quantity') }} <span class="text-danger">**</span></label>
                                            <input type="number" class="form-control" name="quantity"
                                                placeholder="{{ __('Enter No. Of Room') }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Beds') }} <span class="text-danger">**</span></label>
                                            <input type="number" class="form-control" name="bed"
                                                placeholder="{{ __('Enter No. Of Bed') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Baths') }} <span class="text-danger">**</span></label>
                                            <input type="number" class="form-control" name="bath"
                                                placeholder="{{ __('Enter No. Of Bath') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <label>{{ __('Max. Guests') }}</label>
                                            <input type="number" class="form-control" name="max_guests"
                                                placeholder="{{ __('Enter maximum guests') }}">
                                            <p class="text-warning mb-0">
                                                {{ __('Leave blank if you want to make it unlimited') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Latitude') }}</label>
                                            <input type="text" class="form-control" name="latitude"
                                                placeholder="{{ __('Enter Latitude') }}">
                                            <p class="text-warning mb-0">
                                                {{ __('The Latitude must be between -90 to 90. Ex:49.43453') }}</p>
                                            <span> {{ __('Collect Latitude & Longitude') }} <a
                                                    href="https://maps.google.com/"
                                                    class="link text-primary">{{ __('Google Map') }}</a></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Longitude') }}</label>
                                            <input type="text" class="form-control" name="longitude"
                                                placeholder="{{ __('Enter Longitude') }}">
                                            <p class="text-warning mb-0">
                                                {{ __('The Longitude must be between -180 to 180. Ex:149.91553') }}
                                            </p>

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Address') }}</label>
                                            <input type="text" class="form-control" name="address"
                                                placeholder="{{ __('Enter Address') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Phone') }}</label>
                                            <input type="text" class="form-control" name="phone"
                                                placeholder="{{ __('Enter Phone') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Email') }}</label>
                                            <input type="email" class="form-control" name="email"
                                                placeholder="{{ __('Enter Email') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group {{ $defaultLang->rtl == 1 ? 'rtl text-right' : '' }}">
                                            @php
                                                $categories = App\Models\User\RoomCategory::active()
                                                    ->where('language_id', $defaultLang->id)
                                                    ->where('status', 1)
                                                    ->where('user_id', Auth::guard('web')->user()->id)
                                                    ->get();
                                            @endphp

                                            <label>{{ __('Category') }} <span class="text-danger">**</span></label>
                                            <select name="category" class="form-control">
                                                <option selected disabled>
                                                    {{ __('Select a Category') }}
                                                </option>

                                                @foreach ($categories as $category)
                                                    <option value="{{ $category->indx }}">
                                                        {{ $category->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group {{ $defaultLang->rtl == 1 ? 'rtl text-right' : '' }}">

                                            @php
                                                $amenities = App\Models\User\RoomAmenity::active()
                                                    ->where('language_id', $defaultLang->id)
                                                    ->where('user_id', Auth::guard('web')->user()->id)
                                                    ->orderBy('serial_number', 'asc')
                                                    ->get();
                                            @endphp
                                            <label>{{ __('Room Amenities') }} <span class="text-danger">**</span></label>
                                            <div>
                                                @foreach ($amenities as $amenity)
                                                    <div class="d-inline mr-3">
                                                        <input type="checkbox" class="mr-1" name="amenities[]"
                                                            value="{{ $amenity->indx }}">
                                                        <label for="">{{ $amenity->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="accordion" class="mt-5">
                                    @foreach ($languages as $language)
                                        <div class="version">
                                            <div class="version-header" id="heading{{ $language->id }}">
                                                <input type="hidden" value="{{ $language->id }}" name="lang">
                                                <h5 class="mb-0">
                                                    <button type="button"
                                                        class="btn btn-link"
                                                        data-toggle="collapse" data-target="#collapse{{ $language->id }}"
                                                        aria-expanded="{{ $language->is_default == 1 ? 'true' : 'false' }}"
                                                        aria-controls="collapse{{ $language->id }}">
                                                        {{ $language->name . ' ' . __('Language') }}
                                                        {{ $language->is_default == 1 ? __('(Default)') : '' }}
                                                    </button>
                                                </h5>
                                            </div>
                                            <div id="collapse{{ $language->id }}"
                                                class="collapse {{ $language->is_default == 1 ? 'show' : '' }}"
                                                aria-labelledby="heading{{ $language->id }}" data-parent="#accordion">
                                                <div class="version-body">

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Room Title') }} <span class="text-danger">
                                                                        ** </span></label>
                                                                <input type="text" class="form-control"
                                                                    name="{{ $language->code }}_title"
                                                                    placeholder="{{ __('Enter Title') }}">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Summary') }} <span
                                                                        class="text-danger">**</span></label>
                                                                <textarea class="form-control" name="{{ $language->code }}_summary" placeholder="{{ __('Enter Summary') }}"
                                                                    rows="3"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Room Description') }} <span
                                                                        class="text-danger">**</span></label>
                                                                <textarea id="{{ $language->code }}_description" class="form-control summernote"
                                                                    name="{{ $language->code }}_description" placeholder="{{ __('Enter Description') }}" data-height="300"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Meta Keywords') }}</label>
                                                                <input class="form-control"
                                                                    name="{{ $language->code }}_meta_keywords"
                                                                    placeholder="{{ __('Enter Meta Keywords') }}"
                                                                    data-role="tagsinput">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Meta Description') }}</label>
                                                                <textarea class="form-control" name="{{ $language->code }}_meta_description" rows="5"
                                                                    placeholder="{{ __('Enter Meta Description') }}"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-12">
                                                            @php
                                                                $currLang = $language;
                                                            @endphp
                                                            @foreach ($languages as $language)
                                                                @continue($currLang->id == $language->id)

                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value=""
                                                                            onchange="cloneContent('collapse{{ $currLang->id }}', 'collapse{{ $language->id }}', event)">
                                                                        <span
                                                                            class="form-check-sign">{{ __('Clone for') }}
                                                                            <strong
                                                                                class="text-capitalize text-secondary">{{ $language->name }}</strong>
                                                                            {{ __('Language') }}</span>
                                                                    </label>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                            </form>

                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="roomForm" class="btn btn-success">
                                {{ __('Save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @includeIf('user.rooms.thumbnail')
@endsection



@section('script')
    <script src="{{ asset('assets/admin/js/cropper-plugin.js') }}"></script>
    <script>
        "use strict"
        const uploadSliderImage = "{{ route('tenant.rooms_management.sliderImage') }}";
        const imgRmvUrl = "{{ route('tenant.rooms_management.remove_slider_image') }}";
    </script>
    <script src="{{ asset('assets/tenant/js/rooms/dropzone-slider.js') }}"></script>
    <script src="{{ asset('assets/tenant/js/rooms/room.js') }}"></script>
    <script src="{{ asset('assets/tenant/js/rooms/cropper-init.js') }}"></script>
@endsection
