@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('New Booking') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Room Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('New Booking') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Make New Booking') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.room_bookings.all_bookings') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif


                            <form id="roomBookingForm" action="{{ route('tenant.room_bookings.make_booking') }}"
                                method="POST" autocomplete="off">
                                @csrf
                                <input type="hidden" name="room_id" value="{{ request()->input('room_id') }}">

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>{{ __('Check In / Out Date') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Select Dates') }}" id="date-range" name="dates"
                                                value="{{ old('dates') }}" readonly>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_dates"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Number of Nights') }} <span class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Number of Nights') }}" id="night" name="nights"
                                                value="{{ old('nights') }}" readonly autocomplete="off">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_nights"></p>
                                            <p class="text-warning mt-1 mb-0 ml-1">
                                                {{ __('Number of nights will be calculated based on checkin & checkout date.') }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Number of Guests') }} <span class="text-danger">**</span></label>
                                            <input type="number" class="form-control"
                                                placeholder="{{ __('Enter Number of Guests') }}" name="guests"
                                                value="{{ old('guests') }}" autocomplete="off">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_guests"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Price') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="actual_total" value="0.00"
                                                readonly id="price" autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Discount') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="discount" value="0.00"
                                                id="discount" placeholder="Enter Discount Amount" oninput="applyDiscount()"
                                                autocomplete="off">
                                            <p class="text-warning mt-1 mb-0 ml-1">
                                                {{ __('Do not press \'Enter\' key.') }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Subtotal') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="subtotal" value="0.00"
                                                readonly id="subtotal" autocomplete="off">
                                        </div>
                                    </div>

                                    @if ($userBs->room_tax_status == 1)
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Tax') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                                <input type="text" class="form-control" name="tax" value="0.00"
                                                    id="tax" oninput="applyTaxFee()" autocomplete="off">
                                            </div>
                                        </div>
                                    @endif

                                    @if ($userBs->room_fee_status == 1)
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Fee') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                                <input type="text" class="form-control" name="fee" value="0.00"
                                                    id="fee" oninput="applyTaxFee()" autocomplete="off">
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Total Rent') . ' (' . $currencyInfo->base_currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="total" value="0.00"
                                                readonly id="total" autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Full Name') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Enter Full Name') }}" name="customer_name"
                                                value="{{ old('customer_name') }}" autocomplete="off">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_name"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Phone Number') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Enter Phone Number') }}" name="customer_phone"
                                                value="{{ old('customer_phone') }}" autocomplete="off">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_phone"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Email') }} <span class="text-danger">**</span></label>
                                            <input type="email" class="form-control"
                                                placeholder="{{ __('Enter Customer Email') }}" name="customer_email"
                                                value="{{ old('customer_email') }}" autocomplete="off">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_email"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Payment Method') }} <span class="text-danger">**</span></label>
                                            <select name="payment_method" class="form-control" autocomplete="off">
                                                <option selected disabled>{{ __('Select a Method') }}</option>

                                                @if (count($onlineGateways) > 0)
                                                    @foreach ($onlineGateways as $onlineGateway)
                                                        <option
                                                            {{ old('payment_method') == $onlineGateway->name ? 'selected' : '' }}
                                                            value="{{ $onlineGateway->name }}">
                                                            {{ $onlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif

                                                @if (count($offlineGateways) > 0)
                                                    @foreach ($offlineGateways as $offlineGateway)
                                                        <option
                                                            {{ old('payment_method') == $offlineGateway->name ? 'selected' : '' }}
                                                            value="{{ $offlineGateway->name }}">
                                                            {{ $offlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_payment_method"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Payment Status') }} <span class="text-danger">**</span></label>
                                            <select name="payment_status" class="form-control" autocomplete="off">
                                                <option selected disabled>{{ __('Select Payment Status') }}</option>
                                                <option {{ old('payment_status') == '1' ? 'selected' : '' }}
                                                    value="1">
                                                    {{ __('Paid') }}
                                                </option>
                                                <option {{ old('payment_status') == '0' ? 'selected' : '' }}
                                                    value="0">
                                                    {{ __('Unpaid') }}
                                                </option>
                                            </select>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_payment_status"></p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="roomBookingForm" class="btn btn-success">
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        'use strict';

        // assign php value to js variable
        let bookedDates = {!! json_encode($dates) !!};
        let roomRentPerNight = '{{ $rent }}';
        let room_fee = "{{ $userBs->room_fee_status == 1 ? $userBs->room_fee : 0 }}";
        let room_tax = "{{ $userBs->room_tax_status == 1 ? $userBs->room_tax : 0 }}";
    </script>

    <script type="text/javascript" src="{{ asset('assets/tenant/js/admin-room.js') }}"></script>
@endsection
