@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Booking Details') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Room Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Booking Details') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Edit Booking Details') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.room_bookings.all_bookings') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            <form id="roomBookingForm" action="{{ route('tenant.room_bookings.update_booking') }}"
                                method="POST">
                                @csrf
                                <input type="hidden" name="booking_id" value="{{ $details->id }}">
                                <input type="hidden" name="room_id" value="{{ $details->room_id }}">

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Booking Number') }}</label>
                                            <input type="text" class="form-control"
                                                value="{{ '#' . $details->booking_number }}" readonly>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Booking Date') }}</label>
                                            <input type="text" class="form-control"
                                                value="{{ date_format($details->created_at, 'F d, Y') }}" readonly>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Full Name') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Enter Full Name') }}" name="customer_name"
                                                value="{{ $details->customer_name }}">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_name"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Email') }} <span class="text-danger">**</span></label>
                                            <input type="email" class="form-control"
                                                placeholder="{{ __('Enter Customer Email') }}" name="customer_email"
                                                value="{{ $details->customer_email }}">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_email"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Customer Phone Number') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Enter Phone Number') }}" name="customer_phone"
                                                value="{{ $details->customer_phone }}">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_customer_phone"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Room Name') }}</label>
                                            <input type="text" class="form-control" value="{{ $roomTitle }}" readonly
                                                placeholder="{{ __('Enter Room Name') }}">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Room Type') }}</label>
                                            <input type="text" class="form-control" value="{{ $roomCategoryName }}"
                                                readonly>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Check In / Out Date') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Select Dates') }}" id="date-range" name="dates"
                                                value="{{ $details->arrival_date . ' - ' . $details->departure_date }}"
                                                readonly>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_dates"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Number of Nights') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control"
                                                placeholder="{{ __('Number of Nights') }}" id="night" name="nights"
                                                value="{{ $interval->days }}" readonly>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_nights"></p>
                                            <p class="text-warning mt-1 mb-0 ml-1">
                                                {{ __('Number of nights will be calculated based on checkin & checkout date.') }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Number of Guests') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="number" class="form-control"
                                                placeholder="{{ __('Enter Number of Guests') }}" name="guests"
                                                value="{{ $details->guests }}">
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_guests"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Price') . ' (' . $details->currency_text . ')' }}</label>
                                            <input type="text" class="form-control" id="price"
                                                name="actual_total"
                                                value="{{ number_format($details->actual_total, 2) }}" readonly>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Discount') . ' (' . $details->currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="discount"
                                                value="{{ $details->discount }}" id="discount"
                                                oninput="applyDiscount()">
                                            <p class="text-warning mt-1 mb-0 ml-1">
                                                {{ __('Do not press `Enter` key.') }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Subtotal') . ' (' . $details->currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="subtotal"
                                                value="{{ $details->subtotal }}" readonly id="subtotal">
                                        </div>
                                    </div>
                                    @if ($details->tax >= 0 || $userBs->room_tax_status == 1)
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Tax') . ' (' . $details->currency_text . ')' }}</label>
                                                <input type="text" class="form-control" name="tax"
                                                    value="{{ $details->tax }}" id="tax"
                                                    placeholder="Enter Tax Amount" oninput="applyTaxFee()">
                                                <p class="text-warning mt-1 mb-0 ml-1">
                                                    {{ __('Do not press `Enter` key.') }}
                                                </p>
                                            </div>
                                        </div>
                                    @endif

                                    @if ($details->fee >= 0 || $userBs->room_fee_status == 1)
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Fee') . ' (' . $details->currency_text . ')' }}</label>
                                                <input type="text" class="form-control" name="fee"
                                                    value="{{ $details->fee }}" id="fee"
                                                    placeholder="Enter Fee Amount" oninput="applyTaxFee()">
                                                <p class="text-warning mt-1 mb-0 ml-1">
                                                    {{ __('Do not press `Enter` key.') }}
                                                </p>
                                            </div>
                                        </div>
                                    @endif

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Total Rent') . ' (' . $details->currency_text . ')' }}</label>
                                            <input type="text" class="form-control" name="total"
                                                value="{{ $details->grand_total }}" readonly id="total">
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Payment Method') }} <span class="text-danger">**</span></label>
                                            <select name="payment_method" class="form-control">
                                                <option disabled>{{ __('Select a Method') }}</option>

                                                @if (count($onlineGateways) > 0)
                                                    @foreach ($onlineGateways as $onlineGateway)
                                                        <option
                                                            {{ $details->payment_method == $onlineGateway->name ? 'selected' : '' }}
                                                            value="{{ $onlineGateway->name }}">
                                                            {{ $onlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif

                                                @if (count($offlineGateways) > 0)
                                                    @foreach ($offlineGateways as $offlineGateway)
                                                        <option
                                                            {{ $details->payment_method == $offlineGateway->name ? 'selected' : '' }}
                                                            value="{{ $offlineGateway->name }}">
                                                            {{ $offlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_payment_method"></p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Payment Status') }} <span class="text-danger">**</span></label>
                                            <select name="payment_status" class="form-control">
                                                <option disabled>{{ __('Select Payment Status') }}</option>
                                                <option {{ $details->payment_status == 1 ? 'selected' : '' }}
                                                    value="1">
                                                    {{ __('Paid') }}
                                                </option>
                                                <option {{ $details->payment_status == 0 ? 'selected' : '' }}
                                                    value="0">
                                                    {{ __('Unpaid') }}
                                                </option>
                                            </select>
                                            <p class="mt-1 mb-0 ml-1 em text-danger" id="er_payment_status"></p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="roomBookingForm" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        'use strict';
        // assign php value to js variable
        let room_fee = "{{ $userBs->room_fee_status == 1 ? $details->fee : 0 }}";
        let room_tax = "{{ $userBs->room_tax_status == 1 ? $details->tax : 0 }}";
        let bookedDates = {!! json_encode($bookedDates) !!};
        let roomRentPerNight = '{{ $rent }}';
    </script>

    <script type="text/javascript" src="{{ asset('assets/tenant/js/admin-room.js') }}"></script>
@endsection
