@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Booking Details') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Room Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Booking Details') }}</a>
            </li>
        </ul>
        <a href="{{ url()->previous() }}" class="btn btn-primary ml-auto">
            <span class="btn-label">
                <i class="fas fa-backward"></i>
            </span>
            {{ __('Back') }}
        </a>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title d-inline-block">{{ __('Booking No') . ':' }}
                                #{{ $details->booking_number }} </div>
                        </div>
                        <div class="card-body">
                            <div class="container">

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Booking Date') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        {{ date_format($details->created_at, 'F d, Y') }}
                                    </div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Room Name') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $roomTitle }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Room Type') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $roomCategoryName }}</div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Price') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        {{ $details->currency_symbol }} {{ number_format($details->actual_total, 2) }}
                                    </div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Discount') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        {{ $details->currency_symbol }} {{ number_format($details->discount, 2) }}
                                    </div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Subtotal') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        {{ $details->currency_symbol }} {{ $details->subtotal }}
                                    </div>
                                </div>
                                <hr>

                                @if ($details->tax > 0 || $userBs->room_tax_status == 1)
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <strong>{{ __('Tax') . ':' }}</strong>
                                        </div>
                                        <div class="col-lg-8">
                                            {{ $details->currency_symbol }} {{ number_format($details->tax, 2) }}
                                        </div>
                                    </div>
                                    <hr>
                                @endif

                                @if ($details->fee > 0 || $userBs->room_fee_status == 1)
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <strong>{{ __('Fee') . ':' }}</strong>
                                        </div>
                                        <div class="col-lg-8">
                                            {{ $details->currency_symbol }} {{ number_format($details->fee, 2) }}
                                        </div>
                                    </div>
                                    <hr>
                                @endif

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Total') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        {{ $details->currency_symbol }} {{ $details->grand_total }}
                                    </div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Payment Method') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8"><span
                                            class="badge badge-success">{{ __($details->payment_method) }} </span>
                                    </div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Payment Status') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">
                                        @if ($details->payment_offline_status === null)
                                            @if ($details->payment_status == 1)
                                                <span class="badge badge-success">{{ __('Paid') }}</span>
                                            @endif
                                            @if ($details->payment_status == 0)
                                                <span class="badge badge-danger">{{ __('UnPaid') }}</span>
                                            @endif
                                        @elseif($details->payment_offline_status === 1)
                                            <span class="badge badge-success">{{ __('Accepted') }}</span>
                                        @endif
                                        @if ($details->payment_offline_status === 0)
                                            <span class="badge badge-danger">{{ __('Rejected') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer"></div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title d-inline-block">{{ __('Booking Information') }}</div>
                        </div>
                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Arrival Date') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->arrival_date }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Departure Date') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->departure_date }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Number Of Guests') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->guests }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Number Of Nights') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $interval->days }}</div>
                                </div>
                                <hr>
                            </div>
                        </div>

                        <div class="card-footer"></div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title d-inline-block">{{ __('Billing Details') }}</div>
                        </div>
                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Name') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->customer_name }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Email') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->customer_email }}</div>
                                </div>
                                <hr>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <strong>{{ __('Contact Number') . ':' }}</strong>
                                    </div>
                                    <div class="col-lg-8">{{ $details->customer_phone }}</div>
                                </div>
                                <hr>
                            </div>
                        </div>
                        <div class="card-footer"></div>
                    </div>
                </div>
            </div>
        </div>


    </div>
@endsection

@section('script')
    <script>
        'use strict';
        // assign php value to js variable
        let bookedDates = {!! json_encode($bookedDates) !!};
        let roomRentPerNight = '{{ $rent }}';
        let room_fee =
    </script>
    <script type="text/javascript" src="{{ asset('assets/tenant/js/admin-room.js') }}"></script>
@endsection
