@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Change Password') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Users Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Registered Users') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Change Password') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Change Password') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block" href="{{ route('user.registered_users') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward" style="font-size: 12px;"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>

                <div class="card-body py-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="ajaxEditForm"
                                action="{{ route('user.user.update_password', ['id' => $userInfo->id]) }}" method="post">
                                @csrf
                                <div class="form-group">
                                    <label>{{ __('New Password') }} <span class="text-danger">**</span></label>
                                    <input type="password" class="form-control" name="new_password">
                                    <p id="editErr_new_password" class="mt-1 mb-0 text-danger em"></p>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Confirm New Password') }} <span class="text-danger">**</span></label>
                                    <input type="password" class="form-control" name="new_password_confirmation">
                                    <p id="editErr_new_password_confirmation" class="mt-1 mb-0 text-danger em"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="updateBtn" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
