@php
    $infoIcon = false;
    use App\Constants\Constant;
    use App\Models\Package;
    use App\Http\Helpers\Uploader;
    use App\Http\Helpers\LimitCheckerHelper;

    $username = Auth::guard('web')->user()->username;

    $packageId = LimitCheckerHelper::getMembershipId(Auth::guard('web')->user()->id);
    $currentPackage = Package::find($packageId);

    $feature = json_decode($currentPackage?->features, true);
    $languageCount = $roomCount = $roomcategoryCount = $roomBookingCount = $roomBookingCouponCount = $packageCount = $packagecategoryCount = $packageBookingCouponCount = $customPageCount = $blogCount = 0;

    if ($currentPackage && $feature) {
        $languageCount = LimitCheckerHelper::countLanguages(Auth::guard('web')->user()->id);

        $roomCount = LimitCheckerHelper::countRooms(Auth::guard('web')->user()->id);
        $roomcategoryCount = LimitCheckerHelper::countRoomCategorys(Auth::guard('web')->user()->id);
        $roomBookingCount = LimitCheckerHelper::countRoomBookings(Auth::guard('web')->user()->id);
        $roomBookingCouponCount = LimitCheckerHelper::countRoomBookingCoupon(Auth::guard('web')->user()->id);

        $packageCount = LimitCheckerHelper::countPackages(Auth::guard('web')->user()->id);
        $packagecategoryCount = LimitCheckerHelper::countPackageCategorys(Auth::guard('web')->user()->id);
        $packageBookingCount = LimitCheckerHelper::countPackageBookings(Auth::guard('web')->user()->id);
        $packageBookingCouponCount = LimitCheckerHelper::countPackageBookingCoupon(Auth::guard('web')->user()->id);

        $customPageCount = LimitCheckerHelper::countCustomPage(Auth::guard('web')->user()->id);
        $blogCount = LimitCheckerHelper::blogCount(Auth::guard('web')->user()->id);

        if (
            $languageCount > $currentPackage->language_limit ||
            $roomCount > $currentPackage->room_limit ||
            $roomcategoryCount > $currentPackage->room_categories_limit ||
            $roomBookingCount > $currentPackage->room_booking_limit ||
            $roomBookingCouponCount > $currentPackage->room_booking_coupon_limit ||
            $packageCount > $currentPackage->package_limit ||
            $packagecategoryCount > $currentPackage->package_categories_limit ||
            $packageBookingCount > $currentPackage->package_booking_limit ||
            $packageBookingCouponCount > $currentPackage->package_booking_coupon_limit ||
            $customPageCount > $currentPackage->custom_page_limit ||
            $blogCount > $currentPackage->blog_limit
        ) {
            $infoIcon = true;
        }
    }
@endphp

<div class="main-header">
    <!-- Logo Header -->
    <div class="logo-header" @if (request()->cookie('user-theme') == 'dark') data-background-color="dark2" @endif>
        <a href="{{ route('front.user.detail.view', Auth::guard('web')->user()->username) }}" class="logo"
            target="_blank">
            <img src="{{ $userBs->logo ? '/assets/tenant/img/logo/' . $userBs->logo : asset('assets/tenant/img/defaultlogo.png') }}"
                alt="navbar brand" style="width:109px;" class="navbar-brand">
        </a>
        <button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse"
            data-target="collapse" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon">
                <i class="icon-menu"></i>
            </span>
        </button>
        <button class="topbar-toggler more"><i class="icon-options-vertical"></i></button>
        <div class="nav-toggle">
            <button class="btn btn-toggle toggle-sidebar">
                <i class="icon-menu"></i>
            </button>
        </div>
    </div>
    <!-- End Logo Header -->
    <!-- Navbar Header -->
    <nav class="navbar navbar-header navbar-expand-lg"
        @if (request()->cookie('user-theme') == 'dark') data-background-color="dark" @endif>
        <div class="container-fluid">
            <ul class="navbar-nav topbar-nav ml-md-auto align-items-center">
                <li class="">
                    <form action="{{ route('user.theme.change') }}" class="mr-4 form-inline" id="adminThemeForm">
                        <div class="form-group">
                            <div class="selectgroup selectgroup-secondary selectgroup-pills">
                                <label class="selectgroup-item">
                                    <input type="radio" name="theme" value="light" class="selectgroup-input"
                                        {{ empty(request()->cookie('user-theme')) || request()->cookie('user-theme') == 'light' ? 'checked' : '' }}
                                        onchange="document.getElementById('adminThemeForm').submit();">
                                    <span class="selectgroup-button selectgroup-button-icon"><i
                                            class="fa fa-sun"></i></span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="theme" value="dark" class="selectgroup-input"
                                        {{ request()->cookie('user-theme') == 'dark' ? 'checked' : '' }}
                                        onchange="document.getElementById('adminThemeForm').submit();">
                                    <span class="selectgroup-button selectgroup-button-icon"><i
                                            class="fa fa-moon"></i></span>
                                </label>
                            </div>
                        </div>
                    </form>
                </li>

                <li class="mr-4">
                    <a class="btn btn-primary btn-sm btn-round" target="_blank"
                        href="{{ route('front.user.detail.view', Auth::user()->username) }}" title="View Website">
                        <i class="fas fa-eye"></i>
                    </a>
                </li>

                <li class="d-flex mr-4">
                    <a class="btn btn-secondary  btn-sm" data-toggle="modal" data-target="#limitModal">
                        <span class="text-white">{{ __('Check Limits') }}
                        </span>

                    </a>
                    <sup class="float-start">
                        @if ($infoIcon == true)
                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15 class="errorIcon">
                        @endif
                    </sup>
                </li>

                <li class="d-flex mr-4">
                    <label class="switch">
                        <input type="checkbox" name="online_status" id="toggle-btn" data-toggle="toggle" data-on="1"
                            data-off="0" @if (Auth::user()->online_status == 1) checked @endif>
                        <span class="slider round"></span>
                    </label>
                    @if (Auth::user()->online_status == 1)
                        <h5 class="mt-2 ml-2 @if (request()->cookie('user-theme') == 'dark') text-white @endif">
                            {{ __('Active') }}
                        </h5>
                    @else
                        <h5 class="mt-2 ml-2 @if (request()->cookie('user-theme') == 'dark') text-white @endif">
                            {{ __('Deactive') }}
                        </h5>
                    @endif
                </li>

                <li class="nav-item dropdown hidden-caret">
                    <a class="dropdown-toggle profile-pic" data-toggle="dropdown" href="#" aria-expanded="false">
                        <div class="avatar-sm">
                            @if (!empty(Auth::user()->photo))
                                <img src="{{ asset('assets/tenant/img/users/' . Auth::user()->photo) }}" alt="..."
                                    class="avatar-img rounded-circle">
                            @else
                                <img src="{{ asset('assets/admin/img/propics/blank_user.jpg') }}" alt="..."
                                    class="avatar-img rounded-circle">
                            @endif
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-user animated fadeIn">
                        <div class="dropdown-user-scroll scrollbar-outer">
                            <li>
                                <div class="user-box">
                                    <div class="avatar-lg">
                                        @if (!empty(Auth::user()->photo))
                                            <img src="{{ asset('assets/tenant/img/users/' . Auth::user()->photo) }}"
                                                alt="..." class="avatar-img rounded">
                                        @else
                                            <img src="{{ asset('assets/admin/img/propics/blank_user.jpg') }}"
                                                alt="..." class="avatar-img rounded">
                                        @endif
                                    </div>
                                    <div class="u-text">
                                        <h4>{{ Auth::user()->first_name }} {{ Auth::user()->last_name }}</h4>
                                        <p class="text-muted">{{ Auth::user()->email }}</p>
                                        <a href="{{ route('user.profile_edit') }}"
                                            class="btn btn-xs btn-secondary btn-sm">{{ __('Edit Profile') }}</a>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item"
                                    href="{{ route('user.profile_edit') }}">{{ __('Edit Profile') }}</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item"
                                    href="{{ route('user.changePass') }}">{{ __('Change Password') }}</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{ route('user-logout') }}">{{ __('Logout') }}</a>
                            </li>
                        </div>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>
    <!-- End Navbar -->
</div>


<div class="modal fade" id="limitModal" tabindex="-1" aria-labelledby="limitModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="limitModalLabel"> {{ __('All Limits') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <span class="text-warning">
                        {{ __('If any feature has crossed its current subscription package\'s limit, then you won\'t be able to add/edit any other feature.') }}
                    </span>
                </div>

                @if ($currentPackage)
                    <ul class="list-group limit-modal">

                        <li class="list-group-item border">
                            <div class="d-flex justify-content-between">
                                <span>
                                    @if ($roomCount > $currentPackage->room_limit)
                                        <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                            class="errorIcon ">
                                    @endif {{ __('Rooms Left') . ':' }}
                                </span>
                                <span
                                    class="badge badge-primary badge-sm">{{ $currentPackage->room_limit == 999999 ? 'Unlimited' : ($currentPackage->room_limit - $roomCount < 0 ? 0 : $currentPackage->room_limit - $roomCount) }}</span>
                            </div>
                            @if ($roomCount - $currentPackage->room_limit == 0)
                                <p class="text-warning m-0">
                                    {{ __('Your room limit has been reached. You cannot add more rooms.') }}
                                </p>
                            @endif
                            @if ($roomCount > $currentPackage->room_limit)
                                <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                    {{ abs($currentPackage->room_limit - $roomCount) }}
                                    {{ abs($currentPackage->room_limit - $roomCount) == 1 ? __('room') : __('rooms') }}
                                </p>
                            @endif
                        </li>
                        <li class="list-group-item border">
                            <div class="d-flex  justify-content-between">
                                <span>
                                    @if ($roomcategoryCount > $currentPackage->room_categories_limit)
                                        <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                            class="errorIcon ">
                                    @endif {{ __('Room Categories Left') }} :
                                </span>
                                <span
                                    class="badge badge-primary badge-sm">{{ $currentPackage->room_categories_limit == 999999 ? __('Unlimited') : ($currentPackage->room_categories_limit - $roomcategoryCount < 0 ? 0 : $currentPackage->room_categories_limit - $roomcategoryCount) }}</span>
                            </div>
                            @if ($roomcategoryCount - $currentPackage->room_categories_limit == 0)
                                <p class="text-warning m-0">
                                    {{ __('Your room category limit has been reached. You cannot add more room categories.') }}
                                </p>
                            @endif

                            @if ($roomcategoryCount > $currentPackage->room_categories_limit)
                                <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                    {{ abs($currentPackage->room_categories_limit - $roomcategoryCount) }}
                                    {{ abs($currentPackage->room_categories_limit - $roomcategoryCount) == 1 ? __('room category') : __('room categories') }}
                                </p>
                            @endif
                        </li>
                        <li class="list-group-item border">
                            <div class="d-flex  justify-content-between">
                                <span>
                                    @if ($roomBookingCount > $currentPackage->room_booking_limit)
                                        <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                            class="errorIcon ">
                                    @endif {{ __('Room Bookings Left') }} :
                                </span>

                                <span
                                    class="badge badge-primary badge-sm">{{ $currentPackage->room_booking_limit == 999999 ? __('Unlimited') : ($currentPackage->room_booking_limit - $roomBookingCount < 0 ? 0 : $currentPackage->room_booking_limit - $roomBookingCount) }}</span>
                            </div>
                            @if ($roomBookingCount - $currentPackage->room_booking_limit == 0)
                                <p class="text-warning m-0">
                                    {{ __('Your room booking limit has been reached. You cannot add more room bookings.') }}
                                </p>
                            @endif
                            @if ($roomBookingCount > $currentPackage->room_booking_limit)
                                <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                    {{ abs($currentPackage->room_booking_limit - $roomBookingCount) }}
                                    {{ abs($currentPackage->room_booking_limit - $roomBookingCount) == 1 ? __('room booking') : __('room bookings') }}
                                </p>
                            @endif
                        </li>
                        <li class="list-group-item border">
                            <div class="d-flex  justify-content-between">
                                <span>
                                    @if ($roomBookingCouponCount > $currentPackage->room_booking_coupon_limit)
                                        <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                            class="errorIcon ">
                                    @endif {{ __('Room Booking Coupons Left') }} :
                                </span>
                                <span
                                    class="badge badge-primary badge-sm">{{ $currentPackage->room_booking_coupon_limit == 999999 ? __('Unlimited') : ($currentPackage->room_booking_coupon_limit - $roomBookingCouponCount < 0 ? 0 : $currentPackage->room_booking_coupon_limit - $roomBookingCouponCount) }}</span>
                            </div>
                            @if ($roomBookingCouponCount - $currentPackage->room_booking_coupon_limit == 0)
                                <p class="text-warning m-0">
                                    {{ __('Your room booking coupon limit has been reached. You cannot add more room booking coupons') }}
                                </p>
                            @endif
                            @if ($roomBookingCouponCount > $currentPackage->room_booking_coupon_limit)
                                <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                    {{ abs($currentPackage->room_booking_coupon_limit - $roomBookingCouponCount) }}
                                    {{ abs($currentPackage->room_booking_coupon_limit - $roomBookingCouponCount) == 1 ? __('room booking') : __('room bookings') }}
                                </p>
                            @endif
                        </li>

                        @if (in_array('Tour Package', $feature))
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($packageCount > $currentPackage->package_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Tour Packages Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->package_limit == 999999 ? __('Unlimited') : ($currentPackage->package_limit - $packageCount < 0 ? 0 : $currentPackage->package_limit - $packageCount) }}</span>
                                </div>
                                @if ($packageCount - $currentPackage->package_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your tour package limit has been reached. You cannot add more tour packages') }}
                                    </p>
                                @endif
                                @if ($packageCount > $currentPackage->package_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->package_limit - $packageCount) }}
                                        {{ abs($currentPackage->package_limit - $packageCount) == 1 ? __('tour package') : __('tour packages') }}
                                    </p>
                                @endif
                            </li>
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($packagecategoryCount > $currentPackage->package_categories_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Tour Package Categories Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->package_categories_limit == 999999 ? __('Unlimited') : ($currentPackage->package_categories_limit - $packagecategoryCount < 0 ? 0 : $currentPackage->package_categories_limit - $packagecategoryCount) }}</span>
                                </div>
                                @if ($packagecategoryCount - $currentPackage->package_categories_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your tour package category limit has been reached. You cannot add more tour package categories') }}
                                    </p>
                                @endif
                                @if ($packagecategoryCount > $currentPackage->package_categories_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->package_categories_limit - $packagecategoryCount) }}
                                        {{ abs($currentPackage->package_categories_limit - $packagecategoryCount) == 1 ? __('tour package category') : __('tour package categories') }}
                                    </p>
                                @endif
                            </li>
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($packageBookingCount > $currentPackage->package_booking_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Tour Package Bookings Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->package_booking_limit == 999999 ? __('Unlimited') : ($currentPackage->package_booking_limit - $packageBookingCount < 0 ? 0 : $currentPackage->package_booking_limit - $packageBookingCount) }}</span>
                                </div>

                                @if ($packageBookingCount - $currentPackage->package_booking_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your tour package booking limit has been reached. You cannot add more tour package bookings') }}
                                    </p>
                                @endif

                                @if ($packageBookingCount > $currentPackage->package_booking_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->package_booking_limit - $packageBookingCount) }}
                                        {{ abs($currentPackage->package_booking_limit - $packageBookingCount) == 1 ? 'tour package booking' : 'tour package bookings' }}
                                    </p>
                                @endif
                            </li>
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($packageBookingCouponCount > $currentPackage->package_booking_coupon_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Tour Package Booking Coupons Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->package_booking_coupon_limit == 999999 ? __('Unlimited') : ($currentPackage->package_booking_coupon_limit - $packageBookingCouponCount < 0 ? 0 : $currentPackage->package_booking_coupon_limit - $packageBookingCouponCount) }}</span>
                                </div>

                                @if ($packageBookingCouponCount - $currentPackage->package_booking_coupon_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your tour package  booking coupon limit has been reached. You cannot add more tour package booking coupons') }}
                                    </p>
                                @endif
                                @if ($packageBookingCouponCount > $currentPackage->package_booking_coupon_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->package_booking_coupon_limit - $packageBookingCouponCount) }}
                                        {{ abs($currentPackage->package_booking_coupon_limit - $packageBookingCouponCount) == 1 ? __('tour package booking coupon') : __('tour package bookings coupons') }}
                                    </p>
                                @endif
                            </li>
                        @endif

                        @if (in_array('Blog', $feature))
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($blogCount > $currentPackage->blog_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Blogs Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->blog_limit == 999999 ? __('Unlimited') : ($currentPackage->blog_limit - $blogCount < 0 ? 0 : $currentPackage->blog_limit - $blogCount) }}</span>
                                </div>
                                @if ($blogCount - $currentPackage->blog_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your blog limit has been reached. You cannot add more blogs.') }}
                                    </p>
                                @endif
                                @if ($blogCount > $currentPackage->blog_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->blog_limit - $blogCount) }}
                                        {{ abs($currentPackage->blog_limit - $blogCount) == 1 ? __('Blog') : __('Blogs') }}
                                    </p>
                                @endif
                            </li>
                        @endif

                        @if (in_array('Custom Page', $feature))
                            <li class="list-group-item border">
                                <div class="d-flex  justify-content-between">
                                    <span>
                                        @if ($customPageCount > $currentPackage->custom_page_limit)
                                            <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                                class="errorIcon ">
                                        @endif {{ __('Additional Pages Left') }} :
                                    </span>
                                    <span
                                        class="badge badge-primary badge-sm">{{ $currentPackage->custom_page_limit == 999999 ? __('Unlimited') : ($currentPackage->custom_page_limit - $customPageCount < 0 ? 0 : $currentPackage->custom_page_limit - $customPageCount) }}</span>
                                </div>

                                @if ($customPageCount - $currentPackage->custom_page_limit == 0)
                                    <p class="text-warning m-0">
                                        {{ __('Your additional page limit has been reached. You cannot add more additional pages.') }}
                                    </p>
                                @endif

                                @if ($customPageCount > $currentPackage->custom_page_limit)
                                    <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                        {{ abs($currentPackage->custom_page_limit - $customPageCount) }}
                                        {{ abs($currentPackage->custom_page_limit - $customPageCount) == 1 ? __('Additional Page') : __('Additional Pages') }}
                                    </p>
                                @endif
                            </li>
                        @endif

                        <li class="list-group-item border">
                            <div class="d-flex  justify-content-between">
                                <span>
                                    @if ($languageCount > $currentPackage->language_limit)
                                        <img src="{{ asset('assets/tenant/img/error.png') }}" width="15"
                                            class="errorIcon ">
                                    @endif {{ __('Languages Left') }} :
                                </span>
                                <span
                                    class="badge badge-primary badge-sm">{{ $currentPackage->language_limit == 999999 ? __('Unlimited') : ($currentPackage->language_limit - $languageCount < 0 ? 0 : $currentPackage->language_limit - $languageCount) }}
                                </span>
                            </div>

                            @if ($languageCount - $currentPackage->language_limit == 0)
                                <p class="text-warning m-0">
                                    {{ __('Your language limit has been reached. You cannot add more languages.') }}
                                </p>
                            @endif
                            @if ($languageCount > $currentPackage->language_limit)
                                <p class="text-warning m-0">{{ __('Limit has been crossed, you have to delete') }}
                                    {{ abs($currentPackage->language_limit - $languageCount) }}
                                    {{ abs($currentPackage->language_limit - $languageCount) == 1 ? __('language') : __('languages') }}
                                </p>
                            @endif
                        </li>
                    </ul>
                @endif
            </div>
        </div>
    </div>
</div>
