@php
    use App\Http\Helpers\UserPermissionHelper;
    use App\Models\User\BasicSetting;
    use App\Models\User\Language;
    use Illuminate\Support\Facades\Auth;
    $default = Language::where('is_default', 1)
        ->where('user_id', Auth::user()->id)
        ->first();
    $user = Auth::guard('web')->user();
    $package = UserPermissionHelper::currentPackage($user->id);
    if (!empty($user)) {
        $permissions = UserPermissionHelper::packagePermission($user->id);
        $permissions = json_decode($permissions, true);
        $userBs = BasicSetting::where('user_id', $user->id)->first();
    }

@endphp
<div class="sidebar sidebar-style-2" @if (request()->cookie('user-theme') == 'dark') data-background-color="dark2" @endif>
    <div class="sidebar-wrapper scrollbar scrollbar-inner">
        <div class="sidebar-content">
            <div class="user">
                <div class="avatar-sm float-left mr-2">
                    @if (!empty(Auth::user()->photo))
                        <img src="{{ asset('assets/tenant/img/users/' . Auth::user()->photo) }}" alt="..."
                            class="avatar-img rounded">
                    @else
                        <img src="{{ asset('assets/admin/img/propics/blank_user.jpg') }}" alt="..."
                            class="avatar-img rounded">
                    @endif
                </div>
                <div class="info">
                    <a data-toggle="collapse" href="#collapseExample" aria-expanded="true">
                        <span>
                            {{ auth()->user()->first_name . ' ' . auth()->user()->last_name }}
                            <span class="user-level">{{ auth()->user()->username }}</span>
                            <span class="caret"></span>
                        </span>
                    </a>
                    <div class="clearfix"></div>
                    <div class="collapse in" id="collapseExample">
                        <ul class="nav">
                            @if (!is_null($package))
                                <li>
                                    <a href="{{ route('user.profile_edit') }}">
                                        <span class="link-collapse">{{ __('Edit Profile') }}</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('user.changePass') }}">
                                        <span class="link-collapse">{{ __('Change Password') }}</span>
                                    </a>
                                </li>
                            @endif
                            <li>
                                <a href="{{ route('user-logout') }}">
                                    <span class="link-collapse">{{ __('Logout') }}</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
     
            <ul class="nav nav-primary">
                <div class="row mb-2">
                    <div class="col-12">
                        <form action="">
                            <div class="form-group py-0">
                                <input name="term" type="text" class="form-control sidebar-search"
                                    value="" placeholder="{{ __('Search Menu Here') }}..."  style="direction: {{  $dashboard_language->rtl == 1 ? 'rtl' : 'ltr' }} !important">
                            </div>
                        </form>
                    </div>
                </div>
                <li class="nav-item
                     @if (request()->path() == 'user/dashboard') active @endif">
                    <a href="{{ route('user-dashboard') }}">
                        <i class="fas fa-tachometer-alt"></i>
                        <p>{{ __('Dashboard') }}</p>
                    </a>
                </li>



                @if (!is_null($package))
                    {{-- Start Rooms Management --}}
                    <li
                        class="nav-item 
                        @if (request()->routeIs('tenant.rooms_management.settings')) active
                        @elseif (request()->routeIs('tenant.rooms_management.categories')) active
                        @elseif (request()->routeIs('tenant.rooms_management.edit_category')) active
                        @elseif (request()->routeIs('tenant.rooms_management.settings')) active
                        @elseif (request()->routeIs('tenant.rooms_management.amenities')) active
                        @elseif (request()->routeIs('tenant.rooms_management.edit_amenity')) active
                        @elseif (request()->routeIs('tenant.rooms_management.coupons')) active
                        @elseif (request()->routeIs('tenant.rooms_management.rooms')) active
                        @elseif (request()->routeIs('tenant.rooms_management.create_room')) active
                        @elseif (request()->routeIs('tenant.rooms_management.edit_room')) active
                        @elseif (request()->routeIs('tenant.rooms_management.tax_fee')) active @endif">
                        <a data-toggle="collapse" href="#rooms">
                              <i class="fas fa-hotel"></i>
                            <p>{{ __('Rooms Management') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div id="rooms"
                            class="collapse
                            @if (request()->routeIs('tenant.rooms_management.settings')) show
                            @elseif (request()->routeIs('tenant.rooms_management.categories')) show
                            @elseif (request()->routeIs('tenant.rooms_management.edit_category')) show
                            @elseif (request()->routeIs('tenant.rooms_management.settings')) show
                            @elseif (request()->routeIs('tenant.rooms_management.amenities')) show
                            @elseif (request()->routeIs('tenant.rooms_management.edit_amenity')) show
                            @elseif (request()->routeIs('tenant.rooms_management.coupons')) show
                            @elseif (request()->routeIs('tenant.rooms_management.rooms')) show
                            @elseif (request()->routeIs('tenant.rooms_management.create_room')) show
                            @elseif (request()->routeIs('tenant.rooms_management.edit_room')) show
                            @elseif (request()->routeIs('tenant.rooms_management.tax_fee')) show @endif">
                            <ul class="nav nav-collapse">
                                <li
                                    class="submenu  @if (request()->routeIs('tenant.rooms_management.settings')) selected
                                      @elseif (request()->routeIs('tenant.rooms_management.categories')) selected
                                      @elseif(request()->routeIs('tenant.rooms_management.edit_category')) selected 
                                      @elseif (request()->routeIs('tenant.rooms_management.coupons')) selected
                                      @elseif (request()->routeIs('tenant.rooms_management.amenities')) selected
                                      @elseif(request()->routeIs('tenant.rooms_management.edit_amenity'))  selected
                                      @elseif (request()->routeIs('tenant.rooms_management.tax_fee')) selected @endif">
                                    <a data-toggle="collapse" href="#roomSettings">
                                        <span class="sub-item">{{ __('Settings') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div class="collapse
                                      @if (request()->routeIs('tenant.rooms_management.settings')) show
                                      @elseif (request()->routeIs('tenant.rooms_management.categories')) show
                                      @elseif(request()->routeIs('tenant.rooms_management.edit_category')) show 
                                      @elseif (request()->routeIs('tenant.rooms_management.coupons')) show
                                      @elseif (request()->routeIs('tenant.rooms_management.amenities')) show
                                      @elseif(request()->routeIs('tenant.rooms_management.edit_amenity'))  show
                                      @elseif (request()->routeIs('tenant.rooms_management.tax_fee')) show @endif"
                                        id="roomSettings">
                                        <ul class="nav nav-collapse subnav">
                                            <li
                                                class="
                                                @if (request()->routeIs('tenant.rooms_management.settings')) active @endif">
                                                <a
                                                    href="{{ route('tenant.rooms_management.settings', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Preferences') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="
                                               @if (request()->routeIs('tenant.rooms_management.coupons')) active @endif">
                                                <a
                                                    href="{{ route('tenant.rooms_management.coupons', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Coupons') }}</span>
                                                </a>
                                            </li>
                                            <li class="@if (request()->routeIs('tenant.rooms_management.tax_fee')) active @endif">
                                                <a
                                                    href="{{ route('tenant.rooms_management.tax_fee', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Fees - Tax , Fee') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="
                                                    @if (request()->routeIs('tenant.rooms_management.amenities')) active
                                                    @elseif(request()->routeIs('tenant.rooms_management.edit_amenity'))  active @endif">
                                                <a
                                                    href="{{ route('tenant.rooms_management.amenities', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Amenities') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="
                                                @if (request()->routeIs('tenant.rooms_management.categories')) active
                                                @elseif(request()->routeIs('tenant.rooms_management.edit_category')) active @endif">
                                                <a
                                                    href="{{ route('tenant.rooms_management.categories', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Categories') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <li
                                    class="@if (request()->routeIs('tenant.rooms_management.rooms')) active
                                          @elseif (request()->routeIs('tenant.rooms_management.edit_room')) active @endif">
                                    <a
                                        href="{{ route('tenant.rooms_management.rooms', ['language' => $default->code]) }}">
                                        <span class="sub-item"> {{ __('Manage Rooms') }}</span>
                                    </a>
                                </li>

                                <li class="@if (request()->routeIs('tenant.rooms_management.create_room')) active @endif">
                                    <a
                                        href="{{ route('tenant.rooms_management.create_room', ['language' => $default->code]) }}">
                                        <span class="sub-item"> {{ __('Add Room') }}</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>

                    {{-- End Room Management --}}



                    {{-- Start Room Bookings --}}
                    <li
                        class="nav-item @if (request()->routeIs('tenant.room_bookings.all_bookings')) active
                        @elseif (request()->routeIs('tenant.room_bookings.paid_bookings')) active
                        @elseif (request()->routeIs('tenant.room_bookings.booking_edit')) active
                        @elseif (request()->routeIs('tenant.room_bookings.unpaid_bookings')) active
                        @elseif (request()->routeIs('tenant.room_bookings.booking_details_and_edit')) active
                        @elseif (request()->routeIs('tenant.rooms_management.report')) active
                        @elseif (request()->routeIs('tenant.room_bookings.booking_form')) active
                        @elseif (request()->routeIs('tenant.room_bookings.booking_details')) active @endif">
                        <a data-toggle="collapse" href="#roomBookings">
                            <i class="fas fa-bookmark"></i>
                            <p class="pr-2">{{ __('Room Bookings') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div id="roomBookings"
                            class="collapse
                            @if (request()->routeIs('tenant.room_bookings.all_bookings')) show
                            @elseif (request()->routeIs('tenant.room_bookings.paid_bookings')) show
                            @elseif (request()->routeIs('tenant.room_bookings.unpaid_bookings')) show
                            @elseif (request()->routeIs('tenant.room_bookings.unpaid_bookings')) show
                            @elseif (request()->routeIs('tenant.room_bookings.booking_edit')) show
                            @elseif (request()->routeIs('tenant.rooms_management.report')) show
                            @elseif (request()->routeIs('tenant.room_bookings.booking_form')) show
                            @elseif (request()->routeIs('tenant.room_bookings.booking_details')) show @endif">
                            <ul class="nav nav-collapse">
                                <li
                                    class="@if (request()->routeIs('tenant.room_bookings.all_bookings')) active
                                          @elseif(request()->routeIs('tenant.room_bookings.booking_edit')) active @endif">
                                    <a href="{{ route('tenant.room_bookings.all_bookings') }}">
                                        <span class="sub-item">{{ __('All Bookings') }}</span>
                                    </a>
                                </li>
                                <li
                                    class="{{ request()->routeIs('tenant.room_bookings.paid_bookings') ? 'active' : '' }}">
                                    <a href="{{ route('tenant.room_bookings.paid_bookings') }}">
                                        <span class="sub-item">{{ __('Paid Bookings') }}</span>
                                    </a>
                                </li>
                                <li
                                    class="{{ request()->routeIs('tenant.room_bookings.unpaid_bookings') ? 'active' : '' }}">
                                    <a href="{{ route('tenant.room_bookings.unpaid_bookings') }}">
                                        <span class="sub-item">{{ __('Unpaid Bookings') }}</span>
                                    </a>
                                </li>
                                <li class="@if (request()->routeIs('tenant.rooms_management.report')) active @endif">
                                    <a href="{{ route('tenant.rooms_management.report') }}">
                                        <span class="sub-item">{{ __('Report') }}</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                @endif
                {{-- End Room Bookings --}}

                {{-- Start package Management --}}
                @if (!is_null($package))
                    @if (!empty($permissions) && in_array('Tour Package', $permissions))
                        <li
                            class="nav-item @if (request()->routeIs('tenant.packages_management.settings')) active
                                    @elseif (request()->routeIs('tenant.packages_management.categories')) active
                                    @elseif (request()->routeIs('tenant.packages_management.edit_category')) active
                                    @elseif (request()->routeIs('tenant.packages_management.settings')) active
                                    @elseif (request()->routeIs('tenant.packages_management.coupons')) active
                                    @elseif (request()->routeIs('tenant.packages_management.packages')) active
                                    @elseif (request()->routeIs('tenant.packages_management.create_package')) active
                                    @elseif (request()->routeIs('tenant.packages_management.view_locations')) active
                                    @elseif (request()->routeIs('tenant.packages_management.view_plans')) active
                                    @elseif (request()->routeIs('tenant.packages_management.edit_package')) active
                                    @elseif (request()->routeIs('tenant.packages_management.tax_fee')) active @endif">
                            <a data-toggle="collapse" href="#packageManagement">
                                <i class="fas fa-boxes"></i>
                                <p>{{ __('Tour Packages Mang') }}</p>
                                <span class="caret"></span>
                            </a>
                            <div id="packageManagement"
                                class="collapse
                                    @if (request()->routeIs('tenant.packages_management.settings')) show
                                    @elseif (request()->routeIs('tenant.packages_management.categories')) show
                                    @elseif (request()->routeIs('tenant.packages_management.edit_category')) show
                                    @elseif (request()->routeIs('tenant.packages_management.settings')) show
                                    @elseif (request()->routeIs('tenant.packages_management.coupons')) show
                                    @elseif (request()->routeIs('tenant.packages_management.packages')) show
                                    @elseif (request()->routeIs('tenant.packages_management.create_package')) show
                                    @elseif (request()->routeIs('tenant.packages_management.view_locations')) show
                                    @elseif (request()->routeIs('tenant.packages_management.view_plans')) show
                                    @elseif (request()->routeIs('tenant.packages_management.edit_package')) show
                                    @elseif (request()->routeIs('tenant.packages_management.tax_fee')) show @endif">
                                <ul class="nav nav-collapse">
                                    <li
                                        class="submenu 
                                            @if (request()->routeIs('tenant.packages_management.settings')) selected
                                            @elseif(request()->routeIs('tenant.packages_management.coupons')) selected
                                            @elseif(request()->routeIs('tenant.packages_management.categories')) selected
                                            @elseif (request()->routeIs('tenant.packages_management.edit_category')) selected 
                                            @elseif (request()->routeIs('tenant.packages_management.tax_fee')) selected @endif">
                                        <a data-toggle="collapse" href="#packageSettings">
                                            <span class="sub-item">{{ __('Settings') }}</span>
                                            <span class="caret"></span>
                                        </a>
                                        <div class="collapse @if (request()->routeIs('tenant.packages_management.settings')) show
                                            @elseif(request()->routeIs('tenant.packages_management.coupons')) show
                                            @elseif(request()->routeIs('tenant.packages_management.categories')) show
                                            @elseif (request()->routeIs('tenant.packages_management.edit_category')) show
                                            @elseif (request()->routeIs('tenant.packages_management.tax_fee')) show @endif"
                                            id="packageSettings">
                                            <ul class="nav nav-collapse subnav">
                                                <li class="@if (request()->routeIs('tenant.packages_management.settings')) active @endif">
                                                    <a
                                                        href="{{ route('tenant.packages_management.settings', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Preferences') }}</span>
                                                    </a>
                                                </li>
                                                <li class="@if (request()->routeIs('tenant.packages_management.coupons')) active @endif">
                                                    <a
                                                        href="{{ route('tenant.packages_management.coupons', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Coupons') }}</span>
                                                    </a>
                                                </li>
                                                <li class="@if (request()->routeIs('tenant.packages_management.tax_fee')) active @endif">
                                                    <a
                                                        href="{{ route('tenant.packages_management.tax_fee', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Fees - Tax , Fee') }}</span>
                                                    </a>
                                                </li>
                                                <li
                                                    class="@if (request()->routeIs('tenant.packages_management.categories')) active
                                                    @elseif (request()->routeIs('tenant.packages_management.edit_category')) active @endif">
                                                    <a
                                                        href="{{ route('tenant.packages_management.categories', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Categories') }}</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>

                                    <li
                                        class="@if (request()->routeIs('tenant.packages_management.packages')) active
                                                @elseif (request()->routeIs('tenant.packages_management.view_locations')) active
                                                @elseif (request()->routeIs('tenant.packages_management.edit_package')) active
                                                @elseif (request()->routeIs('tenant.packages_management.view_locations')) active
                                                @elseif (request()->routeIs('tenant.packages_management.view_plans')) active @endif">
                                        <a href="{{ route('tenant.packages_management.packages') }}">
                                            <span class="sub-item">{{ __('Manage Packages') }}</span>
                                        </a>
                                    </li>

                                    <li class="@if (request()->routeIs('tenant.packages_management.create_package')) active @endif">
                                        <a href="{{ route('tenant.packages_management.create_package') }}">
                                            <span class="sub-item">{{ __('Add Package') }}</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif

                    {{-- End package Management --}}
                    {{-- Start Package Bookings --}}
                    @if (!empty($permissions) && in_array('Tour Package', $permissions))
                        <li
                            class="nav-item 
                                @if (request()->routeIs('tenant.package_bookings.all_bookings')) active
                                @elseif (request()->routeIs('tenant.package_bookings.paid_bookings')) active
                                @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings')) active
                                @elseif (request()->routeIs('tenant.package_bookings.booking_details_and_edit')) active
                                @elseif (request()->routeIs('tenant.package_management.report')) active
                                @elseif (request()->routeIs('tenant.package_bookings.booking_details')) active
                                @elseif (request()->routeIs('tenant.package_bookings.booking_form')) active @endif">
                            <a data-toggle="collapse" href="#packageBookings">
                                <i class="fas fa-bookmark"></i>
                                <p class="pr-2">{{ __('Tour Package Bookings') }}</p>
                                <span class="caret"></span>
                            </a>
                            <div id="packageBookings"
                                class="collapse
                                    @if (request()->routeIs('tenant.package_bookings.all_bookings')) show
                                    @elseif (request()->routeIs('tenant.package_bookings.paid_bookings')) show
                                    @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings')) show
                                    @elseif (request()->routeIs('tenant.package_bookings.booking_details_and_edit')) show
                                    @elseif (request()->routeIs('tenant.package_management.report')) show
                                    @elseif (request()->routeIs('tenant.package_bookings.booking_details')) show
                                    @elseif (request()->routeIs('tenant.package_bookings.booking_form')) show @endif">
                                <ul class="nav nav-collapse">
                                    <li
                                        class="{{ request()->routeIs('tenant.package_bookings.all_bookings') ? 'active' : '' }}">
                                        <a href="{{ route('tenant.package_bookings.all_bookings') }}">
                                            <span class="sub-item">{{ __('All Bookings') }}</span>
                                        </a>
                                    </li>
                                    <li
                                        class="{{ request()->routeIs('tenant.package_bookings.paid_bookings') ? 'active' : '' }}">
                                        <a href="{{ route('tenant.package_bookings.paid_bookings') }}">
                                            <span class="sub-item">{{ __('Paid Bookings') }}</span>
                                        </a>
                                    </li>
                                    <li
                                        class="{{ request()->routeIs('tenant.package_bookings.unpaid_bookings') ? 'active' : '' }}">
                                        <a href="{{ route('tenant.package_bookings.unpaid_bookings') }}">
                                            <span class="sub-item">{{ __('Unpaid Bookings') }}</span>
                                        </a>
                                    </li>
                                    <li class="@if (request()->routeIs('tenant.package_management.report')) active @endif">
                                        <a href="{{ route('tenant.package_management.report') }}">
                                            <span class="sub-item">{{ __('Report') }}</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif
                @endif
                {{-- End Package Bookings --}}

                @if (!is_null($package))
                    <li
                        class="nav-item
                            @if (request()->routeIs('user.registered_users')) active
                            @elseif(request()->routeIs('user.user_details')) active
                            @elseif(request()->routeIs('user.user.change_password')) active 
                            @elseif (request()->routeIs('user.subscriber.index'))  active
                            @elseif(request()->routeIs('user.mailsubscriber')) active @endif">
                        <a data-toggle="collapse" href="#Users_Management">
                            <i class="far fa-envelope-open-text"></i>
                            <p>{{ __('Users Management') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse 
                                @if (request()->routeIs('user.registered_users')) show
                                @elseif(request()->routeIs('user.user_details')) show
                                @elseif(request()->routeIs('user.user.change_password')) show 
                                @elseif (request()->routeIs('user.subscriber.index'))  show
                                @elseif(request()->routeIs('user.mailsubscriber')) show @endif"
                            id="Users_Management">
                            <ul class="nav nav-collapse">
                                <li
                                    class="submenu
                                        @if (request()->routeIs('user.registered_users')) active
                                        @elseif(request()->routeIs('user.user_details')) active
                                        @elseif(request()->routeIs('user.user.change_password')) active @endif">
                                    <a href="{{ route('user.registered_users') }}">
                                        <span class="sub-item">{{ __('Registered Users') }}</span>
                                    </a>
                                </li>
                                <li
                                    class="submenu
                                    @if (request()->routeIs('user.subscriber.index')) selected
                                    @elseif(request()->routeIs('user.mailsubscriber')) selected @endif">
                                    <a data-toggle="collapse" href="#subscribers">
                                        <span class="sub-item">{{ __('Subscribers') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div class="collapse
                                    @if (request()->routeIs('user.subscriber.index')) show
                                    @elseif(request()->routeIs('user.mailsubscriber')) show @endif"
                                        id="subscribers">
                                        <ul class="nav nav-collapse subnav">
                                            <li class="@if (request()->routeIs('user.subscriber.index')) active @endif">
                                                <a href="{{ route('user.subscriber.index') }}">
                                                    <span class="sub-item">{{ __('Subscribers') }}</span>
                                                </a>
                                            </li>
                                            <li class="@if (request()->routeIs('user.mailsubscriber')) active @endif">
                                                <a href="{{ route('user.mailsubscriber') }}">
                                                    <span class="sub-item">{{ __('Mail to Subscribers') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </li>
                @endif
                {{-- advertise --}}
                @if (!is_null($package))
                    @if (!empty($permissions) && in_array('Advertisement', $permissions))
                        <li
                            class="nav-item
                        @if (request()->routeIs('user.advertise.settings')) active
                        @elseif (request()->routeIs('user.advertisements')) active @endif">
                            <a data-toggle="collapse" href="#ad">
                                <i class="fab fa-buysellads"></i>
                                <p>{{ __('Advertise') }}</p>
                                <span class="caret"></span>
                            </a>
                            <div id="ad"
                                class="collapse
                            @if (request()->routeIs('user.advertise.settings')) show
                            @elseif (request()->routeIs('user.advertisements')) show @endif">
                                <ul class="nav nav-collapse">
                                    <li class="{{ request()->routeIs('user.advertise.settings') ? 'active' : '' }}">
                                        <a href="{{ route('user.advertise.settings') }}">
                                            <span class="sub-item">{{ __('Settings') }}</span>
                                        </a>
                                    </li>
                                    <li class="{{ request()->routeIs('user.advertisements') ? 'active' : '' }}">
                                        <a href="{{ route('user.advertisements') }}">
                                            <span class="sub-item">{{ __('Advertisements') }}</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif
                @endif



                {{-- pages --}}
                @if (!is_null($package))
                    <li
                        class="nav-item
   @if (request()->routeIs('user.basic_settings.seo')) active
   @elseif(request()->routeIs('user.page_headings')) active
    @elseif(request()->routeIs('user.breadcrumb')) active
    @elseif(request()->routeIs('user.faq_management')) active
    @elseif (request()->routeIs('user.blog_management.categories')) active
    @elseif (request()->routeIs('user.blog_management.category.edit')) active
    @elseif (request()->routeIs('user.blog_management.blogs')) active
    @elseif (request()->routeIs('user.blog_management.create_blog')) active
    @elseif (request()->routeIs('user.blog_management.edit_blog')) active
    @elseif (request()->routeIs('user.footer.content')) active
    @elseif (request()->routeIs('user.footer.quick_links')) active
    @elseif (request()->routeIs('user.custom_pages.create_page')) active
    @elseif(request()->routeIs('user.custom_pages')) active
    @elseif(request()->routeIs('user.custom_pages.edit_page')) active
    @elseif (request()->routeIs('tenant.home_page.hero.slider_version')) active
    @elseif (request()->routeIs('tenant.home_page.hero.create_slider')) active
    @elseif (request()->routeIs('tenant.home_page.hero.edit_slider')) active
    @elseif (request()->routeIs('tenant.home_page.hero.video_version')) active
    @elseif (request()->routeIs('tenant.home_page.intro_section')) active
    @elseif (request()->routeIs('tenant.home_page.intro_section.create_count_info')) active
    @elseif (request()->routeIs('tenant.home_page.intro_section.edit_count_info')) active
    @elseif (request()->routeIs('tenant.home_page.room_section')) active
    @elseif (request()->routeIs('tenant.home_page.service_section')) active
    @elseif (request()->routeIs('tenant.home_page.booking_section')) active
    @elseif (request()->routeIs('tenant.home_page.package_section')) active
    @elseif (request()->routeIs('tenant.home_page.facility_section')) active
    @elseif (request()->routeIs('tenant.home_page.facility_section.create_facility')) active
    @elseif (request()->routeIs('tenant.home_page.facility_section.edit_facility')) active
    @elseif (request()->routeIs('tenant.home_page.testimonial_section')) active
    @elseif (request()->routeIs('tenant.home_page.testimonial_section.create_testimonial')) active
    @elseif (request()->routeIs('tenant.home_page.testimonial_section.edit_testimonial')) active
    @elseif (request()->routeIs('tenant.home_page.brand_section')) active
    @elseif (request()->routeIs('tenant.home_page.faq_section')) active
    @elseif (request()->routeIs('tenant.home_page.blog_section')) active
    @elseif (request()->routeIs('tenant.sections.index')) active
    @elseif(request()->routeIs('user.additional_sections')) active
    @elseif(request()->routeIs('user.additional_section.edit')) active
    @elseif(request()->routeIs('user.additional_section.create')) active
    @elseif (request()->routeIs('user.about.additional_section.create')) active
    @elseif(request()->routeIs('user.about.additional_sections')) active
    @elseif(request()->routeIs('user.about.sections.index')) active
    @elseif(request()->routeIs('user.about.additional_section.edit')) active
    @elseif(request()->routeIs('user.menu_builder.index')) active
    @elseif (request()->routeIs('user.basic_settings.information')) active
    @elseif(request()->routeIs('tenant.gallery_management.categories')) active
    @elseif(request()->routeIs('tenant.gallery_management.images')) active
    @elseif (request()->routeIs('tenant.services_management')) active
    @elseif (request()->routeIs('tenant.services_management.create_service')) active
    @elseif (request()->routeIs('tenant.services_management.edit_service')) active 
    @elseif (request()->routeIs('tenant.pages.home_page.images_texts')) active 
    @elseif (request()->routeIs('user.about.images_texts')) active 
    @elseif (request()->routeIs('user.basic_settings.error_404')) active 
    @elseif (request()->routeIs('user.basic_settings.signup_page')) active 
    @elseif (request()->routeIs('user.basic_settings.login_page')) active 
    @endif">
                        <a data-toggle="collapse" href="#pages">
                            <i class="la flaticon-file"></i>
                            <p>{{ __('Pages') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse
    @if (request()->routeIs('user.basic_settings.seo')) show
    @elseif(request()->routeIs('user.page_headings')) show
    @elseif(request()->routeIs('user.breadcrumb')) show
    @elseif(request()->routeIs('user.faq_management')) show
    @elseif (request()->routeIs('user.blog_management.categories')) show
     @elseif (request()->routeIs('user.blog_management.category.edit')) show
    @elseif (request()->routeIs('user.blog_management.blogs')) show
    @elseif (request()->routeIs('user.blog_management.create_blog')) show
    @elseif (request()->routeIs('user.blog_management.edit_blog')) show
    @elseif (request()->routeIs('user.footer.content')) show
    @elseif (request()->routeIs('user.footer.quick_links')) show
    @elseif (request()->routeIs('user.custom_pages.create_page')) show
    @elseif(request()->routeIs('user.custom_pages')) show
    @elseif(request()->routeIs('user.custom_pages.edit_page')) show
    @elseif (request()->routeIs('tenant.home_page.hero.slider_version')) show
    @elseif (request()->routeIs('tenant.home_page.hero.create_slider')) show
    @elseif (request()->routeIs('tenant.home_page.hero.edit_slider')) show
    @elseif (request()->routeIs('tenant.home_page.hero.video_version')) show
    @elseif (request()->routeIs('tenant.home_page.intro_section')) show
    @elseif (request()->routeIs('tenant.home_page.intro_section.create_count_info')) show
    @elseif (request()->routeIs('tenant.home_page.intro_section.edit_count_info')) show
    @elseif (request()->routeIs('tenant.home_page.room_section')) show
    @elseif (request()->routeIs('tenant.home_page.service_section')) show
    @elseif (request()->routeIs('tenant.home_page.booking_section')) show
    @elseif (request()->routeIs('tenant.home_page.package_section')) show
    @elseif (request()->routeIs('tenant.home_page.facility_section')) show
    @elseif (request()->routeIs('tenant.home_page.facility_section.create_facility')) show
    @elseif (request()->routeIs('tenant.home_page.facility_section.edit_facility')) show
    @elseif (request()->routeIs('tenant.home_page.testimonial_section')) show
    @elseif (request()->routeIs('tenant.home_page.testimonial_section.create_testimonial')) show
    @elseif (request()->routeIs('tenant.home_page.testimonial_section.edit_testimonial')) show
    @elseif (request()->routeIs('tenant.home_page.brand_section')) show
    @elseif (request()->routeIs('tenant.home_page.faq_section')) show
    @elseif (request()->routeIs('tenant.home_page.blog_section')) show
    @elseif (request()->routeIs('tenant.sections.index')) show
    @elseif(request()->routeIs('user.additional_sections')) show
    @elseif(request()->routeIs('user.additional_section.edit')) show
    @elseif(request()->routeIs('user.additional_section.create')) show
    @elseif (request()->routeIs('user.about.additional_section.create')) show
    @elseif(request()->routeIs('user.about.additional_sections')) show
    @elseif(request()->routeIs('user.about.sections.index')) show
    @elseif(request()->routeIs('user.about.additional_section.edit')) show
    @elseif (request()->routeIs('user.basic_settings.information')) show
    @elseif(request()->routeIs('user.menu_builder.index')) show
    @elseif(request()->routeIs('tenant.gallery_management.categories')) show
    @elseif(request()->routeIs('tenant.gallery_management.images')) show
    @elseif (request()->routeIs('tenant.services_management')) show
    @elseif (request()->routeIs('tenant.services_management.create_service')) show
    @elseif (request()->routeIs('tenant.services_management.edit_service')) show 
    @elseif (request()->routeIs('tenant.pages.home_page.images_texts')) show 
    @elseif (request()->routeIs('user.about.images_texts')) show
    @elseif (request()->routeIs('user.basic_settings.error_404')) show
    @elseif (request()->routeIs('user.basic_settings.signup_page')) show 
    @elseif (request()->routeIs('user.basic_settings.login_page')) show 
    @endif"
                            id="pages">
                            <ul class="nav nav-collapse">

                                {{-- ======== Home pages ======== --}}
                                <li
                                    class="submenu
                    @if (request()->routeIs('tenant.home_page.hero.slider_version')) selected
                    @elseif (request()->routeIs('tenant.home_page.hero.create_slider')) selected
                    @elseif (request()->routeIs('tenant.home_page.hero.edit_slider')) selected
                    @elseif (request()->routeIs('tenant.home_page.hero.video_version')) selected
                    @elseif (request()->routeIs('tenant.home_page.room_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.service_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.booking_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.package_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.brand_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.faq_section')) selected
                    @elseif (request()->routeIs('tenant.home_page.blog_section')) selected
                    @elseif (request()->routeIs('tenant.sections.index')) selected
                    @elseif(request()->routeIs('user.additional_sections')) selected
                    @elseif(request()->routeIs('user.additional_section.edit')) selected
                    @elseif(request()->routeIs('user.additional_section.create')) selected 
                    @elseif (request()->routeIs('tenant.pages.home_page.images_texts')) selected
                    @endif">
                                    <a data-toggle="collapse" href="#home_page">
                                        <span class="sub-item">{{ __('Home Page') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="home_page"
                                        class="collapse
                    @if (request()->routeIs('tenant.home_page.hero.slider_version')) show
                    @elseif (request()->routeIs('tenant.home_page.hero.create_slider')) show
                    @elseif (request()->routeIs('tenant.home_page.hero.edit_slider')) show
                    @elseif (request()->routeIs('tenant.home_page.room_section')) show
                    @elseif (request()->routeIs('tenant.home_page.service_section')) show
                    @elseif (request()->routeIs('tenant.home_page.booking_section')) show
                    @elseif (request()->routeIs('tenant.home_page.package_section')) show
                    @elseif (request()->routeIs('tenant.home_page.brand_section')) show
                    @elseif (request()->routeIs('tenant.home_page.faq_section')) show
                    @elseif (request()->routeIs('tenant.home_page.blog_section')) show
                    @elseif (request()->routeIs('tenant.sections.index')) show
                    @elseif(request()->routeIs('user.additional_sections')) show
                    @elseif(request()->routeIs('user.additional_section.edit')) show
                    @elseif(request()->routeIs('user.additional_section.create')) show 
                    @elseif (request()->routeIs('tenant.pages.home_page.images_texts')) show 
                    @endif">
                                        <ul class="nav nav-collapse subnav">

                                            <li class="@if (request()->routeIs('tenant.pages.home_page.images_texts')) active @endif">
                                                <a
                                                    href="{{ route('tenant.pages.home_page.images_texts') . '?language=' . $defaultLang->code }}">
                                                    <span class="sub-item">{{ __('Images & Texts') }}</span>
                                                </a>
                                            </li>

                                            @if (in_array($userBs->theme_version,['theme_three','theme_four','theme_five']) || $userBs->home_version == 'slider')
                                                <li
                                                    class="@if (request()->routeIs('tenant.home_page.hero.slider_version')) active
                                                    @elseif(request()->routeIs('tenant.home_page.hero.create_slider')) active
                                                    @elseif(request()->routeIs('tenant.home_page.hero.edit_slider')) active @endif">
                                                    <a
                                                        href="{{ route('tenant.home_page.hero.slider_version') . '?language=' . $defaultLang->code }}">
                                                        <span class="sub-item">{{ __('Sliders') }}</span>
                                                    </a>
                                                </li>
                                            @endif

                                             @if (in_array($userBs->theme_version,['theme_one','theme_two','theme_five']))
                                            <li
                                                class="{{ request()->routeIs('tenant.home_page.brand_section') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('tenant.home_page.brand_section') . '?language=' . $defaultLang->code }}">
                                                    <span class="sub-item">{{ __('Brand Partners') }}</span>
                                                </a>
                                            </li>
                                            @endif


                                            {{-- ======Additional Section===== --}}
                                            <li
                                                class="submenu
                  @if (request()->routeIs('user.additional_sections')) selected
                  @elseif(request()->routeIs('user.additional_section.edit')) selected
                  @elseif(request()->routeIs('user.additional_section.create')) selected @endif">
                                                <a data-toggle="collapse" href="#home_additional_page">
                                                    <span class="sub-item">{{ __('Additional Section') }}</span>
                                                    <span class="caret"></span>
                                                </a>
                                                <div id="home_additional_page"
                                                    class="pl-2 collapse
                     @if (request()->routeIs('user.additional_sections')) show
                    @elseif(request()->routeIs('user.additional_section.edit')) show
                    @elseif(request()->routeIs('user.additional_section.create')) show @endif ">
                                                    <ul class="nav nav-collapse subnav">

                                                        <li class="@if (request()->routeIs('user.additional_section.create')) active @endif">
                                                            <a href="{{ route('user.additional_section.create') }}">
                                                                <span class="sub-item">{{ __('Add Section') }}</span>
                                                            </a>
                                                        </li>

                                                        <li
                                                            class="@if (request()->routeIs('user.additional_sections')) active
                                      @elseif(request()->routeIs('user.additional_section.edit')) active @endif">
                                                            <a
                                                                href="{{ route('user.additional_sections', ['language' => $defaultLang->code]) }}">
                                                                <span class="sub-item">{{ __('Sections') }}</span>
                                                            </a>
                                                        </li>

                                                    </ul>
                                                </div>
                                            </li>
                                            <li
                                                class="{{ request()->routeIs('tenant.sections.index') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('tenant.sections.index') }}">
                                                    <span class="sub-item">{{ __('Sections Hide / Show') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                {{-- ====== About us pages ======= --}}
                                <li
                                    class="submenu @if (request()->routeIs('user.about.additional_section.create')) selected
                            @elseif(request()->routeIs('user.about.additional_sections')) selected
                            @elseif(request()->routeIs('user.about.sections.index')) selected
                            @elseif(request()->routeIs('user.about.additional_section.edit')) selected 
                            @elseif(request()->routeIs('user.about.images_texts')) selected @endif">
                                    <a data-toggle="collapse" href="#about_us">
                                        <span class="sub-item">{{ __('About Us') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="about_us"
                                        class="collapse @if (request()->routeIs('user.about.additional_section.create')) show
                               @elseif(request()->routeIs('user.about.additional_sections')) show
                               @elseif(request()->routeIs('user.about.sections.index')) show
                               @elseif(request()->routeIs('user.about.additional_section.edit')) show 
                               @elseif(request()->routeIs('user.about.images_texts')) show @endif">
                                        <ul class="nav nav-collapse subnav">

                                            {{-- Image and Text --}}

                                            <li class="@if (request()->routeIs('user.about.images_texts')) active @endif">
                                                <a
                                                    href="{{ route('user.about.images_texts') . '?language=' . $defaultLang->code }}">
                                                    <span class="sub-item">{{ __('Images & Texts') }}</span>
                                                </a>
                                            </li>
                                            {{-- Image and Text --}}

                                            {{-- ======Additional Section===== --}}
                                            <li
                                                class="submenu @if (request()->routeIs('user.about.additional_sections')) selected
                                     @elseif(request()->routeIs('user.about.additional_section.edit')) selected
                                     @elseif(request()->routeIs('user.about.additional_section.create')) selected @endif">
                                                <a data-toggle="collapse" href="#about_us_additional_page">
                                                    <span class="sub-item">{{ __('Additional Section') }}</span>
                                                    <span class="caret"></span>
                                                </a>
                                                <div id="about_us_additional_page"
                                                    class="collapse
                            @if (request()->routeIs('user.about.additional_sections')) show
                            @elseif(request()->routeIs('user.about.additional_section.edit')) show
                            @elseif(request()->routeIs('user.about.additional_section.create')) show @endif">

                                                    <ul class="nav nav-collapse subnav pl-2">
                                                        <li class="@if (request()->routeIs('user.about.additional_section.create')) active @endif">
                                                            <a
                                                                href="{{ route('user.about.additional_section.create') }}">
                                                                <span class="sub-item">{{ __('Add Section') }}</span>
                                                            </a>
                                                        </li>
                                                        <li
                                                            class="@if (request()->routeIs('user.about.additional_sections')) active
                                      @elseif(request()->routeIs('user.about.additional_section.edit')) active @endif">
                                                            <a
                                                                href="{{ route('user.about.additional_sections', ['language' => $default->code]) }}">
                                                                <span class="sub-item">{{ __('Sections') }}</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </li>

                                            <li class="@if (request()->routeIs('user.about.sections.index')) active @endif">
                                                <a href="{{ route('user.about.sections.index') }}">
                                                    <span class="sub-item">{{ __('Section Hide/ Show') }}</span>
                                                </a>
                                            </li>

                                        </ul>
                                    </div>
                                </li>

                                <li
                                    class="@if (request()->routeIs('tenant.home_page.intro_section')) active
                    @elseif (request()->routeIs('tenant.home_page.intro_section.create_count_info')) active
                    @elseif (request()->routeIs('tenant.home_page.intro_section.edit_count_info')) active @endif">
                                    <a
                                        href="{{ route('tenant.home_page.intro_section') . '?language=' . $defaultLang->code }}">
                                        <span class="sub-item">{{ __('Statistics') }}</span>
                                    </a>
                                </li>
                                <li
                                    class="@if (request()->routeIs('tenant.home_page.testimonial_section')) active
                  @elseif (request()->routeIs('tenant.home_page.testimonial_section.create_testimonial')) active
                  @elseif (request()->routeIs('tenant.home_page.testimonial_section.edit_testimonial')) active @endif">
                                    <a
                                        href="{{ route('tenant.home_page.testimonial_section') . '?language=' . $defaultLang->code }}">
                                        <span class="sub-item">{{ __('Testimonials') }}</span>
                                    </a>
                                </li>
                                <li
                                    class="@if (request()->routeIs('tenant.home_page.facility_section')) active
                  @elseif (request()->routeIs('tenant.home_page.facility_section.create_facility')) active
                  @elseif (request()->routeIs('tenant.home_page.facility_section.edit_facility')) active @endif ">
                                    <a
                                        href="{{ route('tenant.home_page.facility_section') . '?language=' . $defaultLang->code }}">
                                        <span class="sub-item">{{ __('Facilities') }}</span>
                                    </a>
                                </li>
                                {{-- =========== Login page ============= --}}
                                <li class="@if (request()->routeIs('user.basic_settings.login_page')) active  @endif">
                                    <a href="{{ route('user.basic_settings.login_page',['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('Login Page') }}</span>
                                    </a>
                                </li>

                                <li class="@if (request()->routeIs('user.basic_settings.signup_page')) active  @endif">
                                    <a href="{{ route('user.basic_settings.signup_page',['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('Signup Page') }}</span>
                                    </a>
                                </li>

                                {{-- ====== Contact Page ======= --}}
                                <li class="@if (request()->routeIs('user.basic_settings.information')) active @endif">
                                    <a href="{{ route('user.basic_settings.information') }}">
                                        <span class="sub-item">{{ __('Contact Page') }}</span>
                                    </a>
                                </li>

                                 {{-- ====== 404 Page ======= --}}
                                <li class="@if (request()->routeIs('user.basic_settings.error_404')) active @endif">
                                    <a href="{{ route('user.basic_settings.error_404',['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('404 Page') }}</span>
                                    </a>
                                </li>

                                {{-- ======== Custom pages /addtional pages ======== --}}
                                @if (!empty($permissions) && in_array('Custom Page', $permissions))
                                    <li
                                        class="submenu
            @if (request()->routeIs('user.custom_pages.create_page')) selected
            @elseif(request()->routeIs('user.custom_pages')) selected
            @elseif(request()->routeIs('user.custom_pages.edit_page')) selected @endif">
                                        <a data-toggle="collapse" href="#additional_pages">
                                            <span class="sub-item">{{ __('Additional Pages') }}</span>
                                            <span class="caret"></span>
                                        </a>
                                        <div id="additional_pages"
                                            class="collapse
            @if (request()->routeIs('user.custom_pages.create_page')) show
            @elseif(request()->routeIs('user.custom_pages')) show
            @elseif(request()->routeIs('user.custom_pages.edit_page')) show @endif">

                                            <ul class="nav nav-collapse subnav">
                                                <li class=" @if (request()->routeIs('user.custom_pages.create_page')) active @endif">
                                                    <a href="{{ route('user.custom_pages.create_page') }}">
                                                        <span class="sub-item">{{ __('Add Page') }}</span>
                                                    </a>
                                                </li>
                                                <li
                                                    class="@if (request()->routeIs('user.custom_pages')) active
                    @elseif (request()->routeIs('user.custom_pages.edit_page')) active @endif">
                                                    <a
                                                        href="{{ route('user.custom_pages', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('All Page') }}</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endif

                                {{-- ========== Breadcrumbs =========== --}}

                                <li
                                    class="submenu
            @if (request()->routeIs('user.breadcrumb')) selected
            @elseif(request()->routeIs('user.page_headings')) selected @endif">
                                    <a data-toggle="collapse" href="#Breadcrumbs">
                                        <span class="sub-item">{{ __('Breadcrumbs') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="Breadcrumbs"
                                        class="collapse 
                    @if (request()->routeIs('user.breadcrumb')) show
                    @elseif(request()->routeIs('user.page_headings')) show @endif">
                                        <ul class="nav nav-collapse subnav">
                                            <li class="@if (request()->routeIs('user.breadcrumb')) active @endif">
                                                <a href="{{ route('user.breadcrumb') }}">
                                                    <span class="sub-item">{{ __('Image') }}</span>
                                                </a>
                                            </li>
                                            <li class="@if (request()->routeIs('user.page_headings')) active @endif }}">
                                                <a
                                                    href="{{ route('user.page_headings', ['language' => $default->code]) }}">
                                                    <span class="sub-item">{{ __('Headings') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>



                                {{-- ======== Blogs ======== --}}

                                @if (!empty($permissions) && in_array('Blog', $permissions))
                                    <li
                                        class="submenu @if (request()->routeIs('user.blog_management.categories')) selected
               @elseif (request()->routeIs('user.blog_management.category.edit')) selected
                @elseif (request()->routeIs('user.blog_management.blogs')) selected
                @elseif (request()->routeIs('user.blog_management.create_blog')) selected
                @elseif (request()->routeIs('user.blog_management.edit_blog')) selected @endif">
                                        <a data-toggle="collapse" href="#blog">
                                            <span class="sub-item">{{ __('Blog') }}</span>
                                            <span class="caret"></span>
                                        </a>
                                        <div id="blog"
                                            class="collapse
                    @if (request()->routeIs('user.blog_management.categories')) show
                    @elseif (request()->routeIs('user.blog_management.category.edit')) show
                    @elseif (request()->routeIs('user.blog_management.blogs')) show
                    @elseif (request()->routeIs('user.blog_management.create_blog')) show
                    @elseif (request()->routeIs('user.blog_management.edit_blog')) show @endif">

                                            <ul class="nav nav-collapse subnav">
                                                <li
                                                    class="@if (request()->routeIs('user.blog_management.categories')) active
                            @elseif (request()->routeIs('user.blog_management.category.edit')) active @endif">
                                                    <a
                                                        href="{{ route('user.blog_management.categories', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Categories') }}</span>
                                                    </a>
                                                </li>
                                                <li
                                                    class="@if (request()->routeIs('user.blog_management.blogs')) active
                            @elseif (request()->routeIs('user.blog_management.create_blog')) active
                            @elseif (request()->routeIs('user.blog_management.edit_blog')) active @endif">
                                                    <a
                                                        href="{{ route('user.blog_management.blogs', ['language' => $default->code]) }}">
                                                        <span class="sub-item">{{ __('Posts') }}</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                @endif

                                {{-- Faq management --}}
                                
                                @if (in_array($userBs->theme_version,['theme_two',]))
                                <li class="{{ request()->routeIs('user.faq_management') ? 'active' : '' }}">
                                    <a href="{{ route('user.faq_management', ['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('FAQ') }}</span>
                                    </a>
                                </li>
                                @endif


                                {{-- Services --}}
                                <li
                                    class="@if (request()->routeIs('tenant.services_management')) active
                    @elseif (request()->routeIs('tenant.services_management.create_service')) active
                    @elseif (request()->routeIs('tenant.services_management.edit_service')) active @endif">
                                    <a
                                        href="{{ route('tenant.services_management', ['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('Services') }}</span>
                                    </a>
                                </li>

                                {{-- Start Gallery Management --}}
                                <li
                                    class="submenu
                @if (request()->routeIs('tenant.gallery_management.categories')) selected
                @elseif (request()->routeIs('tenant.gallery_management.images')) selected @endif">
                                    <a data-toggle="collapse" href="#gallery">
                                        <span class="sub-item">{{ __('Gallery') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="gallery"
                                        class="collapse
                    @if (request()->routeIs('tenant.gallery_management.categories')) show
                    @elseif (request()->routeIs('tenant.gallery_management.images')) show @endif">
                                        <ul class="nav nav-collapse subnav">
                                            <li
                                                class="{{ request()->routeIs('tenant.gallery_management.categories') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('tenant.gallery_management.categories') . '?language=' . $defaultLang->code }}">
                                                    <span class="sub-item">{{ __('Categories') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="{{ request()->routeIs('tenant.gallery_management.images') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('tenant.gallery_management.images') . '?language=' . $defaultLang->code }}">
                                                    <span class="sub-item">{{ __('Images') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                {{-- End Gallery Management --}}

                                {{-- Menu Builder --}}
                                <li class="@if (request()->routeIs('user.menu_builder.index')) active @endif">
                                    <a href="{{ route('user.menu_builder.index') . '?language=' . $default->code }}">
                                        <span class="sub-item">{{ __('Menu Builder') }}</span>
                                    </a>
                                </li>

                                {{-- ======== Footer ======== --}}
                                <li
                                    class="submenu
                @if (request()->routeIs('user.footer.content')) selected
                @elseif (request()->routeIs('user.footer.quick_links')) selected @endif">
                                    <a data-toggle="collapse" href="#footer">
                                        <span class="sub-item">{{ __('Footer') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="footer"
                                        class="collapse
                    @if (request()->routeIs('user.footer.content')) show
                    @elseif (request()->routeIs('user.footer.quick_links')) show @endif">
                                        <ul class="nav nav-collapse subnav">
                                            <li
                                                class="{{ request()->routeIs('user.footer.content') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('user.footer.content') . '?language=' . $default->code }}">
                                                    <span class="sub-item">{{ __('Footer Content') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="{{ request()->routeIs('user.footer.quick_links') ? 'active' : '' }}">
                                                <a
                                                    href="{{ route('user.footer.quick_links') . '?language=' . $default->code }}">
                                                    <span class="sub-item">{{ __('Quick Links') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                {{-- ======== SEO Informations ======== --}}
                                <li class="@if (request()->routeIs('user.basic_settings.seo')) active @endif">
                                    <a href="{{ route('user.basic_settings.seo', ['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('SEO Informations') }}</span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li>


                @endif

                {{-- Start User Ticket   --}}
                @if (!is_null($package))
                    @if (!empty($permissions) && in_array('Support Ticket', $permissions))
                        <li
                            class="nav-item 
                            @if (request()->routeIs('tenant.tickets')) active
                            @elseif (request()->routeIs('tenant.ticket.create')) active
                            @elseif (request()->routeIs('tenant.ticket.messages')) active @endif">
                            <a data-toggle="collapse" href="#ticket">
                               <i class="fas fa-ticket-alt"></i>
                                <p class="pr-2"> {{ __('Support Tickets') }}</p>
                                <span class="caret"></span>
                            </a>
                            <div id="ticket"
                                class="collapse
                                @if (request()->routeIs('tenant.tickets')) show
                                @elseif (request()->routeIs('tenant.ticket.create')) show
                                @elseif (request()->routeIs('tenant.ticket.messages')) show @endif">
                                <ul class="nav nav-collapse">
                                    <li
                                        class=" @if (request()->routeIs('tenant.tickets')) active
                                                @elseif(request()->routeIs('tenant.ticket.create')) active
                                                @elseif(request()->routeIs('tenant.ticket.messages')) active @endif">
                                        <a href="{{ route('tenant.tickets') }}">
                                            <span class="sub-item">{{ __('My Tickets') }}</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    @endif
                @endif

                {{-- announcement popup --}}
                @if (!is_null($package))
                    <li
                        class="nav-item @if (request()->routeIs('user.announcement_popups')) active
                            @elseif (request()->routeIs('user.announcement_popups.select_popup_type')) active
                            @elseif (request()->routeIs('user.announcement_popups.create_popup')) active
                            @elseif (request()->routeIs('user.announcement_popups.edit_popup')) active @endif">
                        <a href="{{ route('user.announcement_popups', ['language' => $default->code]) }}">
                            <i class="fas fa-bullhorn"></i>
                            <p>{{ __('Announcement Popups') }}</p>
                        </a>
                    </li>
                @endif



                @if (!is_null($package))
                    <li
                        class="nav-item
                @if (request()->routeIs('user.site_settings.general_settings')) active
                @elseif(request()->routeIs('user.dasboard_language')) active
                @elseif(request()->path() == 'user/settings/social') active
                @elseif(request()->is('user/settings/social/*')) active
                @elseif(request()->is('user/settings/plugins')) active
                @elseif(request()->is('user/settings/maintenance-mode')) active
                @elseif(request()->is('user/settings/cookie-alert')) active
                @elseif (request()->routeIs('user.mail_templates')) active
                @elseif (request()->routeIs('user.edit_mail_template')) active
                @elseif (request()->routeIs('user.mail.info')) active 
                @elseif (request()->routeIs('user.gateway.index')) active
                @elseif(request()->routeIs('user.gateway.offline')) active
                @elseif (request()->routeIs('user-domains')) active
                @elseif(request()->routeIs('user-subdomain')) active
                @elseif (request()->path() == 'user/settings/language/all') active
                @elseif(request()->is('user/settings/language/*/edit')) active
                @elseif(request()->is('user/settings/language/*/edit/keyword')) active
                @elseif (request()->routeIs('user-profile')) active 
                @elseif (request()->routeIs('user.changePass')) active @endif">
                        <a data-toggle="collapse" href="#basic">
                            <i class="far fa-cog"></i>
                            <p>{{ __('Settings') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse
                    @if (request()->routeIs('user.site_settings.general_settings')) show
                    @elseif(request()->routeIs('user.dasboard_language')) show
                    @elseif(request()->path() == 'user/settings/social') show
                    @elseif(request()->is('user/settings/social/*')) show
                    @elseif(request()->is('user/settings/plugins')) show
                    @elseif(request()->is('user/settings/maintenance-mode')) show
                    @elseif(request()->is('user/settings/cookie-alert')) show
                    @elseif (request()->routeIs('user.mail_templates')) show
                    @elseif (request()->routeIs('user.edit_mail_template')) show
                    @elseif (request()->routeIs('user.mail.info')) show
                    @elseif (request()->routeIs('user.gateway.index')) show
                    @elseif(request()->routeIs('user.gateway.offline')) show 
                    @elseif (request()->routeIs('user-domains')) show
                    @elseif(request()->routeIs('user-subdomain')) show 
                    @elseif (request()->path() == 'user/settings/language/all') show
                    @elseif(request()->is('user/settings/language/*/edit')) show
                    @elseif(request()->is('user/settings/language/*/edit/keyword')) show
                    @elseif (request()->routeIs('user-profile')) show 
                    @elseif (request()->routeIs('user.changePass')) show @endif"
                            id="basic">
                            <ul class="nav nav-collapse">

                                <li class="@if (request()->routeIs('user.site_settings.general_settings')) active @endif">
                                    <a href="{{ route('user.site_settings.general_settings') }}">
                                        <span class="sub-item">{{ __('General Settings') }}</span>
                                    </a>
                                </li>

                                {{-- =====  Domains url   ==== --}}
                                <li
                                    class="submenu
                                    @if (request()->routeIs('user-domains')) selected
                                    @elseif(request()->routeIs('user-subdomain')) selected @endif">
                                    <a data-toggle="collapse" href="#domains">
                                        <span class="sub-item">{{ __('Domains & URLs') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div class="collapse
                                    @if (request()->routeIs('user-domains')) show
                                    @elseif(request()->routeIs('user-subdomain')) show @endif"
                                        id="domains">
                                        <ul class="nav nav-collapse subnav">
                                            @if (!empty($permissions) && in_array('Custom Domain', $permissions))
                                                <li class=" @if (request()->routeIs('user-domains')) active @endif">
                                                    <a href="{{ route('user-domains') }}">
                                                        <span class="sub-item">{{ __('Custom Domain') }}</span>
                                                    </a>
                                                </li>
                                            @endif

                                            @if (!empty($permissions) && in_array('Subdomain', $permissions))
                                                <li
                                                    class="
                                              @if (request()->routeIs('user-subdomain')) active @endif">
                                                    <a href="{{ route('user-subdomain') }}">
                                                        <span
                                                            class="sub-item">{{ __('Subdomain & Path URL') }}</span>
                                                    </a>
                                                </li>
                                            @else
                                                <li
                                                    class="
                                                   @if (request()->routeIs('user-subdomain')) active @endif">
                                                    <a href="{{ route('user-subdomain') }}">
                                                        <span class="sub-item">{{ __('Path Based URL') }}</span>
                                                    </a>
                                                </li>
                                            @endif

                                        </ul>
                                    </div>
                                </li>

                                {{-- ======= Payment Gateways --}}
                                <li
                                    class="submenu
                                @if (request()->routeIs('user.gateway.index')) selected
                                @elseif(request()->routeIs('user.gateway.offline')) selected @endif">
                                    <a data-toggle="collapse" href="#gateways">

                                        <span class="sub-item">{{ __('Payment Gateways') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div class="collapse
                                    @if (request()->routeIs('user.gateway.index')) show
                                    @elseif(request()->routeIs('user.gateway.offline')) show @endif"
                                        id="gateways">
                                        <ul class="nav nav-collapse subnav">
                                            <li class="@if (request()->routeIs('user.gateway.index')) active @endif">
                                                <a href="{{ route('user.gateway.index') }}">
                                                    <span class="sub-item">{{ __('Online Gateways') }}</span>
                                                </a>
                                            </li>
                                            <li class="@if (request()->routeIs('user.gateway.offline')) active @endif">
                                                <a
                                                    href="{{ route('user.gateway.offline') . '?language=' . $default->code }}">
                                                    <span class="sub-item">{{ __('Offline Gateways') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                {{-- ======  Langauge ======== --}}

                                <li
                                    class="
                                    @if (request()->path() == 'user/settings/language/all') active
                                    @elseif(request()->is('user/settings/language/*/edit')) active
                                    @elseif(request()->is('user/settings/language/*/edit/keyword')) active @endif">
                                    <a href="{{ route('user.language.index') }}">
                                        <span class="sub-item">{{ __('Languages') }}</span>
                                    </a>
                                </li>

                                {{-- =====  Email Settings   ==== --}}
                                <li
                                    class="submenu
                                    @if (request()->routeIs('user.mail_templates')) selected
                                    @elseif (request()->routeIs('user.edit_mail_template')) selected
                                    @elseif (request()->routeIs('user.mail.info')) selected @endif">
                                    <a data-toggle="collapse" href="#mail_settings">
                                        <span class="sub-item">{{ __('Email Settings') }}</span>
                                        <span class="caret"></span>
                                    </a>
                                    <div id="mail_settings"
                                        class="collapse
                                @if (request()->routeIs('user.mail_templates')) show
                                @elseif (request()->routeIs('user.mail.info')) show
                                @elseif (request()->routeIs('user.edit_mail_template')) show @endif">
                                        <ul class="nav nav-collapse subnav">
                                            <li class="@if (request()->routeIs('user.mail.info')) active @endif">
                                                <a href="{{ route('user.mail.info') }}">
                                                    <span class="sub-item">{{ __('Mail Information') }}</span>
                                                </a>
                                            </li>
                                            <li
                                                class="@if (request()->routeIs('user.mail_templates')) active
                                        @elseif (request()->routeIs('user.edit_mail_template')) active @endif">
                                                <a href="{{ route('user.mail_templates') }}">
                                                    <span class="sub-item">{{ __('Mail Templates') }}</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>

                                <li class="{{ request()->routeIs('user.plugins') ? 'active' : '' }}">
                                    <a href="{{ route('user.plugins') }}">
                                        <span class="sub-item">{{ __('Plugins') }}</span>
                                    </a>
                                </li>

                                <li class="{{ request()->routeIs('user.maintenance_mode') ? 'active' : '' }}">
                                    <a href="{{ route('user.maintenance_mode') }}">
                                        <span class="sub-item">{{ __('Maintenance Mode') }}</span>
                                    </a>
                                </li>

                                <li class="{{ request()->routeIs('user.cookie_alert') ? 'active' : '' }}">
                                    <a href="{{ route('user.cookie_alert', ['language' => $default->code]) }}">
                                        <span class="sub-item">{{ __('Cookie Alert') }}</span>
                                    </a>
                                </li>

                                <li
                                    class="@if (request()->path() == 'user/settings/social') active
                                            @elseif(request()->is('user/settings/social/*')) active @endif">
                                    <a href="{{ route('user.social.index') }}">
                                        <span class="sub-item">{{ __('Social Medias') }}</span>
                                    </a>
                                </li>

                                <li class="@if (request()->routeIs('user.profile_edit')) active @endif">
                                    <a href="{{ route('user.profile_edit') }}">
                                        <span class="sub-item">{{ __('Edit Profile') }}</span>
                                    </a>
                                </li>

                                <li class="@if (request()->routeIs('user.changePass')) active @endif">
                                    <a href="{{ route('user.changePass') }}">
                                        <span class="sub-item">{{ __('Change Password') }}</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                @endif
                <li
                    class="nav-item
                @if (request()->path() == 'user/membership/payment-log') active
                @elseif(request()->path() == 'user/membership/package-list') active
                @elseif(request()->is('user/membership/package/checkout/*')) active
                @elseif(request()->path() == 'user/membership/package/checkout/*') active @endif">
                    <a data-toggle="collapse" href="#Membership">
                        <i class="fas fa-file-invoice-dollar"></i>
                        <p>{{ __('Membership') }}</p>
                        <span class="caret"></span>
                    </a>
                    <div class="collapse
                    @if (request()->path() == 'user/membership/payment-log') show
                    @elseif(request()->path() == 'user/membership/package-list') show
                    @elseif(request()->is('user/membership/package/checkout/*')) show
                    @elseif(request()->path() == 'user/membership/package/checkout/*') show @endif"
                        id="Membership">
                        <ul class="nav nav-collapse">
                            <li
                                class="
                              @if (request()->path() == 'user/membership/payment-log') active @endif">
                                <a href="{{ route('user.payment-log.index') }}">
                                    <span class="sub-item">{{ __('Payment Logs') }}</span>
                                </a>
                            </li>
                            <li
                                class="
                                    @if (request()->path() == 'user/membership/package-list') active
                                    @elseif(request()->is('user/membership/package/checkout/*')) active @endif">
                                <a href="{{ route('user.plan.extend.index') }}">
                                    <span class="sub-item">{{ __('Buy Plan') }}</span>
                                </a>
                            </li>
                        </ul>
                    </div>

                </li>

                {{-- QR Builder --}}
                @if (!empty($permissions) && in_array('QR Builder', $permissions))
                    <li
                        class="nav-item
                @if (request()->routeIs('user.qrcode')) active
                @elseif(request()->routeIs('user.qrcode.index')) active @endif">
                        <a data-toggle="collapse" href="#qrcode">
                            <i class="fas fa-qrcode"></i>
                            <p>{{ __('QR Codes') }}</p>
                            <span class="caret"></span>
                        </a>
                        <div class="collapse
                    @if (request()->routeIs('user.qrcode')) show
                    @elseif(request()->routeIs('user.qrcode.index')) show @endif"
                            id="qrcode">
                            <ul class="nav nav-collapse">
                                <li class="@if (request()->routeIs('user.qrcode')) active @endif">
                                    <a href="{{ route('user.qrcode') }}">
                                        <span class="sub-item">{{ __('Generate QR Code') }}</span>
                                    </a>
                                </li>
                                <li class="@if (request()->routeIs('user.qrcode.index')) active @endif">
                                    <a href="{{ route('user.qrcode.index') }}">
                                        <span class="sub-item">{{ __('Saved QR Codes') }}</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                @endif

            </ul>
        </div>
    </div>
</div>
