@extends('user.layout')

@section('content')
    <div class="page-header">
        @if (request()->routeIs('tenant.package_management.report'))
            <h4 class="page-title">{{ __('Report') }}</h4>
        @endif

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Tour Package Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                @if (request()->routeIs('tenant.package_management.report'))
                    <a href="#">{{ __('Report') }}</a>
                @endif
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10">
                            <form action="{{ route('tenant.package_management.report') }}" method="GET">
                                <div class="row no-gutters">
                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label>{{ __('From') }}</label>
                                            <input name="from" type="text" class="form-control datepicker-2"
                                                placeholder="{{ __('Select Start Date') }}"
                                                value="{{ !empty(request()->input('from')) ? request()->input('from') : '' }}"
                                                readonly autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label>{{ __('To') }}</label>
                                            <input name="to" type="text" class="form-control datepicker-2"
                                                placeholder="{{ __('Select To Date') }}"
                                                value="{{ !empty(request()->input('to')) ? request()->input('to') : '' }}"
                                                readonly autocomplete="off">
                                        </div>
                                    </div>

                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label>{{ __('Payment Gateways') }}</label>
                                            <select class="form-control h-42" name="payment_gateway">
                                                <option value="">{{ __('All') }}</option>
                                                @if (count($onlineGateways) > 0)
                                                    @foreach ($onlineGateways as $onlineGateway)
                                                        <option value="{{ $onlineGateway->keyword }}"
                                                            {{ request()->input('payment_gateway') == $onlineGateway->keyword ? 'selected' : '' }}>
                                                            {{ $onlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif

                                                @if (count($offlineGateways) > 0)
                                                    @foreach ($offlineGateways as $offlineGateway)
                                                        <option value="{{ $offlineGateway->name }}"
                                                            {{ request()->input('payment_gateway') == $offlineGateway->name ? 'selected' : '' }}>
                                                            {{ $offlineGateway->name }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-2">
                                        <div class="form-group">
                                            <label>{{ __('Payment Status') }}</label>
                                            <select class="form-control h-42" name="payment_status">
                                                <option value="">{{ __('All') }}</option>
                                                <option value="completed"
                                                    {{ request()->input('payment_status') == 'completed' ? 'selected' : '' }}>
                                                    {{ __('Completed') }}
                                                </option>
                                                <option value="incomplete"
                                                    {{ request()->input('payment_status') == 'incomplete' ? 'selected' : '' }}>
                                                    {{ __('Incomplete') }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-lg-2">
                                        <button type="submit" style="margin-top:42px"
                                            class="btn btn-primary btn-sm ml-lg-3 card-header-button">
                                            {{ __('Submit') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <div class="col-lg-2">
                            <a href="{{ route('tenant.package_management.export_report') }}"
                                class="btn btn-success btn-sm  float-right card-header-button" style="margin-top:42px">
                                <i class="fas fa-file-export"></i> {{ __('Export') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">

                            @if (count($bookings) == 0)
                                <h3 class="text-center mt-2">{{ __('NO PACKAGE BOOKING FOUND') . '!' }}</h3>
                            @else
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">{{ __('Booking No.') }}</th>
                                                <th scope="col">{{ __('Title') }}</th>
                                                <th scope="col">{{ __('Customer Name') }}</th>
                                                <th scope="col">{{ __('Rent') }}</th>
                                                <th scope="col">{{ __('Paid via') }}</th>
                                                <th scope="col">{{ __('Payment Status') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($bookings as $booking)
                                                <tr>
                                                    <td>{{ '#' . $booking->booking_number }}</td>
                                                    <td>{{ $booking->packageTitle }}</td>
                                                    <td>{{ $booking->customer_name }}</td>
                                                    <td>
                                                        {{ $booking->currency_text_position == 'left' ? $booking->currency_text : '' }}
                                                        {{ $booking->grand_total }}
                                                        {{ $booking->currency_text_position == 'right' ? $booking->currency_text : '' }}
                                                    </td>
                                                    <td>{{ $booking->payment_method }}</td>
                                                    <td>
                                                        @if ($booking->gateway_type == 'online')
                                                            @if ($booking->payment_status == 1)
                                                                <h2 class="d-inline-block"><span
                                                                        class="badge badge-success">{{ __('Completed') }}</span>
                                                                </h2>
                                                            @else
                                                                <h2 class="d-inline-block"><span
                                                                        class="badge badge-danger">{{ __('Incomplete') }}</span>
                                                                </h2>
                                                            @endif
                                                        @else
                                                            <form id="paymentStatusForm{{ $booking->id }}"
                                                                class="d-inline-block"
                                                                action="{{ route('tenant.room_bookings.update_payment_status') }}"
                                                                method="post">
                                                                @csrf
                                                                <input type="hidden" name="booking_id"
                                                                    value="{{ $booking->id }}">

                                                                <select
                                                                    class="form-control form-control-sm {{ $booking->payment_status == 1 ? 'bg-success' : 'bg-danger' }}"
                                                                    name="payment_status"
                                                                    onchange="document.getElementById('paymentStatusForm{{ $booking->id }}').submit();">
                                                                    <option value="1"
                                                                        {{ $booking->payment_status == 1 ? 'selected' : '' }}>
                                                                        {{ __('Completed') }}
                                                                    </option>
                                                                    <option value="0"
                                                                        {{ $booking->payment_status == 0 ? 'selected' : '' }}>
                                                                        {{ __('Incomplete') }}
                                                                    </option>
                                                                </select>
                                                            </form>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="mt-3 text-center">
                        <div class="d-inline-block mx-auto">
                            @if (count($bookings) > 0)
                                {{ $bookings->appends([
                                        'from' => request()->input('from'),
                                        'to' => request()->input('to'),
                                        'payment_gateway' => request()->input('payment_gateway'),
                                        'payment_status' => request()->input('payment_status'),
                                    ])->links() }}
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript" src="{{ asset('assets/tenant/js/admin-room.js') }}"></script>
@endsection
