@extends('user.layout')
@section('styles')
    <link rel="stylesheet" href="{{ asset('assets/tenant/css/custom_dropzone.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/admin/css/cropper.css') }}">
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Edit Package') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Tour Packages Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('tenant.packages_management.packages') }}">{{ __('Manage Packages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Edit Package') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Update Package') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.packages_management.packages') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward" style="font-size: 12px;"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>
                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-10 offset-lg-1">
                            <div class="alert alert-danger pb-1" id="packageErrors" style="display: none;">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>
                            <div style="margin-left: 10px;">
                                <label for=""><strong>{{ __('Slider Images') }} <span
                                            class="text-danger">**</span></strong></label>

                                @php $sliderImages = json_decode($package->slider_imgs); @endphp
                                @if (count($sliderImages) > 0)
                                    <div id="reload-slider-div">
                                        <div class="row mt-2">
                                            <div class="col">
                                                <table class="table" id="img-table">
                                                    @foreach ($sliderImages as $key => $sliderImage)
                                                        <tr class="table-row" id="{{ 'slider_image-' . $key }}">
                                                            <td>
                                                                <img class="thumb-preview" style="width: 150px;"
                                                                    src="{{ asset('assets/tenant/img/packages/slider_images/' . $sliderImage) }}"
                                                                    alt="slider image">
                                                            </td>
                                                            <td>
                                                                <i class="fa fa-times-circle"
                                                                    onclick="rmvStoredImg({{ $package->id }}, {{ $key }})"></i>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <form id="slider-dropzone" enctype="multipart/form-data" class="dropzone mt-2 mb-0">
                                    @csrf
                                    <div class="fallback"></div>
                                </form>
                                <h4 class="em text-danger mt-3 mb-0 font-weight-bold" id="err_slider_image"></h4>
                                <p class="em text-warning mt-3 mb-0">
                                    {{ __('Recommended image size : Upload 770X600 pixel size image for best quality.') }}
                                </p>
                            </div>
                            <form id="packageForm"
                                action="{{ route('tenant.packages_management.update_package', ['id' => $package->id]) }}"
                                method="POST">
                                @csrf
                                {{-- featured image start --}}
                                <div id="slider-image-id"></div>
                                <div class="form-group">
                                    <div class="col-12 mb-2">
                                        <label for="image"><strong> {{ __('Thumbnail Image') }} <span
                                                    class="text-danger">**</span></strong></label>
                                    </div>
                                    <div class="col-md-12 showImage mb-3">
                                        <img src="{{ asset('assets/tenant/img/packages/' . $package->featured_img) }}"
                                            alt="package image" style=""
                                            class="img-thumbnail cropped-thumbnail-image">
                                    </div>

                                    <button type="button" class="btn btn-primary" data-toggle="modal"
                                        data-target="#thumbnail-image-modal">{{ __('Choose Image') }}</button>

                                    <p class="text-warning"> {{ __('Only image size will be 300x360 pixel.') }}</p>
                                </div>
                                {{-- featured image end --}}

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Number of Days') }} <span class="text-danger">**</span></label>
                                            <input type="number" class="form-control" name="number_of_days"
                                                placeholder="{{ __('Number of Tour Days') }}"
                                                value="{{ $package->number_of_days }}" min="1">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Max Persons') }}</label>
                                            <input type="number" class="form-control" name="max_persons"
                                                placeholder="{{ __('Enter Max Persons') }}"
                                                value="{{ $package->max_persons }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Contact Email') }}</label>
                                            <input type="email" class="form-control" name="email"
                                                placeholder="{{ __('Enter Contact Email') }}"
                                                value="{{ $package->email }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Contact Number') }}</label>
                                            <input type="number" class="form-control" name="phone"
                                                placeholder="{{ __('Enter Contact Number') }}"
                                                value="{{ $package->phone }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label>{{ __('Plan Type') }} <span class="text-danger">**</span></label>
                                            <select name="plan_type" class="form-control">
                                                <option disabled>{{ __('Select a Type') }}</option>
                                                <option value="daywise"
                                                    {{ $package->plan_type == 'daywise' ? 'selected' : '' }}>
                                                    {{ __('Daywise') }}
                                                </option>
                                                <option value="timewise"
                                                    {{ $package->plan_type == 'timewise' ? 'selected' : '' }}>
                                                    {{ __('Timewise') }}
                                                </option>
                                            </select>
                                            <p id="daywise-text" class="mt-2 mb-0 text-warning d-none">
                                                {{ __('Plan need to be set according to per day') }}
                                            </p>
                                            <p id="timewise-text" class="mt-2 mb-0 text-warning d-none">
                                                {{ __('Plan need to be set according to per time frame') }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 ">
                                        <div class="form-group {{ $defaultLang->rtl == 1 ? 'rtl text-right' : '' }}">
                                            @php
                                                $categories = App\Models\User\PackageCategory::where(
                                                    'language_id',
                                                    $defaultLang->id,
                                                )
                                                    ->where('status', 1)
                                                    ->get();
                                            @endphp
                                            <label>{{ __('Category') }} <span class="text-danger">**</span></label>
                                            <select name="category" class="form-control">
                                                <option disabled selected>{{ __('Select a Category') }}
                                                </option>
                                                @foreach ($categories as $category)
                                                    <option value="{{ $category->indx }}" @selected($category->indx == $package->package_category_index)>
                                                        {{ $category->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>{{ __('Pricing Type') }} <span class="text-danger">**</span>
                                                ({{ __('in') }}
                                                {{ $userBs->base_currency_text }})</label>
                                            <div>
                                                <div class="d-sm-inline mr-3">
                                                    <input type="radio" class="mr-1" name="pricing_type"
                                                        value="negotiable"
                                                        {{ $package->pricing_type == 'negotiable' ? 'checked' : '' }}>
                                                    <label for="">{{ __('Negotiable') }}</label>
                                                </div>
                                                <div class="d-sm-inline mr-3">
                                                    <input type="radio" class="mr-1" name="pricing_type"
                                                        value="fixed"
                                                        {{ $package->pricing_type == 'fixed' ? 'checked' : '' }}>
                                                    <label for="">{{ __('Fixed') }}</label>
                                                </div>
                                                <div class="d-sm-inline">
                                                    <input type="radio" class="mr-1" name="pricing_type"
                                                        value="per-person"
                                                        {{ $package->pricing_type == 'per-person' ? 'checked' : '' }}>
                                                    <label for="">{{ __('Per Person') }}</label>
                                                </div>
                                            </div>
                                            <div class="row mt-2">
                                                <div class="col-lg-12">
                                                    <input type="number" step="0.01" id="fixed-price"
                                                        class="form-control d-none" name="fixed_package_price"
                                                        placeholder="Enter Package Price (Fixed)"
                                                        value="{{ $package->pricing_type == 'fixed' ? $package->package_price : '' }}">
                                                    <input type="number" step="0.01" id="per-person-price"
                                                        class="form-control d-none" name="per_person_package_price"
                                                        placeholder="Enter Package Price (Per Person)"
                                                        value="{{ $package->pricing_type == 'per-person' ? $package->package_price : '' }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="accordion" class="mt-5">
                                    @foreach ($languages as $language)
                                        @php
                                            $packageContent = $language
                                                ->packageDetails()
                                                ->where('package_id', $package->id)
                                                ->first();
                                            $title = !empty($packageContent) ? $packageContent->title : '';
                                            $categoryId = !empty($packageContent)
                                                ? $packageContent->package_category_id
                                                : '';
                                            $summary = !empty($packageContent) ? $packageContent->summary : '';
                                            $description = !empty($packageContent) ? $packageContent->description : '';
                                            $meta_keywords = !empty($packageContent)
                                                ? $packageContent->meta_keywords
                                                : '';
                                            $meta_description = !empty($packageContent)
                                                ? $packageContent->meta_description
                                                : '';
                                        @endphp
                                        <div class="version">
                                            <div class="version-header" id="heading{{ $language->id }}">
                                                <h5 class="mb-0">
                                                    <button type="button"
                                                        class="btn btn-link"
                                                        data-toggle="collapse" data-target="#collapse{{ $language->id }}"
                                                        aria-expanded="{{ $language->is_default == 1 ? 'true' : 'false' }}"
                                                        aria-controls="collapse{{ $language->id }}">
                                                        {{ $language->name . ' ' . __('Language') }}
                                                        {{ $language->is_default == 1 ? __('(Default)') : '' }}
                                                    </button>
                                                </h5>
                                            </div>
                                            <div id="collapse{{ $language->id }}"
                                                class="collapse {{ $language->is_default == 1 ? 'show' : '' }}"
                                                aria-labelledby="heading{{ $language->id }}" data-parent="#accordion">
                                                <div class="version-body">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Package Title') }} <span
                                                                        class="text-danger">**</span></label>
                                                                <input type="text" class="form-control"
                                                                    name="{{ $language->code }}_title"
                                                                    placeholder="{{ __('Enter Package Title') }}"
                                                                    value="{{ $title }}">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Package Description') }} <span
                                                                        class="text-danger">**</span></label>
                                                                <textarea class="form-control summernote" id="{{ $language->code }}_description"
                                                                    name="{{ $language->code }}_description" placeholder="{{ __('Enter Package Description') }}" data-height="300">{{ replaceBaseUrl($description, 'summernote') }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Package Meta Keywords') }}</label>
                                                                <input class="form-control"
                                                                    name="{{ $language->code }}_meta_keywords"
                                                                    placeholder="{{ __('Enter Meta Keywords') }}"
                                                                    data-role="tagsinput" value="{{ $meta_keywords }}">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div
                                                                class="form-group {{ $language->rtl == 1 ? 'rtl text-right' : '' }}">
                                                                <label>{{ __('Package Meta Description') }}</label>
                                                                <textarea class="form-control" name="{{ $language->code }}_meta_description" rows="5"
                                                                    placeholder="{{ __('Enter Meta Description') }}">{{ $meta_description }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            @php
                                                                $currLang = $language;
                                                            @endphp
                                                            @foreach ($languages as $language)
                                                                @continue($currLang->id == $language->id)

                                                                <div class="form-check py-0">
                                                                    <label class="form-check-label">
                                                                        <input class="form-check-input" type="checkbox"
                                                                            value=""
                                                                            onchange="cloneContent('collapse{{ $currLang->id }}', 'collapse{{ $language->id }}', event)">
                                                                        <span
                                                                            class="form-check-sign">{{ __('Clone for') }}
                                                                            <strong
                                                                                class="text-capitalize text-secondary">{{ $language->name }}</strong>
                                                                            {{ __('Language') }}</span>
                                                                    </label>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="packageForm" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @includeIf('user.packages.thumbnail')
@endsection
@section('script')
    <script src="{{ asset('assets/admin/js/cropper-plugin.js') }}"></script>
    <script>
        "use strict"
        const uploadSliderImage = "{{ route('tenant.packages_management.sliderImage') }}";
        const imgRmvUrl = "{{ route('tenant.packages_management.remove_slider_image') }}";
        const imgDetachUrl = "{{ route('tenant.packages_management.detach_slider_image') }}";
    </script>
    <script src="{{ asset('assets/tenant/js/packages/dropzone-slider.js') }}"></script>
    <script src="{{ asset('assets/tenant/js/packages/package.js') }}"></script>
    <script src="{{ asset('assets/tenant/js/packages/cropper-init.js') }}"></script>
@endsection
