@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('backend.partials.rtl_style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Categories') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Package Management') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Categories') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Edit Category') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.packages_management.categories') . '?language=' . request()->input('language') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>
                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <div class="alert alert-danger pb-1 dis-none" id="blogErrors">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                <ul></ul>
                            </div>
                            <form id="categoryForm" action="{{ route('tenant.packages_management.update_category') }}"
                                method="post">
                                @csrf
                                <input type="hidden" name="category_indx" value="{{ $data->indx }}">
                                @foreach ($languages as $language)
                                    @php
                                        $category = App\Models\User\PackageCategory::where('indx', $data->indx)
                                            ->where('language_id', $language->id)
                                            ->first();
                                    @endphp
                                    <div class="form-group">
                                        <label for=""
                                            class="">{{ __('Name') }} ({{ $language->name }})
                                            <span class="text-danger">**</span>
                                            
                                        </label>
                                        <input type="text" value="{{ $category?->name }}"
                                            class="form-control {{ $language->rtl == 1 ? 'text-right rtl' : '' }}"
                                            name="{{ $language->code }}_name" placeholder="{{ __('Enter Name') }}">
                                    </div>
                                @endforeach

                                @if (in_array($userBs->theme_version, [
                                    App\Enums\ThemeVersion::ThemeFour->value,
                                ]))
                                <div class="form-group">
                                    <div class="col-12 mb-2 pl-0">
                                        <label for="image"><strong>{{ __('Image') }} <span
                                                    class="text-danger">**</span></strong></label>
                                    </div>
                                    <div class="col-md-12 showImage12 mb-3 pl-0 pr-0">
                                        <img src="{{ $data->image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_PACKAGE_IMAGE, $data->image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                            alt="..." class="img-thumbnail">
                                    </div>
                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image12">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="category_image">
                                    </div>
                                    <p id="err_category_image" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">
                                        {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                    </p>
                                    @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                                        <p class="text-warning">
                                            {{ __('Recommended image size:Upload 600X400 pixel size image for best quality') }}
                                        </p>
                                    @endif
                                    @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFour->value]))
                                        <p class="text-warning">
                                            {{ __('Recommended image size:Upload 600X800 pixel size image for best quality') }}
                                        </p>
                                    @endif
                                </div>
                            @endif

                                <div class="form-group">
                                    <label for="">{{ __('Status') }} <span class="text-danger">**</span></label>
                                    <select name="status" id="in_status" class="form-control">
                                        <option disabled>{{ __('Select a Status') }}</option>
                                        <option value="1" {{ $data->status == 1 ? 'selected' : '' }}>
                                            {{ __('Active') }}
                                        </option>
                                        <option value="0" {{ $data->status == 0 ? 'selected' : '' }}>
                                            {{ __('Deactive') }}
                                        </option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Serial Number') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="number" id="in_serial_number" class="form-control ltr"
                                        value="{{ $data->serial_number }}" name="serial_number"
                                        placeholder="{{ __('Enter Serial Number') }}">
                                    <p class="text-warning mt-2">
                                        <small>{{ __('The higher the serial number, the later it will be displayed.') }}</small>
                                    </p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="form">
                        <div class="form-group from-show-notify row">
                            <div class="col-12 text-center">
                                <button type="submit" form="categoryForm"
                                    class="btn btn-success">{{ __('Update') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
