<div class="modal fade" id="addLocationModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
  aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">
          {{ __('Add Location') }}
        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <form id="ajaxForm" class="modal-form" action="{{ route('tenant.packages_management.store_location') }}"
          method="POST">
          @csrf
          <input type="hidden" name="language_id" value="{{ $language->id }}">
          <input type="hidden" id="package-id-location" name="package_id">
          <div class="form-group">
            <label for="">{{ __('Lacation Name') }} <span class="text-danger">**</span></label>
            <input type="text" class="form-control" name="name" placeholder="{{ __('Enter Location Name') }}">
            <p id="err_name" class="mt-1 mb-0 text-danger em"></p>
          </div>

          <div class="form-group">
            <label for="">{{ __('Latitude') }}</label>
            <input type="number" step="0.01" class="form-control ltr" name="latitude"
              placeholder="{{ __('Enter Latitude') }}">
              <p id="err_latitude" class="mt-1 mb-0 text-danger em"></p>
            <p class="text-warning mb-0">{{ __('The Latitude must be between -90 to 90. Ex:49.43453') }}</p>
            <span> {{ __('Collect Latitude & Longitude') }} <a href="https://maps.google.com/"
                class="link text-primary">{{
                __('Google Map') }}</a></span>
          </div>

          <div class="form-group">
            <label for="">{{ __('Longitude') }}</label>
            <input type="number" step="0.01" class="form-control ltr" name="longitude"
              placeholder="{{ __('Enter Longitude') }}">
              <p id="err_longitude" class="mt-1 mb-0 text-danger em"></p>
            <p class="text-warning mb-0">
              {{ __('The Longitude must be between -180 to 180. Ex:149.91553') }}
            </p>
          </div>
        </form>
      </div>

      <div class="modal-footer">
        <button id="submitBtn" type="button" class="btn btn-primary">
          {{ __('Save') }}
        </button>
      </div>
    </div>
  </div>
</div>
