<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
  aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">{{ __('Add Category') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <div class="alert alert-danger pb-1 dis-none" id="blogErrors">
          <button type="button" class="close" data-dismiss="alert">×</button>
          <ul></ul>
        </div>
        <form id="categoryForm" class="modal-form" action="{{ route('tenant.packages_management.store_category') }}"
          method="post">
          @csrf

          @foreach ($langs as $lang)
            <div class="form-group" >
              <label for="" class="">{{ __('Name') }} ({{ $lang->name }})  <span class="text-danger">**</span></label>
              <input type="text" class="form-control {{ $lang->rtl == 1 ? 'text-right rtl' : '' }}" name="{{ $lang->code }}_name"
                placeholder="{{ __('Enter Name') }}">
            </div>
          @endforeach

          
          @if (in_array($userBs->theme_version, [
            App\Enums\ThemeVersion::ThemeFour->value,
        ]))
        <div class="form-group">
            <div class="col-12 mb-2 pl-0">
                <label for="image"><strong>{{ __('Image') }} <span
                            class="text-danger">**</span></strong></label>
            </div>
            <div class="col-md-12 showImage12 mb-3 pl-0 pr-0">
                <img src="{{ asset('/assets/tenant/img/default.jpg') }}" alt="..."
                    class="img-thumbnail">
            </div>
            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image12">
                {{ __('Choose Image') }}
                <input type="file" class="img-input" name="category_image">
            </div>
            <p id="err_category_image" class="mb-0 text-danger em"></p>
            <p class="text-warning mb-0">
                {{ __('Only JPG, JPEG, PNG images are allowed') }}
            </p>
            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeThree->value]))
                <p class="text-warning">
                    {{ __('Recommended image size:Upload 600X400 pixel size image for best quality') }}
                </p>
            @endif
            @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeFour->value]))
                <p class="text-warning">
                    {{ __('Recommended image size:Upload 600X800 pixel size image for best quality') }}
                </p>
            @endif
        </div>
    @endif

          <div class="form-group">
            <label for="">{{ __('Status') }}<span class="text-danger">**</span></label>
            <select name="status" class="form-control">
              <option selected disabled>{{ __('Select a Status') }}</option>
              <option value="1">{{ __('Active') }}</option>
              <option value="0">{{ __('Deactive') }}</option>
            </select>
            <p id="err_status" class="mt-1 mb-0 text-danger em"></p>
          </div>

          <div class="form-group">
            <label for="">{{ __('Serial Number') }} <span class="text-danger">**</span></label>
            <input type="number" class="form-control ltr" name="serial_number"
              placeholder="{{ __('Enter Serial Number') }}">
            <p id="err_serial_number" class="mt-1 mb-0 text-danger em"></p>
            <p class="text-warning mt-2">
              <small>{{ __('The higher the serial number, the later it will be displayed.') }}</small>
            </p>
          </div>
        </form>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">
          {{ __('Close') }}
        </button>
        <button form="categoryForm" type="submit" class="btn btn-primary">
          {{ __('Save') }}
        </button>
      </div>
    </div>
  </div>
</div>
