@extends('user.layout')

@section('content')
    <div class="page-header">
        @if (request()->routeIs('tenant.package_bookings.all_bookings'))
            <h4 class="page-title">{{ __('All Bookings') }}</h4>
        @elseif (request()->routeIs('tenant.package_bookings.paid_bookings'))
            <h4 class="page-title">{{ __('Paid Bookings') }}</h4>
        @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings'))
            <h4 class="page-title">{{ __('Unpaid Bookings') }}</h4>
        @endif
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Tour Package Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                @if (request()->routeIs('tenant.package_bookings.all_bookings'))
                    <a href="#">{{ __('All Bookings') }}</a>
                @elseif (request()->routeIs('tenant.package_bookings.paid_bookings'))
                    <a href="#">{{ __('Paid Bookings') }}</a>
                @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings'))
                    <a href="#">{{ __('Unpaid Bookings') }}</a>
                @endif
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="card-title">
                                @if (request()->routeIs('tenant.package_bookings.all_bookings'))
                                    {{ __('All Package Bookings') }}
                                @elseif (request()->routeIs('tenant.package_bookings.paid_bookings'))
                                    {{ __('Paid Package Bookings') }}
                                @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings'))
                                    {{ __('Unpaid Package Bookings') }}
                                @endif
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <button class="btn btn-danger btn-sm float-right d-none bulk-delete mr-2 ml-3 mt-1"
                                data-href="{{ route('tenant.package_bookings.bulk_delete_booking') }}"><i
                                    class="flaticon-interface-5"></i> {{ __('Delete') }}</button>

                            <form class="float-right"
                                @if (request()->routeIs('tenant.package_bookings.all_bookings')) action="{{ route('tenant.package_bookings.all_bookings') }}"
                @elseif (request()->routeIs('tenant.package_bookings.paid_bookings'))
                  action="{{ route('tenant.package_bookings.paid_bookings') }}"
                @elseif (request()->routeIs('tenant.package_bookings.unpaid_bookings'))
                  action="{{ route('tenant.package_bookings.unpaid_bookings') }}" @endif
                                method="GET">
                                <input name="booking_no" type="text" class="form-control"
                                    placeholder="{{ __('Search By Booking No') }}"
                                    value="{{ !empty(request()->input('booking_no')) ? request()->input('booking_no') : '' }}">
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            @if (count($bookings) == 0)
                                <h3 class="text-center mt-2">{{ __('NO PACKAGE BOOKING FOUND') . '!' }}</h3>
                            @else
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">
                                                    <input type="checkbox" class="bulk-check" data-val="all">
                                                </th>
                                                <th scope="col">{{ __('Booking No') . '.' }}</th>
                                                <th scope="col">{{ __('Package') }}</th>
                                                <th scope="col">{{ __('Cost') }}</th>
                                                <th scope="col">{{ __('Paid via') }}</th>
                                                <th scope="col">{{ __('Payment Status') }}</th>
                                                <th scope="col">{{ __('Attachment') }}</th>
                                                <th scope="col">{{ __('Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($bookings as $booking)
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" class="bulk-check"
                                                            data-val="{{ $booking->id }}">
                                                    </td>
                                                    <td>{{ '#' . $booking->booking_number }}</td>
                                                    <td>

                                                        @php
                                                            $title = '-';
                                                            if (
                                                                $booking->tourPackage &&
                                                                optional(
                                                                    $booking->tourPackage->packageContent,
                                                                )->isNotEmpty()
                                                            ) {
                                                                $title = $booking->tourPackage->packageContent
                                                                    ->where('user_id', Auth::guard('web')->user()->id)
                                                                    ->first()->title;
                                                            }

                                                        @endphp
                                                        {{ strlen($title) > 25 ? mb_substr($title, 0, 25, 'utf-8') . '...' : $title }}
                                                    </td>
                                                    <td>{{ $booking->currency_text_position == 'left' ? $booking->currency_text : '' }}
                                                        {{ $booking->grand_total }}
                                                        {{ $booking->currency_text_position == 'right' ? $booking->currency_text : '' }}
                                                    </td>
                                                    <td>{{ __($booking->payment_method) }}</td>
                                                    <td>

                                                        @if ($booking->gateway_type == 'online')
                                                            @if ($booking->payment_status == 1)
                                                                <h2 class="d-inline-block"><span
                                                                        class="badge badge-success">{{ __('Paid') }}</span>
                                                                </h2>
                                                            @else
                                                                <h2 class="d-inline-block"><span
                                                                        class="badge badge-danger">{{ __('Unpaid') }}</span>
                                                                </h2>
                                                            @endif
                                                        @else
                                                            @if ($booking->payment_offline_status === null)
                                                                <form id="paymentStatusForm{{ $booking->id }}"
                                                                    class="d-inline-block"
                                                                    action="{{ route('tenant.package_bookings.update_payment_status') }}"
                                                                    method="post">
                                                                    @csrf
                                                                    <input type="hidden" name="booking_id"
                                                                        value="{{ $booking->id }}">

                                                                    <select
                                                                        class="form-control form-control-sm {{ $booking->payment_status == 1 ? 'bg-success' : 'bg-danger' }}"
                                                                        name="payment_status"
                                                                        onchange="document.getElementById('paymentStatusForm{{ $booking->id }}').submit();">
                                                                        <option value="1"
                                                                            {{ $booking->payment_status == 1 ? 'selected' : '' }}>
                                                                            {{ __('Paid') }}
                                                                        </option>
                                                                        <option value="0"
                                                                            {{ $booking->payment_status == 0 ? 'selected' : '' }}>
                                                                            {{ __('Unpaid') }}
                                                                        </option>
                                                                    </select>
                                                                </form>
                                                            @endif
                                                            @if ($booking->payment_offline_status === 1)
                                                                <span
                                                                    class="badge badge-success">{{ __('Paid') }}</span>
                                                            @elseif($booking->payment_offline_status === 0)
                                                                <span class="badge badge-danger">{{ __('Unpaid') }}</span>
                                                            @endif
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if (!empty($booking->attachment))
                                                            <a class="btn btn-sm btn-info" href="#"
                                                                data-toggle="modal"
                                                                data-target="#attachmentModal{{ $booking->id }}">{{ __('Show') }}</a>
                                                        @else
                                                            -
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary btn-sm dropdown-toggle"
                                                                type="button" id="dropdownMenuButton"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                                {{ __('Select') }}
                                                            </button>

                                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                <a href="{{ route('tenant.package_bookings.booking_details', ['id' => $booking->id]) }}"
                                                                    class="dropdown-item">{{ __('Details') }}</a>

                                                                <a href="{{ asset('assets/tenant/invoices/packages/' . $booking->invoice) }}"
                                                                    class="dropdown-item"
                                                                    target="_blank">{{ __('Invoice') }}</a>

                                                                <a href="#" class="dropdown-item mailBtn"
                                                                    data-target="#mailModal" data-toggle="modal"
                                                                    data-customer_email="{{ $booking->customer_email }}">{{ __('Send Mail') }}</a>

                                                                <form class="deleteForm d-block"
                                                                    action="{{ route('tenant.package_bookings.delete_booking', ['id' => $booking->id]) }}"
                                                                    method="post">
                                                                    @csrf
                                                                    <button type="submit" class="deleteBtn">
                                                                        {{ __('Delete') }}
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>

                                                @includeIf('user.packages.show_attachment')
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="d-inline-block mx-auto">
                            {{ $bookings->appends(['booking_no' => request()->input('booking_no')])->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @includeIf('user.packages.send_mail')
@endsection
