@extends('user.layout')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Booking Details') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Tour Package Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Package Bookings') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Booking Details') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card-header">
                <div class="card-title d-inline-block">{{ __('Package Booking Details') }}</div>
                <a class="btn btn-info btn-sm float-right d-inline-block" href="{{ url()->previous() }}">
                    <span class="btn-label">
                        <i class="fas fa-backward" style="font-size: 12px;"></i>
                    </span>
                    {{ __('Back') }}
                </a>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                @php
                    $position = $details->currency_text_position;
                    $currency = $details->currency_text;
                @endphp

                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Booking Number') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ '#' . $details->booking_number }}</div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Booking Date') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ date_format($details->created_at, 'F d, Y') }}
                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Package Name') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ $packageTitle }}</div>
                        </div>
                        <hr>


                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Package Type') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ $packageCategoryName }}</div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Number of Visitors') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ $details->visitors }}</div>
                        </div>

                        <hr>
                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Price') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->actual_total }}{{ $position == 'right' ? ' ' . $currency : '' }}
                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Discount') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->discount }}{{ $position == 'right' ? ' ' . $currency : '' }}
                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Subtotal') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->subtotal }}{{ $position == 'right' ? ' ' . $currency : '' }}
                            </div>
                        </div>
                        <hr>

                        @if ($details->tax != 0.0)
                            <div class="row">
                                <div class="col-lg-4">
                                    <strong>{{ __('Tax') . ':' }}</strong>
                                </div>
                                <div class="col-lg-8">
                                    {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->tax }}{{ $position == 'right' ? ' ' . $currency : '' }}
                                </div>
                            </div>
                            <hr>
                        @endif

                        @if ($details->fee != 0.0)
                            <div class="row">
                                <div class="col-lg-4">
                                    <strong>{{ __('Fee') . ':' }}</strong>
                                </div>
                                <div class="col-lg-8">
                                    {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->fee }}{{ $position == 'right' ? ' ' . $currency : '' }}
                                </div>
                            </div>
                            <hr>
                        @endif


                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Total Cost') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ $position == 'left' ? $currency . ' ' : '' }}{{ $details->grand_total }}{{ $position == 'right' ? ' ' . $currency : '' }}
                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Payment Method') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8"><span
                                    class="badge badge-success">{{ __($details->payment_method) }}</span></div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Payment Status') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                @if ($details->payment_status == 1)
                                    <span class="badge badge-success">{{ __('Paid') }}</span>
                                @elseif($details->payment_status == 0)
                                    <span class="badge badge-danger">{{ __('UnPiad') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer"></div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Booking Number') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ '#' . $details->booking_number }}</div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Booking Date') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">
                                {{ date_format($details->created_at, 'F d, Y') }}
                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Customer Name') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ convertUtf8($details->customer_name) }}</div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Customer Email') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ $details->customer_email }}</div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-lg-4">
                                <strong>{{ __('Customer Phone') . ':' }}</strong>
                            </div>
                            <div class="col-lg-8">{{ $details->customer_phone }}</div>
                        </div>
                        <hr>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
