<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">{{ __('Add Category') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <div class="alert alert-danger pb-1 dis-none" id="blogErrors">
                    <button type="button" class="close" data-dismiss="alert">×</button>
                    <ul></ul>
                </div>
                <form id="categoryForm" class="modal-form create"
                    action="{{ route('user.blog_management.store_category', ['language' => request()->input('language')]) }}"
                    method="post" dir="ltr">
                    @csrf

                    @foreach ($langs as $language)
                        <div class="form-group">
                            <label for=""
                                class="d-flex">{{ __('Name') }}
                                ({{ $language->name }})
                                <span class="text-danger">**</span></label>
                            <input type="text" class="form-control {{ $language->rtl == 1 ? 'text-right rtl' : '' }}"
                                name="{{ $language->code }}_name" placeholder="{{ __('Enter Name') }}">
                        </div>
                    @endforeach

                    <div class="form-group">
                        <label for="">{{ __('Status') }} <span class="text-danger">**</span></label>
                        <select name="status" class="form-control">
                            <option selected disabled>{{ __('Select a Status') }}</option>
                            <option value="1">{{ __('Active') }}</option>
                            <option value="0">{{ __('Deactive') }}</option>
                        </select>
                        <p id="err_status" class="mt-1 mb-0 text-danger em"></p>
                    </div>

                    <div class="form-group">
                        <label for="">{{ __('Serial Number') }} <span class="text-danger">**</span></label>
                        <input type="number" class="form-control ltr" name="serial_number"
                            placeholder="{{ __('Enter Serial Number') }}">
                        <p id="err_serial_number" class="mt-1 mb-0 text-danger em"></p>
                        <p class="text-warning mt-2 mb-0">
                            <small>{{ __('The higher the serial number, the later it will be displayed.') }}</small>
                        </p>
                    </div>
                </form>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">
                    {{ __('Close') }}
                </button>
                <button form="categoryForm" type="submit" class="btn btn-primary">
                    {{ __('Save') }}
                </button>
            </div>
        </div>
    </div>
</div>
