@extends('user.layout')
{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Testimonials') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Testimonials') }}</a>
            </li>

        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4 mb-3 mb-lg-0">
                            <div class="card-title d-inline-block">{{ __('Testimonials') }}</div>
                        </div>
                        <div class="col-lg-3">
                            @includeIf('user.partials.languages')
                        </div>

                        <div class="col-lg-5  mt-2 mt-lg-0">
                            <a href="{{ route('tenant.home_page.testimonial_section.create_testimonial') . '?language=' . request()->input('language') }}"
                                class="btn btn-primary btn-sm float-right"><i class="fas fa-plus"></i>
                                {{ __('Add Testimonial') }}</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            @if (count($testimonialInfos) == 0)
                                <h3 class="text-center">{{ __('NO TESTIMONIAL FOUND!') }}</h3>
                            @else
                                <div class="table-responsive">
                                    <table class="table table-striped mt-3">
                                        <thead>
                                            <tr>
                                                <th scope="col">{{ __('#') }}</th>
                                                @if ($userBs->theme_version == \App\Enums\ThemeVersion::ThemeOne->value)
                                                    <th scope="col">{{ __('Image') }}</th>
                                                @endif
                                                <th scope="col">{{ __('Name') }}</th>

                                                <th scope="col">{{ __('Comment') }}</th>
                                                <th scope="col">{{ __('Serial Number') }}</th>
                                                <th scope="col">{{ __('Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($testimonialInfos as $testimonialInfo)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    @if ($userBs->theme_version == \App\Enums\ThemeVersion::ThemeOne->value)
                                                        <td>
                                                            @if (!is_null($testimonialInfo->image))
                                                                <img src="{{ asset(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE . '/' . $testimonialInfo->image) }}"
                                                                    alt="user" width="40">
                                                            @else
                                                                -
                                                            @endif
                                                        </td>
                                                    @endif
                                                    <td>
                                                        {{ $testimonialInfo->name }}
                                                    </td>
                                                    <td>

                                                        {{ strlen($testimonialInfo->comment) > 50 ? convertUtf8(substr($testimonialInfo->comment, 0, 50)) . '...' : convertUtf8($testimonialInfo->comment) }}

                                                    </td>
                                                    <td>{{ $testimonialInfo->serial_number }}</td>
                                                    <td>
                                                        <a class="btn btn-secondary btn-sm mr-1 mb-1"
                                                            href="{{ route('tenant.home_page.testimonial_section.edit_testimonial', $testimonialInfo->id) . '?language=' . request()->input('language') }}">
                                                            <span class="btn-label">
                                                                <i class="fas fa-edit" style="margin-right: -3px;"></i>
                                                            </span>
                                                        </a>

                                                        <form class="deleteForm d-inline-block"
                                                            action="{{ route('tenant.home_page.testimonial_section.delete_testimonial') }}"
                                                            method="post">
                                                            @csrf
                                                            <input type="hidden" name="testimonial_id"
                                                                value="{{ $testimonialInfo->id }}">

                                                            <button type="submit"
                                                                class="btn btn-danger btn-sm deleteBtn mb-1">
                                                                <span class="btn-label">
                                                                    <i class="fas fa-trash" style="margin-right: -3px;"></i>
                                                                </span>
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
