@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@include('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Edit Testimonial') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a
                    href="{{ route('tenant.home_page.testimonial_section') . '?language=' . $defaultLang->code }}">{{ __('Testimonials') }}</a>
            </li>

            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Edit Testimonial') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="card-title">{{ __('Update Testimonial') }}</div>
                        </div>
                        <div class="col-lg-2">
                            <a class="btn btn-info btn-sm float-right d-inline-block"
                                href="{{ route('tenant.home_page.testimonial_section') . '?language=' . request()->input('language') }}">
                                <span class="btn-label">
                                    <i class="fas fa-backward" style="font-size: 12px;"></i>
                                </span>
                                {{ __('Back') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="testimonialForm"
                                action="{{ route('tenant.home_page.testimonial_section.update_testimonial', ['id' => $testimonialInfo->id]) }}"
                                method="POST" enctype="multipart/form-data">
                                @csrf

                                <div class="form-group">
                                    <label for="image">{{ __('Image') }}
                                        <span class="text-danger">**</span></label>
                                    <div class="showImage mb-3">
                                        <img src="{{ asset(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE . '/' . $testimonialInfo->image) }}"
                                            alt="client image" class="img-thumbnail">
                                    </div>

                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="image">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Client Name') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="name"
                                                value="{{ $testimonialInfo->name }}">
                                            @if ($errors->has('client_name'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('name') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Client Designation') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="designation"
                                                value="{{ $testimonialInfo->designation }}">
                                            @if ($errors->has('designation'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('designation') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Comment') }} <span
                                                    class="text-danger">**</span></label>
                                            <textarea class="form-control" name="comment" rows="5" cols="80">{{ $testimonialInfo->comment }}</textarea>
                                            @if ($errors->has('comment'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('comment') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Serial Number') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="number" class="form-control ltr" name="serial_number"
                                                value="{{ $testimonialInfo->serial_number }}">
                                            @if ($errors->has('serial_number'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('serial_number') }}</p>
                                            @endif
                                            <p class="text-warning mb-0 mt-2">
                                                <small>{{ __('The higher the serial number, the later it will be displayed.') }}</small>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="testimonialForm" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
