@extends('user.layout')

@php   
   use App\Http\Helpers\UserPermissionHelper;
    $user = Auth::guard('web')->user();
    $packageFeatures = UserPermissionHelper::currentPackageFeatures($user->id);
@endphp

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Section Customization') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Section Customization') }}</a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <form class="" action="{{ route('tenant.sections.update') }}" method="post">
                    @csrf
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-title">{{ __('Customize Sections') }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-5 pb-5">
                        <div class="row">
                            <div class="col-lg-6 mx-auto">
                                @csrf
                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Search Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="search_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->search_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }}</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="search_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->search_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Intro Section') }}
                                            <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="intro_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->intro_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }}</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="intro_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->intro_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Room Category Section') }} <span
                                                class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_rooms_category_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_rooms_category_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_rooms_category_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_rooms_category_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                    App\Enums\ThemeVersion::ThemeFour->value,
                                ]))
                                <div class="form-group">
                                    <label>{{ __('Package Category Section') }} <span
                                            class="text-danger">**</span></label>
                                    <div class="selectgroup w-100">
                                        <label class="selectgroup-item">
                                            <input type="radio" name="package_category_section" value="1"
                                                class="selectgroup-input"
                                                {{ $sections->package_category_section == 1 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Active') }} </span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="package_category_section" value="0"
                                                class="selectgroup-input"
                                                {{ $sections->package_category_section == 0 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                        </label>
                                    </div>
                                </div>
                            @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Featured Rooms Section') }} <span
                                                class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_rooms_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_rooms_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }}</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_rooms_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_rooms_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                            </label>
                                        </div>
                                    </div>
                                @endif


                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Featured Services Section') }}</label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_services_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_services_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }}</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_services_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_services_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button"> {{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [App\Enums\ThemeVersion::ThemeTwo->value]))
                                    <div class="form-group">
                                        <label>{{ __('FAQ Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="faq_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->faq_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }}</span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="faq_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->faq_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Statistics Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="statistics_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->statistics_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="statistics_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->statistics_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                    App\Enums\ThemeVersion::ThemeThree->value,
                                ]))
                                <div class="form-group">
                                    <label>{{ __('Latest Rooms Section') }} <span
                                            class="text-danger">**</span></label>
                                    <div class="selectgroup w-100">
                                        <label class="selectgroup-item">
                                            <input type="radio" name="latest_rooms_section" value="1"
                                                class="selectgroup-input"
                                                {{ $sections->latest_rooms_section == 1 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Active') }}</span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="latest_rooms_section" value="0"
                                                class="selectgroup-input"
                                                {{ $sections->latest_rooms_section == 0 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                        </label>
                                    </div>
                                </div>
                               @endif

                                @if (in_array($userBs->theme_version,[App\Enums\ThemeVersion::ThemeFour->value, App\Enums\ThemeVersion::ThemeFive->value]))
                                <div class="form-group">
                                    <label>{{ __('Latest Packages Section') }} <span
                                            class="text-danger">**</span></label>
                                    <div class="selectgroup w-100">
                                        <label class="selectgroup-item">
                                            <input type="radio" name="latest_packages_section" value="1"
                                                class="selectgroup-input"
                                                {{ $sections->latest_packages_section == 1 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Active') }}</span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="latest_packages_section" value="0"
                                                class="selectgroup-input"
                                                {{ $sections->latest_packages_section == 0 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                        </label>
                                    </div>
                                </div>
                                @endif



                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                    ]) && in_array('Tour Package',$packageFeatures))
                                    <div class="form-group">
                                        <label>{{ __('Featured Packages Section') }} <span
                                                class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_package_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_package_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="featured_package_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->featured_package_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif


                                @if (in_array($userBs->theme_version, [
                                    App\Enums\ThemeVersion::ThemeOne->value,
                                    App\Enums\ThemeVersion::ThemeTwo->value,
                                    App\Enums\ThemeVersion::ThemeThree->value,
                                    App\Enums\ThemeVersion::ThemeFour->value,
                                    App\Enums\ThemeVersion::ThemeFive->value,
                                ]))
                                <div class="form-group">
                                    <label>{{ __('Video Section') }} <span class="text-danger">**</span></label>
                                    <div class="selectgroup w-100">
                                        <label class="selectgroup-item">
                                            <input type="radio" name="video_section" value="1"
                                                class="selectgroup-input"
                                                {{ $sections->video_section == 1 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Active') }} </span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="video_section" value="0"
                                                class="selectgroup-input"
                                                {{ $sections->video_section == 0 ? 'checked' : '' }}>
                                            <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                        </label>
                                    </div>
                                </div>
                                 @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Testimonial Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="testimonials_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->testimonials_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="testimonials_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->testimonials_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif


                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Facilities Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="facilities_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->facilities_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="facilities_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->facilities_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                    ]) && in_array('Blog', $packageFeatures))
                                    <div class="form-group">
                                        <label>{{ __('Blogs Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="blogs_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->blogs_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="blogs_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->blogs_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Brand Partners Section') }} <span
                                                class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="brand_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->brand_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="brand_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->brand_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Top Footer Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="top_footer_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->top_footer_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="top_footer_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->top_footer_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeOne->value,
                                        App\Enums\ThemeVersion::ThemeTwo->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                    ]))
                                    <div class="form-group">
                                        <label>{{ __('Copyright Section') }} <span class="text-danger">**</span></label>
                                        <div class="selectgroup w-100">
                                            <label class="selectgroup-item">
                                                <input type="radio" name="copyright_section" value="1"
                                                    class="selectgroup-input"
                                                    {{ $sections->copyright_section == 1 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Active') }} </span>
                                            </label>
                                            <label class="selectgroup-item">
                                                <input type="radio" name="copyright_section" value="0"
                                                    class="selectgroup-input"
                                                    {{ $sections->copyright_section == 0 ? 'checked' : '' }}>
                                                <span class="selectgroup-button">{{ __('Deactive') }} </span>
                                            </label>
                                        </div>
                                    </div>
                                @endif



                                @if (count($additional_section_statuses) > 0)
                                    @foreach ($additional_section_statuses as $key => $additional_section_status)
                                        @php
                                            $section_content = App\Models\User\AdditionalSectionContent::where([
                                                ['language_id', $languge_id],
                                                ['addition_section_id', $key],
                                            ])->first();
                                        @endphp

                                        @if ($section_content)
                                            <div class="form-group">
                                                <label>{{ $section_content->section_name . ' ' . __('Section') }}
                                                </label>
                                                <div class="selectgroup w-100">
                                                    <label class="selectgroup-item">
                                                        <input type="radio"
                                                            name="additional_sections[{{ $key }}]"
                                                            value="1" class="selectgroup-input"
                                                            {{ $additional_section_status == 1 ? 'checked' : '' }}>
                                                        <span class="selectgroup-button">{{ __('Active') }}</span>
                                                    </label>
                                                    <label class="selectgroup-item">
                                                        <input type="radio"
                                                            name="additional_sections[{{ $key }}]"
                                                            value="0" class="selectgroup-input"
                                                            {{ $additional_section_status == 0 ? 'checked' : '' }}>
                                                        <span class="selectgroup-button">{{ __('Deactive') }}</span>
                                                    </label>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                @endif

                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="form">
                            <div class="form-group from-show-notify row">
                                <div class="col-12 text-center">
                                    <button type="submit" id="displayNotif" class="btn btn-success">{{ __('Update') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
