@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Sliders') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>

            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Sliders') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4 mb-3 mb-lg-0">
                            <div class="card-title d-inline-block">{{ __('Sliders') }}</div>
                        </div>

                        <div class="col-lg-3">
                            @includeIf('user.partials.languages')
                        </div>

                        <div class="col-lg-5  mt-2 mt-lg-0">
                            <a href="{{ route('tenant.home_page.hero.create_slider') . '?language=' . request()->input('language') }}"
                                class="btn btn-primary btn-sm float-right"><i class="fas fa-plus"></i>
                                {{ __('Add Slider') }}</a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            @if (count($sliders) == 0)
                                <h3 class="text-center">{{ __('NO SLIDER FOUND!') }}</h3>
                            @else
                                <div class="row">
                                    @foreach ($sliders as $slider)
                                        <div class="col-md-3">
                                            <div class="card">
                                                <div class="card-body">
                                                    <img src="{{ asset('assets/tenant/img/hero_slider/' . $slider->img) }}"
                                                        alt="image" class="w-100">
                                                </div>

                                                <div class="card-footer text-center">
                                                    <a class="btn btn-secondary btn-sm mr-2 mb-1"
                                                        href="{{ route('tenant.home_page.hero.edit_slider', $slider->id) . '?language=' . request()->input('language') }}">
                                                        <span class="btn-label">
                                                            <i class="fas fa-edit"></i>
                                                        </span>
                                                    </a>

                                                    <form class="deleteForm d-inline-block"
                                                        action="{{ route('tenant.home_page.hero.delete_slider') }}"
                                                        method="post">
                                                        @csrf
                                                        <input type="hidden" name="slider_id" value="{{ $slider->id }}">
                                                        <button type="submit" class="btn btn-danger btn-sm deleteBtn mb-1">
                                                            <span class="btn-label">
                                                                <i class="fas fa-trash"></i>
                                                            </span>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
