@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Edit Slider') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Hero Section') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Edit Slider') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title d-inline-block">{{ __('Edit Slider') }}</div>
                    <a class="btn btn-info btn-sm float-right d-inline-block"
                        href="{{ route('tenant.home_page.hero.slider_version') . '?language=' . request()->input('language') }}">
                        <span class="btn-label">
                            <i class="fas fa-backward" style="font-size: 12px;"></i>
                        </span>
                        {{ __('Back') }}
                    </a>
                </div>

                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-8 mx-auto">
                            <form id="sliderVersionForm"
                                action="{{ route('tenant.home_page.hero.update_slider_info', ['id' => $slider->id]) }}"
                                method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="form-group">
                                    <label for="image"><strong> {{ __('Image') }} <span
                                                class="text-danger">**</span></strong></label>
                                    <div class=" showImage mb-3">
                                        @if (!empty($slider->img))
                                            <img src="{{ asset('assets/tenant/img/hero_slider/' . $slider->img) }}"
                                                alt="..." class="img-thumbnail">
                                        @endif
                                    </div>
                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="img">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Title') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="title"
                                                placeholder="{{ __('Enter Slider Title') }}" value="{{ $slider->title }}">
                                            @if ($errors->has('title'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('title') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="">{{ __('Subtitle') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="text" class="form-control" name="subtitle"
                                                placeholder="{{ __('Enter Slider Subtitle') }}"
                                                value="{{ $slider->subtitle }}">
                                            @if ($errors->has('subtitle'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('subtitle') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @if (in_array($userBs->theme_version, ['theme_one', 'theme_two']))
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label for="">{{ __('Button Name') }} <span
                                                        class="text-danger"></span></label>
                                                <input type="text" class="form-control" name="btn_name"
                                                    placeholder="{{ __('Enter Slider Button Name') }}"
                                                    value="{{ $slider->btn_name }}">
                                                @if ($errors->has('btn_name'))
                                                    <p class="mt-2 mb-0 text-danger">{{ $errors->first('btn_name') }}</p>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                <label>{{ __('Button URL') }}</label>
                                                <input type="url" class="form-control ltr" name="btn_url"
                                                    placeholder="{{ __('Enter Slider Button URL') }}"
                                                    value="{{ $slider->btn_url }}">
                                                @if ($errors->has('btn_url'))
                                                    <p class="mt-2 mb-0 text-danger">{{ $errors->first('btn_url') }}</p>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label for="">{{ __('Serial Number') }} <span
                                                    class="text-danger">**</span></label>
                                            <input type="number" class="form-control ltr" name="serial_number"
                                                placeholder="{{ __('Enter Serial Number') }}"
                                                value="{{ $slider->serial_number }}">
                                            @if ($errors->has('serial_number'))
                                                <p class="mt-2 mb-0 text-danger">{{ $errors->first('serial_number') }}</p>
                                            @endif
                                            <p class="text-warning mt-2 mb-0">
                                                {{ __('The higher the serial number, the later it will be displayed.') }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" form="sliderVersionForm" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
