@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Add Facility') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a
                    href="{{ route('tenant.home_page.facility_section') . '?language=' . request()->input('language') }}">{{ __('Facilities') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Add Facility') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10">
                            <div class="card-title">{{ __('Create Facility') }}</div>
                        </div>

                        <div class="col-lg-2">
                            <a class="btn btn-info btn-sm float-right d-inline-block"
                                href="{{ route('tenant.home_page.facility_section') . '?language=' . request()->input('language') }}">
                                <span class="btn-label">
                                    <i class="fas fa-backward" style="font-size: 12px;"></i>
                                </span>
                                {{ __('Back') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5 pb-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="ajaxForm"
                                action="{{ route('tenant.home_page.facility_section.store_facility', ['language' => request()->input('language')]) }}"
                                method="post">
                                @csrf
                                <div class="form-group">
                                    <label for="">{{ __('Icon') }} <span class="text-danger">**</span></label>
                                    <div class="btn-group d-block">
                                        <button type="button" class="btn btn-primary iconpicker-component"><i
                                                class="fa fa-fw fa-heart"></i></button>
                                        <button type="button" class="icp icp-dd btn btn-primary dropdown-toggle"
                                            data-selected="fa-car" data-toggle="dropdown"></button>
                                        <div class="dropdown-menu"></div>
                                    </div>
                                    <input type="hidden" id="inputIcon" name="facility_icon">
                                    <p id="err_facility_icon" class="mt-1 mb-0 text-danger em"></p>
                                    <div class="text-warning mt-2">
                                        <small>{{ __('Click on the dropdown icon to select a icon.') }}</small>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Facility Title') }} <span
                                            class="text-danger">**</span></label>
                                    <input type="text" class="form-control" name="facility_title"
                                        placeholder="{{ __('Enter Title') }}">
                                    <p id="err_facility_title" class="mt-1 mb-0 text-danger em"></p>
                                </div>

                                <div class="form-group">
                                    <label for="">{{ __('Facility Text') }} <span
                                            class="text-danger">**</span></label>
                                    <textarea class="form-control" name="facility_text" rows="5" cols="80"
                                        placeholder="{{ __('Enter Facility Text') }}"></textarea>
                                    <p id="err_facility_text" class="mt-1 mb-0 text-danger em"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="submit" id="submitBtn" class="btn btn-success">
                                {{ __('Save') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
