@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Brand Partners') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Home Page') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Brand Partners') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4 mb-3 mb-lg-0">
                            <div class="card-title d-inline-block">{{ __('Brand Partners') }}</div>
                        </div>

                        <div class="col-lg-3">
                            @includeIf('user.partials.languages')
                        </div>

                        <div class="col-lg-5 mt-2 mt-lg-0">
                            <a href="#" data-toggle="modal" data-target="#createModal"
                                class="btn btn-primary btn-sm float-right"><i class="fas fa-plus"></i>
                                {{ __('Add Brand') }}</a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            @if (count($brands) == 0)
                                <h3 class="text-center">{{ __('NO BRAND FOUND!') }}</h3>
                            @else
                                <div class="row">
                                    @foreach ($brands as $brand)
                                        <div class="col-md-3">
                                            <div class="card">
                                                <div class="card-body">
                                                    <img src="{{ asset('assets/tenant/img/brands/' . $brand->brand_img) }}"
                                                        alt="brand image" class="w-100">
                                                </div>

                                                <div class="card-footer text-center">
                                                    <a class="editBtn btn btn-secondary btn-sm mr-2 mb-1" href="#"
                                                        data-toggle="modal" data-target="#editModal"
                                                        data-id="{{ $brand->id }}"
                                                        data-brand_img="{{ asset('assets/tenant/img/brands/' . $brand->brand_img) }}"
                                                        data-brand_url="{{ $brand->brand_url }}"
                                                        data-serial_number="{{ $brand->serial_number }}">
                                                        <span class="btn-label">
                                                            <i class="fas fa-edit"></i>
                                                        </span>
                                                    </a>

                                                    <form class="deleteForm d-inline-block"
                                                        action="{{ route('tenant.home_page.brand_section.delete_brand') }}"
                                                        method="post">
                                                        @csrf
                                                        <input type="hidden" name="brand_id" value="{{ $brand->id }}">
                                                        <button type="submit" class="mb-1 btn btn-danger btn-sm deleteBtn">
                                                            <span class="btn-label">
                                                                <i class="fas fa-trash"></i>
                                                            </span>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- create modal --}}
    @include('user.home_page.brand_section.create')

    {{-- edit modal --}}
    @include('user.home_page.brand_section.edit')
@endsection
