<div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
  aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLongTitle">{{ __('Update Gallery Info') }}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>

      <div class="modal-body">
        <form id="ajaxEditForm" class="modal-form" action="{{ route('tenant.gallery_management.update_gallery_info') }}"
          method="POST" enctype="multipart/form-data">
          @csrf
          <input type="hidden" id="in_id" name="gallery_id">

          <div class="form-group">
            <label for="image"><strong> {{  __('Image') }} <span class="text-danger">**</span></strong></label>
            <div class="showImage2 mb-3">
              <img src="" alt="gallery image" class="gallery-img img-thumbnail">
            </div>
            <div role="button" class="btn btn-primary btn-sm upload-btn" id="image2">
              {{  __('Choose Image') }}
              <input type="file" class="img-input" name="gallery_img">
            </div>
            <p id="editErr_gallery_img" class="mt-2 mb-0 text-danger em"></p>
          </div>

          <div class="form-group">
            <label>{{  __('Category') }} <span class="text-danger">**</span></label>
            <select name="gallery_category_id" id="in_gallery_category_id" class="form-control">
              <option disabled>{{  __('Select a Category') }}</option>
              @foreach ($categories as $category)
                <option value="{{ $category->id }}">{{ $category->name }}</option>
              @endforeach
            </select>
            <p id="editErr_gallery_category_id" class="mt-1 mb-0 text-danger em"></p>
          </div>

          <div class="form-group">
            <label for="">{{  __('Title') }} <span class="text-danger">**</span></label>
            <input type="text" id="in_title" class="form-control" name="title"
              placeholder="{{  __('Enter Title') }}">
            <p id="editErr_title" class="mt-1 mb-0 text-danger em"></p>
          </div>

          <div class="form-group">
            <label for="">{{  __('Serial Number') }} <span class="text-danger">**</span></label>
            <input type="number" id="in_serial_number" class="form-control ltr" name="serial_number"
              placeholder="{{  __('Enter Serial Number') }}">
            <p id="editErr_serial_number" class="mt-1 mb-0 text-danger em"></p>
            <p class="text-warning mt-2">
              <small>{{  __('The higher the serial number, the later it will be displayed.') }}</small>
            </p>
          </div>
        </form>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">
          {{ __('Close') }}
        </button>
        <button id="updateBtn" type="button" class="btn btn-primary">
          {{  __('Update') }}
        </button>
      </div>
    </div>
  </div>
</div>
