@extends('user.layout')

{{-- this style will be applied when the direction of language is right-to-left --}}
@includeIf('user.partials.rtl-style')

@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('Footer Content') }}</h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="{{ route('user-dashboard') }}">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Pages') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Footer') }}</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">{{ __('Footer Content') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 mb-3 mb-lg-0">
                            <div class="card-title">{{ __('Update Footer Content') }}</div>
                        </div>

                        <div class="col-lg-2">
                            @includeIf('user.partials.languages')
                        </div>
                    </div>
                </div>

                <div class="card-body pt-5">
                    <div class="row">
                        <div class="col-lg-6 mx-auto">
                            <form id="ajaxForm"
                                action="{{ route('user.footer.update_content', ['language' => request()->input('language')]) }}"
                                method="post">
                                @csrf

                                <div class="form-group">
                                    <label for="image">{{ __('Logo') }}
                                        <span class="text-danger">**</span></label>
                                    <div class="showImage mb-3">
                                        <img src="{{ $themeInfo->footer_logo ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $themeInfo->footer_logo, $userBs) : asset('assets/tenant/img/default.jpg') }}"
                                            alt="..." class="img-thumbnail">
                                    </div>

                                    <div role="button" class="btn btn-primary btn-sm upload-btn" id="image">
                                        {{ __('Choose Image') }}
                                        <input type="file" class="img-input" name="footer_logo">
                                    </div>

                                    <p id="err_footer_logo" class="mb-0 text-danger em"></p>
                                    <p class="text-warning mb-0">{{ __('Only JPG, JPEG, PNG images are allowed') }}</p>
                                    <p class="text-warning mb-0">
                                        {{ __('Recommended image size:Upload 170 X 50 image for best quality') }}</p>
                                </div>

                                @if (in_array($userBs->theme_version, [
                                        App\Enums\ThemeVersion::ThemeFive->value,
                                        App\Enums\ThemeVersion::ThemeFour->value,
                                        App\Enums\ThemeVersion::ThemeThree->value,
                                    ]))
                                    <div class="form-group">
                                        <div class="col-12 mb-2 pl-0">
                                            <label for="image"><strong>{{ __('Background Image') }} <span
                                                        class="text-danger"></span></strong></label>
                                        </div>
                                        <div class="col-md-12 showImage21 mb-3 pl-0 pr-0">
                                            <img src="{{ $themeInfo->footer_bg_image ? \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FOOTER_LOGO, $themeInfo->footer_bg_image, $userBs) : asset('/assets/tenant/img/default.jpg') }}"
                                                alt="..." class="img-thumbnail">
                                        </div>
                                        <div role="button" class="btn btn-primary btn-sm upload-btn" id="image21">
                                            {{ __('Choose Image') }}
                                            <input type="file" class="img-input" name="footer_bg_image">
                                        </div>
                                        <p id="err_footer_bg_image" class="mb-0 text-danger em">
                                        </p>
                                        <p class="text-warning mb-0">
                                            {{ __('Only JPG, JPEG, PNG images are allowed') }}
                                        </p>
                                        <p class="text-warning">
                                            {{ __('Recommended image size:Upload 1920X600 pixel size image for best quality') }}
                                        </p>
                                    </div>
                                @endif

                                <div class="form-group">
                                    <label>{{ __('About Company') }} </label>
                                    <textarea class="form-control" name="about_company" rows="5" cols="80">{{ !is_null($data) ? $data->about_company : '' }}</textarea>
                                    <p id="err_about_company" class="em text-danger mt-2 mb-0"></p>
                                </div>

                                <div class="form-group">
                                    <label>{{ __('Copyright Text') }} <span class="text-danger">**</span></label>
                                    <textarea id="copyrightSummernote" class="form-control summernote" name="copyright_text" data-height="80">{{ !is_null($data) ? replaceBaseUrl($data->copyright_text, 'summernote') : '' }}</textarea>
                                    <p id="err_copyright_text" class="em text-danger mt-2 mb-0"></p>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 text-center">
                            <button type="button" id="submitBtn" class="btn btn-success">
                                {{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
