@extends('user.layout')

@php
    use App\Http\Helpers\UserPermissionHelper;
    use App\Models\User\Language;
    use Illuminate\Support\Facades\Auth;
    $default = Language::where('is_default', 1)->first();
    $user = Auth::guard('web')->user();
    $package = UserPermissionHelper::currentPackage($user->id);
    if (!empty($user)) {
        $permissions = UserPermissionHelper::packagePermission($user->id);
        $permissions = json_decode($permissions, true);
    }
@endphp

@section('content')
    <div class="mt-2 mb-4">
        <h2 class="pb-2">{{ __('Welcome back') }}, {{ Auth::guard('web')->user()->first_name }}
            {{ Auth::guard('web')->user()->last_name }}!</h2>
    </div>


    @if (is_null($package))
        @php
            $pendingMemb = \App\Models\Membership::query()
                ->where([['user_id', '=', Auth::id()], ['status', 0]])
                ->whereYear('start_date', '<>', '9999')
                ->orderBy('id', 'DESC')
                ->first();
            $pendingPackage = isset($pendingMemb)
                ? \App\Models\Package::query()->findOrFail($pendingMemb->package_id)
                : null;
        @endphp

        @if ($pendingPackage)
            <div class="alert alert-warning">
                {{ __('You have requested a package which needs an action (Approval / Rejection) by Admin. You will be notified via mail once an action is taken.') }}
            </div>
            <div class="alert alert-warning">
                <strong>{{ __('Pending Package') }}: </strong> {{ $pendingPackage->title }}
                <span class="badge badge-secondary">{{ $pendingPackage->term }}</span>
                <span class="badge badge-warning">{{ __('Decision Pending') }}</span>
            </div>
        @else
            <div class="alert alert-warning">
                {{ __('Your membership is expired. Please purchase a new package / extend the current package.') }}
            </div>
        @endif
    @else
        <div class="row justify-content-center align-items-center mb-1">
            <div class="col-12">
                <div class="alert border-left border-primary text-dark">
                    @if ($package_count >= 2)
                        @if ($next_membership->status == 0)
                            <strong
                                class="text-danger">{{ __('You have requested a package which needs an action (Approval / Rejection) by Admin. You will be notified via mail once an action is taken.') }}</strong><br>
                        @elseif ($next_membership->status == 1)
                            <strong
                                class="text-danger">{{ __('You have another package to activate after the current package expires. You cannot purchase / extend any package, until the next package is activated') }}</strong><br>
                        @endif
                    @endif

                    <strong>{{ __('Current Package') }}: </strong> {{ $current_package->title }}
                    <span class="badge badge-secondary">{{ $current_package->term }}</span>
                    @if ($current_membership->is_trial == 1)
                        ({{ __('Expire Date') }}:
                        {{ Carbon\Carbon::parse($current_membership->expire_date)->format('M-d-Y') }})
                        <span class="badge badge-primary">{{ __('Trial') }}</span>
                    @else
                        ({{ __('Expire Date') }}:
                        {{ $current_package->term === 'lifetime' ? 'Lifetime' : Carbon\Carbon::parse($current_membership->expire_date)->format('M-d-Y') }})
                    @endif

                    @if ($package_count >= 2)
                        <div>
                            <strong>{{ __('Next Package To Activate') }}: </strong> {{ $next_package->title }} <span
                                class="badge badge-secondary">{{ $next_package->term }}</span>
                            @if ($current_package->term != 'lifetime' && $current_membership->is_trial != 1)
                                (
                                {{ __('Activation Date') }}:
                                {{ Carbon\Carbon::parse($next_membership->start_date)->format('M-d-Y') }},
                                {{ __('Expire Date') }}:
                                {{ $next_package->term === 'lifetime' ? 'Lifetime' : Carbon\Carbon::parse($next_membership->expire_date)->format('M-d-Y') }})
                            @endif
                            @if ($next_membership->status == 0)
                                <span class="badge badge-warning">{{ __('Decision Pending') }}</span>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif

    <div class="row">

        @if (!is_null($package))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-primary"
                    href="{{ route('tenant.rooms_management.rooms', ['language' => $default->code]) }}" target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                    <i class="fas fa-hotel"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Rooms') }}</p>
                                    <h4 class="card-title">{{ $roomsCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif
        @if (!is_null($package))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-info"
                    href="{{ route('tenant.room_bookings.all_bookings', ['language' => $default->code]) }}"
                    target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                      <i class="fas fa-hotel"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('All Room Bookings') }}</p>
                                    <h4 class="card-title">{{ $allRbCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif
        @if (!is_null($package))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-secondary"
                    href="{{ route('tenant.room_bookings.paid_bookings', ['language' => $default->code]) }}"
                    target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                   <i class="fas fa-check-square"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Paid Room Bookings') }}</p>
                                    <h4 class="card-title">{{ $paidRbCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif
        @if (!is_null($package) && in_array('Tour Package', $permissions))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-success"
                    href="{{ route('tenant.packages_management.packages', ['language' => $default->code]) }}"
                    target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                 <i class="fas fa-boxes"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Packages') }}</p>
                                    <h4 class="card-title">{{ $packagesCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif
        
        @if (!is_null($package) && in_array('Tour Package', $permissions))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-warning"
                    href="{{ route('tenant.package_bookings.all_bookings', ['language' => $default->code]) }}"
                    target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                        <i class="fas fa-boxes"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('All Package Bookings') }}</p>
                                    <h4 class="card-title">{{ $allPbCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif

        @if (!is_null($package) && in_array('Tour Package', $permissions))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round card-danger"
                    href="{{ route('tenant.package_bookings.paid_bookings', ['language' => $default->code]) }}"
                    target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                            <i class="fas fa-check-square"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Paid Package Bookings') }}</p>
                                    <h4 class="card-title">{{ $paidPbCount }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif

        @if (!is_null($package))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-round"
                    href="{{ route('tenant.gallery_management.images', ['language' => $default->code]) }}" target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                  <i class="fas fa-images"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Galleries') }}</p>
                                    <h4 class="card-title">{{ $galleries }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-primary card-round"
                    href="{{ route('tenant.services_management', ['language' => $default->code]) }}" target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                   <i class="fas fa-users-cog"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Services') }}</p>
                                    <h4 class="card-title">{{ $services }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif


        @if (!empty($permissions) && in_array('Blog', $permissions))
            <div class="col-sm-6 col-md-4">
                <a class="card card-stats card-success card-round"
                    href="{{ route('user.blog_management.blogs', ['language' => $default->code]) }}" target="_blank">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-5">
                                <div class="icon-big text-center">
                                    <i class="fas fa-blog"></i>
                                </div>
                            </div>
                            <div class="col-7 col-stats">
                                <div class="numbers">
                                    <p class="card-category">{{ __('Blogs') }}</p>
                                    <h4 class="card-title">{{ $blogs }}</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endif
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">{{ __('Monthly Room Bookings') }} ({{ date('Y') }})</div>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="roomBookinglineChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">{{ __('Monthly Room Booking Income') }} ({{ date('Y') }})</div>
                </div>
                <div class="card-body">
                    <div class="chart-container">
                        <canvas id="roomBookingIncomelineChart"></canvas>
                    </div>
                </div>
            </div>
        </div>


        @if (!empty($permissions) && in_array('Tour Package', $permissions))
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">{{ __('Monthly Package Bookings') }} ({{ date('Y') }})</div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="packageBookinglineChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">{{ __('Monthly Package Booking Income') }} ({{ date('Y') }})</div>
                    </div>
                    <div class="card-body">
                        <div class="chart-container">
                            <canvas id="packageBookingIncomelineChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        @endif


    </div>
@endsection
@php
    $months = [];
    $inTotalRoomBookings = [];
    $roomIncomeTotals = [];

    $inTotalPackageBookings = [];
    $packageBookingIncomeTotals = [];

    for ($i = 1; $i <= 12; $i++) {
        $monthNum = $i;
        $dateObj = DateTime::createFromFormat('!m', $monthNum);
        $months[] = $dateObj->format('M');

        //room bookings
        $inFound = 0;
        foreach ($monthy_room_bookings as $key => $income) {
            if ($income->month == $i) {
                $inTotalRoomBookings[] = $income->total;
                $inFound = 1;
                break;
            }
        }
        if ($inFound == 0) {
            $inTotalRoomBookings[] = 0;
        }

        //room incomes
        $roomIncomFound = 0;
        foreach ($monthy_room_booking_incomes as $key => $booking) {
            if ($booking->month == $i) {
                $roomIncomeTotals[] = $booking->total;
                $roomIncomFound = 1;
                break;
            }
        }
        if ($roomIncomFound == 0) {
            $roomIncomeTotals[] = 0;
        }

        //package bookings
        $packageBookingFound = 0;
        foreach ($monthy_package_bookings as $key => $income) {
            if ($income->month == $i) {
                $inTotalPackageBookings[] = $income->total;
                $packageIncomFound = 1;
                break;
            }
        }
        if ($packageBookingFound == 0) {
            $inTotalPackageBookings[] = 0;
        }

        //package incomes
        $packageIncomFound = 0;
        foreach ($monthy_package_booking_incomes as $key => $income) {
            if ($income->month == $i) {
                $packageBookingIncomeTotals[] = $income->total;
                $packageIncomFound = 1;
                break;
            }
        }
        if ($packageIncomFound == 0) {
            $packageBookingIncomeTotals[] = 0;
        }
    }

@endphp
@section('script')
    <!-- Chart JS -->
    <script src="{{ asset('assets/admin/js/plugin/chart.min.js') }}"></script>
    <script>
        "use strict";
        var months = @php echo json_encode($months) @endphp;
        var inTotalRoomBookings = @php echo json_encode($inTotalRoomBookings) @endphp;
        var roomIncomeTotals = @php echo json_encode($roomIncomeTotals) @endphp;

        var package_permission = "{{ in_array('Tour Package', $permissions) ? 1 : 0 }}";
        var inTotalPackageBookings = @php echo json_encode($inTotalPackageBookings) @endphp;
        var packageBookingIncomeTotals = @php echo json_encode($packageBookingIncomeTotals) @endphp;
    </script>
    <script src="{{ asset('assets/tenant/js/dashboard.js') }}"></script>
@endsection
