@extends('user-front.common.layout')

@section('pageHeading')
  {{ $keywords['Home'] ?? __('Home') }}
@endsection

@php
  $metaKeywords = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
  $metaDescription = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
  $additional_section_status = json_decode($sections->additional_section_status, true);
@endphp
@section('meta-keywords', "$metaKeywords ")
@section('meta-description', "$metaDescription")
@section('content')

  <!-- Home-area start-->
  @includeIf('user-front.common.hero.theme3.slider')
  <!-- Home-area end -->

  <!-- After Search Section -->
  @if (isset($after_search) && count($after_search) > 0)
    @foreach ($after_search as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();

          @endphp
           @if(!is_null($cusHeroContent))
            @includeIf('user-front.common.additional-section', [
                'data' => $cusHeroContent,
                'possition' => $cusHero->possition,
            ])
          @endif
        @endif
      @endif
    @endforeach
  @endif

  <!-- About-area start -->
  @if ($sections->intro_section == 1)
    <section class="about-area about-1 pt-100 pb-60">
      <div class="container">

        <div class="row align-items-center">
          <div class="col-lg-6" data-aos="fade-up">
            <div class="image mb-40">
              <div class="img-1">
                <img class="blur-up lazyload"
                  data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_img, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                  alt="Image">
              </div>
              <div class="img-2">
                <img class="lazyload blur-up"
                  data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_image_two, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                  alt="Image">
              </div>
              <div class="img-3">
                <img class="lazyload blur-up"
                  data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_image_three, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                  alt="Image">
              </div>

            </div>
          </div>
          <div class="col-lg-6" data-aos="fade-up">
            <div class="content-title mb-40">
              @if (!is_null($secHeading))
                <h2 class="title mb-20">
                  {{ $secHeading->intro_primary_title }}
                </h2>
                <p>
                  {{ $secHeading->intro_secondary_title }}
                </p>
                <blockquote class="blockquote mt-30">
                  {{ $secHeading->intro_text }}
                </blockquote>
              @endif

              <div class="info-list mt-40">
                <div class="row align-items-center">
                  @if (count($counterInfos) > 0)
                    @foreach ($counterInfos as $counterInfo)
                      <div class="col-md-6 col-lg-12 col-xxl-6">
                        <div class="card mb-30">
                          <div class="card-icon rounded-pill">
                            <i class="{{ $counterInfo->icon }}"></i>
                          </div>
                          <div class="card-content">
                            <h6 class="mb-2 text-center">{{ $counterInfo->amount }}+</h6>
                            <p class="card-text">{{ $counterInfo->title }}</p>
                          </div>
                        </div>
                      </div>
                    @endforeach
                  @endif
                </div>
              </div>
              <div class="d-flex align-items-center flex-wrap gap-3 mt-10" data-aos="fade-up">
                @if ($secHeading->intro_button_url)
                  <a href="{{ $secHeading->intro_button_url }}" class="btn btn-lg btn-primary"
                    target="_self">{{ $secHeading->intro_button_text }}</a>
                @endif
                @if($secHeading->intro_member_image_show ==1)
                @if (!empty($secHeading->intro_member_image))
                  <div class="clients-avatar">
                    <img
                      src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_member_image, $userBs) }}"
                      alt="">
                  </div>
                @endif
                @endif
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif
  <!-- About-area end -->

  <!-- After intro Section -->
  @if (isset($after_intro) && count($after_intro) > 0)
  
    @foreach ($after_intro as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
           @if(!is_null($cusHeroContent))
          @include('user-front.common.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
        @endif
        @endif
      @endif
    @endforeach
  @endif

  <!-- Category-area start -->
  @if ($sections->featured_rooms_category_section == 1)
    <section class="category-area category-1 pt-100 pb-75 bg-img z-1 lazyload"
      data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_ROOM_IMAGE, $secHeading->room_category_section_image, $userBs, 'assets/user-front/default-img/category-bg-1.jpg') }}">
      <div class="overlay opacity-75"></div>
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-center mw-100 mb-50" data-aos="fade-up">
              @if (!is_null($secHeading))
                <h2 class="title text-white">{{ $secHeading->room_category_section_title }}</h2>
              @endif
            </div>
          </div>
          <div class="col-12">
            <div class="row">
              @foreach ($room_categories as $room_category)
                <div class="col-lg-4" data-aos="fade-up">
                  <div class="row">
                    <div class="col-lg-12 col-md-6">
                      <div class="card radius-md mb-25">
                        <a href="{{ route('rooms', [getParam(), 'category' => $room_category->slug]) }}" target="_self"
                          title="Link">
                          <div class="card-img">
                            <div class="lazy-container ratio ratio-5-3">
                              <img class=" ls-is-cached lazyload"
                                data-src="{{ asset(Constant::WEBSITE_ROOM_IMAGE . '/' . $room_category->image) }}"
                                alt="{{ $room_category->name }}">
                            </div>
                          </div>
                          <div class="card-text text-center">
                            <h5 class="card-title mb-1">{{ $room_category->name }}</h5>
                          </div>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif
  <!-- Category-area end -->

  <!-- After featured rooms section -->
  @if (isset($after_rooms_category) && count($after_rooms_category) > 0)
    @foreach ($after_rooms_category as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
           @if(!is_null($cusHeroContent))
            @includeIf('user-front.common.additional-section', [
                'data' => $cusHeroContent,
                'possition' => $cusHero->possition,
            ])
          @endif
        @endif
      @endif
    @endforeach
  @endif


  <!-- Product-area start -->
  @if ($sections->featured_rooms_section == 1)
    <!-- Product-area start -->
    <section class="product-area ptb-100">
      <div class="container">
        <div class="row">
          <div class="col-12" data-aos="fade-up">
            <div class="section-title title-inline mb-50" data-aos="fade-up">
              @if (!empty($secHeading))
                <h2 class="title">{{ convertUtf8($secHeading->room_section_title) }}</h2>
              @endif
              @if (count($roomInfos) > 3)
                <a href="{{ route('rooms', getParam()) }}" class="btn btn-lg btn-primary" target="_self"
                  title="{{ $keywords['Show More'] ?? __('Show More') }}">{{ $keywords['Show More'] ?? __('Show More') }}</a>
              @endif
            </div>
          </div>
          <div class="col-12">
            <div class="swiper product-inline-slider" id="product-inline-slider-1" data-slides-per-view="2">
              <div class="swiper-wrapper" aria-live="off">
                @foreach ($roomInfos as $roomInfo)
                  @if (!empty($roomInfo->room))
                    <div class="swiper-slide" data-aos="fade-up">
                      <div class="row g-0 product-default product-column border radius-md mb-25 align-items-center">
                        <figure class="product-img col-sm-12 col-md-5">
                          <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                            class="lazy-container ratio ratio-5-4" target="_self" title="Link">

                            <img class="lazyload"
                              data-src="{{ asset(Constant::WEBSITE_ROOM_IMAGE . '/' . $roomInfo->room->featured_img) }}"
                              alt="Product">
                          </a>
                        </figure>
                        <div class="product-details col-sm-12 col-md-7">
                          <div class="d-flex align-items-center gap-3">
                            <span class="product-tag border radius-sm">
                              @php
                                $category = \App\Models\User\RoomCategory::where(
                                    'indx',
                                    $roomInfo->room->category_index,
                                )
                                    ->where('language_id', $roomInfo->language_id)
                                    ->first();
                              @endphp
                              {{ !is_null($category) ? $category->name : '' }}
                            </span>

                            <div class="product-price">
                              <span class="h6 new-price color-primary">
                                {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                                {{ $roomInfo->room->rent }}
                                {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                / {{ $keywords['Night'] ?? __('Night') }}
                              </span>
                            </div>
                          </div>
                          <h5 class="product-title lc-2 mt-2 mb-15">
                            <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                              target="_self"
                              title="Link">{{ strlen($roomInfo->title) > 50 ? mb_substr($roomInfo->title, 0, 150, 'utf-8') . '...' : $roomInfo->title }}</a>
                          </h5>
                          <ul class="product-icon-list list-unstyled d-flex align-items-center">
                            <li class="icon-start">
                              <i class="fal fa-bed"></i>
                              <span>
                                {{ $roomInfo->room->bed }}
                                {{ $roomInfo->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                              </span>
                            </li>

                            <li class="icon-start">
                              <i class="fal fa-bath"></i>
                              <span> {{ $roomInfo->room->bath }}
                                {{ $roomInfo->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}</span>
                            </li>
                            @if (!is_null($roomInfo->room->max_guests))
                              <li class="icon-start">
                                <i class="fal fa-bath"></i>
                                <span> {{ $roomInfo->room->max_guests }}
                                  {{ $roomInfo->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}</span>
                              </li>
                            @endif
                          </ul>
                        </div>
                      </div>
                    </div>
                  @endif
                @endforeach
              </div>
              <div
                class="swiper-pagination position-static swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal"
                id="product-inline-slider-1-pagination"><span
                  class="swiper-pagination-bullet swiper-pagination-bullet-active" tabindex="0" role="button"
                  aria-label="Go to slide 1" aria-current="true"></span><span class="swiper-pagination-bullet"
                  tabindex="0" role="button" aria-label="Go to slide 2"></span></div>
              <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif
  <!-- Product-area end -->


  <!-- After featured rooms section -->
  @if (isset($after_featured_package) && count($after_featured_package) > 0)
    @foreach ($after_featured_package as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
           @if(!is_null($cusHeroContent))
          @includeIf('user-front.common.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
          @endif
        @endif
      @endif
    @endforeach
  @endif

  <!-- Product-area start -->
  @if ($sections->latest_rooms_section == 1)
    <!-- Room latest Section Start -->
    <section class="product-area pb-100">
      <div class="container">
        <div class="row">
          <div class="col-12" data-aos="fade-up">
            <div class="section-title title-center mb-50" data-aos="fade-up">
              @if (!empty($secHeading))
                <h2 class="title mb-30">
                  {{ $secHeading->latest_room_section_title }}
                </h2>
              @endif
              <div class="tabs-navigation-area">
                <ul class="nav nav-tabs" data-hover="fancyHover" role="tablist">
                  <li class="nav-item active" role="presentation">
                    <button class="nav-link hover-effect btn-md radius-sm active" data-bs-toggle="tab"
                      data-bs-target="#tab1" type="button" aria-selected="true"
                      role="tab">{{ $keywords['All Rooms'] ?? __('All Rooms') }}</button>
                  </li>
                  @foreach ($room_categories as $category)
                    <li class="nav-item" role="presentation">
                      <button class="nav-link hover-effect  btn-md radius-sm" data-bs-toggle="tab"
                        data-bs-target="#tab{{ $category->id }}" type="button" aria-selected="true"
                        role="tab">{{ $category->name }}</button>
                    </li>
                  @endforeach
                </ul>
              </div>
            </div>
          </div>
          <div class="col-12">
            <div class="tab-content">
              <div class="tab-pane slide active" id="tab1" role="tabpanel">
                <div class="row">
                  @forelse ($latestRoomInfos as $key => $roomInfo)
                    @if (!empty($roomInfo->room) && $key < 6)
                      <div class="col-lg-6" data-aos="fade-up">
                        <div class="row g-0 product-default product-column border radius-md mb-25 align-items-center">
                          <figure class="product-img col-sm-12 col-md-5">
                            <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                              class="lazy-container ratio ratio-5-4" target="_self" title="Link">
  
                              <img class="lazyload"
                                data-src="{{ asset(Constant::WEBSITE_ROOM_IMAGE . '/' . $roomInfo->room->featured_img) }}"
                                alt="Product">
                            </a>
                          </figure>
                          <div class="product-details col-sm-12 col-md-7">
                            <div class="d-flex align-items-center gap-3">
                              <span class="product-tag border radius-sm">
                                @php
                                  $category = \App\Models\User\RoomCategory::where(
                                      'indx',
                                      $roomInfo->room->category_index,
                                  )
                                      ->where('language_id', $roomInfo->language_id)
                                      ->first();
                                @endphp
                                {{ !is_null($category) ? $category->name : '' }}
                              </span>
  
                              <div class="product-price">
                                <span class="h6 new-price color-primary">
                                  {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                                  {{ $roomInfo->room->rent }}
                                  {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                  / {{ $keywords['Night'] ?? __('Night') }}
                                </span>
                              </div>
                            </div>
                            <h5 class="product-title lc-2 mt-2 mb-15">
                              <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                                target="_self"
                                title="Link">{{ strlen($roomInfo->title) > 50 ? mb_substr($roomInfo->title, 0, 150, 'utf-8') . '...' : $roomInfo->title }}</a>
                            </h5>
                            <ul class="product-icon-list list-unstyled d-flex align-items-center">
                              <li class="icon-start">
                                <i class="fal fa-bed"></i>
                                <span>
                                  {{ $roomInfo->room->bed }}
                                  {{ $roomInfo->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                                </span>
                              </li>
  
                              <li class="icon-start">
                                <i class="fal fa-bath"></i>
                                <span> {{ $roomInfo->room->bath }}
                                  {{ $roomInfo->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}</span>
                              </li>
                              @if (!is_null($roomInfo->room->max_guests))
                                <li class="icon-start">
                                  <i class="fal fa-bath"></i>
                                  <span> {{ $roomInfo->room->max_guests }}
                                    {{ $roomInfo->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}</span>
                                </li>
                              @endif
                            </ul>
                          </div>
                        </div>
                      </div>
                    @endif
                  @empty
                    <h3 class="text-center">
                      {{ $keywords['No Room Found!'] ?? __('No Room Found!') }}
                    </h3>
                  @endforelse
                  
                  @if (count($latestRoomInfos) > 6)
                    <div class="text-center mt-20" data-aos="fade-up">
                      <a href="{{ route('rooms', getparam()) }}" class="btn btn-lg btn-primary fancy">
                        {{ $keywords['View All Items'] ?? __('View All Items') }}
                      </a>
                    </div>
                  @endif

                </div>
              </div>
              @foreach ($room_categories as $room_category)
                <div class="tab-pane slide" id="tab{{ $room_category->id }}" role="tabpanel">
                  <div class="row">
                    @php
                      $latestRooms = $latestRoomInfos->filter(function ($room_content) use ($room_category) {
                          return $room_content->room->category_index == $room_category->indx;
                      })->take(6);
                    @endphp
                    @forelse ($latestRooms as $roomInfo)
                      @if ($roomInfo->room )
                      <div class="col-lg-6" data-aos="fade-up">
                        <div class="row g-0 product-default product-column border radius-md mb-25 align-items-center">
                          <figure class="product-img col-sm-12 col-md-5">
                            <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                              class="lazy-container ratio ratio-5-4" target="_self" title="Link">
  
                              <img class="lazyload"
                                data-src="{{ asset(Constant::WEBSITE_ROOM_IMAGE . '/' . $roomInfo->room->featured_img) }}"
                                alt="Product">
                            </a>
                          </figure>
                          <div class="product-details col-sm-12 col-md-7">
                            <div class="d-flex align-items-center gap-3">
                              <span class="product-tag border radius-sm">
                                @php
                                  $category = \App\Models\User\RoomCategory::where(
                                      'indx',
                                      $roomInfo->room->category_index,
                                  )->where('language_id', $roomInfo->language_id)
                                  ->first();

                                @endphp
                                {{ !is_null($category) ? $category->name : '' }}
                              </span>
  
                              <div class="product-price">
                                <span class="h6 new-price color-primary">
                                  {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                                  {{ $roomInfo->room->rent }}
                                  {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                  / {{ $keywords['Night'] ?? __('Night') }}
                                </span>
                              </div>
                            </div>
                            <h5 class="product-title lc-2 mt-2 mb-15">
                              <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                                target="_self"
                                title="Link">{{ strlen($roomInfo->title) > 50 ? mb_substr($roomInfo->title, 0, 150, 'utf-8') . '...' : $roomInfo->title }}</a>
                            </h5>
                            <ul class="product-icon-list list-unstyled d-flex align-items-center">
                              <li class="icon-start">
                                <i class="fal fa-bed"></i>
                                <span>
                                  {{ $roomInfo->room->bed }}
                                  {{ $roomInfo->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                                </span>
                              </li>
  
                              <li class="icon-start">
                                <i class="fal fa-bath"></i>
                                <span> {{ $roomInfo->room->bath }}
                                  {{ $roomInfo->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}</span>
                              </li>
                              @if (!is_null($roomInfo->room->max_guests))
                                <li class="icon-start">
                                  <i class="fal fa-bath"></i>
                                  <span> {{ $roomInfo->room->max_guests }}
                                    {{ $roomInfo->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}</span>
                                </li>
                              @endif
                            </ul>
                          </div>
                        </div>
                      </div>
                      @endif
                    @empty
                      <h3 class="text-center">
                        {{ $keywords['No Room Found!'] ?? __('No Room Found!') }}
                      </h3>
                    @endforelse
                    @if (count($latestRooms) > 6)
                      <div class="text-center mt-20" data-aos="fade-up">
                        <a href="{{ route('rooms', [getparam(), 'category' => $room_category->slug]) }}"
                          class="btn btn-lg btn-primary fancy">
                          {{ $keywords['View All Items'] ?? __('View All Items') }}
                        </a>
                      </div>
                    @endif
                  </div>
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Room latest Section End -->
  @endif
  <!-- Product-area end -->

  <!-- After featured package section -->
  @if (isset($after_latest_rooms) && count($after_latest_rooms) > 0)
    @foreach ($after_latest_rooms as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
           @if(!is_null($cusHeroContent))
          @includeIf('user-front.common.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
          @endif
        @endif
      @endif
    @endforeach
  @endif


  <!-- Choose-area start -->
  @if ($sections->featured_services_section == 1)
    <section class="choose-area pb-60">
      <div class="container">
        <div class="row gx-xl-4 align-items-center">
          <div class="col-lg-6">
            <div class="content mb-40" data-aos="fade-right">
              @if (!is_null($secHeading))
                <div class="content-title">
                  <h2 class="title mb-30">{{ $secHeading->service_section_title }}</h2>
                </div>
                <div class="w-75 w-sm-100">
                  <p class="text">{{ $secHeading->service_section_subtitle }}</p>
                </div>
              @endif
              <div class="choose-grid mt-40">
                @foreach ($serviceInfos as $serviceInfo)
                  @if ($serviceInfo->service)
                    <div class="grid-item border radius-md p-20">
                      <div class="icon mb-20">
                        @if ($serviceInfo->service->details_page_status == 0)
                          <i class="{{ $serviceInfo->service->service_icon }}"></i>
                        @else
                          <a href="{{ route('service_details', [getParam(), 'slug' => $serviceInfo->slug]) }}">
                            <i class="{{ $serviceInfo->service->service_icon }}"></i></a>
                        @endif
                      </div>
                      <h6 class="mb-0 lc-1">
                        <a href="{{ route('service_details', [getParam(), 'slug' => $serviceInfo->slug]) }}">{{ $serviceInfo->title }}</a>
                        
                      </h6>
                    </div>
                  @endif
                @endforeach
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="image mb-40 img-right" data-aos="fade-left">
              @if ($sections->video_section == 1)
                <div class="img-1">
                  <img class="lazyload blur-up"
                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $secHeading->video_section_image, $userBs, 'assets/user-front/default-img/choose-1-2.jpg') }}"
                    alt="Image">
                </div>
                <div class="img-2">
                  <img class="lazyload blur-up"
                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $secHeading->video_section_image_two, $userBs, 'assets/user-front/default-img/choose-1-1.jpg') }}"
                    alt="Image">
                  @if (!empty($secHeading->video_section_video_url))
                    <a href="{{ $secHeading->video_section_video_url }}"
                      class="video-btn youtube-popup p-absolute" title="Play Video">
                      <i class="fas fa-play"></i>
                    </a>
                  @endif
                </div>
              @endif
            </div>
          </div>
        </div>
      </div>
    </section>
  @endif


  <!-- Choose-area end -->
  @if (isset($after_featured_services) && count($after_featured_services) > 0)
    @foreach ($after_featured_services as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
           @if(!is_null($cusHeroContent))
          @includeIf('user-front.common.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
          @endif
        @endif
      @endif
    @endforeach
  @endif


  <!-- Counter-area start -->
  @if ($sections->statistics_section == 1)
    <div class="counter-area pt-60 pb-30 bg-img lazyload"
      data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_STATISTICS_SECTION_IMAGE, $secHeading->statistics_section_image, $userBs, 'assets/user-front/default-img/statitics-bg-1.jpg') }}">
      <div class="overlay opacity-75"></div>
      <div class="container">
        <div class="d-flex justify-content-center align-items-center">
          @if (count($counterInfos) > 0)
            @foreach ($counterInfos as $counterInfo)
              <div class="col-sm-6 col-lg-3" data-aos="fade-up">
                <div class="card text-center mb-30">
                  <div class="card-icon color-primary mb-10">
                    <i class="{{ $counterInfo->icon }}"></i>
                  </div>
                  <div class="card-content">
                    <span class="h2 mb-1 color-white"><span class="counter">{{ $counterInfo->amount }}</span></span>
                    <p class="card-text font-lg color-medium lh-1">{{ $counterInfo->title }}</p>
                  </div>
                </div>
              </div>
            @endforeach
          @endif
        </div>
      </div>
    </div>
  @endif
  <!-- Counter-area end -->


  @if (isset($after_statistics) && count($after_statistics) > 0)
    @foreach ($after_statistics as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
          @if(!is_null($cusHeroContent))
          @includeIf('user-front.common.additional-section', [
              'data' => $cusHeroContent,
              'possition' => $cusHero->possition,
          ])
          @endif
        @endif
      @endif
    @endforeach
  @endif


  <!-- Testimonial-area start -->
  @if ($sections->testimonials_section == 1)
    <section class="testimonial-area testimonial-1 ptb-100">
      <div class="container">
        <div class="section-title title-inline mb-50" data-aos="fade-up">
          <h2 class="title">{{ $secHeading->testimonial_section_title }}</h2>
          <!-- Slider navigation buttons -->
          @if (count($testimonials) > 0)
            <div class="slider-navigation text-end">
              <button type="button" title="Slide prev" class="slider-btn" id="testimonial-slider-1-prev">
                <i class="fal fa-angle-left"></i>
              </button>
              <button type="button" title="Slide next" class="slider-btn" id="testimonial-slider-1-next">
                <i class="fal fa-angle-right"></i>
              </button>
            </div>
          @endif
        </div>

        @if (count($testimonials) > 0)
          <div class="swiper testimonial-slider swiper-initialized swiper-horizontal swiper-pointer-events"
            id="testimonial-slider-1" data-slides-per-view="4">
            <div class="swiper-wrapper" id="swiper-wrapper-fae86b5b0937c48c" aria-live="off"
              style="transform: translate3d(-2311.75px, 0px, 0px); transition-duration: 0ms;">
              @foreach ($testimonials as $testimonial)
                <div class="swiper-slide pb-25" data-aos="fade-up" data-swiper-slide-index="1" role="group"
                  aria-label="2 / 4" style="width: 305.25px; margin-right: 25px;">
                  <div class="slider-item test-item{{ $loop->iteration }} radius-md mt-15">
                    <div class="client p-25">
                      <div class="client-img">
                        <div class="lazy-container rounded-pill ratio ratio-1-1">
                          <img class="lazyload"
                            data-src="{{ asset(Constant::WEBSITE_TESTIMONIAL_CLIENT_IMAGE . '/' . $testimonial->image) }}"
                            alt="Person Image">
                        </div>
                      </div>
                      <div class="content">
                        <h6 class="name mb-1">{{ $testimonial->name }}</h6>
                        <span class="designation font-sm">{{ $testimonial->designation }}</span>
                      </div>
                    </div>
                    <div class="quote p-25">
                      <span class="icon">
                        <i class="fal fa-quote-right"></i>
                      </span>
                      <p class="text mb-0">
                        {{ $testimonial->comment }}
                      </p>
                    </div>
                  </div>
                </div>
              @endforeach
            </div>
            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
          </div>
        @else
          <div class="row text-center">
            <div class="col">
              <h3 class="">{{ $keywords['No Testimonial Found!'] ?? __('No Testimonial Found!') }}
              </h3>
            </div>
          </div>
        @endif
      </div>
    </section>
  @endif
  <!-- Testimonial-area end -->

  <!-- After testimonials section -->
  @if (isset($after_testimonials) && count($after_testimonials) > 0)
    @foreach ($after_testimonials as $cusHero)
      @if (isset($additional_section_status[$cusHero->id]))
        @if ($additional_section_status[$cusHero->id] == 1)
          @php
            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                ['language_id', $language->id],
                ['addition_section_id', $cusHero->id],
            ])->first();
          @endphp
          @if(!is_null($cusHeroContent))
            @includeIf('user-front.common.additional-section', [
                'data' => $cusHeroContent,
                'possition' => $cusHero->possition,
            ])
          @endif
        @endif
      @endif
    @endforeach
  @endif
@endsection
@section('script')
  <script src="{{ asset('assets/user-front/js/home.js') }}"></script>
@endsection
