@extends('user-front.common.layout')

@section('pageHeading')
     {{ $keywords['Home'] ??__('Home') }}
@endsection

@php
    $metaKeywords = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
    $metaDescription = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';

    $additional_section_status = json_decode($sections->additional_section_status, true);
@endphp
@section('meta-keywords', "$metaKeywords ")
@section('meta-description', "$metaDescription")

@section('content')
    <main>
     
        @if ($userBs->home_version == 'slider')
            @includeIf('user-front.common.hero.theme1.slider')
        @elseif($userBs->home_version == 'static')
            @includeIf('user-front.common.hero.theme1.static')
        @elseif($userBs->home_version == 'video')
            @includeIf('user-front.common.hero.theme1.video')
        @elseif ($userBs->home_version == 'particles')
            @includeIf('user-front.common.hero.theme1.particles')
        @elseif ($userBs->home_version == 'water')
            @includeIf('user-front.common.hero.theme1.water')
        @elseif ($userBs->home_version == 'parallax')
            @includeIf('user-front.common.hero.theme1.parallax')
        @endif

        @if ($sections->search_section == 1)
            <!-- Booking Search Form Start -->
            <section class="booking-section">
                <div class="container">
                    <div class="booking-form-wrap bg-img-center section-bg">
                        <form action="{{ route('rooms', getParam()) }}" method="GET">
                            <div class="row no-gutters">
                                <div class="col-lg-3 col-md-6">
                                    <div class="input-wrap">
                                        <input type="text"
                                            placeholder="{{ $keywords['Check In / Out Date'] ?? __('Check In / Out Date') }}"
                                            id="date-range" name="dates" readonly>
                                        <i class="far fa-calendar-alt"></i>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6">
                                    <div class="input-wrap">
                                        <input type="text" placeholder="{{ $keywords['Location'] ?? __('Location') }}" name="location">
                                        <i class="fas fa-map-marker"></i>
                                    </div>
                                </div>

                                <div class="col-lg-2 col-md-6">
                                    <div class="input-wrap">
                                        <select name="beds" class="nice-select">
                                            <option selected disabled>{{ $keywords['Beds'] ?? __('Beds') }}</option>

                                            @for ($i = 1; $i <= $numOfBed; $i++)
                                                <option value="{{ $i }}">{{ $i }}</option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6">
                                    <div class="input-wrap">
                                        <button type="submit" class="btn filled-btn btn-block rounded-0">
                                            {{ $keywords['search'] ?? __('search') }}
                                            <i class="far fa-long-arrow-right"></i>
                                        </button>
                                    </div>
                                </div>

                            </div>
                        </form>

                        <div class="booking-shape-1">
                            <img class="lazy" data-src="{{ asset('assets/tenant/img/shape/01.png') }}" alt="shape">
                        </div>
                        <div class="booking-shape-2">
                            <img class="lazy" data-src="{{ asset('assets/tenant/img/shape/02.png') }}" alt="shape">
                        </div>
                        <div class="booking-shape-3">
                            <img class="lazy" data-src="{{ asset('assets/tenant/img/shape/03.png') }}" alt="shape">
                        </div>
                    </div>
                </div>
            </section>
            <!-- Booking Search Form End -->
        @endif


        <!-- After Search Section -->
        @if (isset($after_search) && count($after_search) > 0)
            @foreach ($after_search as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();

                        @endphp
                        {{-- @dd($cusHeroContent) --}}
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ]);
                    @endif
                @endif
            @endforeach
        @endif


        @if ($sections->intro_section == 1)
            <!-- Welcome Section Start -->
            <section class="welcome-section section-padding">
                <div class="container">
                    <div class="row align-items-center no-gutters">
                        <div class="col-lg-6">
                            <div class="title-gallery">
                                @if (!is_null($secHeading->intro_img))
                                    <img class="lazy"
                                        data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_img, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                                        alt="image">
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-5 offset-lg-1">
                            <!-- Section Title -->
                            <div class="section-title">
                                @if (!is_null($secHeading))
                                    @if (!empty($secHeading->intro_primary_title))
                                        <span class="title-top with-border">{{ $secHeading->intro_primary_title }}</span>
                                    @endif

                                    <h1>{{ $secHeading->intro_secondary_title }}</h1>
                                    <p>{{ $secHeading->intro_text }}</p>
                                @endif
                            </div>

                            @if ($sections->statistics_section == 1)
                                <!-- Counter Start -->
                                <div class="counter">
                                    <div class="row">
                                        @if (count($counterInfos) > 0)
                                            @foreach ($counterInfos as $counterInfo)
                                                <div class="col-sm-4">
                                                    <div class="counter-box">
                                                        <i class="{{ $counterInfo->icon }}"></i>
                                                        <span class="counter-number">{{ $counterInfo->amount }}</span>
                                                        <p>{{ $counterInfo->title }}</p>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                                <!-- Counter End -->
                            @endif
                        </div>
                    </div>
                </div>
            </section>
            <!-- Welcome Section End -->
        @endif


        <!-- After intro Section -->
        @if (isset($after_intro) && count($after_intro) > 0)
            @foreach ($after_intro as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif



        @if ($sections->featured_rooms_section == 1)
            <!-- Latest Room Section Start -->
            <section class="latest-room section-bg section-padding">
                <div class="container-fluid">
                    <div class="row align-items-center no-gutters">
                        <div class="col-lg-3">
                            <div class="section-title">
                                @if (!is_null($secHeading))
                                    @if (!empty($secHeading->room_section_title))
                                        <span class="title-top with-border">
                                            {{ convertUtf8($secHeading->room_section_title) }}
                                        </span>
                                    @endif
                                    <h1>{{ convertUtf8($secHeading->room_section_subtitle) }}</h1>
                                    <p>{{ $secHeading->room_section_text }}</p>
                                @endif
                                <!-- Page Info -->
                                <div class="page-Info"></div>
                                <!-- Room Arrow -->
                                <div class="room-arrows"></div>
                            </div>
                        </div>
                        <div class="col-lg-8 offset-lg-1">
                            @if ($roomInfos->count() > 0)
                                <div class="row latest-room-slider" id="roomSliderActive">
                                    @forelse ($roomInfos as $roomInfo)
                                        @if (!is_null($roomInfo->room))
                                            @includeIf('user-front.common.room.single_room')
                                        @endif
                                    @endforeach
                                </div>
                            @else
                                <h3 class="no-found-1 mt-5">
                                    {{ $keywords['No Featured Room Found!'] ?? __('No Featured Room Found!') }}
                                </h3>

                            @endif

                        </div>
                    </div>
                </div>
            </section>
            <!-- Latest Room Section End -->
        @endif

        <!-- After featured rooms section -->
        @if (isset($after_featured_rooms) && count($after_featured_rooms) > 0)
            @foreach ($after_featured_rooms as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif


        @if ($sections->featured_services_section == 1)
            <!-- Service Section Start -->
            <section class="service-section section-padding">
                <div class="container">
                    <!-- Section Title -->
                    <div class="section-title text-center">
                        @if (!empty($secHeading))
                            <div class="row justify-content-center">
                                <div class="col-lg-7">
                                    <span class="title-top">{{ convertUtf8($secHeading->service_section_title) }}</span>
                                    <h1>{{ convertUtf8($secHeading->service_section_subtitle) }}</h1>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Service Boxes -->
                    @if (count($serviceInfos) == 0 || $serviceFlag == 0)
                        <div class="row text-center">
                            <div class="col">
                                <h3 class="no-found-1">
                                    {{ $keywords['No Featured Service Found!'] ?? __('No Featured Service Found !') }}</h3>
                            </div>
                        </div>
                    @else
                        <div class="row">
                            @foreach ($serviceInfos as $serviceInfo)
                                @if (!is_null($serviceInfo->service))
                                    <div class="col-lg-4 col-md-6">
                                        <div class="single-service-box text-center wow fadeIn animated"
                                            data-wow-duration="1500ms" data-wow-delay="{{ $loop->iteration * 200 }}ms">
                                            <span class="service-counter">{{ $loop->iteration }}</span>
                                            <div class="service-icon">
                                                <i class="{{ $serviceInfo->service->service_icon }}"></i>
                                            </div>
                                            <h4>{{ convertUtf8($serviceInfo->title) }}</h4>
                                            <p>
                                                {{ strlen($serviceInfo->summary) > 60 ? substr($serviceInfo->summary, 0, 60) . '...' : $serviceInfo->summary }}
                                            </p>
                                            @if ($serviceInfo->service->details_page_status == 1)
                                                <a href="{{ route('service_details', [getParam(),'slug' => $serviceInfo->slug]) }}"
                                                    class="read-more">
                                                    {{ $keywords['read more'] ?? __('read more') }} <i
                                                        class="far fa-long-arrow-right"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @endif
                </div>
            </section>
            <!-- Service Section End -->
        @endif

        <!-- After featured services section -->

        @if (isset($after_featured_services) && count($after_featured_services) > 0)
            @foreach ($after_featured_services as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif


        @if ($sections->video_section == 1)
            <!-- Call To Action Start -->
            <section class="cta-section bg-img-center lazy {{ $userBs->home_version == 'parallax' ? 'parallax' : '' }}"
                data-bg="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $secHeading->video_section_image, $userBs, 'assets/user-front/default-img/booking-img.jpg') }}">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-md-10">
                            <div class="cta-left-content">
                                @if (!is_null($secHeading))
                                    <span>{{ convertUtf8($secHeading->video_section_title) }}</span>
                                    <h1>{{ convertUtf8($secHeading->video_section_subtitle) }}</h1>
                                    @if (!empty($secHeading->video_section_button_url))
                                        <a href="{{ $secHeading->video_section_button_url }}" class="btn filled-btn">
                                            {{ $secHeading->video_section_button }} <i class="far fa-long-arrow-right"></i>
                                        </a>
                                    @endif
                                @endif
                            </div>
                        </div>

                        <div class="col-md-2">
                            @if (!empty($secHeading->video_section_video_url))
                                <div class="video-icon text-right">
                                    <a href="{{ $secHeading->video_section_video_url }}" class="video-popup"> <i
                                            class="fas fa-play"></i></a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </section>
            <!-- Call To Action End -->
        @endif


        <!-- After Video section -->
        @if ( isset($after_video) &&  count($after_video) > 0)
            @foreach ($after_video as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif


        @if ($sections->featured_package_section == 1 && in_array('Tour Package', $packagePermissions))
            <!-- Package Section Start -->
            <section class="ma-package-section section-padding featured-packages">
                <div class="container">
                    <!-- Section Title -->
                    <div class="section-title text-center">
                        @if (!empty($secHeading))
                            <div class="row justify-content-center">
                                <div class="col-lg-7">
                                    <span class="title-top">{{ convertUtf8($secHeading->package_section_title) }}</span>
                                    <h1>{{ convertUtf8($secHeading->package_section_subtitle) }}</h1>
                                </div>
                            </div>
                        @endif
                    </div>

                    <!-- Package Boxes -->
                    @if (count($packageInfos) == 0 || $packageFlag == 0)
                        <div class="row text-center">
                            <div class="col">
                                <h3 class="no-found-1 mb-5">
                                    {{ $keywords['No Featured Package Found!'] ?? __('No Featured Package Found !') }}</h3>
                            </div>
                        </div>
                    @else
                        <div class="row">
                            @foreach ($packageInfos as $packageInfo)
                                @if (!is_null($packageInfo->package))
                                    <div class="col-lg-6">
                                        <div class="packages-post-item">
                                            <a class="post-thumbnail d-block"
                                                href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}">
                                                <img class="lazy"
                                                    data-src="{{ asset('assets/tenant/img/packages/' . $packageInfo->package->featured_img) }}"
                                                    alt="package img">
                                            </a>

                                            <div class="entry-content">
                                                <h3 class="title">
                                                    <a
                                                        href="{{ route('package_details', [getParam(),'slug' => $packageInfo->slug]) }}">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 50, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                </h3>
                                                <div class="post-meta">
                                                    <ul>

                                                        @if ($packageInfo->package->pricing_type != 'negotiable')
                                                            <li>
                                                                <span><i class="fas fa-comment-dollar"></i>
                                                                    <strong>
                                                                    {{ $keywords['Package Price'] ?? __('Package Price') . ':' }}
                                                                   </strong>
                                                                    {{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'left' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                                                                    {{ $packageInfo->package->package_price }}
                                                                    {{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'right' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                                                                    ({{  $keywords[strtoupper($packageInfo->package->pricing_type)]  ??  __(strtoupper($packageInfo->package->pricing_type))  }})
                                                                </span>
                                                            </li>
                                                        @else
                                                            <li><span><i
                                                                        class="fas fa-comment-dollar"></i><strong>{{ $keywords['Package Price'] ?? __('Package Price') . ':' }}</strong>
                                                                    {{ $keywords['NEGOTIABLE'] ?? __('NEGOTIABLE') }}</span>
                                                            </li>
                                                        @endif

                                                        <li><span><i
                                                                    class="fas fa-users"></i><strong>{{ $keywords['Number of Days'] ?? __('Number of Days') . ':' }}</strong>
                                                                {{ $packageInfo->package->number_of_days }}</span></li>

                                                        <li><span><i
                                                                    class="fas fa-users"></i><strong>{{ $keywords['Maximum Persons'] ?? __('Maximum Persons') . ':' }}</strong>
                                                                {{ $packageInfo->package->max_persons != null ? $packageInfo->package->max_persons : '-' }}</span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    @endif
                </div>
            </section>
            <!-- Package Section End -->
        @endif

        <!-- After featured package section -->
        @if (isset($after_featured_package) && count($after_featured_package) > 0 &&  in_array('Tour Package', $packagePermissions))
            @foreach ($after_featured_package as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif


        <!-- After featured package section -->
        @if ($sections->facilities_section == 1)
            <!-- Why Choose Us/Facility Section Start -->
            <section class="wcu-section section-bg section-padding">
                <div class="container">
                    @if (count($facilities) > 0)
                        <div class="row align-items-center">
                            <div class="col-lg-5 offset-lg-1">
                                <!-- Section Title -->
                                <div class="feature-left">
                                    <div class="section-title">
                                        @if (!is_null($secHeading))
                                            @if (!empty($secHeading->facility_section_title))
                                                <span
                                                    class="title-top with-border">{{ convertUtf8($secHeading->facility_section_title) }}</span>
                                            @endif

                                            <h1>{{ convertUtf8($secHeading->facility_section_subtitle) }}</h1>
                                        @endif
                                    </div>

                                    <ul class="feature-list">
                                        @foreach ($facilities as $facility)
                                            <li class="wow fadeInUp animated" data-wow-duration="1000ms"
                                                data-wow-delay="{{ $loop->iteration * 100 }}ms">
                                                <div class="feature-icon"><i class="{{ $facility->facility_icon }}"></i>
                                                </div>
                                                <h4>{{ convertUtf8($facility->facility_title) }}</h4>
                                                <p>{{ $facility->facility_text }}</p>
                                            </li>
                                        @endforeach
                                    </ul>


                                </div>
                            </div>

                            <div class="col-lg-5 offset-lg-1">
                                @if (!is_null($secHeading))
                                    <div class="feature-img">
                                        <div class="feature-abs-con">
                                            <div class="f-inner">
                                                <i class="far fa-stars"></i>
                                                <p>{{ $keywords['Popular Features'] ?? __('Popular Features') }}</p>
                                            </div>
                                        </div>
                                        <img class="lazy"
                                            data-src="{{ asset(Constant::WEBSITE_FACILITY_SECTION_IMAGE .'/' . $secHeading->facility_section_image) }}"
                                            alt="image">
                                    </div>
                                @endif
                            </div>
                        </div>
                    @else
                        <div class="row">
                            <div class="col-lg-12">
                                <h3 class="no-found-1 mb-3">
                                    {{ $keywords['No Facilitie Found!'] ?? __('No Facilitie  Found !') }}</h3>
                            </div>
                        </div>
                    @endif
                </div>
            </section>
            <!-- Why Choose Us/Facility Section End -->
        @endif

        <!-- After facilities section -->
        @if (isset($after_facilities) && count($after_facilities) > 0)
            @foreach ($after_facilities as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif


        @if ($sections->testimonials_section == 1)
            <!-- Feedback Section Start -->
            <section class="feedback-section section-padding">
                <div class="container">
                    <!-- Section Title -->
                    @if (!empty($secHeading))
                        <div class="section-title text-center">
                            <div class="row justify-content-center">
                                <div class="col-lg-7">
                                    <span
                                        class="title-top">{{ convertUtf8($secHeading->testimonial_section_title) }}</span>
                                    <h1>{{ convertUtf8($secHeading->testimonial_section_subtitle) }}</h1>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (count($testimonials) == 0)
                        <div class="row text-center">
                            <div class="col">
                                <h3 class="text-white mb-5">
                                    {{ $keywords['No Testimonial Found!'] ?? __('No Testimonial Found!') }}
                                </h3>
                            </div>
                        </div>
                    @else
                        <div class="feadback-slide" id="feedbackSlideActive">
                            @foreach ($testimonials as $testimonial)
                                <div class="single-feedback-box">
                                    <p>{{ $testimonial->comment }}</p>
                                    <h5 class="feedback-author">{{ convertUtf8($testimonial->client_name) }}</h5>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </section>
            <!-- Feedback Section End -->
        @endif

        <!-- After testimonials section -->
        @if (isset($after_testimonials) && count($after_testimonials) > 0)
            @foreach ($after_testimonials as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif

        @if ($sections->brand_section == 1)
            <!-- Brands Section Start -->
            <section class="brands-section brands-section primary-bg">
                <div class="container">
                    @if (count($brands) == 0)
                        <div class="row text-center">
                            <div class="col">
                                <h3>{{ $keywords['No Brand Found!'] ?? __('No Brand Found !') }}</h3>
                            </div>
                        </div>
                    @else
                        <div id="brandsSlideActive" class="row">
                            @foreach ($brands as $brand)
                                <a class="brand-item text-center d-block" href="{{ $brand->brand_url }}"
                                    target="_blank">
                                    <img class="lazy"
                                        data-src="{{ asset('assets/tenant/img/brands/' . $brand->brand_img) }}"
                                        alt="brand image">
                                </a>
                            @endforeach
                        </div>
                    @endif
                </div>
            </section>
            <!-- Brands Section End -->
        @endif

        <!-- After brand_sectionn -->
        @if (isset($after_brand) && count($after_brand) > 0)
            @foreach ($after_brand as $cusHero)
                @if (isset($additional_section_status[$cusHero->id]))
                    @if ($additional_section_status[$cusHero->id] == 1)
                        @php
                            $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                                ['language_id', $language->id],
                                ['addition_section_id', $cusHero->id],
                            ])->first();
                        @endphp
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endforeach
        @endif

    </main>
@endsection

@section('script')
    <script src="{{ asset('assets/user-front/js/home.js') }}"></script>
@endsection
