@extends('user-front.common.layout')

@section('pageHeading')
    {{ $keywords['Home'] ?? __('Home') }}
@endsection

@php
    $metaKeywords = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
    $metaDescription = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
    $additional_section_status = json_decode($sections->additional_section_status, true);
@endphp
@section('meta-keywords', "$metaKeywords ")
@section('meta-description', "$metaDescription")
@section('content')

    <!-- Home-area start-->
    @includeIf('user-front.common.hero.theme4.slider')
    <!-- Home-area end -->
    <!-- After Search Section -->
    @if (isset($after_search) && count($after_search) > 0)
        @foreach ($after_search as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();

                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Category-area start -->
    @if ($sections->package_category_section == 1)
        <section class="category-area category-2 ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="section-title title-inline mw-100 mb-50" data-aos="fade-up">
                            @if (!is_null($secHeading))
                                <h2 class="title"> {{ convertUtf8($secHeading->package_category_section_title) }}</h2>
                            @endif
                            <a href="{{ route('packages', getParam()) }}" class="btn btn-lg btn-primary" target="_self"
                                title="{{ $keywords['Show More'] ?? __('Show More') }}">{{ $keywords['Show More'] ?? __('Show More') }}</a>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="swiper category-slider" id="category-slider-1" data-slides-per-view="4">
                            <div class="swiper-wrapper">
                                @foreach ($package_categories as $category)
                                    <div class="swiper-slide" data-aos="fade-up">
                                        <div class="card mb-25">
                                            <a href="{{ route('packages', [getParam(), 'category' => $category->slug]) }}"
                                                target="_self" title="Link">
                                                <div class="card-img">

                                                    <div class="lazy-container ratio ratio-1-3">
                                                        <img class="lazyload"
                                                            data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $category->image) }}"
                                                            alt="{{ $category->image }}">
                                                    </div>
                                                </div>
                                                <div class="card-text text-center">
                                                    <h5 class="card-title color-white mb-1">{{ $category->name }}</h5>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-pagination position-static" id="category-slider-1-pagination"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- Category-area end -->

    <!-- After featured rooms section -->
    @if (isset($after_packages_category) && count($after_packages_category) > 0)
        @foreach ($after_packages_category as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- About-area start -->
    @if ($sections->intro_section == 1)
        <section class="about-area about-2 pb-60">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6" data-aos="fade-up">
                        <div class="content-title mb-40">
                            @if (!is_null($secHeading))
                                <h2 class="title mb-20">
                                    {{ $secHeading->intro_primary_title }}
                                </h2>

                                <div class="mw-80 w-md-100">
                                    <p>
                                        {{ $secHeading->intro_text }}
                                    </p>
                                </div>
                            @endif

                            @if ($sections->statistics_section == 1)
                                <div class="about-grid mt-40">
                                    @if (count($counterInfos) > 0)
                                        @foreach ($counterInfos as $counterInfo)
                                            <div class="grid-item radius-md p-20">
                                                <h3 class="mb-2 lc-1"><span
                                                        class="counter">{{ $counterInfo->amount }}</span>+</h3>
                                                <p>{{ $counterInfo->title }}</p>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="d-flex align-items-center flex-wrap gap-3 mt-40" data-aos="fade-up">
                                    @if ($secHeading->intro_button_url)
                                        <a href="{{ $secHeading->intro_button_url }}"
                                            class="btn btn-lg btn-primary rounded-pill"
                                            title="{{ $secHeading->intro_button_text }}"
                                            target="_self">{{ $secHeading->intro_button_text }}</a>
                                    @endif
                                    @if($secHeading->intro_member_image_show ==1)
                                    @if (!empty($secHeading->intro_member_image))
                                        <div class="clients-avatar">
                                            <img src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_member_image, $userBs) }}"
                                                alt="">
                                        </div>
                                    @endif
                                    @endif
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-6" data-aos="fade-up">
                        <div class="image mb-40 img-right">
                            @if (!is_null($secHeading))
                                <img class="blur-up lazyload"
                                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_img, $userBs, 'assets/user-front/default-img/intro-image.jpg') }}"
                                    alt="Image">
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- About-area end -->

    <!-- After intro Section -->
    @if (isset($after_intro) && count($after_intro) > 0)
        @foreach ($after_intro as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Product-area start -->
    @if ($sections->featured_package_section == 1 && in_array('Tour Package', $packagePermissions))
        <!-- Product-area start -->
        <section class="product-area pb-100">
            <div class="container">
                <div class="row">
                    @if (!empty($secHeading))
                        <div class="col-12" data-aos="fade-up">
                            <div class="section-title title-inline mb-50" data-aos="fade-up">
                                <h2 class="title">{{ convertUtf8($secHeading->package_section_title) }}</h2>
                                @if (count($featured_tour_packages) > 3)
                                    <a href="{{ route('packages', getParam()) }}"
                                        class="btn btn-lg btn-primary">{{ $keywords['All Packages'] ?? __('All Packages') }}</a>
                                @endif
                            </div>
                        </div>
                    @endif
                    @if (count($featured_tour_packages) == 0)
                        <div class="col">
                            <h3>{{ $keywords['No Featured Package Found!'] ?? __('No Featured Package Found!') }}</h3>
                        </div>
                    @else
                        <div class="col-12">
                            <div class="swiper product-slider" id="product-slider-1" data-slides-per-view="4">
                                <div class="swiper-wrapper">
                                    @foreach ($featured_tour_packages as $packageInfo)
                                        @if (!empty($packageInfo->package))
                                            <div class="swiper-slide" data-aos="fade-up">
                                                <div class="product-default mb-25">
                                                    <figure class="product-img">
                                                        <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                            class="lazy-container radius-md ratio ratio-3-4" target="_self"
                                                            title="Link">
                                                            <img class="lazyload"
                                                                data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $packageInfo->package->featured_img) }}"
                                                                alt="Product">
                                                        </a>
                                                    </figure>
                                                    <div class="product-details p-20 border radius-md mx-auto">
                                                        <div
                                                            class="d-flex align-items-center gap-3 justify-content-between">
                                                            <span class="product-tag border radius-sm">
                                                                @php
                                                                    $packageCategory = \App\Models\User\PackageCategory::where(
                                                                        'indx',
                                                                        $packageInfo->package->package_category_index,
                                                                    )
                                                                        ->where(
                                                                            'language_id',
                                                                            $packageInfo->language_id,
                                                                        )
                                                                        ->first();
                                                                @endphp
                                                                {{ !is_null($packageCategory) ? $packageCategory->name : '' }}
                                                            </span>
                                                            <div class="product-price">
                                                                @if ($packageInfo->package->pricing_type == 'fixed')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '(' . strtoupper($packageInfo->package->pricing_type) . ')' }}</span>
                                                                @elseif ($packageInfo->package->pricing_type == 'per-person')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '/ ' . $keywords['Person'] ?? __('Person') }}</span>
                                                                @else
                                                                    <span
                                                                        class="h6 new-price color-primary"></strong>{{ $keywowds['Negotiable'] ?? __('Negotiable') }}</strong></span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <h6 class="product-title lc-1 mt-2">
                                                            <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                target="_self"
                                                                title="Link">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                        </h6>
                                                        <ul
                                                            class="product-icon-list list-unstyled d-flex align-items-center">
                                                            <li class="icon-start">
                                                                <i class="fal fa-calendar-check"></i>
                                                                <span> {{ $packageInfo->package->number_of_days }}
                                                                    {{ $keywords['Days'] ?? __('Days') }}</span>
                                                            </li>
                                                            <li class="icon-start">
                                                                <i class="fal fa-user-friends"></i>
                                                                <span>
                                                                    {{ $packageInfo->package->max_persons != null ? $packageInfo->package->max_persons : '-' }}
                                                                    {{ $packageInfo->package->max_persons == 1 ? $keywords['Person'] ?? __('Person') : $keywords['Persons'] ?? __('Persons') }}
                                                                </span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                                <div class="swiper-pagination position-static" id="product-slider-1-pagination"></div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>
    @endif
    <!-- Product-area end -->

    <!-- After featured package section -->
    @if (isset($after_featured_package) &&
            count($after_featured_package) > 0 &&
            in_array('Tour Package', $packagePermissions))
        @foreach ($after_featured_package as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Product-area start -->
    @if ($sections->latest_packages_section == 1 && in_array('Tour Package', $packagePermissions))
        <!-- Package Section Start -->
        <section class="product-area pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-12" data-aos="fade-up">
                        <div class="section-title title-center mb-50" data-aos="fade-up">
                            @if (!is_null($secHeading))
                                <h2 class="title mb-30">
                                    {{ $secHeading->latest_package_section_title }}
                                </h2>
                            @endif
                            <div class="tabs-navigation-area">
                                <ul class="nav nav-tabs" data-hover="fancyHover" role="tablist">
                                    <li class="nav-item active" role="presentation">
                                        <button class="nav-link hover-effect btn-md radius-sm active" data-bs-toggle="tab"
                                            data-bs-target="#tab1" type="button" aria-selected="true"
                                            role="tab">{{ $keywords['All Packages'] ?? __('All Packages') }}</button>
                                    </li>
                                    @foreach ($package_categories as $package_category)
                                        <li class="nav-item " role="presentation">
                                            <button class="nav-link hover-effect btn-md radius-sm" data-bs-toggle="tab"
                                                data-bs-target="#tab{{ $package_category->id }}" type="button"
                                                aria-selected="false" role="tab"
                                                tabindex="-1">{{ $package_category->name }}</button>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="tab-content">
                            <div class="tab-pane slide active" id="tab1" role="tabpanel">
                                <div class="row">
                                    @forelse ($all_tour_packages as $packageInfo)
                                        @if (!empty($packageInfo->package))
                                            <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                                                <div class="product-default mb-25">
                                                    <figure class="product-img">
                                                        <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                            class="lazy-container radius-md ratio ratio-3-4"
                                                            target="_self" title="Link">
                                                            <img class="lazyload"
                                                                data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $packageInfo->package->featured_img) }}"
                                                                alt="Product">
                                                        </a>
                                                    </figure>
                                                    <div class="product-details p-20 border radius-md mx-auto">
                                                        <div
                                                            class="d-flex align-items-center gap-3 justify-content-between">
                                                            <span class="product-tag border radius-sm">
                                                                @php
                                                                    $packageCategory = \App\Models\User\PackageCategory::where(
                                                                        'indx',
                                                                        $packageInfo->package->package_category_index,
                                                                    )
                                                                        ->where(
                                                                            'language_id',
                                                                            $packageInfo->language_id,
                                                                        )
                                                                        ->first();

                                                                @endphp
                                                                {{ !is_null($packageCategory) ? $packageCategory->name : '' }}
                                                            </span>
                                                            <div class="product-price">
                                                                @if ($packageInfo->package->pricing_type == 'fixed')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '(' . strtoupper($packageInfo->package->pricing_type) . ')' }}</span>
                                                                @elseif ($packageInfo->package->pricing_type == 'per-person')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '/ ' . $keywords['Person'] ?? __('Person') }}</span>
                                                                @else
                                                                    <span
                                                                        class="h6 new-price color-primary"></strong>{{ $keywowds['Negotiable'] ?? __('Negotiable') }}</strong></span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <h6 class="product-title lc-1 mt-2">
                                                            <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                target="_self"
                                                                title="Link">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                        </h6>
                                                        <ul
                                                            class="product-icon-list list-unstyled d-flex align-items-center">
                                                            <li class="icon-start">
                                                                <i class="fal fa-calendar-check"></i>
                                                                <span> {{ $packageInfo->package->number_of_days }}
                                                                    {{ $keywords['Days'] ?? __('Days') }}</span>
                                                            </li>
                                                            <li class="icon-start">
                                                                <i class="fal fa-user-friends"></i>
                                                                <span>
                                                                    {{ $packageInfo->package->max_persons != null ? $packageInfo->package->max_persons : '-' }}
                                                                    {{ $packageInfo->package->max_persons == 1 ? $keywords['Person'] ?? __('Person') : $keywords['Persons'] ?? __('Persons') }}
                                                                </span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div><!-- product-default -->
                                            </div>
                                        @endif
                                    @empty
                                        <h6 class="text-center">
                                            {{ $keywords['No Package Found!'] ?? __('No Package Found!') }}
                                        </h6>
                                    @endforelse
                                    @if (count($packageInfos) > 6)
                                        <div class="text-center mt-20" data-aos="fade-up">
                                            <a href="{{ route('packages', getParam()) }}" class="btn btn-lg btn-primary">
                                                {{ $keywords['View All Items'] ?? __('View All Items') }}
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            @foreach ($package_categories as $package_category)
                                <div class="tab-pane slide" id="tab{{ $package_category->id }}" role="tabpanel">
                                    <div class="row">
                                        @php
                                            $packageInfos = $all_tour_packages->filter(function ($package) use (
                                                $package_category,
                                            ) {
                                                return $package->package->package_category_index ==
                                                    $package_category->indx;
                                            });
                                        @endphp

                                        @forelse ($packageInfos as $packageInfo)
                                            @if (!empty($packageInfo->package))
                                                <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                                                    <div class="product-default mb-25">
                                                        <figure class="product-img">
                                                            <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                class="lazy-container radius-md ratio ratio-3-4"
                                                                target="_self" title="Link">
                                                                <img class="lazyload"
                                                                    data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $packageInfo->package->featured_img) }}"
                                                                    alt="Product">
                                                            </a>
                                                        </figure>
                                                        <div class="product-details p-20 border radius-md mx-auto">
                                                            <div
                                                                class="d-flex align-items-center gap-3 justify-content-between">
                                                                <span class="product-tag border radius-sm">
                                                                    @php
                                                                        $packageCategory = \App\Models\User\PackageCategory::where(
                                                                            'indx',
                                                                            $packageInfo->package
                                                                                ->package_category_index,
                                                                        )
                                                                            ->where(
                                                                                'language_id',
                                                                                $packageInfo->language_id,
                                                                            )
                                                                            ->first();

                                                                    @endphp
                                                                    {{ !is_null($packageCategory) ? $packageCategory->name : '' }}
                                                                </span>
                                                                <div class="product-price">
                                                                    @if ($packageInfo->package->pricing_type == 'fixed')
                                                                        <span class="h6 new-price color-primary"></strong>
                                                                            {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                            {{ '(' . strtoupper($packageInfo->package->pricing_type) . ')' }}</span>
                                                                    @elseif ($packageInfo->package->pricing_type == 'per-person')
                                                                        <span class="h6 new-price color-primary"></strong>
                                                                            {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                            {{ '/ ' . $keywords['Person'] ?? __('Person') }}</span>
                                                                    @else
                                                                        <span
                                                                            class="h6 new-price color-primary"></strong>{{ $keywowds['Negotiable'] ?? __('Negotiable') }}</strong></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <h6 class="product-title lc-1 mt-2">
                                                                <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                    target="_self"
                                                                    title="Link">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                            </h6>
                                                            <ul
                                                                class="product-icon-list list-unstyled d-flex align-items-center">
                                                                <li class="icon-start">
                                                                    <i class="fal fa-calendar-check"></i>
                                                                    <span> {{ $packageInfo->package->number_of_days }}
                                                                        {{ $packageInfo->package->number_of_days == 1 ? $keywords['Day'] ?? __('Day') : $keywords['Days'] ?? __('Days') }}</span>
                                                                </li>
                                                                <li class="icon-start">
                                                                    <i class="fal fa-user-friends"></i>
                                                                    <span>
                                                                        {{ $packageInfo->package->max_persons != null ? $packageInfo->package->max_persons : '-' }}
                                                                        {{ $packageInfo->package?->max_persons == 1 ? $keywords['Person'] ?? __('Person') : $keywords['Persons'] ?? __('Persons') }}
                                                                    </span>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div><!-- product-default -->
                                                </div>
                                            @endif
                                        @empty
                                            <h6 class="text-center">
                                                {{ $keywords['No Package Found!'] ?? __('No Package Found!') }}
                                            </h6>
                                        @endforelse
                                        @if (count($packageInfos) > 6)
                                            <div class="text-center mt-20" data-aos="fade-up">
                                                <a href="{{ route('packages', [getParam(), 'category' => $package_category->slug]) }}"
                                                    class="btn btn-lg btn-primary">
                                                    {{ $keywords['View All Items'] ?? __('View All Items') }}
                                                </a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Package Section End -->
    @endif
    <!-- Product-area end -->

    <!-- After featured package section -->
    @if (isset($after_latest_packages) && count($after_latest_packages) > 0 && in_array('Tour Package', $packagePermissions))
        @foreach ($after_latest_packages as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif


    <!-- Video-banner start -->
    @if ($sections->video_section == 1)
        <div class="video-banner ptb-60 bg-img position-relative z-1 lazyload"
            data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $secHeading->video_section_image, $userBs, 'assets/user-front/default-img/choose-1-2.jpg') }}">
            <!-- Bg overlay -->
            <div class="overlay opacity-50"></div>
            <div class="container">
                <div class="wrapper" data-aos="fade-up">
                    @if (!empty($secHeading->video_section_video_url))
                        <div class="text-center ptb-100">
                            <a href="{{ $secHeading->video_section_video_url }}" class="video-btn youtube-popup mx-auto">
                                <i class="fas fa-play"></i>
                            </a>
                        </div>
                    @endif
                    <span class="line-1"></span>
                    <span class="line-2"></span>
                    <span class="line-3"></span>
                    <span class="line-4"></span>
                </div>
            </div>
        </div>
    @endif
    <!-- Video-banner end -->

    <!-- After Video section -->
    @if (isset($after_video) && count($after_video) > 0)
        @foreach ($after_video as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif


    <!-- Choose-area start -->
    @if ($sections->facilities_section == 1)
        <!-- Why Choose Us/Facility Section Start -->
        <section class="choose-area choose-2 pt-100 pb-60">
            <div class="container">
                <div class="row gx-xl-5 align-items-center">
                    <div class="col-lg-6" data-aos="fade-right">
                        @if (!is_null($secHeading))
                            <div class="image mb-40 img-left">
                                <img class="blur-up lazyload"
                                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $secHeading->facility_section_image, $userBs, 'assets/user-front/default-img/facility.jpg') }}"
                                    alt="Image">
                            </div>
                        @endif
                    </div>
                    <div class="col-lg-6" data-aos="fade-left">
                        <div class="content mb-10">
                            @if (!is_null($secHeading))
                                <div class="content-title">
                                    <h2 class="title mb-30">{{ convertUtf8($secHeading->facility_section_title) }}</h2>
                                </div>
                                <p class="text">{{ convertUtf8($secHeading->facility_section_subtitle) }}</p>
                            @endif

                            @if (count($facilities) > 0)
                                <div class="item-list mt-40">
                                    @foreach ($facilities as $facility)
                                        <div class="item d-flex gap-3 mb-30">
                                            <div class="icon rounded-pill">
                                                <i class="{{ $facility->facility_icon }}"></i>
                                            </div>
                                            <div class="content w-75 w-sm-100">
                                                <h4 class="mb-2 lh-1">{{ convertUtf8($facility->facility_title) }}</h4>
                                                <p class="card-text">{{ $facility->facility_text }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>

    @endif
    <!-- Choose-area end -->
    <!-- After facilities section -->
    @if (count($after_facilities) > 0)
        @foreach ($after_facilities as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Blog-area start -->
    @if ($sections->blogs_section == 1 && in_array('Blog', $packagePermissions))
        <!-- Latest Blog Start -->
        <section class="blog-area blog-1 pb-75">
            <div class="container">
                <div class="row">
                    @if (!empty($secHeading))
                        <div class="col-12" data-aos="fade-up">
                            <div class="section-title title-inline mb-50" data-aos="fade-up">
                                <h2 class="title">{{ convertUtf8($secHeading->blog_section_title) }}</h2>
                                <a href="{{ route('blogs', getParam()) }}"
                                    class="btn btn-lg btn-primary">{{ $keywords['All Posts'] ?? __('All Posts') }}</a>

                            </div>
                        </div>
                    @endif

                    @if (count($blogInfos) == 0)
                        <div class="col-12">
                            <h3>{{ $keywords['No Post Found!'] ?? __('No Post Found!') }}</h3>
                        </div>
                    @else
                        <div class="col-12">
                            <div class="row gx-xl-5 justify-content-center">
                                @foreach ($blogInfos as $blogInfo)
                                    <div class="col-md-6 col-lg-4" data-aos="fade-up">
                                        <article class="card mb-25">
                                            <div class="card-img radius-md mb-25">
                                                <a href="{{ route('blog_details', [getParam(), 'slug' => $blogInfo->slug]) }}"
                                                    class="lazy-container ratio ratio-5-3">
                                                    <img class="lazyload"
                                                        data-src="{{ asset(Constant::WEBSITE_BLOG_IMAGE . '/' . @$blogInfo->blog->image) }}"
                                                        alt="Blog Image">
                                                </a>
                                            </div>
                                            <div class="content">
                                                <h4 class="card-title">
                                                    <a
                                                        href="{{ route('blog_details', [getParam(), 'slug' => $blogInfo->slug]) }}">
                                                        {{ convertUtf8($blogInfo->title) }}
                                                    </a>
                                                </h4>
                                                <p class="card-text">
                                                    {!! $blogInfo->content !!}
                                                </p>
                                                <div class="mt-20">
                                                    <a href="{{ route('blog_details', [getParam(), 'slug' => $blogInfo->slug]) }}"
                                                        class="btn-text"
                                                        target="_self">{{ $keywords['Read More'] ?? __('Read More') }}</a>
                                                </div>
                                            </div>
                                        </article>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>
        <!-- Latest Blog End -->
    @endif
    <!-- Blog-area end -->
    <!-- After blog section -->
    @if (isset($after_blogs) && count($after_blogs) > 0 && in_array('Blog', $packagePermissions))
        @foreach ($after_blogs as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                     @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

@endsection
