@extends('user-front.common.layout')
@section('pageHeading')
    {{ $keywords['Home'] ?? __('Home') }}
@endsection

@php
    $metaKeywords = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
    $metaDescription = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
    $additional_section_status = json_decode($sections->additional_section_status, true);
@endphp
@section('meta-keywords', "$metaKeywords ")
@section('meta-description', "$metaDescription")
@section('content')

    <!-- Home-area start-->
    @includeIf('user-front.common.hero.theme5.slider')
    <!-- Home-area end -->


    <!-- After Search Section -->
    @if (isset($after_search) && count($after_search) > 0)
        @foreach ($after_search as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();

                    @endphp
                    @if (!is_null($cusHeroContent))
                        @includeIf('user-front.common.additional-section', [
                            'data' => $cusHeroContent,
                            'possition' => $cusHero->possition,
                        ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- About-area start -->
    @if ($sections->intro_section == 1)
        <section class="about-area about-3 pt-100 pb-60">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6" data-aos="fade-up">
                        <div class="content-title mb-40">
                            @if (!is_null($secHeading))
                                <h2 class="title mb-20">
                                    {{ $secHeading->intro_primary_title }}
                                </h2>

                                <div class="mw-80 w-md-100">
                                    <p>
                                        {{ $secHeading->intro_text }}
                                    </p>
                                </div>
                            @endif
                            @if ($sections->statistics_section == 1)
                                <div class="about-grid mt-40">
                                    @if (count($counterInfos) > 0)
                                        @foreach ($counterInfos as $counterInfo)
                                            <div class="grid-item radius-md p-20">
                                                <div class="icon mb-15">
                                                    <i class="{{ $counterInfo->icon }}"></i>
                                                </div>
                                                <h3 class="mb-2 lc-1"><span
                                                        class="counter">{{ $counterInfo->amount }}</span>+</h3>
                                                <p>{{ $counterInfo->title }}</p>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="d-flex align-items-center flex-wrap gap-3 mt-40" data-aos="fade-up">
                                    @if ($secHeading->intro_button_url)
                                        <a href="{{ $secHeading->intro_button_url }}"
                                            class="btn btn-lg btn-primary rounded-pill"
                                            title="{{ $secHeading->intro_button_text }}"
                                            target="_self">{{ $secHeading->intro_button_text }}</a>
                                    @endif
                                    @if ($secHeading->intro_member_image_show == 1)
                                        @if (!empty($secHeading->intro_member_image))
                                            <div class="clients-avatar">
                                                <img src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_member_image, $userBs) }}"
                                                    alt="">
                                            </div>
                                        @endif
                                    @endif
                                </div>
                            @endif

                        </div>
                    </div>
                    <div class="col-lg-6" data-aos="fade-up">
                        <div class="image mb-40 img-right">
                            <div class="img-1">
                                <img class="blur-up lazyload"
                                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_img, $userBs, 'assets/user-front/default-img/intro-2.jpg') }}"
                                    alt="Image">
                            </div>
                            <div class="img-2">
                                <img class="lazyload blur-up"
                                    data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_INTRO_SECTION_IMAGE, $secHeading->intro_image_two, $userBs, 'assets/user-front/default-img/intro-1.jpg') }}"
                                    alt="Image">
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- About-area end -->

    <!-- After intro Section -->
    @if (isset($after_intro) && count($after_intro) > 0)
        @foreach ($after_intro as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- featured room start -->
    @if ($sections->featured_rooms_section == 1)
        <!-- Product-area start -->
        <section class="product-area pb-100">
            <div class="container">
                <div class="row">
                    @if (!empty($secHeading))
                        <div class="col-12" data-aos="fade-up">
                            <div class="section-title title-inline mb-50" data-aos="fade-up">
                                <h2 class="title">{{ convertUtf8($secHeading->room_section_title) }}</h2>
                                @if ($roomInfos->count() > 3)
                                    <a href="{{ route('rooms', getParam()) }}"
                                        class="btn btn-lg btn-primary">{{ $keywords['All Rooms'] ?? __('All Rooms') }}</a>
                                @endif
                            </div>
                        </div>
                    @endif

                    @if ($roomInfos->count() == 0)
                        <div class="col">
                            <h3>{{ $keywords['No Featured Room Found!'] ?? __('No Featured Room Found!') }}</h3>
                        </div>
                    @else
                        <div class="col-12">
                            <div class="swiper product-slider" id="product-slider-1" data-slides-per-view="4">
                                <div class="swiper-wrapper">
                                    @foreach ($roomInfos as $roomInfo)
                                        @if (!empty($roomInfo->room))
                                            <div class="swiper-slide" data-aos="fade-up">
                                                <div class="product-default mb-25">
                                                    <figure class="product-img">
                                                        <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                                                            class="lazy-container radius-md ratio ratio-3-4" target="_self"
                                                            title="Link">
                                                            <img class="lazyload"
                                                                data-src="{{ asset(Constant::WEBSITE_ROOM_IMAGE . '/' . $roomInfo->room->featured_img) }}"
                                                                alt="{{ convertUtf8($roomInfo->title) }}">
                                                        </a>
                                                    </figure>
                                                    <div class="product-details p-20 border radius-md mx-auto">
                                                        <div
                                                            class="d-flex align-items-center gap-3 justify-content-between">

                                                            <span class="product-tag border radius-sm">
                                                                @php
                                                                    $category = \App\Models\User\RoomCategory::where(
                                                                        'indx',
                                                                        $roomInfo->room->category_index,
                                                                    )
                                                                        ->where('language_id', $roomInfo->language_id)
                                                                        ->first();
                                                                @endphp
                                                                {{ !is_null($category) ? $category->name : '' }}
                                                            </span>

                                                            <div class="product-price">

                                                                <span class="h6 new-price color-primary">
                                                                    {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}
                                                                    {{ $roomInfo->room->rent }}
                                                                    {{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                    / {{ $keywords['Night'] ?? __('Night') }}
                                                                </span>

                                                            </div>
                                                        </div>
                                                        <h6 class="product-title lc-1 mt-2">
                                                            <a href="{{ route('room_details', [getParam(), 'slug' => $roomInfo->slug]) }}"
                                                                target="_self"
                                                                title="{{ convertUtf8($roomInfo->title) }}">{{ convertUtf8($roomInfo->title) }}</a>
                                                        </h6>
                                                        <ul
                                                            class="product-icon-list list-unstyled d-flex align-items-center">
                                                            <li class="icon-start">
                                                                <i class="fal fa-bed"></i>
                                                                <span>
                                                                    {{ $roomInfo->room->bed }}
                                                                    {{ $roomInfo->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                                                                </span>
                                                            </li>
                                                            <li class="icon-start">
                                                                <i class="fal fa-bath"></i>
                                                                <span>
                                                                    {{ $roomInfo->room->bath }}
                                                                    {{ $roomInfo->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}
                                                                </span>
                                                            </li>
                                                            <li class="icon-start">
                                                                <i class="fal fa-users"></i>
                                                                <span>
                                                                    {{ $roomInfo->room->max_guests }}
                                                                    {{ $roomInfo->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}
                                                                </span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div><!-- product-default -->
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                                <div class="swiper-pagination position-static" id="product-slider-1-pagination"></div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </section>
    @endif
    <!-- featured room  end -->

    <!-- After featured rooms section -->
    @if (isset($after_featured_rooms) && count($after_featured_rooms) > 0)
        @foreach ($after_featured_rooms as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif


    <!-- Product-area start -->
    @if ($sections->latest_packages_section == 1 && in_array('Tour Package', $packagePermissions))
        <!-- Package Section Start -->
        <section class="product-area pb-100">
            <div class="container">
                <div class="row">
                    <div class="col-12" data-aos="fade-up">
                        <div class="section-title title-center mb-50" data-aos="fade-up">
                            @if (!empty($secHeading))
                                <h2 class="title mb-30">
                                    {{ convertUtf8($secHeading->latest_package_section_title) }}
                                </h2>
                            @endif
                            <div class="tabs-navigation-area">
                                <ul class="nav nav-tabs" data-hover="fancyHover" role="tablist">
                                    <li class="nav-item active" role="presentation">
                                        <button class="nav-link hover-effect btn-md radius-sm active" data-bs-toggle="tab"
                                            data-bs-target="#tab1" type="button" aria-selected="true"
                                            role="tab">{{ $keywords['All Packages'] ?? __('All Packages') }}</button>
                                    </li>
                                    @foreach ($package_categories as $package_category)
                                        <li class="nav-item " role="presentation">
                                            <button class="nav-link hover-effect btn-md radius-sm" data-bs-toggle="tab"
                                                data-bs-target="#tab{{ $package_category->id }}" type="button"
                                                aria-selected="false" role="tab"
                                                tabindex="-1">{{ $package_category->name }}</button>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="tab-content">
                            <div class="tab-pane slide active" id="tab1" role="tabpanel">
                                <div class="row">
                                    @forelse ($all_tour_packages as $key => $packageInfo)
                                        @if (!empty($packageInfo->package) && $key < 8)
                                            <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                                                <div class="product-default mb-25">
                                                    <figure class="product-img">
                                                        <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                            class="lazy-container radius-md ratio ratio-3-4"
                                                            target="_self" title="Link">
                                                            <img class="lazyload"
                                                                data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $packageInfo->package->featured_img) }}"
                                                                alt="{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}">
                                                        </a>
                                                    </figure>
                                                    <div class="product-details p-20 border radius-md mx-auto">
                                                        <div
                                                            class="d-flex align-items-center gap-3 justify-content-between">
                                                            <span class="product-tag border radius-sm">
                                                                @php
                                                                    $packageCategory = \App\Models\User\PackageCategory::where(
                                                                        'indx',
                                                                        $packageInfo->package->package_category_index,
                                                                    )
                                                                        ->where('language_id', $roomInfo->language_id)
                                                                        ->first();
                                                                @endphp
                                                                {{ !is_null($packageCategory) ? $packageCategory->name : '' }}
                                                            </span>

                                                            <div class="product-price">
                                                                @if ($packageInfo->package->pricing_type == 'fixed')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '(' . strtoupper($packageInfo->package->pricing_type) . ')' }}</span>
                                                                @elseif ($packageInfo->package->pricing_type == 'per-person')
                                                                    <span class="h6 new-price color-primary"></strong>
                                                                        {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                        {{ '/ ' . $keywords['Person'] ?? __('Person') }}</span>
                                                                @else
                                                                    <span
                                                                        class="h6 new-price color-primary"></strong>{{ $keywowds['Negotiable'] ?? __('Negotiable') }}</strong></span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <h6 class="product-title lc-1 mt-2">
                                                            <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                target="_self"
                                                                title="Link">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                        </h6>
                                                        <ul
                                                            class="product-icon-list list-unstyled d-flex align-items-center">
                                                            <li class="icon-start">
                                                                <i class="fal fa-calendar-check"></i>
                                                                <span> {{ $packageInfo->package->number_of_days }}
                                                                    {{ $keywords['Days'] ?? __('Days') }}</span>
                                                            </li>
                                                            <li class="icon-start">
                                                                <i class="fal fa-user-friends"></i>
                                                                <span>
                                                                    {{ $packageInfo->package?->max_persons != null ? $packageInfo->package?->max_persons : '-' }}
                                                                    {{ $packageInfo->package?->max_persons == 1 ? $keywords['Person'] ?? __('Person') : $keywords['Persons'] ?? __('Persons') }}
                                                                </span>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div><!-- product-default -->
                                            </div>
                                        @endif
                                    @empty
                                        <h3 class="text-center">
                                            {{ $keywords['No Package Found!'] ?? __('No Package Found!') }}
                                        </h3>
                                    @endforelse
                                    @if (count($packageInfos) > 8)
                                        <div class="text-center mt-20" data-aos="fade-up">
                                            <a href="{{ route('packages', getParam()) }}" class="btn btn-lg btn-primary">
                                                {{ $keywords['View All Items'] ?? __('View All Items') }}
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            @foreach ($package_categories as $package_category)
                                <div class="tab-pane slide" id="tab{{ $package_category->id }}" role="tabpanel">
                                    <div class="row">
                                        @php
                                            $packageInfos = $all_tour_packages
                                                ->filter(function ($package) use ($package_category) {
                                                    return $package->package->package_category_index ==
                                                        $package_category->indx;
                                                })
                                                ->take(8);
                                        @endphp

                                        @forelse($packageInfos as $packageInfo)
                                            @if (!empty($packageInfo->package))
                                                <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                                                    <div class="product-default mb-25">
                                                        <figure class="product-img">
                                                            <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                class="lazy-container radius-md ratio ratio-3-4"
                                                                target="_self" title="Link">
                                                                <img class="lazyload"
                                                                    data-src="{{ asset(Constant::WEBSITE_PACKAGE_IMAGE . '/' . $packageInfo->package->featured_img) }}"
                                                                    alt="{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}">
                                                            </a>
                                                        </figure>
                                                        <div class="product-details p-20 border radius-md mx-auto">
                                                            <div
                                                                class="d-flex align-items-center gap-3 justify-content-between">
                                                                <span class="product-tag border radius-sm">
                                                                    @php
                                                                        $packageCategory = \App\Models\User\PackageCategory::where(
                                                                            'indx',
                                                                            $packageInfo->package
                                                                                ->package_category_index,
                                                                        )
                                                                            ->where(
                                                                                'language_id',
                                                                                $roomInfo->language_id,
                                                                            )
                                                                            ->first();
                                                                    @endphp
                                                                    {{ !is_null($packageCategory) ? $packageCategory->name : '' }}
                                                                </span>


                                                                <div class="product-price">
                                                                    @if ($packageInfo->package->pricing_type == 'fixed')
                                                                        <span class="h6 new-price color-primary"></strong>
                                                                            {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                            {{ '(' . strtoupper($packageInfo->package->pricing_type) . ')' }}</span>
                                                                    @elseif ($packageInfo->package->pricing_type == 'per-person')
                                                                        <span class="h6 new-price color-primary"></strong>
                                                                            {{ $currencyInfo->base_currency_symbol_position == 'left' ? $currencyInfo->base_currency_symbol : '' }}{{ $packageInfo->package->package_price }}{{ $currencyInfo->base_currency_symbol_position == 'right' ? $currencyInfo->base_currency_symbol : '' }}
                                                                            {{ '/ ' . $keywords['Person'] ?? __('Person') }}</span>
                                                                    @else
                                                                        <span
                                                                            class="h6 new-price color-primary"></strong>{{ $keywowds['Negotiable'] ?? __('Negotiable') }}</strong></span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <h6 class="product-title lc-1 mt-2">
                                                                <a href="{{ route('package_details', [getParam(), 'slug' => $packageInfo->slug]) }}"
                                                                    target="_self"
                                                                    title="Link">{{ strlen($packageInfo->title) > 50 ? mb_substr($packageInfo->title, 0, 150, 'utf-8') . '...' : $packageInfo->title }}</a>
                                                            </h6>
                                                            <ul
                                                                class="product-icon-list list-unstyled d-flex align-items-center">
                                                                <li class="icon-start">
                                                                    <i class="fal fa-calendar-check"></i>
                                                                    <span> {{ $packageInfo->package->number_of_days }}
                                                                        {{ $keywords['Days'] ?? __('Days') }}</span>
                                                                </li>
                                                                <li class="icon-start">
                                                                    <i class="fal fa-user-friends"></i>
                                                                    <span>
                                                                        {{ $packageInfo->package?->max_persons != null ? $packageInfo->package?->max_persons : '-' }}
                                                                        {{ $packageInfo->package?->max_persons == 1 ? $keywords['Person'] ?? __('Person') : $keywords['Persons'] ?? __('Persons') }}
                                                                    </span>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @empty
                                            <h3 class="text-center">
                                                {{ $keywords['No Package Found!'] ?? __('No Package Found!') }}
                                            </h3>
                                        @endforelse

                                        @if (count($packageInfos) > 8)
                                            <div class="text-center mt-20" data-aos="fade-up">
                                                <a href="{{ route('packages', [getParam(), 'category' => $package_category->slug]) }}"
                                                    class="btn btn-lg btn-primary">
                                                    {{ $keywords['View All Items'] ?? __('View All Items') }}
                                                </a>
                                            </div>
                                        @endif

                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Package Section End -->
    @endif
    <!-- Product-area end -->

    <!-- After latest package section -->
    @if (isset($after_latest_packages) &&
            count($after_latest_packages) > 0 &&
            in_array('Tour Package', $packagePermissions))
        @foreach ($after_latest_packages as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Video-banner start -->
    @if ($sections->video_section == 1)
        <div class="video-banner video-banner-2 pt-100 bg-img lazyload position-relative z-1 bg-a-fixed"
            data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_VIDEO_SECTION_IMAGE, $secHeading->video_section_image, $userBs, 'assets/user-front/default-img/choose-1-2.jpg') }}">
            <!-- Bg overlay -->
            <div class="overlay opacity-50"></div>
            <div class="container">
                <div class="wrapper" data-aos="fade-up">
                    <div class="text-center ptb-100">
                        @if (!empty($secHeading->video_section_video_url))
                            <a href="{{ $secHeading->video_section_video_url }}" class="video-btn youtube-popup mx-auto">
                                <i class="fas fa-play"></i>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- Call To Action End -->
    @endif
    <!-- Video-banner end -->

    <!-- Counter-area start -->
    @if ($sections->statistics_section == 1)
        <div class="counter-area counter-2">
            <div class="container">
                <div class="wrapper rounded-pill pt-60 pb-30 bg-img lazyload"
                    data-bg-image="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_STATISTICS_SECTION_IMAGE, $secHeading->statistics_section_image, $userBs, 'assets/user-front/default-img/statitics-bg-1.jpg') }}">
                    <div class="overlay opacity-25"></div>
                    <div class="d-flex justify-content-center">
                        @if (count($counterInfos) > 0)
                            @foreach ($counterInfos as $counterInfo)
                                <div class="col-sm-6 col-lg-3" data-aos="fade-up">
                                    <div class="card text-center mb-30">
                                        <div class="card-icon color-white mb-10">
                                            <i class="{{ $counterInfo->icon }}"></i>
                                        </div>
                                        <div class="card-content">
                                            <span class="h2 mb-1 color-white"><span
                                                    class="counter">{{ $counterInfo->amount }}</span></span>
                                            <p class="card-text font-lg color-white lh-1">{{ $counterInfo->title }}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- Counter-area end -->

    <!-- Choose-area start -->
    @if ($sections->facilities_section == 1)
        <section class="choose-area choose-3 pt-100 pb-60">
            <div class="container">
                <div class="row gx-xl-5 align-items-center">
                    <div class="col-lg-6" data-aos="fade-right">
                        @if (!is_null($secHeading))
                            <div class="image mb-40">
                                <div class="img-1">
                                    <img class="blur-up lazyload"
                                        data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $secHeading->facility_section_image, $userBs, 'assets/user-front/default-img/facility.jpg') }}"
                                        alt="Image">
                                </div>
                                <div class="img-2">
                                    <img class="lazyload blur-up"
                                        data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $secHeading->facility_section_image_two, $userBs, 'assets/user-front/default-img/facility.jpg') }}"
                                        alt="Image">
                                </div>
                                <div class="img-3">
                                    <img class="lazyload blur-up"
                                        data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_FACILITY_SECTION_IMAGE, $secHeading->facility_section_image_three, $userBs, 'assets/user-front/default-img/facility.jpg') }}"
                                        alt="Image">
                                </div>

                            </div>
                        @endif
                    </div>
                    <div class="col-lg-6" data-aos="fade-left">
                        <div class="content mb-10">
                            @if (!is_null($secHeading))
                                <div class="content-title">
                                    <h2 class="title mb-30">{{ convertUtf8($secHeading->facility_section_title) }}</h2>
                                </div>
                                <p class="text">{{ convertUtf8($secHeading->facility_section_subtitle) }}</p>
                            @endif

                            @if (count($facilities) > 0)
                                <div class="item-list mt-40">
                                    @foreach ($facilities as $facility)
                                        <div class="item d-flex gap-3 mb-30">
                                            <div class="icon rounded-pill">
                                                <i class="{{ $facility->facility_icon }}"></i>
                                            </div>
                                            <div class="content w-75 w-sm-100">
                                                <h4 class="mb-2 lh-1">{{ convertUtf8($facility->facility_title) }}</h4>
                                                <p class="card-text">{{ $facility->facility_text }}</p>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    <!-- Choose-area end -->

    <!-- After facilities section -->
    @if (isset($after_facilities) && count($after_facilities) > 0)
        @foreach ($after_facilities as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif

    <!-- Sponsor Start  -->
    @if ($sections->brand_section == 1)
        <section class="sponsor pb-100">
            <div class="container">
                @if (count($brands) == 0)
                    <div class="row text-center">
                        <div class="col">
                            <h3>{{ $keywords['No Brand Found!'] ?? __('No Brand Found!') }}</h3>
                        </div>
                    </div>
                @else
                    <div class="row">
                        <div class="col-12">
                            <div class="swiper sponsor-slider">
                                <div class="swiper-wrapper">
                                    @foreach ($brands as $brand)
                                        <div class="swiper-slide">
                                            <div class="sponsor-img text-center">
                                                <a href="{{ $brand->brand_url }}" target="_blank">
                                                    <img class="lazyload blur-up"
                                                        data-src="{{ asset(Constant::WEBSITE_BRAND_IMAGE . '/' . $brand->brand_img) }}"
                                                        alt="Sponsor">
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="swiper-pagination position-static mt-30" id="sponsor-slider-pagination"
                                    data-aos="fade-up">
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </section>
    @endif
    <!-- Sponsor End -->

    <!-- After brand_sectionn -->
    @if (isset($after_brand) && count($after_brand) > 0)
        @foreach ($after_brand as $cusHero)
            @if (isset($additional_section_status[$cusHero->id]))
                @if ($additional_section_status[$cusHero->id] == 1)
                    @php
                        $cusHeroContent = App\Models\User\AdditionalSectionContent::where([
                            ['language_id', $language->id],
                            ['addition_section_id', $cusHero->id],
                        ])->first();
                    @endphp
                    @if(!is_null($cusHeroContent))
                    @includeIf('user-front.common.additional-section', [
                        'data' => $cusHeroContent,
                        'possition' => $cusHero->possition,
                    ])
                    @endif
                @endif
            @endif
        @endforeach
    @endif


@endsection
@section('script')
    <script src="{{ asset('assets/user-front/js/home.js') }}"></script>
@endsection
