@extends('user-front.common.layout')

@section('pageHeading')

    {{ $keywords['Package Bookings'] ?? __('Package Bookings') }}
@endsection

@php
    $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
    $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $bgImg->breadcrumb,
            'title' => $pageHeading->package_bookings_page_title ??__('Package Bookings'),
        ])
        <!-- Breadcrumb Section End -->

        <!-- All Package Bookings Area Start -->
        <section class="user-dashboard section-bg">
            <div class="container">
                <div class="row">
                    @include('user-front.common.customer.common.side-navbar')
                    <div class="col-lg-9">
                        <div class="row">
                            <div class="col-lg-12">
                                @if (count($packageBookingInfos) == 0)
                                    <div class="py-5 bg-white">
                                        <h3 class="text-center">
                                            {{ $keywords['No Package Booking Found!'] ?? __('No Package Booking Found!') }}
                                        </h3>
                                    </div>
                                @else
                                    <div class="user-profile-details bg-white">
                                        <div class="account-info">
                                            <div class="title">
                                                <h4>{{ $keywords['Recent Package Bookings'] ?? __('Recent Package Bookings') }}
                                                </h4>
                                            </div>

                                            <div class="main-info">
                                                <div class="main-table">
                                                    <div class="table-responsive">
                                                        <table id="dashboard-datatable"
                                                            class="dataTables_wrapper dt-responsive table-striped dt-bootstrap4"
                                                            style="width:100%">
                                                            <thead>
                                                                <tr>
                                                                    <th>{{ $keywords['Booking Number'] ?? __('Booking Number') }}
                                                                    </th>
                                                                    <th>{{ $keywords['Title'] ?? __('Title') }}</th>
                                                                    <th>{{ $keywords['Booking Date'] ?? __('Booking Date') }}
                                                                    </th>
                                                                    <th>{{ $keywords['Booking Status'] ?? __('Booking Status') }}
                                                                    </th>
                                                                    <th>{{ $keywords['Action'] ?? __('Action') }}</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($packageBookingInfos as $info)
                                                                    <tr>
                                                                        <td class="pl-3">{{ '#' . $info->booking_number }}
                                                                        </td>

                                                                        @php
                                                                            $packageTitle = '---';
                                                                            if ($info->tourPackage && optional($info->tourPackage->packageContent)->isNotEmpty()) {
                                                                                $packageDetails = $info->tourPackage
                                                                                    ->packageContent()
                                                                                    ->where('language_id',$langInfo->id)
                                                                                    ->first();
                                                                                $packageTitle = $packageDetails->title;
                                                                            }

                                                                        @endphp

                                                                        <td class="pl-3">
                                                                            <a target="_blank"
                                                                                href="{{ isset($packageDetails) ?  route('package_details', [getParam(), $packageDetails->slug])  : '#' }}">
                                                                                {{ strlen($packageTitle) > 20 ? mb_substr($packageTitle, 0, 20) . '...' : $packageTitle }}
                                                                            </a>
                                                                        </td>

                                                                        <td class="pl-3">
                                                                            {{ date_format($info->created_at, 'M d, Y') }}
                                                                        </td>

                                                                        {{-- if payment_status == 1 then, booking is complete. otherwise booking is pending --}}
                                                                        @if ($info->payment_status == 1)
                                                                            <td class="pl-3">
                                                                                <span class="badge bg-success">
                                                                                    {{ $keywords['Complete'] ?? __('Complete') }}
                                                                                </span>
                                                                            </td>
                                                                        @else
                                                                            <td class="pl-3">
                                                                                <span class="badge bg-warning">
                                                                                    {{ $keywords['Pending'] ?? __('Pending') }}
                                                                                </span>
                                                                            </td>
                                                                        @endif

                                                                        <td class="pl-3">
                                                                            <a href="{{ route('user.package_booking_details', [getParam(), 'id' => $info->id]) }}"
                                                                                class="btn">
                                                                                {{ $keywords['Details'] ?? __('Details') }}
                                                                            </a>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- All Package Bookings Area End -->
    </main>
@endsection
