@extends('user-front.common.layout')

@section('pageHeading')
  {{ $keywords['Package Booking Details'] ?? __('Package Booking Details') }}
@endsection

@php
  $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
  $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
@endphp

@section('meta-keywords', "$metaKeys")
@section('meta-description', "$metaDesc")

@section('content')
  <main>
    <!-- Breadcrumb Section Start -->
    @includeIf('user-front.common.partials.breadcrumb', [
        'breadcrumb' => $bgImg->breadcrumb,
        'title' => $keywords['Package Booking Details'] ?? __('Package Booking Details'),
    ])
    <!-- Breadcrumb Section End -->

    <!-- Package Booking Details Area Start -->
    <section class="user-dashboard">
      <div class="container">
        <div class="row">
          @include('user-front.common.customer.common.side-navbar')

          <div class="col-lg-9">
            <div class="row">
              <div class="col-lg-12">
                <div class="user-profile-details">
                  <div class="order-details">
                    <div class="title">
                      <h4>{{ $keywords['Package Booking Details'] ?? __('Package Booking Details') }}</h4>
                    </div>

                    <div class="view-order-page">
                      <div class="order-info-area">
                        <div class="row align-items-center">
                          <div class="col-lg-8">
                            <div class="order-info mb-20">
                              <h3>{{ $keywords['Booking'] ?? __('Booking') }} {{ ': ' . '#' . $details->booking_number }}
                              </h3>
                              <p>{{ $keywords['Booking Date'] ?? __('Booking Date') }}
                                {{ ': ' . date_format($details->created_at, 'M d, Y') }}</p>
                            </div>
                          </div>

                          <div class="col-lg-4">
                            <div class="print">
                              <a href="{{ asset('assets/tenant/invoices/packages/' . $details->invoice) }}" download
                                class="theme-btn">
                                <i class="fas fa-download"></i>{{ $keywords['Invoice'] ?? __('Invoice') }}
                              </a>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="billing-add-area">
                      <div class="row">
                        <div class="col-md-6 billing-add-item">
                          <div class="main-info mb-30">
                            <h5 class="color-1">
                              <span class="me-2">
                                <i class="far fa-user"></i>
                              </span>
                              {{ $keywords['User Information'] ?? __('User Information') }}
                            </h5>
                            <ul class="list">
                              <li>
                                <strong>{{ $keywords['Name'] ?? __('Name') . ':' }}:</strong>{{ $userInfo->first_name . ' ' . $userInfo->last_name }}
                              </li>

                              <li>
                                <strong>{{ $keywords['Email'] ?? __('Email') . ':' }}:</strong>
                                {{ $userInfo->email }}
                              </li>

                              <li>
                                <strong>{{ $keywords['Phone'] ?? __('Phone') . ':' }}:</strong>
                                {{ $userInfo->contact_number }}
                              </li>

                              <li>
                                <strong>{{ $keywords['Address'] ?? __('Address') . ':' }}:</strong>
                                {{ $userInfo->address }}
                              </li>

                              <li>
                                <strong>{{ $keywords['City'] ?? __('City') . ':' }}:</strong>
                                {{ $userInfo->city }}
                              </li>

                              <li>
                                <strong>{{ $keywords['State'] ?? __('State') . ':' }}:</strong>
                                {{ $userInfo->state }}
                              </li>

                              <li>
                                <strong>{{ $keywords['Country'] ?? __('Country') . ':' }}:</strong>
                                {{ $userInfo->country }}
                              </li>
                            </ul>
                          </div>
                        </div>

                        @php
                          $position = $details->currency_symbol_position;
                          $symbol = $details->currency_symbol;
                        @endphp

                        <div class="col-md-6 billing-add-item">
                          <div class="main-info mb-30">
                            <h5 class="color-2">
                              <span class="me-2">
                                <i class="far fa-credit-card"></i>
                              </span>
                              {{ $keywords['Payment Information'] ?? __('Payment Information') }}
                            </h5>
                            <ul class="list">
                              <li>
                                <strong>{{ $keywords['Subtotal'] ?? __('Subtotal') . ':' }}:</strong>
                                <span class="amount">
                                  {{ $position == 'left' ? $symbol : '' }}{{ $details->subtotal }}{{ $position == 'right' ? $symbol : '' }}
                                </span>
                              </li>

                              <li>
                                <strong>{{ $keywords['Discount'] ?? __('Discount') }} (<i
                                    class="far fa-minus text-success"></i>):</strong>
                                <span class="amount">
                                  {{ $position == 'left' ? $symbol : '' }}{{ $details->discount }}{{ $position == 'right' ? $symbol : '' }}
                                </span>
                              </li>

                              <li>
                                <strong>{{ $keywords['Total'] ?? __('Total' . ':') }}</strong>
                                <span class="amount">
                                  {{ $position == 'left' ? $symbol : '' }}{{ $details->grand_total }}{{ $position == 'right' ? $symbol : '' }}
                                </span>
                              </li>

                              <li>
                                <strong>{{ $keywords['Paid via'] ?? __('Paid via') }}:</strong>
                                {{ $details->payment_method }}
                              </li>

                              <li>
                                @if ($details->payment_status == 1)
                                  <strong>{{ $keywords['Payment Status'] ?? __('Payment Status') }} :</strong>
                                  <span class="badge bg-success px-2 py-1">
                                    {{ $keywords['Complete'] ?? __('Complete') }}
                                  </span>
                                @else
                                  <strong>{{ $keywords['Payment Status'] ?? __('Payment Status') }} :</strong>
                                  <span class="badge bg-warning px-2 py-1">
                                    {{ $keywords['Pending'] ?? __('Pending') }}
                                  </span>
                                @endif
                              </li>
                            </ul>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="edit-account-info">
                      <a href="{{ url()->previous() }}" class="theme-btn">{{ $keywords['Back'] ?? __('Back') }}</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Package Booking Details Area End -->
  </main>
@endsection
