        @extends('user-front.common.layout')

        @section('pageHeading')
        @if (!empty($pageHeading))
            {{ $keywords['Room Bookings'] ?? __('Room Bookings') }}
        @endif
        @endsection

        @php
        $metaKeys = !empty($seo->home_meta_keywords) ? $seo->home_meta_keywords : '';
        $metaDesc = !empty($seo->home_meta_description) ? $seo->home_meta_description : '';
        @endphp

        @section('meta-keywords', "$metaKeys")
        @section('meta-description', "$metaDesc")

        @section('content')
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $bgImg->breadcrumb,
            'title' => $pageHeading?->room_bookings_page_title ?? __('Room Bookings'),
        ])

        <!-- Start User Enrolled Room Section -->
        <section class="user-dashboard section-bg">
            <div class="container">
            <div class="row">
                @includeIf('user-front.common.customer.common.side-navbar')
                <div class="col-lg-9">
                <div class="row">
                    <div class="col-lg-12">
                    @if (count($roomBookingInfos) == 0)
                        <div class="py-5 bg-white">
                        <h3 class="text-center">
                            {{ $keywords['No Room Booking Found!'] ?? __('No Room Booking Found!') }}
                        </h3>
                        </div>
                    @else
                        <div class="user-profile-details bg-white">
                        <div class="account-info">
                            <div class="title">
                            <h4>{{ $keywords['Recent Room Bookings'] ?? __('Recent Room Bookings') }}</h4>
                            </div>

                            <div class="main-info">
                            <div class="main-table">
                                <div class="table-responsive">
                                <table id="dashboard-datatable"
                                    class="dataTables_wrapper dt-responsive table-striped dt-bootstrap4" style="width:100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ $keywords['Booking Number'] ?? __('Booking Number') }}
                                        </th>
                                        <th scope="col">{{ $keywords['Title'] ?? __('Title') }}</th>
                                        <th scope="col">{{ $keywords['Booking Date'] ?? __('Booking Date') }}
                                        </th>
                                        <th scope="col">{{ $keywords['Booking Status'] ?? __('Booking Status') }}
                                        </th>
                                        <th scope="col">{{ $keywords['Action'] ?? __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($roomBookingInfos as $info)
                                        <tr>
                                        <td class="pl-3">{{ '#' . $info->booking_number }}
                                        </td>

                                        @php
                                            $room = $info->hotelRoom()->first();

                                            $roomDetails = $room
                                                ->roomContent()
                                                ->where('language_id', $langInfo->id)
                                                ->first();

                                            $roomTitle = $roomDetails->title;
                                        @endphp

                                        <td class="pl-3">
                                            <a target="_blank"
                                            href="{{ route('room_details', [getParam(), 'slug' => $roomDetails->slug]) }}">
                                            {{ strlen($roomTitle) > 20 ? mb_substr($roomTitle, 0, 20) . '...' : $roomTitle }}
                                            </a>
                                        </td>

                                        <td class="pl-3">
                                            {{ date_format($info->created_at, 'M d, Y') }}</td>

                                        @if ($info->payment_status == 1)
                                            <td class="pl-3">
                                            <span class="badge bg-success">
                                                {{ $keywords['Complete'] ?? __('Complete') }}
                                            </span>
                                            </td>
                                        @else
                                            <td class="pl-3">
                                            <span class="badge bg-warning">
                                                {{ $keywords['Pending'] ?? __('Pending') }}
                                            </span>
                                            </td>
                                        @endif

                                        <td class="pl-3">
                                            <a href="{{ route('customer.room_booking_details', [getParam(), 'id' => $info->id]) }}"
                                            class="btn">
                                            {{ $keywords['Details'] ?? __('Details') }}
                                            </a>
                                        </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                </div>
                            </div>
                            </div>
                        </div>
                        </div>
                    @endif
                    </div>
                </div>
                </div>
            </div>
            </div>
        </section>
        <!-- End User Enrolled Room Section -->
        @endsection
