@extends('user-front.common.layout')

@section('pageHeading')
 {{ $pageHeading->services_page_title ?? ($keywords['Services'] ?? __('Services')) }}
@endsection

@php
    $metaKeywords = !empty($seo->services_meta_keywords) ? $seo->services_meta_keywords : '';
    $metaDescription = !empty($seo->services_meta_description) ? $seo->services_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords)
@section('meta-description', $metaDescription)

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $pageHeading->services_page_title ?? ($keywords['Services'] ?? __('Services')),
        ])
        <!-- Breadcrumb Section End -->

        <!-- Service Section Start -->
        <section class="service-section section-padding section-bg">
            <div class="container">
                @if (count($serviceInfos) == 0)
                    <div class="bg-white py-5">
                        <h3 class="text-center">{{ $keywords['No Service Found!'] ?? __('No Service Found!') }}</h3>
                    </div>
                @else
                    <!-- Section Title -->
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="section-title text-center">
                                @if (!is_null($secHeading))
                                    <span class="title-top">{{ convertUtf8($secHeading->service_section_title) }}</span>
                                    <h1>{{ convertUtf8($secHeading->service_section_subtitle) }}</h1>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Service Boxes -->
                    <div class="row">
                        @foreach ($serviceInfos as $serviceInfo)
                            <div class="col-lg-4 col-md-6">
                                <!-- Single Service -->
                                <div class="single-service-box service-white-bg text-center wow fadeIn animated"
                                    data-wow-duration="1500ms" data-wow-delay="{{ $loop->iteration * 200 }}ms">
                                    <span class="service-counter">{{ $loop->iteration }}</span>
                                    <div class="service-icon">
                                        <i class="{{ $serviceInfo->service_icon }}"></i>
                                    </div>
                                    <h4>{{ convertUtf8($serviceInfo->title) }}</h4>
                                    <p>
                                        {{ strlen($serviceInfo->summary) > 60 ? substr($serviceInfo->summary, 0, 60) . '...' : $serviceInfo->summary }}
                                    </p>
                                    @if ($serviceInfo->details_page_status == 1)
                                        <a href="{{ route('service_details', [getParam(), 
                                        'slug' => $serviceInfo->slug]) }}"
                                            class="read-more">
                                            {{ $keywords['read more'] ?? __('read more') }} <i class="far fa-long-arrow-right"></i>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif

                <!-- Ads sections -->
                @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
                    @if (!empty(showAd(3)))
                        <div class="text-center mt-0">
                            {!! showAd(3) !!}
                        </div>
                    @endif
                @endif
            </div>
        </section>
        <!-- Service Section End -->

    </main>
@endsection
