@extends('user-front.common.layout')

@section('pageHeading')
   {{ $keywords['Service Details'] ?? __('Service Details') }}
@endsection

@php
    $metaKeys = !empty($details) ? $details->meta_keywords : '';
    $metaDesc = !empty($details) ? $details->meta_description : '';
@endphp

@section('meta-keywords', $metaKeys)
@section('meta-description', $metaDesc)

@section('og-title', Str::limit(convertUtf8($details->title), 70))
@section('og-description',  Str::limit($details->summary,200))

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $keywords['Service Details'] ?? __('Service Details'),
            'top_title' => convertUtf8($details->title),
        ])
        <!-- Breadcrumb Section End -->
        <section class="service-details-section pt-130 pb-130">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="service-sidebar">
                            <div class="widgets service-cat">
                                <h4 class="widget-title">{{ $keywords['More Services'] ?? __('More Services') }}</h4>
                                @if (count($moreServices) == 0)
                                    <h5>{{ $keywords['No More Service Found!'] ?? __('No More Service Found!') }}</h5>
                                @else
                                    <ul class="service-cat-list">
                                        @foreach ($moreServices as $moreService)
                                            @if (!is_null($moreService->service))
                                                <li>
                                                    @php
                                                        $href = '#';
                                                        if ($moreService->service->details_page_status == 1) {
                                                            $href = route('service_details', [
                                                                getParam(),
                                                                'slug' => $moreService->slug,
                                                            ]);
                                                        }
                                                    @endphp
                                                    <a href="{{ $href }}">{{ $moreService->title }}<i
                                                            class="far fa-angle-right"></i></a>
                                                </li>
                                            @endif
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                            <div class="widget share-widget mt-2 mb-5">
                                <h4 class="widget-title text-center mb-2">
                                    {{ $keywords['Share This Service'] ?? __('Share This Service') }}</h4>
                                <ul class="social-icons d-flex justify-content-center align-items-center">
                                        @include('user-front.common.share-socail-media')
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Service Details Section Start -->
                    <div class="col-lg-8">
                        <div class="service-details">
                            <h2 class="title">{{ convertUtf8($details->title) }}</h2>
                            <p>{{ $details->summary }}</p>
                             <div class="summernote-content">
                               {!! replaceBaseUrl($details->content, 'summernote') !!}
                           </div>
                        </div>
                    </div>
                    <!-- Service Details Section End -->
                </div>
            </div>
        </section>
    </main>
@endsection
