   <div class="single-room">
       <a class="room-thumb d-block"
           href="{{ route('room_details', [getParam(),'slug'=> $roomInfo->slug]) }}">
           <img class="lazy" data-src="{{ asset('assets/tenant/img/rooms/' . $roomInfo->room->featured_img) }}"
               alt="">
           <div class="room-price">
               <p>
                   {{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'left' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                   {{ $roomInfo->room->rent }}
                   {{ dynamicPosition($currencyInfo->base_currency_symbol_position) == 'right' ? dynamicCurrency($currencyInfo->base_currency_symbol) : '' }}
                   / {{ $keywords['Night'] ?? __('Night') }}</p>
           </div>
       </a>
       <div class="room-desc">
               <div class="room-cat">
                   <a class="d-block p-0"
                       href="{{ route('rooms', [getParam(), 'category' => $roomInfo->category_slug]) }}">
                       {{ $roomInfo->category_name }}
                   </a>
               </div>
           <h4>
               <a
                   href="{{ route('room_details', [getParam(),'slug' => $roomInfo->slug]) }}">
                   {{ (strlen(strip_tags(convertUtf8($roomInfo->title))) > 40) ? substr(strip_tags(convertUtf8($roomInfo->title)), 0, 40) . '...' : strip_tags(convertUtf8($roomInfo->title)) }}
                  </a>
           </h4>
           <p>
             {{ (strlen(strip_tags(convertUtf8($roomInfo->summary))) > 108) ? substr(strip_tags(convertUtf8($roomInfo->summary)), 0, 108) . '...' : strip_tags(convertUtf8($roomInfo->summary)) }}
           </p>
           <ul class="room-info">
               <li><i class="far fa-bed"></i>{{ $roomInfo->room->bed }}
                   {{ $roomInfo->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
               </li>
               <li><i class="far fa-bath"></i>{{ $roomInfo->room->bath }}
                   {{ $roomInfo->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}
               </li>
               @if (!empty($roomInfo->room->max_guests))
                   <li><i class="far fa-users"></i>{{ $roomInfo->room->max_guests }}
                       {{ $roomInfo->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}
                   </li>
               @endif
           </ul>
       </div>
   </div>
