@extends('user-front.common.layout')

@section('pageHeading')
   {{ $pageHeading->rooms_page_title ?? ($keywords['Rooms'] ?? __('Rooms')) }}
@endsection


@php
    $metaKeywords = !empty($seo->rooms_meta_keywords) ? $seo->rooms_meta_keywords : '';
    $metaDescription = !empty($seo->rooms_meta_description) ? $seo->rooms_meta_description : '';
@endphp
@section('meta-keywords', $metaKeywords )
@section('meta-description',$metaDescription)

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $pageHeading->rooms_page_title ?? ($keywords['Rooms'] ?? __('Rooms')),
        ])
        <!-- Breadcrumb Section End -->

        <!-- All Rooms Section Start -->
        <section class="rooms-warp list-view section-bg section-padding ">
            <div class="container">
                <div class="row">
                    @includeIf('user-front.common.room.categories')
                </div>
                <div class="row" id="mainRows">
                    <div class="col-lg-4">
                        @includeIf('user-front.common.room.room_sidebar')
                    </div>
                    <div class="col-lg-8">
                        <div class="search-container">
                            @includeIf('user-front.common.room.grid_view')
                        </div>
                        @includeIf('user-front.common.room.skeleton')
                    </div>
                </div>
            </div>
        </section>
        <!-- All Rooms Section Start -->
    </main>
@endsection
@php
    $symbol = dynamicCurrency($currencyInfo->base_currency_symbol);
    $position = dynamicPosition($currencyInfo->base_currency_symbol_position);
@endphp
@section('script')
    <script>
        "use strict";
        var currentSymbol = "{!! $symbol !!}";
        var currentPosition = "{!! $position !!}";
        var searchUrl = "{{ route('rooms',getParam()) }}";

        var minprice = {{ $minPrice }};
        var maxprice = {{ $maxPrice }};
        var priceValues = [{{ $minRent }}, {{ $maxRent }}];
    </script>

    <script src="{{ asset('assets/user-front/js/rooms.js') }}"></script>
@endsection
