<div class="sidebar-wrap room_sidebar">
  <div class="widget fillter-widget">
    <h4 class="widget-title">{{ $keywords['Filters'] ?? __('Filters') }}</h4>
    <form action="{{ route('rooms', getParam()) }}" method="GET" id="searchForm">
      <input type="hidden" name="sidebar_search" value="1">
      <input type="hidden" name="category" value="{{ request()->input('category') }}" id="category_search">
      <div class="input-wrap">
        <label
          for=""><strong>{{ $keywords['Check In / Out Date'] ?? __('Check In / Out Date') }}</strong></label>
        <input type="text" placeholder="{{ $keywords['Dates'] ?? __('Dates') }}" id="date-range" name="dates"
          value="{{ request()->input('dates') }}" readonly>
      </div>
      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Location'] ?? __('Location') }}</strong></label>
        <input type="text" class="form-control" name="locations"
          placeholder="{{ $keywords['Location'] ?? __('Location') }}" id="locations">
      </div>

      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Beds'] ?? __('Beds') }}</strong></label>
        <select class="nice-select" name="beds" id="beds">
          <option selected value="">{{ $keywords['All'] ?? __('All') }}</option>

          @for ($i = 1; $i <= $numOfBed; $i++)
            <option value="{{ $i }}" {{ request()->input('beds') == $i ? 'selected' : '' }}>
              {{ $i }}</option>
          @endfor
        </select>
      </div>

      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Baths'] ?? __('Baths') }}</strong></label>
        <select class="nice-select" name="baths" id="baths">
          <option selected value="">{{ $keywords['All'] ?? __('All') }}</option>

          @for ($i = 1; $i <= $numOfBath; $i++)
            <option value="{{ $i }}" {{ request()->input('baths') == $i ? 'selected' : '' }}>
              {{ $i }}</option>
          @endfor
        </select>
      </div>

      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Guests'] ?? __('Guests') }}</strong></label>
        <select class="nice-select" name="guests" id="guests">
          <option selected value="">{{ $keywords['All'] ?? __('All') }}</option>
          @for ($i = 1; $i <= $maxGuests; $i++)
            <option value="{{ $i }}" {{ request()->input('guests') == $i ? 'selected' : '' }}>
              {{ $i }}</option>
          @endfor
        </select>
      </div>

      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Sort By'] ?? __('Sort By') }}</strong></label>
        <select class="nice-select" name="sort_by">
          <option {{ !empty(request()->input('sort_by')) || request()->input('sort_by') == 'desc' ? 'selected' : '' }}
            value="desc">{{ $keywords['Latest Rooms'] ?? __('Latest Rooms') }}</option>
          <option {{ request()->input('sort_by') == 'asc' ? 'selected' : '' }} value="asc">
            {{ $keywords['Oldest Rooms'] ?? __('Oldest Rooms') }}</option>
          <option {{ request()->input('sort_by') == 'price-asc' ? 'selected' : '' }} value="price-asc">
            {{ $keywords['Rent: Low to High'] ?? __('Rent: Low to High') }}</option>
          <option {{ request()->input('sort_by') == 'price-desc' ? 'selected' : '' }} value="price-desc">
            {{ $keywords['Rent: High to Low'] ?? __('Rent: High to Low') }}</option>
        </select>
      </div>

      <div class="input-wrap">
        <label for=""><strong>{{ $keywords['Rent'] ?? __('Rent') }} /
            {{ $keywords['Night'] ?? __('Night') }} ({{ $userBs->base_currency_text }})
          </strong></label>
        <div class="price-range-wrap mt-15">
          <div class="slider-range">
            <div id="price-range-slider"></div>
          </div>

          <div class="price-ammount">
            <input type="text" id="amount" name="rents" readonly />
          </div>
        </div>
      </div>

      <div class="input-wrap">
        <label for="">
          <strong>
            {{ $keywords['Amenities'] ?? __('Amenities') }}
          </strong>
        </label>

        <div class="checkboxes mt-1">
          @foreach ($amenities as $amenity)
            @if ($loop->iteration <= 3)
              <p class="d-block">
                <input type="checkbox" name="ammenities[]" value="{{ $amenity->indx }}" id="amm{{ $amenity->id }}"
                  {{ is_array(request()->input('ammenities')) && in_array($amenity->id, request()->input('ammenities')) ? 'checked' : '' }}>
                <label for="amm{{ $amenity->id }}">{{ $amenity->name }}</label>
              </p>
            @else
              <p class="d-none show-more">
                <input type="checkbox" name="ammenities[]" value="{{ $amenity->indx }}" id="amm{{ $amenity->id }}"
                  {{ is_array(request()->input('ammenities')) && in_array($amenity->id, request()->input('ammenities')) ? 'checked' : '' }}>
                <label for="amm{{ $amenity->id }}">{{ $amenity->name }}</label>
              </p>
            @endif
          @endforeach

          @if (count($amenities) > 3)
            <div class="more-ammenities">
              <a href="#">{{ $keywords['More Amenities'] ?? __('More Amenities') }}...</a>
            </div>
          @endif
        </div>
      </div>

      @if ($userBs->room_rating_status == 1)
        <div class="input-wrap">
          <label for=""><strong>{{ $keywords['Ratings'] ?? __('Ratings') }}</strong></label>
          <ul class="list-group custom-radio">
            <li class="d-flex justify-content-start align-items-center gap-2 mb-1">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio6" value=""
                checked>
              <label class="form-radio-label" for="radio6">
                <div class="product-ratings text-xsm">
                  <span>{{ __('All') }}</span>
                </div>
              </label>
            </li>
            <li class="d-flex justify-content-start align-items-center gap-1 mb-2">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio1" value="5">
              <label class="form-radio-label" for="radio1">
                <div class="rate">
                  <div class="rating" style="width:100%"></div>
                </div>
              </label>
            </li>
            <li class="d-flex justify-content-start align-items-center gap-1 mb-2">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio2" value="4">
              <label class="form-radio-label" for="radio2">
                <div class="rate">
                  <div class="rating" style="width:80%"></div>
                </div>
              </label>
            </li>
            <li class="d-flex justify-content-start align-items-center gap-1 mb-2">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio3" value="3">
              <label class="form-radio-label" for="radio3">
                <div class="rate">
                  <div class="rating" style="width:60%"></div>
                </div>
              </label>
            </li>
            <li class="d-flex justify-content-start align-items-center gap-1 mb-2">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio4" value="2">
              <label class="form-radio-label" for="radio4">
                <div class="rate">
                  <div class="rating" style="width:40%"></div>
                </div>
              </label>
            </li>
            <li class="d-flex justify-content-start align-items-center gap-1 mb-2">
              <input class="input-radio rating-ratio" type="radio" name="ratings" id="radio5" value="1">

              <label class="form-radio-label" for="radio5">
                <div class="rate">
                  <div class="rating" style="width:20%"></div>
                </div>
              </label>
            </li>
          </ul>
        </div>
      @endif

      <div class="input-wrap">
        <button type="submit" class="btn filled-btn btn-block w-100" id="reset_all_btn">
          <i class="fal fa-sync-alt"></i>
          {{ $keywords['Reset All'] ?? __('Reset All') }}
        </button>
      </div>

    </form>
  </div>
  <!-- Ads sections -->
  @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
    @if (!empty(showAd(1)))
      <div class="text-center mt-0 d-none d-md-block">
        {!! showAd(1) !!}
      </div>
    @endif
  @endif
</div>
