@extends('user-front.common.layout')

@section('pageHeading')
    {{ $keywords['Room Details'] ?? __('Room Details') }}
@endsection

@php
    $metaKeys = !empty($details->meta_keywords) ? $details->meta_keywords : '';
    $metaDesc = !empty($details->meta_description) ? $details->meta_description : '';
@endphp

@section('meta-keywords', $metaKeys)
@section('meta-description', $metaDesc)

@section('og-title', Str::limit(convertUtf8($details->title), 70))
@section('og-description', Str::limit($details->summary, 200))

@section('content')
    <main>
        <!-- Breadcrumb Section Start -->
        @includeIf('user-front.common.partials.breadcrumb', [
            'breadcrumb' => $breadcrumbInfo?->breadcrumb,
            'title' => $keywords['Room Details'] ?? __('Room Details'),
            'top_title' => convertUtf8($details->title),
        ])
        <!-- Breadcrumb Section End -->

        <section class="room-details-wrapper section-padding ">
            @php
                $position = dynamicPosition($currencyInfo->base_currency_symbol_position);
                $symbol = dynamicCurrency($currencyInfo->base_currency_symbol);
            @endphp

            <div class="container">
                {{-- show error message for attachment --}}
                @error('attachment')
                    <div class="row">
                        <div class="col">
                            <div class="alert alert-danger alert-block">
                                <strong>{{ $message }}</strong>
                                <button type="button" class="close" data-dismiss="alert">×</button>
                            </div>
                        </div>
                    </div>
                @enderror

                {{-- show error message for room review --}}
                @error('rating')
                    <div class="row">
                        <div class="col">
                            <div class="alert alert-danger alert-block">
                                <strong>{{ $message }}</strong>
                                <button type="button" class="close" data-dismiss="alert">×</button>
                            </div>
                        </div>
                    </div>
                @enderror

                <div class="row">
                    <!-- Room Details Section Start -->
                    <div class="col-lg-8">
                        <div class="room-details">
                            <div class="entry-header">
                                <div class="post-thumb position-relative">
                                    <div class="post-thumb-slider">
                                        @php
                                            $sliderImages = json_decode($details->room->slider_imgs);
                                        @endphp
                                        <div class="main-slider">
                                            @foreach ($sliderImages as $image)
                                                <div class="single-img">
                                                    <a href="{{ asset('assets/tenant/img/rooms/slider_images/' . $image) }}"
                                                        class="main-img">
                                                        <img src="{{ asset('assets/tenant/img/rooms/slider_images/' . $image) }}"
                                                            alt="Image">
                                                    </a>
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="dots-slider row">
                                            @foreach ($sliderImages as $image)
                                                <div class="single-dots">
                                                    <img src="{{ asset('assets/tenant/img/rooms/slider_images/' . $image) }}"
                                                        alt="image">
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="price-tag">
                                        {{ $position == 'left' ? $symbol : '' }}{{ $details->room->rent }}{{ $position == 'right' ? $symbol : '' }}
                                        / {{ $keywords['Night'] ?? __('Night') }}
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between mb-4">
                                    @php
                                        $category = \App\Models\User\RoomCategory::where(
                                            'indx',
                                            $details->room->category_index,
                                        )
                                            ->where('language_id', $details->language_id)
                                            ->first();
                                    @endphp
                                    <div class="room-cat mb-0">
                                        <a href="{{ route('rooms', [getParam(), 'category' => $category->slug]) }}">
                                            {{ !is_null($category) ? $category->name : '' }}
                                        </a>
                                    </div>

                                    @if ($userBs->room_rating_status == 1)
                                        <div class="rate">
                                            <div class="rating" style="width:{{ $avgRating * 20 }}%"></div>
                                        </div>
                                    @endif
                                </div>

                                <p id="room-id" class="d-none">{{ $details->room_id }}</p>

                                <h2 class="entry-title">{{ convertUtf8($details->title) }}</h2>
                                <ul class="entry-meta list-inline">
                                    <li><i class="far fa-bed"></i>{{ $details->room->bed }}
                                        {{ $details->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                                    </li>
                                    <li><i class="far fa-bath"></i>{{ $details->room->bath }}
                                        {{ $details->room->bath == 1 ? $keywords['Bath'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}
                                    </li>
                                    @if (!empty($details->room->max_guests))
                                        <li><i class="far fa-users"></i>{{ $details->room->max_guests }}
                                            {{ $details->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}
                                        </li>
                                    @endif
                                </ul>
                            </div>

                            <div class="room-details-tab">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <ul class="nav desc-tab-item" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link active" href="#desc" role="tab"
                                                    data-bs-toggle="tab">
                                                    {{ $keywords['Room Details'] ?? __('Room Details') }}
                                                </a>
                                            </li>

                                            <li class="nav-item">
                                                <a class="nav-link" href="#amm" role="tab" data-bs-toggle="tab">
                                                    {{ $keywords['Amenities'] ?? __('Amenities') }}
                                                </a>
                                            </li>

                                            <li class="nav-item">
                                                <a class="nav-link" href="#location" role="tab" data-bs-toggle="tab">
                                                    {{ $keywords['Contact Info'] ?? __('Contact Info') }}
                                                </a>
                                            </li>

                                            <li class="nav-item {{ $userBs->room_rating_status == 0 ? 'd-none' : '' }}">
                                                <a class="nav-link" href="#reviews" role="tab" data-bs-toggle="tab">
                                                    {{ $keywords['Reviews'] ?? __('Reviews') }}
                                                </a>
                                            </li>
                                        </ul>
                                    </div>

                                    <div class="col-sm-9">
                                        <div class="tab-content desc-tab-content">
                                            <div role="tabpanel" class="tab-pane fade in active show" id="desc">
                                                <h5 class="tab-title">{{ $keywords['Room Details'] ?? __('Room Details') }}
                                                </h5>
                                                <div class="entry-content">
                                                    <div class="summernote-content">{!! replaceBaseUrl($details->description, 'summernote') !!}</div>
                                                </div>
                                            </div>

                                            <div role="tabpanel" class="tab-pane fade" id="amm">
                                                <h5 class="tab-title">{{ $keywords['Amenities'] ?? __('Amenities') }}</h5>
                                                <div class="ammenities">

                                                    @foreach ($amms as $key => $amm)
                                                        <a>{{ $amm }}</a>
                                                    @endforeach
                                                </div>
                                            </div>

                                            <div role="tabpanel" class="tab-pane fade" id="location">
                                                <div class="room-location">
                                                    <div class="row">
                                                        @if (!empty($details->address))
                                                            <div class="col-4">
                                                                <h6>{{ $keywords['Address'] ?? __('Address') }}</h6>
                                                                <p>{{ $details->address }}</p>
                                                            </div>
                                                        @endif

                                                        @if (!empty($details->phone))
                                                            <div class="col-4">
                                                                <h6>{{ $keywords['Phone'] ?? __('Phone') }}</h6>
                                                                <p>{{ $details->phone }}
                                                                </p>
                                                            </div>
                                                        @endif

                                                        @if (!empty($details->email))
                                                            <div class="col-4">
                                                                <h6>{{ $keywords['Email'] ?? __('Email') }}</h6>
                                                                <p>{{ $details->email }}</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>

                                                @if (!empty($details->latitude) && !empty($details->longitude))
                                                    <h5 class="tab-title mt-3">
                                                        {{ $keywords['Google Map'] ?? __('Google Map') }}</h5>
                                                    <div>
                                                        <iframe width="100%" height="400" frameborder="0" scrolling="no"
                                                            marginheight="0" marginwidth="0"
                                                            src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q={{ $details->latitude }},%20{{ $details->longitude }}+(My%20Business%20Name)&amp;t=&amp;z=15&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                                                    </div>
                                                @endif
                                            </div>

                                            <div role="tabpanel" class="tab-pane fade" id="reviews">
                                                <div class="comment-area">
                                                    <h5 class="tab-title">{{ $keywords['Reviews'] ?? __('Reviews') }}</h5>

                                                    @if (count($reviews) == 0)
                                                        <div class="bg-light py-5">
                                                            <h6 class="text-center">
                                                                {{ $keywords['This Room Has No Review Yet .'] ?? __('This Room Has No Review Yet .') }}
                                                            </h6>
                                                        </div>
                                                    @else
                                                        <ul class="comment-list">
                                                            @foreach ($reviews as $review)
                                                                <li>
                                                                    @php
                                                                        $user = $review->customer()->first();
                                                                    @endphp

                                                                    <div class="comment-user">
                                                                        <img class="lazy"
                                                                            data-src="{{ \App\Http\Helpers\Uploader::getImageUrl(Constant::WEBSITE_TENANT_CUSTOMER_IMAGE, @Auth::guard('customer')?->user()?->image, $userBs, 'assets/tenant/img/customer.jpg') }}"
                                                                            alt="user image">
                                                                    </div>

                                                                    <div class="comment-desc">
                                                                        <h6>{{ $user->first_name . ' ' . $user->last_name }}
                                                                            <span class="comment-date">
                                                                                {{ date('d-m-Y', strtotime($review->created_at)) }}</span>
                                                                        </h6>

                                                                        <p>{{ $review->comment }}</p>

                                                                        <div class="user-rating">
                                                                            @for ($i = 1; $i <= $review->rating; $i++)
                                                                                <i class="fa fa-star"></i>
                                                                            @endfor
                                                                        </div>
                                                                    </div>
                                                                </li>
                                                            @endforeach
                                                        </ul>
                                                    @endif
                                                </div>

                                                @guest('customer')
                                                    <h5>{{ $keywords['Please'] ?? __('Please') }}
                                                        <a
                                                            href="{{ route('customer.login', [getParam(), 'redirectPath' => 'package_details']) }}">
                                                            {{ $keywords['Login'] ?? __('Login') }}</a>
                                                        {{ $keywords['To Give Your Review.'] ?? __('To Give Your Review .') }}
                                                    </h5>
                                                @endguest

                                                @auth('customer')
                                                    <div class="review-form">
                                                        <h5 class="tab-title">
                                                            {{ $keywords['Give Your Review.'] ?? __('Give Your Review .') }}
                                                        </h5>
                                                        <form
                                                            action="{{ route('room.store_review', [getParam(), 'id' => $details->room_id]) }}"
                                                            method="POST">
                                                            @csrf
                                                            <div class="mb-25">
                                                                <div class="review-content">
                                                                    <ul class="review-value review-1">
                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="1">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>
                                                                    </ul>

                                                                    <ul class="review-value review-2">
                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="2">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="2">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>
                                                                    </ul>

                                                                    <ul class="review-value review-3">
                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="3">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="3">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="3">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>
                                                                    </ul>

                                                                    <ul class="review-value review-4">
                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="4">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="4">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="4">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="4">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>
                                                                    </ul>

                                                                    <ul class="review-value review-5">
                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="5">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="5">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="5">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="5">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>

                                                                        <li>
                                                                            <a class="cursor-pointer" data-ratingVal="5">
                                                                                <i class="far fa-star"></i>
                                                                            </a>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                            <input type="hidden" id="ratingId" name="rating">
                                                            <div class="input-wrap text-area">
                                                                <textarea placeholder="{{ $keywords['Review'] ?? __('Review') }}" name="comment">{{ old('comment') }}</textarea>
                                                                <i class="far fa-pencil"></i>
                                                            </div>
                                                            <div class="input-wrap">
                                                                <button type="submit" class="btn filled-btn btn-block px-3">
                                                                    {{ $keywords['Submit'] ?? __('Submit') }}
                                                                </button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                @endauth
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Room Details Section End -->

                    <!-- Sidebar Area Start -->
                    <div class="col-lg-4">
                        <div class="sidebar-wrap">
                            <div class="widget booking-widget">
                                <h4 class="widget-title">
                                    {{ $position == 'left' ? $symbol : '' }}{{ $details->room->rent }}{{ $position == 'right' ? $symbol : '' }}
                                    / <span>{{ $keywords['Night'] ?? __('Night') }}</span>
                                </h4>



                                @if (Auth::guard('customer')->check() == false && $userBs->room_guest_checkout_status == 1)
                                    <div class="alert alert-warning">
                                        {{ $keywords['You are now booking as a guest. if you want to log in before booking, then please'] ?? __('You are now booking as a guest. if you want to log in before booking, then please') }}
                                        <a
                                            href="{{ route('user.login', ['redirectPath' => 'room_details']) }}">{{ $keywords['Click_Here'] ?? __('Click Here') }}</a>
                                    </div>
                                @endif

                                <form action="{{ route('room_booking', getParam()) }}" method="POST"
                                    enctype="multipart/form-data" id="web-payment">
                                    @csrf
                                    <input type="hidden" name="room_id" value="{{ $details->room_id }}">
                                    <input type="hidden" name="language_id" value="{{ $details->language_id }}">

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            <input type="text"
                                                placeholder="{{ $keywords['Check In / Out Date'] ?? __('Check In / Out Date') }}"
                                                id="date-range" name="dates" value="{{ old('dates') }}" readonly>
                                            <i class="far fa-calendar-alt"></i>
                                        </div>
                                        @error('dates')
                                            <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            <input type="text"
                                                placeholder="{{ $keywords['Number of Nights'] ?? __('Number of Nights') }}"
                                                id="night" name="nights" value="{{ old('nights') }}" readonly>
                                            <i class="fas fa-moon"></i>
                                        </div>
                                        <small
                                            class="text-primary mt-2 {{ $currentLanguageInfo->rtl == 0 ? 'ml-2' : 'mr-2' }} mb-0">
                                            {{ $keywords['Number of nights will be calculated based on checkin & checkout date'] ?? __('Number of nights will be calculated based on checkin & checkout date') }}
                                        </small>
                                        @error('nights')
                                            <p class="ml-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            <input type="number"
                                                placeholder="{{ $keywords['Number of Guests'] ?? __('Number of Guests') }}"
                                                name="guests" value="{{ old('guests') }}" required>
                                            <i class="far fa-users"></i>
                                        </div>
                                        @error('guests')
                                            <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">

                                            @guest('customer')
                                                <input type="text"
                                                    placeholder="{{ $keywords['Full Name'] ?? __('Full Name') }}"
                                                    name="customer_name" value="{{ old('customer_name') }}" required>
                                            @endguest

                                            @auth('customer')
                                                @php
                                                    if (
                                                        !empty(Auth::guard('customer')->user()->first_name) ||
                                                        !empty(Auth::guard('customer')->user()->last_name)
                                                    ) {
                                                        $name =
                                                            Auth::guard('customer')->user()->first_name .
                                                            ' ' .
                                                            Auth::guard('customer')->user()->last_name;
                                                    } else {
                                                        $name = '';
                                                    }
                                                @endphp
                                                <input type="text"
                                                    placeholder="{{ $keywords['Full Name'] ?? __('Full Name') }}"
                                                    name="customer_name" value="{{ $name }}" required>
                                            @endauth
                                            <i class="far fa-user"></i>
                                        </div>
                                        @error('customer_name')
                                            <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            @guest('customer')
                                                <input type="tel" placeholder="{{ $keywords['Phone'] ?? __('Phone') }}"
                                                    name="customer_phone" value="{{ old('customer_phone') }}" required>
                                            @endguest

                                            @auth('customer')
                                                <input type="tel" placeholder="{{ $keywords['Phone'] ?? __('Phone') }}"
                                                    name="customer_phone"
                                                    value="{{ Auth::guard('customer')->user()->contact_number }}" required>
                                            @endauth
                                            <i class="far fa-phone"></i>
                                        </div>
                                        @error('customer_phone')
                                            <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            @guest('customer')
                                                <input type="email" placeholder="{{ $keywords['Email'] ?? __('Email') }}"
                                                    name="customer_email" value="{{ old('customer_email') }}" required>
                                            @endguest

                                            @auth('customer')
                                                <input type="email" placeholder="{{ $keywords['Email'] ?? __('Email') }}"
                                                    name="customer_email"
                                                    value="{{ Auth::guard('customer')->user()->email }}" required>
                                            @endauth
                                            <i class="far fa-envelope"></i>
                                        </div>
                                        @error('customer_email')
                                            <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    <div class="mb-2">
                                        <div class="input-wrap">
                                            <select class="nice-select" name="paymentType" id="payment-gateways">
                                                <option value="" selected disabled>
                                                    {{ $keywords['Select Payment Gateway'] ?? __('Select Payment Gateway') }}
                                                </option>
                                                @foreach ($onlineGateways as $onlineGateway)
                                                    <option value="{{ $onlineGateway->keyword }}">
                                                        {{ $onlineGateway->name }}
                                                    </option>
                                                @endforeach

                                                @if (!empty($offlineGateways))
                                                    @foreach ($offlineGateways as $offlineGateway)
                                                        <option value="{{ $offlineGateway['id'] }}">
                                                            {{ $offlineGateway['name'] }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            @error('paymentType')
                                                <p class="ml-2 mt-2 text-danger">{{ $message }}</p>
                                            @enderror
                                        </div>
                                    </div>

                                    <div id="tab-stripe" class="d-none gateway-details">
                                        <div class="row py-3">
                                            <div class="col-md-12">
                                                <div class="form-group mb-3">
                                                    <div id="stripe-element" class="mb-2">
                                                        <!-- A Stripe Element will be inserted here. -->
                                                    </div>
                                                </div>
                                                <p class="text-danger" id="stripe-errors"></p>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- START: Authorize.net Card Details Form --}}
                                    <div class="d-none" id="tab-anet">
                                        <div class="row py-3">
                                            <div class="col-lg-6">
                                                <div class="form-group mb-3">
                                                    <input class="form-control" type="text" id="anetCardNumber"
                                                        placeholder="{{ $keywords['Card Number'] ?? __('Card Number') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-3">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetExpMonth"
                                                        placeholder="{{ $keywords['Expire Month'] ?? __('Expire Month') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 ">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetExpYear"
                                                        placeholder="{{ $keywords['Expire Year'] ?? __('Expire Year') }}"
                                                        disabled />
                                                </div>
                                            </div>
                                            <div class="col-lg-6 ">
                                                <div class="form-group">
                                                    <input class="form-control" type="text" id="anetCardCode"
                                                        placeholder="Card Code" disabled />
                                                </div>
                                            </div>
                                            <input type="hidden" name="opaqueDataValue" id="opaqueDataValue" disabled />
                                            <input type="hidden" name="opaqueDataDescriptor" id="opaqueDataDescriptor"
                                                disabled />
                                            <ul id="anetErrors" class="dis-none"></ul>
                                        </div>
                                    </div>
                                    {{-- END: Authorize.net Card Details Form --}}

                                    <div class="d-none my-3 px-2" id="gateway-description"></div>

                                    <div class="d-none mb-3 px-2" id="gateway-instruction"></div>

                                    <div class="input-wrap d-none mb-4 pl-2" id="gateway-attachment">
                                        <input type="file" name="attachment">
                                    </div>

                                    <div class="mb-2">
                                        <div class="coupon-code-buttons">
                                            <input type="text" id="coupon-code"
                                                placeholder="{{ $keywords['Enter Your Coupon'] ?? __('Enter Your Coupon') }}">
                                            <button type="button" class="btn filled-btn" onclick="applyCoupon(event)" style="padding: 0px 15px;">
                                                {{ $keywords['Apply'] ?? __('Apply') }}
                                            </button>
                                        </div>
                                    </div>

                                    <div class="price-option-table mt-4">
                                        <ul>
                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Price'] ?? __('Price') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="rent-price">0.00</span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>
                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Discount'] ?? __('Discount') }}
                                                    <span class="text-danger">(<i class="fas fa-minus"></i>)</span>
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="discount-amount">0.00</span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>

                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Subtotal'] ?? __('Subtotal') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="subtotal-amount"> 0.00</span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>

                                            @if ($userBs->room_tax_status == 1)
                                                <li class="single-price-option">
                                                    <span class="title">
                                                        {{ $keywords['Tax'] ?? __('Tax') }} ( {{ $userBs->room_tax }}%)
                                                        <span class="text-success">(<i class="fas fa-plus"></i>)</span>
                                                        <span class="amount">
                                                            {{ $position == 'left' ? $symbol : '' }}
                                                            <span id="tax-amount"> {{ number_format(0.0, 2) }}</span>
                                                            {{ $position == 'right' ? $symbol : '' }}
                                                        </span>
                                                    </span>
                                                </li>
                                            @endif

                                            @if ($userBs->room_fee_status == 1)
                                                <li class="single-price-option">
                                                    <span class="title">
                                                        {{ $keywords['Fee'] ?? __('Fee') }}
                                                        <span class="text-success">(<i class="fas fa-plus"></i>)</span>
                                                        <span class="amount">
                                                            {{ $position == 'left' ? $symbol : '' }}
                                                            <span id="fee-amount">
                                                                {{ number_format(0.0, 2) }}
                                                            </span>
                                                            {{ $position == 'right' ? $symbol : '' }}
                                                        </span>
                                                    </span>
                                                </li>
                                            @endif

                                            <li class="single-price-option">
                                                <span class="title">
                                                    {{ $keywords['Total'] ?? __('Total') }}
                                                    <span class="amount">
                                                        {{ $position == 'left' ? $symbol : '' }}
                                                        <span id="total-amount">0.00</span>
                                                        {{ $position == 'right' ? $symbol : '' }}
                                                    </span>
                                                </span>
                                            </li>

                                        </ul>
                                    </div>

                                    <div class="mt-4">
                                        <div class="input-wrap">
                                            <button type="submit" id="web-payment" form="web-payment"
                                                class="btn filled-btn btn-block w-100">
                                                {{ $keywords['Book now'] ?? __('Book now') }} <i
                                                    class="far fa-long-arrow-right"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div class="widget share-widget">
                                <h4 class="widget-title">
                                    {{ $keywords['Share This Room'] ?? __('Share This Room') }}</h4>
                                <ul class="social-icons">
                                    @include('user-front.common.share-socail-media')
                                </ul>
                            </div>
                            {{-- Ads Section --}}
                            @if (is_array($packagePermissions) && in_array('Advertisement', $packagePermissions))
                                @if (!empty(showAd(2)))
                                    <div class="text-center mt-0">
                                        {!! showAd(2) !!}
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                    <!-- Sidebar Area End -->

                </div>
            </div>
        </section>

        <!-- Latest Room Start -->
        @if (count($latestRooms) > 0)
            <section class="latest-room-d section-bg section-padding">
                <div class="container">
                    <!-- Section Title -->
                    <div class="section-title text-center">
                        <h1>{{ $keywords['Related Rooms'] ?? __('Related Rooms') }}</h1>
                    </div>
                    <div class="row">
                        @foreach ($latestRooms as $latestRoom)
                            <div class="col-lg-4 col-md-6">
                                <!-- Single Room -->
                                <div class="single-room">
                                    <a class="room-thumb d-block"
                                        href="{{ route('room_details', [getParam(), 'slug' => $latestRoom->slug]) }}">
                                        <img class="lazy"
                                            data-src="{{ asset('assets/tenant/img/rooms/' . $latestRoom->room->featured_img) }}"
                                            alt="room">
                                        <div class="room-price">
                                            <p>
                                                {{ $position == 'left' ? $symbol : '' }}{{ $latestRoom->room->rent }}{{ $position == 'right' ? $symbol : '' }}
                                                / {{ $keywords['Night'] ?? __('Night') }}</p>
                                        </div>
                                    </a>
                                    <div class="room-desc">
                                        @php
                                            $category = \App\Models\User\RoomCategory::where(
                                                'indx',
                                                $latestRoom->room->category_index,
                                            )
                                                ->where('language_id', $details->language_id)
                                                ->first();
                                        @endphp
                                        <div class="room-cat">
                                            <a class="p-0 d-block"
                                                href="{{ route('rooms', [getParam(), 'category' => $category->slug]) }}">
                                                {{ !is_null($category) ? $category->name : '' }}
                                            </a>
                                        </div>
                                        <h4>
                                            <a
                                                href="{{ route('room_details', [getParam(), 'slug' => $latestRoom->slug]) }}">
                                                {{ strlen($latestRoom->title) > 45 ? mb_substr($latestRoom->title, 0, 45, 'utf-8') . '...' : $latestRoom->title }}
                                            </a>
                                        </h4>
                                        <p>
                                            {{ strlen($latestRoom->summary) > 85 ? mb_substr($latestRoom->summary, 0, 85, 'utf-8') . '...' : $latestRoom->summary }}
                                        </p>
                                        <ul class="room-info">
                                            <li><i class="far fa-bed"></i>{{ $latestRoom->room->bed }}
                                                {{ $latestRoom->room->bed == 1 ? $keywords['Bed'] ?? __('Bed') : $keywords['Beds'] ?? __('Beds') }}
                                            </li>
                                            <li><i class="far fa-bath"></i>{{ $latestRoom->room->bath }}
                                                {{ $latestRoom->room->bath == 1 ? $keywords['Baths'] ?? __('Bath') : $keywords['Baths'] ?? __('Baths') }}
                                            </li>
                                            @if (!empty($latestRoom->room->max_guests))
                                                <li><i class="far fa-users"></i>{{ $latestRoom->room->max_guests }}
                                                    {{ $latestRoom->room->max_guests == 1 ? $keywords['Guest'] ?? __('Guest') : $keywords['Guests'] ?? __('Guests') }}
                                                </li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
        @endif
        <!-- Latest Room End -->
    </main>

    @php
        $exiting_price_show = false;
    @endphp
    @if (Session::has('room_booking_id_dates') && !empty(old('dates')))
        @php
            $room_booking_id_dates = 'room_id_' . $details->room_id . '_dates_' . str_replace(' ', '', old('dates'));
            if(Session::get('room_booking_id_dates') == $room_booking_id_dates){
              $exiting_price_show = true;
            }
        @endphp
    
    @endif
@endsection

@section('script')
    <script>
        'use strict';
        // assign php value to js variable
        var bookingDates = {!! json_encode($bookingDates) !!};
        var offlineGateways = {!! json_encode($offlineGateways) !!};
        var roomRentPerNight = '{{ $details->rent }}';
        var stripe_key = "{{ $stripe_key ?? '' }}";
        var getUser = {!! getUser() !!};
        var tax_status = "{{ $userBs->room_tax_status }}";
        var room_tax = "{{ $userBs->room_tax_status == 1 ? $userBs->room_tax : 0 }}";
        var room_fee = "{{ $userBs->room_fee_status == 1 ? $userBs->room_fee : 0 }}";
    </script>

    <script src="{{ asset('assets/user-front/js/room-details.js') }}"></script>
    @php
        if (!is_null($anet->information)) {
            $anerInfo = $anet->convertAutoData();
            $anetTest = $anerInfo['sandbox_check'];

            if ($anetTest == 1) {
                $anetSrc = 'https://jstest.authorize.net/v1/Accept.js';
            } else {
                $anetSrc = 'https://js.authorize.net/v1/Accept.js';
            }
        } else {
            $anetSrc = '';
        }
    @endphp

    @if (!empty($stripe_key))
        <script src="https://js.stripe.com/v3/"></script>
    @endif

    @if (!is_null($anet->information))
        <script>
            "use strict";
            var clientKey = "{{ $anerInfo['public_key'] }}";
            var loginId = "{{ $anerInfo['login_id'] }}";
        </script>
        <script type="text/javascript" src="{{ $anetSrc }}" charset="utf-8"></script>
    @endif
    @if (!empty($stripe_key) || !is_null($anet->information))
        <script src="{{ asset('assets/tenant/js/anet_stripe.js') }}"></script>
    @endif

    @if (isset($exiting_price_show) &&  $exiting_price_show == true)
        <script>
            showExitingPrice();
        </script>
    @endif


@endsection
